/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;

public class SuspendSerialGCMaxHeapSize {
    private static final FastThreadLocalInt nestingDepth = FastThreadLocalFactory.createInt("SuspendSerialGCMaxHeapSize.nestingDepth");

    @Uninterruptible(reason="Called from code that must not allocate before suspending the heap limit.", callerMustBe=true)
    public static void suspendInCurrentThread() {
        int oldValue = nestingDepth.get();
        int newValue = oldValue + 1;
        assert (oldValue >= 0);
        nestingDepth.set(newValue);
    }

    @Uninterruptible(reason="Called from code that must not allocate after resuming the heap limit.", callerMustBe=true)
    public static void resumeInCurrentThread() {
        int oldValue = nestingDepth.get();
        int newValue = oldValue - 1;
        assert (newValue >= 0);
        nestingDepth.set(newValue);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isSuspended() {
        return nestingDepth.get() > 0;
    }
}

