/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.configure.ClassNameSupport;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.hub.registry.ClassRegistries;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonBuilderFlags;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingletonSupport;
import com.oracle.svm.core.layeredimagesingleton.MultiLayeredImageSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

@AutomaticallyRegisteredImageSingleton
public final class ClassForNameSupport
implements MultiLayeredImageSingleton,
UnsavedSingleton {
    private ClassLoader libGraalLoader;
    private final EconomicMap<String, ConditionalRuntimeValue<Object>> knownClasses;
    private final EconomicMap<String, RuntimeConditionSet> knownClassNames;
    private final EconomicMap<String, Throwable> knownExceptions;
    private final EconomicMap<Class<?>, RuntimeConditionSet> unsafeInstantiatedClasses;
    private static final Object NEGATIVE_QUERY = new Object();

    public void setLibGraalLoader(ClassLoader libGraalLoader) {
        this.libGraalLoader = libGraalLoader;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static ClassForNameSupport currentLayer() {
        return LayeredImageSingletonSupport.singleton().lookup(ClassForNameSupport.class, false, true);
    }

    private static ClassForNameSupport[] layeredSingletons() {
        return (ClassForNameSupport[])MultiLayeredImageSingleton.getAllLayers(ClassForNameSupport.class);
    }

    public ClassForNameSupport() {
        if (ClassForNameSupport.respectClassLoader()) {
            this.knownClasses = null;
            this.knownClassNames = ImageHeapMap.createNonLayeredMap();
            this.knownExceptions = ImageHeapMap.createNonLayeredMap();
        } else {
            this.knownClasses = ImageHeapMap.createNonLayeredMap();
            this.knownClassNames = null;
            this.knownExceptions = null;
        }
        this.unsafeInstantiatedClasses = ImageHeapMap.createNonLayeredMap();
    }

    public static boolean respectClassLoader() {
        return Options.ClassForNameRespectsClassLoader.getValue();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerClass(Class<?> clazz, ClassLoader runtimeClassLoader) {
        this.registerClass(ConfigurationCondition.alwaysTrue(), clazz, runtimeClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerClass(ConfigurationCondition condition, Class<?> clazz, ClassLoader runtimeClassLoader) {
        assert (!clazz.isPrimitive()) : "primitive classes cannot be looked up by name";
        if (PredefinedClassesSupport.isPredefined(clazz)) {
            return;
        }
        String name = clazz.getName();
        if (ClassForNameSupport.respectClassLoader()) {
            this.registerKnownClassName(condition, name);
            Class<?> elemental = clazz;
            while (elemental.isArray()) {
                elemental = elemental.getComponentType();
            }
            if (!elemental.isPrimitive()) {
                ClassRegistries.addAOTClass(runtimeClassLoader, elemental);
            }
        } else {
            EconomicMap<String, ConditionalRuntimeValue<Object>> economicMap = this.knownClasses;
            synchronized (economicMap) {
                Class<?> currentValue;
                ConditionalRuntimeValue existingEntry = (ConditionalRuntimeValue)this.knownClasses.get((Object)name);
                Class<?> clazz2 = currentValue = existingEntry == null ? null : (Class<?>)existingEntry.getValueUnconditionally();
                if (currentValue instanceof Class) {
                    Class currentClazz = currentValue;
                    if (clazz.getClassLoader() != currentClazz.getClassLoader()) {
                        if (this.isLibGraalClass(currentClazz)) {
                            return;
                        }
                        if (this.isLibGraalClass(clazz)) {
                            currentValue = null;
                        }
                    }
                }
                if (currentValue == null || currentValue == NEGATIVE_QUERY || currentValue == clazz) {
                    currentValue = clazz;
                    cond = ClassForNameSupport.updateConditionalValue(existingEntry, currentValue, condition);
                    this.knownClasses.put((Object)name, cond);
                } else if (currentValue instanceof Throwable) {
                    cond = ClassForNameSupport.updateConditionalValue(existingEntry, currentValue, condition);
                    this.knownClasses.put((Object)name, cond);
                } else {
                    throw VMError.shouldNotReachHere("Invalid Class.forName value for %s: %s\nIf the class is already registered as negative, it means that it exists but is not\naccessible through the builder class loader, and it was already registered by name (as\nnegative query) before this point. In that case, we update the map to contain the actual\nclass.\n", name, currentValue);
                }
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private boolean isLibGraalClass(Class<?> clazz) {
        return this.libGraalLoader != null && clazz.getClassLoader() == this.libGraalLoader;
    }

    public static ConditionalRuntimeValue<Object> updateConditionalValue(ConditionalRuntimeValue<Object> existingConditionalValue, Object newValue, ConfigurationCondition additionalCondition) {
        if (existingConditionalValue == null) {
            return new ConditionalRuntimeValue<Object>(RuntimeConditionSet.createHosted(additionalCondition), newValue);
        }
        existingConditionalValue.getConditions().addCondition(additionalCondition);
        existingConditionalValue.updateValue(newValue);
        return existingConditionalValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerExceptionForClass(ConfigurationCondition condition, String className, Throwable t) {
        if (RuntimeClassLoading.isSupported()) {
            return;
        }
        if (ClassForNameSupport.respectClassLoader()) {
            this.registerKnownClassName(condition, className);
            EconomicMap<String, Throwable> economicMap = this.knownExceptions;
            synchronized (economicMap) {
                this.knownExceptions.put((Object)className, (Object)t);
            }
        } else {
            this.updateCondition(condition, className, t);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerNegativeQuery(ConfigurationCondition condition, String className) {
        if (ClassForNameSupport.respectClassLoader()) {
            this.registerKnownClassName(condition, className);
        } else {
            this.updateCondition(condition, className, NEGATIVE_QUERY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerKnownClassName(ConfigurationCondition condition, String className) {
        assert (ClassForNameSupport.respectClassLoader());
        EconomicMap<String, RuntimeConditionSet> economicMap = this.knownClassNames;
        synchronized (economicMap) {
            RuntimeConditionSet existingConditions = (RuntimeConditionSet)this.knownClassNames.get((Object)className);
            if (existingConditions == null) {
                this.knownClassNames.put((Object)className, (Object)RuntimeConditionSet.createHosted(condition));
            } else {
                existingConditions.addCondition(condition);
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerUnsafeAllocated(ConfigurationCondition condition, Class<?> clazz) {
        RuntimeConditionSet conditionSet;
        if (!(clazz.isArray() || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || (conditionSet = (RuntimeConditionSet)this.unsafeInstantiatedClasses.putIfAbsent(clazz, (Object)RuntimeConditionSet.createHosted(condition))) == null)) {
            conditionSet.addCondition(condition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCondition(ConfigurationCondition condition, String className, Object value) {
        EconomicMap<String, ConditionalRuntimeValue<Object>> economicMap = this.knownClasses;
        synchronized (economicMap) {
            ConditionalRuntimeValue runtimeConditions = (ConditionalRuntimeValue)this.knownClasses.putIfAbsent((Object)className, new ConditionalRuntimeValue<Object>(RuntimeConditionSet.createHosted(condition), value));
            if (runtimeConditions != null) {
                runtimeConditions.getConditions().addCondition(condition);
            }
        }
    }

    public static Class<?> forNameOrNull(String className, ClassLoader classLoader) {
        try {
            return ClassForNameSupport.forName(className, classLoader, true);
        }
        catch (ClassNotFoundException e) {
            throw VMError.shouldNotReachHere("ClassForNameSupport#forNameOrNull should not throw", e);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Set<String> getKnownClassNames() {
        Object map = ClassForNameSupport.respectClassLoader() ? this.knownClassNames : this.knownClasses;
        HashSet<String> set = new HashSet<String>(map.size());
        for (String key : map.getKeys()) {
            set.add(key);
        }
        return set;
    }

    public static Class<?> forName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return ClassForNameSupport.forName(className, classLoader, false);
    }

    private static Class<?> forName(String className, ClassLoader classLoader, boolean returnNullOnException) throws ClassNotFoundException {
        if (className == null) {
            return null;
        }
        Object result = ClassForNameSupport.queryResultFor(className, classLoader);
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof Throwable) {
            if (returnNullOnException) {
                return null;
            }
            if (result instanceof Error) {
                throw (Error)result;
            }
            if (result instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)result;
            }
        } else if (result == null) {
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                MissingReflectionRegistrationUtils.reportClassAccess(className);
            }
            if (returnNullOnException) {
                return null;
            }
            throw new ClassNotFoundException(className);
        }
        throw VMError.shouldNotReachHere("Class.forName result should be Class, ClassNotFoundException or Error: " + String.valueOf(result));
    }

    private static Object queryResultFor(String className, ClassLoader classLoader) {
        Object result = null;
        for (ClassForNameSupport singleton : ClassForNameSupport.layeredSingletons()) {
            Object newResult = singleton.forName0(className, classLoader);
            Object object = result = newResult != null ? newResult : result;
            if (result != null && result != NEGATIVE_QUERY) break;
        }
        return result;
    }

    private Object forName0(String className, ClassLoader classLoader) {
        Class<?> result;
        if (className.endsWith("[]")) {
            return new ClassNotFoundException(className);
        }
        ConditionalRuntimeValue conditional = (ConditionalRuntimeValue)this.knownClasses.get((Object)className);
        Class<?> clazz = result = conditional == null ? null : (Class<?>)conditional.getValue();
        if (result == null) {
            result = PredefinedClassesSupport.getLoadedForNameOrNull(className, classLoader);
        }
        if (result == null && !ClassNameSupport.isValidReflectionName((String)className)) {
            return new ClassNotFoundException(className);
        }
        if (MetadataTracer.enabled()) {
            MetadataTracer.singleton().traceReflectionType(ClassNameSupport.reflectionNameToTypeName((String)className));
        }
        return result == NEGATIVE_QUERY ? new ClassNotFoundException(className) : result;
    }

    public int count() {
        if (ClassForNameSupport.respectClassLoader()) {
            return this.knownClassNames.size();
        }
        return this.knownClasses.size();
    }

    public static RuntimeConditionSet getConditionFor(Class<?> jClass) {
        Objects.requireNonNull(jClass);
        String jClassName = jClass.getName();
        if (ClassForNameSupport.respectClassLoader()) {
            RuntimeConditionSet conditionSet = ClassForNameSupport.getConditionForName(jClassName);
            if (conditionSet == null) {
                return RuntimeConditionSet.unmodifiableEmptySet();
            }
            return conditionSet;
        }
        ConditionalRuntimeValue conditionalClass = null;
        for (ClassForNameSupport singleton : ClassForNameSupport.layeredSingletons()) {
            conditionalClass = (ConditionalRuntimeValue)singleton.knownClasses.get((Object)jClassName);
            if (conditionalClass != null) break;
        }
        if (conditionalClass == null) {
            return RuntimeConditionSet.unmodifiableEmptySet();
        }
        return conditionalClass.getConditions();
    }

    public static boolean isRegisteredClass(String className) {
        if (ClassForNameSupport.respectClassLoader()) {
            RuntimeConditionSet conditionSet = ClassForNameSupport.getConditionForName(className);
            if (conditionSet == null) {
                return false;
            }
            return conditionSet.satisfied();
        }
        return ClassForNameSupport.queryResultFor(className, null) != null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean isCurrentLayerRegisteredClass(String className) {
        assert (ClassForNameSupport.respectClassLoader());
        RuntimeConditionSet conditionSet = (RuntimeConditionSet)ClassForNameSupport.currentLayer().knownClassNames.get((Object)className);
        if (conditionSet == null) {
            return false;
        }
        return conditionSet.satisfied();
    }

    private static RuntimeConditionSet getConditionForName(String className) {
        for (ClassForNameSupport singleton : ClassForNameSupport.layeredSingletons()) {
            RuntimeConditionSet conditionSet = (RuntimeConditionSet)singleton.knownClassNames.get((Object)className);
            if (conditionSet == null) continue;
            return conditionSet;
        }
        return null;
    }

    public static Throwable getSavedException(String className) {
        assert (ClassForNameSupport.respectClassLoader() && !RuntimeClassLoading.isSupported());
        if (!ClassForNameSupport.isRegisteredClass(className)) {
            return null;
        }
        Throwable exception = null;
        for (ClassForNameSupport singleton : ClassForNameSupport.layeredSingletons()) {
            exception = (Throwable)singleton.knownExceptions.get((Object)className);
            if (exception != null) break;
        }
        return exception;
    }

    public static boolean canUnsafeInstantiateAsInstance(DynamicHub hub) {
        Class<?> clazz = DynamicHub.toClass(hub);
        if (MetadataTracer.enabled()) {
            MetadataTracer.singleton().traceUnsafeAllocatedType(clazz);
        }
        RuntimeConditionSet conditionSet = null;
        for (ClassForNameSupport singleton : ClassForNameSupport.layeredSingletons()) {
            conditionSet = (RuntimeConditionSet)singleton.unsafeInstantiatedClasses.get(clazz);
            if (conditionSet != null) break;
        }
        if (conditionSet != null) {
            return conditionSet.satisfied();
        }
        return false;
    }

    @Override
    public EnumSet<LayeredImageSingletonBuilderFlags> getImageBuilderFlags() {
        return LayeredImageSingletonBuilderFlags.ALL_ACCESS;
    }

    public static final class Options {
        public static final HostedOptionKey<Boolean> ClassForNameRespectsClassLoader = new HostedOptionKey<Boolean>(false);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class IgnoresClassLoader
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return !ClassForNameSupport.respectClassLoader();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class RespectsClassLoader
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ClassForNameSupport.respectClassLoader();
        }
    }
}

