/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.BuildStackTraceVisitor;
import com.oracle.svm.core.jdk.GetCallerClassVisitor;
import com.oracle.svm.core.jdk.GetClassContextVisitor;
import com.oracle.svm.core.jdk.GetLatestUserDefinedClassLoaderVisitor;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.jdk.LambdaFormHiddenMethod;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.thread.VMOperation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class StackTraceUtils {
    private static final Class<?>[] NO_CLASSES = new Class[0];
    private static final StackTraceElement[] NO_ELEMENTS = new StackTraceElement[0];

    public static StackTraceElement[] getCurrentThreadStackTrace(boolean filterExceptions, Pointer startSP, Pointer endSP) {
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(filterExceptions, SubstrateOptions.maxJavaStackTraceDepth());
        StackTraceUtils.visitCurrentThreadStackFrames(startSP, endSP, visitor);
        return visitor.trace.toArray(NO_ELEMENTS);
    }

    public static void visitCurrentThreadStackFrames(Pointer startSP, Pointer endSP, StackFrameVisitor visitor) {
        JavaStackWalker.walkCurrentThread(startSP, endSP, visitor);
    }

    @NeverInline(value="Potentially starting a stack walk in the caller frame")
    public static StackTraceElement[] getStackTraceAtSafepoint(Thread thread) {
        assert (VMOperation.isInProgressAtSafepoint());
        if (thread == null) {
            return NO_ELEMENTS;
        }
        return JavaThreads.getStackTraceAtSafepoint(thread, KnownIntrinsics.readCallerStackPointer());
    }

    public static StackTraceElement[] getStackTraceAtSafepoint(IsolateThread isolateThread) {
        return StackTraceUtils.getStackTraceAtSafepoint(isolateThread, (Pointer)Word.nullPointer());
    }

    public static StackTraceElement[] getStackTraceAtSafepoint(IsolateThread isolateThread, Pointer endSP) {
        assert (VMOperation.isInProgressAtSafepoint());
        if (isolateThread.isNull()) {
            return NO_ELEMENTS;
        }
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(false, SubstrateOptions.maxJavaStackTraceDepth());
        JavaStackWalker.walkThread(isolateThread, endSP, visitor, null);
        return visitor.trace.toArray(NO_ELEMENTS);
    }

    public static StackTraceElement[] getStackTraceAtSafepoint(IsolateThread isolateThread, Pointer startSP, Pointer endSP) {
        assert (VMOperation.isInProgressAtSafepoint());
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(false, SubstrateOptions.maxJavaStackTraceDepth());
        JavaStackWalker.walkThread(isolateThread, startSP, endSP, (CodePointer)Word.nullPointer(), visitor);
        return visitor.trace.toArray(NO_ELEMENTS);
    }

    public static Class<?>[] getClassContext(int skip, Pointer startSP) {
        GetClassContextVisitor visitor = new GetClassContextVisitor(skip);
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.trace.toArray(NO_CLASSES);
    }

    public static Class<?> getCallerClass(Pointer startSP, boolean showLambdaFrames) {
        return StackTraceUtils.getCallerClass(startSP, showLambdaFrames, 0, true);
    }

    public static Class<?> getCallerClass(Pointer startSP, boolean showLambdaFrames, int depth, boolean ignoreFirst) {
        GetCallerClassVisitor visitor = new GetCallerClassVisitor(showLambdaFrames, depth, ignoreFirst);
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean shouldShowFrame(Class<?> clazz, String method) {
        return StackTraceUtils.shouldShowFrame(clazz, method, false, true, false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean shouldShowFrame(FrameSourceInfo frameSourceInfo) {
        return StackTraceUtils.shouldShowFrame(frameSourceInfo.getSourceClass(), frameSourceInfo.getSourceMethodName());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean shouldShowFrame(FrameSourceInfo frameSourceInfo, boolean showLambdaFrames, boolean showReflectFrames, boolean showHiddenFrames) {
        return StackTraceUtils.shouldShowFrame(frameSourceInfo.getSourceClass(), frameSourceInfo.getSourceMethodName(), showLambdaFrames, showReflectFrames, showHiddenFrames);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean shouldShowFrame(Class<?> clazz, String methodName, boolean showLambdaFrames, boolean showReflectFrames, boolean showHiddenFrames) {
        if (showHiddenFrames) {
            return true;
        }
        if (clazz == null) {
            return false;
        }
        if (DynamicHub.fromClass(clazz).isVMInternal()) {
            return false;
        }
        if (!showLambdaFrames && DynamicHub.fromClass(clazz).isLambdaFormHidden()) {
            return false;
        }
        if (!showReflectFrames) {
            if (clazz == Method.class && UninterruptibleUtils.String.equals("invoke", methodName)) {
                return false;
            }
            if ((clazz == Constructor.class || clazz == Class.class) && UninterruptibleUtils.String.equals("newInstance", methodName)) {
                return false;
            }
        }
        return clazz != Target_jdk_internal_vm_Continuation.class || !UninterruptibleUtils.String.startsWith(methodName, "enter") && !UninterruptibleUtils.String.startsWith(methodName, "yield");
    }

    public static boolean shouldShowFrame(MetaAccessProvider metaAccess, ResolvedJavaMethod method, boolean showLambdaFrames, boolean showReflectFrames, boolean showHiddenFrames) {
        if (showHiddenFrames) {
            return true;
        }
        ResolvedJavaType clazz = method.getDeclaringClass();
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)clazz, InternalVMMethod.class)) {
            return false;
        }
        if (!showLambdaFrames && AnnotationAccess.isAnnotationPresent((AnnotatedElement)clazz, LambdaFormHiddenMethod.class)) {
            return false;
        }
        return showReflectFrames || !(clazz.equals((Object)metaAccess.lookupJavaType(Method.class)) && "invoke".equals(method.getName()) || clazz.equals((Object)metaAccess.lookupJavaType(Constructor.class)) && "newInstance".equals(method.getName())) && (!clazz.equals((Object)metaAccess.lookupJavaType(Class.class)) || !"newInstance".equals(method.getName()));
    }

    public static boolean ignoredBySecurityStackWalk(MetaAccessProvider metaAccess, ResolvedJavaMethod method) {
        return !StackTraceUtils.shouldShowFrame(metaAccess, method, true, false, false);
    }

    public static ClassLoader latestUserDefinedClassLoader(Pointer startSP) {
        GetLatestUserDefinedClassLoaderVisitor visitor = new GetLatestUserDefinedClassLoaderVisitor();
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.result;
    }

    public static StackTraceElement[] asyncGetStackTrace(Thread thread) {
        if (thread == null || !thread.isAlive()) {
            return NO_ELEMENTS;
        }
        GetStackTraceOperation vmOp = new GetStackTraceOperation(thread);
        vmOp.enqueue();
        return vmOp.result;
    }

    private static class GetStackTraceOperation
    extends JavaVMOperation {
        private final Thread thread;
        StackTraceElement[] result;

        GetStackTraceOperation(Thread thread) {
            super(VMOperationInfos.get(GetStackTraceOperation.class, "Get stack trace", VMOperation.SystemEffect.SAFEPOINT));
            this.thread = thread;
        }

        @Override
        protected void operate() {
            this.result = StackTraceUtils.getStackTraceAtSafepoint(this.thread);
        }
    }
}

