/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.Target_java_io_ObjectStreamClass_Caches;
import com.oracle.svm.core.metadata.MetadataTracer;
import com.oracle.svm.core.reflect.serialize.MissingSerializationRegistrationUtils;
import java.io.ObjectStreamClass;
import java.io.Serializable;

@TargetClass(value=ObjectStreamClass.class)
final class Target_java_io_ObjectStreamClass {
    Target_java_io_ObjectStreamClass() {
    }

    @Substitute
    private static boolean hasStaticInitializer(Class<?> cl) {
        return DynamicHub.fromClass(cl).getClassInitializationInfo().hasInitializer();
    }

    @Substitute
    static ObjectStreamClass lookup(Class<?> cl, boolean all) {
        if (!all && !Serializable.class.isAssignableFrom(cl)) {
            return null;
        }
        if (Serializable.class.isAssignableFrom(cl) && !cl.isArray()) {
            if (MetadataTracer.enabled()) {
                MetadataTracer.singleton().traceSerializationType(cl);
            }
            if (!DynamicHub.fromClass(cl).isRegisteredForSerialization()) {
                MissingSerializationRegistrationUtils.reportSerialization(cl);
            }
        }
        return Target_java_io_ObjectStreamClass_Caches.localDescs0.get(cl);
    }
}

