/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferList;
import com.oracle.svm.core.jfr.JfrBufferNode;
import com.oracle.svm.core.jfr.JfrBufferNodeAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrEventWriterAccess;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventWriter;
import com.oracle.svm.core.jfr.events.ThreadCPULoadEvent;
import com.oracle.svm.core.jfr.events.ThreadEndEvent;
import com.oracle.svm.core.jfr.events.ThreadStartEvent;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerStatistics;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.ThreadListener;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.UnsignedWord;

public class JfrThreadLocal
implements ThreadListener {
    private static final FastThreadLocalObject<Target_jdk_jfr_internal_event_EventWriter> javaEventWriter = FastThreadLocalFactory.createObject(Target_jdk_jfr_internal_event_EventWriter.class, "JfrThreadLocal.javaEventWriter");
    private static final FastThreadLocalWord<JfrBuffer> javaBuffer = FastThreadLocalFactory.createWord("JfrThreadLocal.javaBuffer");
    private static final FastThreadLocalWord<JfrBuffer> nativeBuffer = FastThreadLocalFactory.createWord("JfrThreadLocal.nativeBuffer");
    private static final FastThreadLocalWord<UnsignedWord> dataLost = FastThreadLocalFactory.createWord("JfrThreadLocal.dataLost");
    private static final FastThreadLocalInt notified = FastThreadLocalFactory.createInt("JfrThreadLocal.notified");
    private static final FastThreadLocalWord<SamplerBuffer> samplerBuffer = FastThreadLocalFactory.createWord("JfrThreadLocal.samplerBuffer");
    private static final FastThreadLocalLong missedSamples = FastThreadLocalFactory.createLong("JfrThreadLocal.missedSamples");
    private static final FastThreadLocalLong unparseableStacks = FastThreadLocalFactory.createLong("JfrThreadLocal.unparseableStacks");
    private static final JfrBufferList javaBufferList = new JfrBufferList();
    private static final JfrBufferList nativeBufferList = new JfrBufferList();
    private UnsignedWord threadLocalBufferSize;

    @Fold
    public static JfrBufferList getNativeBufferList() {
        return nativeBufferList;
    }

    @Fold
    public static JfrBufferList getJavaBufferList() {
        return javaBufferList;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrThreadLocal() {
    }

    public void initialize(UnsignedWord bufferSize) {
        this.threadLocalBufferSize = bufferSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getThreadLocalBufferSize() {
        return this.threadLocalBufferSize;
    }

    public void teardown() {
        JfrThreadLocal.getNativeBufferList().teardown();
        JfrThreadLocal.getJavaBufferList().teardown();
    }

    @Override
    @Uninterruptible(reason="Only uninterruptible code may be executed before the thread is fully started.")
    public void beforeThreadStart(IsolateThread isolateThread, Thread javaThread) {
        if (SubstrateJVM.get().isRecording()) {
            SubstrateJVM.getThreadRepo().registerThread(javaThread);
            ThreadCPULoadEvent.initWallclockTime(isolateThread);
            ThreadStartEvent.emit(javaThread);
        }
    }

    @Override
    @Uninterruptible(reason="Only uninterruptible code may be executed after Thread.exit.")
    public void afterThreadExit(IsolateThread isolateThread, Thread javaThread) {
        if (SubstrateJVM.get().isRecording()) {
            ThreadEndEvent.emit(javaThread);
            ThreadCPULoadEvent.emit(isolateThread);
        }
        JfrThreadLocal.stopRecording(isolateThread, true);
    }

    @Uninterruptible(reason="Accesses various JFR buffers.")
    public static void stopRecording(IsolateThread isolateThread, boolean freeJavaBuffer) {
        JfrBuffer nb = nativeBuffer.get(isolateThread);
        nativeBuffer.set(isolateThread, (JfrBuffer)Word.nullPointer());
        JfrThreadLocal.flushToGlobalMemoryAndFreeBuffer(nb);
        JfrBuffer jb = javaBuffer.get(isolateThread);
        if (freeJavaBuffer) {
            javaBuffer.set(isolateThread, (JfrBuffer)Word.nullPointer());
            JfrThreadLocal.flushToGlobalMemoryAndFreeBuffer(jb);
        } else {
            JfrThreadLocal.flushToGlobalMemoryAndRetireBuffer(jb);
        }
        javaEventWriter.set(isolateThread, null);
        dataLost.set(isolateThread, Word.unsigned((int)0));
        SamplerStatistics.singleton().addMissedSamples(JfrThreadLocal.getMissedSamples(isolateThread));
        missedSamples.set(isolateThread, 0L);
        SamplerStatistics.singleton().addUnparseableSamples(JfrThreadLocal.getUnparseableStacks(isolateThread));
        unparseableStacks.set(isolateThread, 0L);
        SamplerBuffer buffer = samplerBuffer.get(isolateThread);
        if (buffer.isNonNull()) {
            SubstrateJVM.getSamplerBufferPool().pushFullBuffer(buffer);
            samplerBuffer.set(isolateThread, (SamplerBuffer)Word.nullPointer());
        }
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private static void flushToGlobalMemoryAndFreeBuffer(JfrBuffer buffer) {
        if (buffer.isNull()) {
            return;
        }
        JfrBufferNode node = buffer.getNode();
        if (node.isNull()) {
            assert (JfrBufferAccess.isRetired(buffer));
            JfrBufferAccess.free(buffer);
            return;
        }
        JfrBufferNodeAccess.lockNoTransition(node);
        try {
            JfrThreadLocal.flushToGlobalMemory0(buffer, Word.unsigned((int)0), 0);
            node.setBuffer((JfrBuffer)Word.nullPointer());
            JfrBufferAccess.free(buffer);
        }
        finally {
            JfrBufferNodeAccess.unlock(node);
        }
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private static void flushToGlobalMemoryAndRetireBuffer(JfrBuffer buffer) {
        assert (VMOperation.isInProgressAtSafepoint());
        if (buffer.isNull() || JfrBufferAccess.isRetired(buffer)) {
            return;
        }
        JfrBufferNode node = buffer.getNode();
        JfrBufferNodeAccess.lockNoTransition(node);
        try {
            JfrThreadLocal.flushToGlobalMemory0(buffer, Word.unsigned((int)0), 0);
            JfrBufferAccess.setRetired(buffer);
        }
        finally {
            JfrBufferNodeAccess.unlock(node);
        }
    }

    public static void setExcluded(Thread thread, boolean excluded) {
        if (thread == null || thread != JavaThreads.getCurrentThreadOrNull()) {
            return;
        }
        IsolateThread currentIsolateThread = CurrentIsolate.getCurrentThread();
        Target_java_lang_Thread tjlt = SubstrateUtil.cast(thread, Target_java_lang_Thread.class);
        tjlt.jfrExcluded = excluded;
        if (javaEventWriter.get(currentIsolateThread) != null && !JavaThreads.isVirtual(thread)) {
            JfrThreadLocal.javaEventWriter.get((IsolateThread)currentIsolateThread).excluded = excluded;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isThreadExcluded(Thread thread) {
        if (thread == null) {
            return true;
        }
        Target_java_lang_Thread tjlt = SubstrateUtil.cast(thread, Target_java_lang_Thread.class);
        return tjlt.jfrExcluded;
    }

    public static Target_jdk_jfr_internal_event_EventWriter getEventWriter() {
        Target_jdk_jfr_internal_event_EventWriter eventWriter = javaEventWriter.get();
        if (eventWriter != null && eventWriter.threadID != SubstrateJVM.getCurrentThreadId()) {
            eventWriter.threadID = SubstrateJVM.getCurrentThreadId();
            Target_java_lang_Thread tjlt = SubstrateUtil.cast(Thread.currentThread(), Target_java_lang_Thread.class);
            eventWriter.excluded = tjlt.jfrExcluded;
        }
        return eventWriter;
    }

    public Target_jdk_jfr_internal_event_EventWriter newEventWriter() {
        assert (javaEventWriter.get() == null);
        JfrBuffer buffer = JfrThreadLocal.reinstateJavaBuffer(this.getJavaBuffer());
        if (buffer.isNull()) {
            throw new OutOfMemoryError("OOME for thread local buffer");
        }
        Target_jdk_jfr_internal_event_EventWriter result = JfrEventWriterAccess.newEventWriter(buffer, JfrThreadLocal.isThreadExcluded(JavaThreads.getCurrentThreadOrNull()));
        javaEventWriter.set(result);
        return result;
    }

    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    private static JfrBuffer reinstateJavaBuffer(JfrBuffer buffer) {
        if (buffer.isNull()) {
            return (JfrBuffer)Word.nullPointer();
        }
        JfrBufferNode node = buffer.getNode();
        if (node.isNull()) {
            assert (JfrBufferAccess.isRetired(buffer));
            JfrBufferAccess.reinitialize(buffer);
            JfrBufferAccess.clearRetired(buffer);
            node = javaBufferList.addNode(buffer);
            if (node.isNull()) {
                return (JfrBuffer)Word.nullPointer();
            }
        }
        return buffer;
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public JfrBuffer getExistingJavaBuffer() {
        return javaBuffer.get();
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    public JfrBuffer getJavaBuffer() {
        JfrBuffer buffer = javaBuffer.get();
        if (buffer.isNull()) {
            buffer = JfrBufferAccess.allocate(this.threadLocalBufferSize, JfrBufferType.THREAD_LOCAL_JAVA);
            if (buffer.isNull()) {
                return (JfrBuffer)Word.nullPointer();
            }
            JfrBufferNode node = javaBufferList.addNode(buffer);
            if (node.isNull()) {
                JfrBufferAccess.free(buffer);
                return (JfrBuffer)Word.nullPointer();
            }
            javaBuffer.set(buffer);
        }
        return buffer;
    }

    @Uninterruptible(reason="Accesses a JFR buffer.", callerMustBe=true)
    public JfrBuffer getNativeBuffer() {
        JfrBuffer buffer = nativeBuffer.get();
        if (buffer.isNull()) {
            buffer = JfrBufferAccess.allocate(this.threadLocalBufferSize, JfrBufferType.THREAD_LOCAL_NATIVE);
            if (buffer.isNull()) {
                return (JfrBuffer)Word.nullPointer();
            }
            JfrBufferNode node = nativeBufferList.addNode(buffer);
            if (node.isNull()) {
                JfrBufferAccess.free(buffer);
                return (JfrBuffer)Word.nullPointer();
            }
            nativeBuffer.set(buffer);
        }
        return buffer;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isNotified() {
        return notified.get() != 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void notifyEventWriter(IsolateThread thread) {
        notified.set(thread, 1);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void clearNotification() {
        notified.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Locking without transition requires that the whole critical section is uninterruptible.")
    public static JfrBuffer flushToGlobalMemory(JfrBuffer buffer, UnsignedWord uncommitted, int requested) {
        assert (buffer.isNonNull());
        assert (JfrBufferAccess.isThreadLocal(buffer));
        JfrBufferNode node = buffer.getNode();
        if (node.isNull()) {
            assert (JfrBufferAccess.isRetired(buffer));
            return (JfrBuffer)Word.nullPointer();
        }
        JfrBufferNodeAccess.lockNoTransition(node);
        try {
            JfrBuffer jfrBuffer = JfrThreadLocal.flushToGlobalMemory0(buffer, uncommitted, requested);
            return jfrBuffer;
        }
        finally {
            JfrBufferNodeAccess.unlock(node);
        }
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static JfrBuffer flushToGlobalMemory0(JfrBuffer buffer, UnsignedWord uncommitted, int requested) {
        assert (buffer.isNonNull());
        assert (JfrBufferNodeAccess.isLockedByCurrentThread(buffer.getNode()));
        UnsignedWord unflushedSize = JfrBufferAccess.getUnflushedSize(buffer);
        if (!SubstrateJVM.getGlobalMemory().write(buffer, unflushedSize, false)) {
            JfrBufferAccess.reinitialize(buffer);
            JfrThreadLocal.writeDataLoss(buffer, unflushedSize);
            return (JfrBuffer)Word.nullPointer();
        }
        if (uncommitted.aboveThan(0)) {
            assert (JfrBufferAccess.getDataStart(buffer).add(uncommitted).belowOrEqual((UnsignedWord)JfrBufferAccess.getDataEnd(buffer)));
            UnmanagedMemoryUtil.copy(buffer.getCommittedPos(), JfrBufferAccess.getDataStart(buffer), uncommitted);
        }
        JfrBufferAccess.reinitialize(buffer);
        assert (JfrBufferAccess.getUnflushedSize(buffer).equal(0));
        if (buffer.getSize().aboveOrEqual(uncommitted.add(requested))) {
            return buffer;
        }
        return (JfrBuffer)Word.nullPointer();
    }

    @Uninterruptible(reason="Accesses a JFR buffer.")
    private static void writeDataLoss(JfrBuffer buffer, UnsignedWord unflushedSize) {
        assert (buffer.isNonNull());
        assert (unflushedSize.aboveThan(0));
        UnsignedWord totalDataLoss = JfrThreadLocal.increaseDataLost(unflushedSize);
        if (JfrEvent.DataLoss.shouldEmit()) {
            JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
            JfrNativeEventWriterDataAccess.initialize(data, buffer);
            JfrNativeEventWriter.beginSmallEvent(data, JfrEvent.DataLoss);
            JfrNativeEventWriter.putLong(data, JfrTicks.elapsedTicks());
            JfrNativeEventWriter.putLong(data, unflushedSize.rawValue());
            JfrNativeEventWriter.putLong(data, totalDataLoss.rawValue());
            JfrNativeEventWriter.endSmallEvent(data);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord increaseDataLost(UnsignedWord delta) {
        UnsignedWord result = dataLost.get().add(delta);
        dataLost.set(result);
        return result;
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    public static SamplerBuffer getSamplerBuffer() {
        return JfrThreadLocal.getSamplerBuffer(CurrentIsolate.getCurrentThread());
    }

    @Uninterruptible(reason="Accesses a sampler buffer.", callerMustBe=true)
    public static SamplerBuffer getSamplerBuffer(IsolateThread thread) {
        assert (CurrentIsolate.getCurrentThread() == thread || VMOperation.isInProgressAtSafepoint());
        return samplerBuffer.get(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setSamplerBuffer(SamplerBuffer buffer) {
        samplerBuffer.set(buffer);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void increaseMissedSamples() {
        missedSamples.set(JfrThreadLocal.getMissedSamples() + 1L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getMissedSamples() {
        return missedSamples.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getMissedSamples(IsolateThread thread) {
        return missedSamples.get(thread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void increaseUnparseableStacks() {
        unparseableStacks.set(JfrThreadLocal.getUnparseableStacks() + 1L);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getUnparseableStacks() {
        return unparseableStacks.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getUnparseableStacks(IsolateThread thread) {
        return unparseableStacks.get(thread);
    }
}

