/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.fieldvaluetransformer.NewInstanceFieldValueTransformer;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.RuntimeClassLoading;
import com.oracle.svm.core.hub.registry.ClassRegistries;
import com.oracle.svm.hosted.ClassLoaderFeature;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticallyRegisteredFeature
public class ClassRegistryFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ClassForNameSupport.respectClassLoader();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).initializeAtBuildTime("com.oracle.svm.espresso.classfile", "Native Image classes needed for runtime class loading initialized at build time");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        access.registerSubtypeReachabilityHandler((unused, cls) -> ClassRegistryFeature.onTypeReachable(cls), Object.class);
        Field readWriteLockField = access.findField("com.oracle.svm.espresso.classfile.descriptors.SymbolsImpl", "readWriteLock");
        access.registerFieldValueTransformer(readWriteLockField, new NewInstanceFieldValueTransformer());
    }

    private static void onTypeReachable(Class<?> cls) {
        if (cls.isArray() || cls.isHidden()) {
            return;
        }
        if (RuntimeClassLoading.isSupported() || ClassForNameSupport.isCurrentLayerRegisteredClass(cls.getName())) {
            ClassRegistries.addAOTClass(ClassLoaderFeature.getRuntimeClassLoader(cls.getClassLoader()), cls);
        }
    }
}

