/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.LogUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class LayerArchiveSupport {
    private static final int LAYER_FILE_FORMAT_VERSION_MAJOR = 0;
    private static final int LAYER_FILE_FORMAT_VERSION_MINOR = 1;
    private static final String BUILDER_ARGUMENTS_FILE_NAME = "builder-arguments.txt";
    private static final String SNAPSHOT_FILE_NAME = "layer-snapshot.lsb";
    private static final String SNAPSHOT_GRAPHS_FILE_NAME = "layer-snapshot-graphs.big";
    private static final String LAYER_INFO_MESSAGE_PREFIX = "Native Image Layers";
    protected static final String LAYER_TEMP_DIR_PREFIX = "layerRoot_";
    public static final String LAYER_FILE_EXTENSION = ".nil";
    protected final List<String> builderArguments;
    protected final LayerProperties layerProperties;
    protected final Path layerFile;
    protected final ArchiveSupport archiveSupport;
    protected final Path layerDir;
    private static final Path layerPropertiesFileName = Path.of("META-INF/nilayer.properties", new String[0]);

    public LayerArchiveSupport(String layerName, Path layerFile, Path layerDir, ArchiveSupport archiveSupport) {
        this.archiveSupport = archiveSupport;
        this.layerFile = layerFile;
        this.validateLayerFile();
        this.layerDir = layerDir;
        try {
            Files.createDirectory(layerDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw UserError.abort("Unable to create temp directory " + String.valueOf(layerDir) + " where the layer files reside in expanded form.", e);
        }
        this.layerProperties = new LayerProperties(layerName);
        this.builderArguments = new ArrayList<String>();
    }

    protected void validateLayerFile() {
        Path fileName = this.layerFile.getFileName();
        if (fileName == null || !fileName.toString().endsWith(LAYER_FILE_EXTENSION)) {
            throw UserError.abort("The given layer file " + String.valueOf(this.layerFile) + " must end with '.nil'.", new Object[0]);
        }
        if (Files.isDirectory(this.layerFile, new LinkOption[0])) {
            throw UserError.abort("The given layer file " + String.valueOf(this.layerFile) + " is a directory and not a file.", new Object[0]);
        }
    }

    public Path getSnapshotPath() {
        return this.layerDir.resolve(SNAPSHOT_FILE_NAME);
    }

    public Path getSnapshotGraphsPath() {
        return this.layerDir.resolve(SNAPSHOT_GRAPHS_FILE_NAME);
    }

    public Path getSharedLibraryPath() {
        return this.layerDir.resolve(this.layerProperties.layerName() + ".so");
    }

    protected Path getLayerPropertiesFile() {
        return this.layerDir.resolve(layerPropertiesFileName);
    }

    protected Path getBuilderArgumentsFilePath() {
        return this.layerDir.resolve(BUILDER_ARGUMENTS_FILE_NAME);
    }

    private static String platform() {
        return (OS.getCurrent().className + "-" + SubstrateUtil.getArchitectureName()).toLowerCase(Locale.ROOT);
    }

    protected static void info(String format, Object ... args) {
        LogUtils.prefixInfo((String)LAYER_INFO_MESSAGE_PREFIX, (String)format, (Object[])args);
    }

    public final class LayerProperties {
        private static final String PROPERTY_KEY_LAYER_FILE_VERSION_MAJOR = "LayerFileVersionMajor";
        private static final String PROPERTY_KEY_LAYER_FILE_VERSION_MINOR = "LayerFileVersionMinor";
        private static final String PROPERTY_KEY_LAYER_FILE_CREATION_TIMESTAMP = "LayerFileCreationTimestamp";
        private static final String PROPERTY_KEY_LAYER_BUILDER_VM_PLATFORM = "BuilderVMPlatform";
        private static final String PROPERTY_KEY_IMAGE_LAYER_NAME = "LayerName";
        private final Map<String, String> properties = new HashMap<String, String>();

        LayerProperties(String layerName) {
            VMError.guarantee(layerName != null && !layerName.isEmpty(), "LayerProperties entry LayerName requires non-empty layer-name");
            this.properties.put(PROPERTY_KEY_IMAGE_LAYER_NAME, layerName);
        }

        void loadAndVerify() {
            Path layerFileName = LayerArchiveSupport.this.layerFile.getFileName();
            Path layerPropertiesFile = LayerArchiveSupport.this.getLayerPropertiesFile();
            if (!Files.isReadable(layerPropertiesFile)) {
                throw UserError.abort("The given layer file " + String.valueOf(layerFileName) + " does not contain a layer properties file", new Object[0]);
            }
            this.properties.putAll(ArchiveSupport.loadProperties(layerPropertiesFile));
            this.verifyLayerFileVersion(layerFileName);
            LayerArchiveSupport.info("Loaded layer %s from %s", this.layerName(), layerFileName);
            BuilderVMIdentifier layerBuilderVMIdentifier = BuilderVMIdentifier.load(this.properties);
            if (!layerBuilderVMIdentifier.equals(BuilderVMIdentifier.system())) {
                String message = String.format("The given layer file '%s' was created with an image builder running on %s. This image builder is using %s. The given layer file can only be used with an image builder running the exact same version.", layerFileName, layerBuilderVMIdentifier, BuilderVMIdentifier.system());
                throw UserError.abort(message, new Object[0]);
            }
            String niPlatform = this.properties.getOrDefault(PROPERTY_KEY_LAYER_BUILDER_VM_PLATFORM, "unknown");
            if (!niPlatform.equals(LayerArchiveSupport.platform())) {
                String message = String.format("The given layer file '%s' was created on platform '%s'. The current platform is '%s'. The given layer file can only be used with an image builder running on that same platform.", layerFileName, niPlatform, LayerArchiveSupport.platform());
                throw UserError.abort(message, new Object[0]);
            }
            String layerCreationTimestamp = this.properties.getOrDefault(PROPERTY_KEY_LAYER_FILE_CREATION_TIMESTAMP, "");
            LayerArchiveSupport.info("Layer created at '%s'", ArchiveSupport.parseTimestamp(layerCreationTimestamp));
            LayerArchiveSupport.info("Using version: %s on platform: '%s'", layerBuilderVMIdentifier, niPlatform);
        }

        private void verifyLayerFileVersion(Path layerFileName) {
            String fileVersionKey = PROPERTY_KEY_LAYER_FILE_VERSION_MAJOR;
            try {
                int major = Integer.parseInt(this.properties.getOrDefault(fileVersionKey, "-1"));
                fileVersionKey = PROPERTY_KEY_LAYER_FILE_VERSION_MINOR;
                int minor = Integer.parseInt(this.properties.getOrDefault(fileVersionKey, "-1"));
                String message = String.format("The given layer file %s was created with a newer layer-file-format version %d.%d (current %d.%d). Update to the latest version of native-image.", layerFileName, major, minor, 0, 1);
                if (major > 0) {
                    throw UserError.abort(message, new Object[0]);
                }
                if (major == 0 && minor > 1) {
                    LogUtils.warning((String)message);
                }
            }
            catch (NumberFormatException e) {
                throw VMError.shouldNotReachHere(fileVersionKey + " in " + String.valueOf(layerPropertiesFileName) + " is missing or ill-defined", e);
            }
        }

        void write() {
            this.properties.put(PROPERTY_KEY_LAYER_FILE_CREATION_TIMESTAMP, ArchiveSupport.currentTime());
            this.properties.put(PROPERTY_KEY_LAYER_BUILDER_VM_PLATFORM, LayerArchiveSupport.platform());
            BuilderVMIdentifier.system().store(this.properties);
            Path layerPropertiesFile = LayerArchiveSupport.this.getLayerPropertiesFile();
            Path parent = layerPropertiesFile.getParent();
            if (parent == null) {
                throw VMError.shouldNotReachHere("The layer properties file " + String.valueOf(layerPropertiesFile) + " doesn't have a parent directory.");
            }
            LayerArchiveSupport.this.archiveSupport.ensureDirectoryExists(parent);
            try (OutputStream outputStream = Files.newOutputStream(layerPropertiesFile, new OpenOption[0]);){
                Properties p = new Properties();
                p.putAll(this.properties);
                p.store(outputStream, "Native Image Layer file properties");
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Creating layer properties file " + String.valueOf(layerPropertiesFile) + " failed", e);
            }
        }

        public String layerName() {
            return this.properties.get(PROPERTY_KEY_IMAGE_LAYER_NAME);
        }

        private record BuilderVMIdentifier(String vendor, String version) {
            private static final String PROPERTY_KEY_VM_VENDOR = "BuilderVMVendor";
            private static final String PROPERTY_KEY_VM_VERSION = "BuilderVMVersion";

            BuilderVMIdentifier {
                Objects.requireNonNull(vendor);
                Objects.requireNonNull(version);
            }

            static BuilderVMIdentifier system() {
                return new BuilderVMIdentifier(System.getProperty("java.vm.vendor"), System.getProperty("java.vm.version"));
            }

            static BuilderVMIdentifier load(Map<String, String> properties) {
                String vmVendor = properties.get(PROPERTY_KEY_VM_VENDOR);
                String vmVersion = properties.get(PROPERTY_KEY_VM_VERSION);
                return new BuilderVMIdentifier(vmVendor, vmVersion);
            }

            public void store(Map<String, String> properties) {
                properties.put(PROPERTY_KEY_VM_VENDOR, this.vendor);
                properties.put(PROPERTY_KEY_VM_VERSION, this.version);
            }

            @Override
            public String toString() {
                return "'" + this.vendor + " " + this.version + "'";
            }
        }
    }
}

