/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.javafx;

import com.oracle.svm.configure.ResourcesRegistry;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.hosted.javafx.JavaFXJNI;
import com.oracle.svm.hosted.javafx.JavaFXReflection;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.InternalPlatform;

@AutomaticallyRegisteredFeature
@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
final class JavaFXFeature
extends JNIRegistrationUtil
implements InternalFeature {
    JavaFXFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JavaFXFeature.getJavaFXApplication((Feature.FeatureAccess)access) != null;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        ConfigurationCondition sceneReachable = ConfigurationCondition.create((Class)access.findClassByName("javafx.scene.Scene"), (boolean)false);
        resourcesRegistry.addResources((Object)sceneReachable, "com.sun.javafx.tk.quantum.QuantumMessagesBundle.properties", (Object)"");
        if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
            resourcesRegistry.addResources((Object)sceneReachable, "com.sun.prism.es2.glsl.*", (Object)"");
            resourcesRegistry.addResources((Object)sceneReachable, "com.sun.scenario.effect.impl.es2.glsl.*", (Object)"");
        } else if (Platform.includedIn(Platform.WINDOWS.class)) {
            resourcesRegistry.addResources((Object)sceneReachable, "com.sun.prism.d3d.hlsl.*", (Object)"");
            resourcesRegistry.addResources((Object)sceneReachable, "com.sun.scenario.effect.impl.hw.d3d.hlsl.*", (Object)"");
            resourcesRegistry.addResourceBundles((Object)sceneReachable, "com.sun.glass.ui.win.themes");
        }
        ConfigurationCondition controlsReachable = ConfigurationCondition.create((Class)access.findClassByName("javafx.scene.control.Control"), (boolean)false);
        resourcesRegistry.addResources((Object)controlsReachable, "com.sun.javafx.scene.control.skin.resources.controls.properties", (Object)"");
        resourcesRegistry.addResources((Object)controlsReachable, "com.sun.javafx.scene.control.skin.resources.controls-nt.properties", (Object)"");
        resourcesRegistry.addResources((Object)controlsReachable, "com.sun.javafx.scene.control.skin.modena.*");
        ConfigurationCondition fxmlReachable = ConfigurationCondition.create((Class)access.findClassByName("javafx.fxml.FXMLLoader"), (boolean)false);
        resourcesRegistry.addResources((Object)fxmlReachable, "com.sun.org.apache.xerces.internal.impl.msg.XMLMessages", (Object)"");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerSubtypeReachabilityHandler(this::registerApplicationClass, JavaFXFeature.getJavaFXApplication((Feature.FeatureAccess)access));
        Stream.of("com.sun.javafx.tk.quantum.QuantumRenderer", "javafx.stage.Screen", "com.sun.javafx.scene.control.behavior.BehaviorBase", "com.sun.javafx.scene.control.skin.BehaviorSkinBase", "javafx.scene.control.SkinBase", "javafx.scene.control.Control", "javafx.scene.control.PopupControl", "javafx.scene.control.SkinBase$StyleableProperties", "javafx.scene.control.Labeled$StyleableProperties", "javafx.scene.control.SkinBase$StyleableProperties", "com.sun.javafx.tk.quantum.PrismImageLoader2$AsyncImageLoader", "com.sun.javafx.tk.quantum.PrismImageLoader2", "com.sun.prism.PresentableState").map(arg_0 -> ((Feature.BeforeAnalysisAccess)access).findClassByName(arg_0)).filter(Objects::nonNull).forEach(xva$0 -> RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{xva$0}));
        PlatformNativeLibrarySupport librarySupport = PlatformNativeLibrarySupport.singleton();
        Stream.of("com_sun_glass", "com_sun_javafx_embed", "com_sun_javafx_iio_jpeg", "com_sun_prism_d3d", "com_sun_prism_es2").forEach(librarySupport::addBuiltinPkgNativePrefix);
        Stream<String> fontPackages = Platform.includedIn(Platform.WINDOWS.class) ? Stream.of("PrismFontFactory", "directwrite") : (Platform.includedIn(Platform.LINUX.class) ? Stream.of("FontConfigManager", "freetype") : (Platform.includedIn(Platform.DARWIN.class) ? Stream.of("DFontDecoder", "MacFontFinder", "coretext") : Stream.empty()));
        fontPackages.map("com_sun_javafx_font_"::concat).forEach(librarySupport::addBuiltinPkgNativePrefix);
        access.registerReachabilityHandler(this::enableJavaFX, new Object[]{JavaFXFeature.clazz((Feature.FeatureAccess)access, "javafx.scene.Scene")});
        access.registerReachabilityHandler(this::enableIIO, new Object[]{JavaFXFeature.clazz((Feature.FeatureAccess)access, "com.sun.javafx.iio.jpeg.JPEGImageLoader")});
        access.registerReachabilityHandler(this::enablePrinting, new Object[]{JavaFXFeature.clazz((Feature.FeatureAccess)access, "com.sun.javafx.tk.PrintPipeline")});
        this.registerIfReachable(access, this::enableControls, "javafx.scene.control.Control");
        this.registerIfReachable(access, this::enableFXML, "javafx.fxml.FXMLLoader");
        this.registerIfReachable(access, this::enableSwing, "javafx.embed.swing.SwingNode");
    }

    private static Class<?> getJavaFXApplication(Feature.FeatureAccess access) {
        return access.findClassByName("javafx.application.Application");
    }

    private void registerApplicationClass(Feature.DuringAnalysisAccess access, Class<?> appClass) {
        if (!Modifier.isAbstract(appClass.getModifiers())) {
            RuntimeReflection.register((Class[])new Class[]{appClass});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{appClass});
        }
    }

    private void registerIfReachable(Feature.BeforeAnalysisAccess access, Consumer<Feature.DuringAnalysisAccess> callback, String className) {
        Class cls = access.findClassByName(className);
        if (cls != null) {
            access.registerReachabilityHandler(callback, new Object[]{cls});
        }
    }

    private void enableJavaFX(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerJavaFX(access);
        this.enableGlass(access);
        this.enableFonts(access);
        if (Platform.includedIn(Platform.LINUX.class)) {
            this.enableGlassGTK3(access);
            this.enableFontsLinux(access);
            this.enablePrismES2(access);
        } else if (Platform.includedIn(Platform.DARWIN.class)) {
            this.enableGlassMac(access);
            this.enableFontsMac(access);
            this.enablePrismES2(access);
        } else if (Platform.includedIn(Platform.WINDOWS.class)) {
            this.enableGlassWin(access);
            this.enableFontsWin(access);
            this.enablePrismD3D(access);
        }
    }

    private void enableGlass(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerGlass(access);
        JavaFXJNI.registerGlass(access);
    }

    private void enableGlassMac(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerGlassMac(access);
        JavaFXJNI.registerGlassMac(access);
    }

    private void enableGlassWin(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerGlassWin(access);
        JavaFXJNI.registerGlassWin(access);
    }

    private void enableGlassGTK3(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerGlassGTK3(access);
        JavaFXJNI.registerGlassGTK3(access);
    }

    private void enableFonts(Feature.DuringAnalysisAccess access) {
        JavaFXJNI.registerFonts(access);
    }

    private void enableFontsMac(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerFontsMac(access);
        JavaFXJNI.registerFontsMac(access);
    }

    private void enableFontsWin(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerFontsWin(access);
        JavaFXJNI.registerFontsWin(access);
    }

    private void enableFontsLinux(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerFontsLinux(access);
        JavaFXJNI.registerFontsLinux(access);
    }

    private void enableIIO(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerIIO(access);
        JavaFXJNI.registerIIO(access);
    }

    private void enablePrismD3D(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerPrismD3D(access);
        JavaFXJNI.registerPrismD3D(access);
    }

    private void enablePrismES2(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerPrismES2(access);
        JavaFXJNI.registerPrismES2(access);
    }

    private void enableControls(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerControls(access);
    }

    private void enableFXML(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerFXML(access);
    }

    private void enableSwing(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerSwing(access);
        JavaFXJNI.registerSwing(access);
    }

    private void enablePrinting(Feature.DuringAnalysisAccess access) {
        JavaFXReflection.registerPrinting(access);
    }
}

