/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import java.util.HashSet;
import java.util.Set;
import jdk.graal.compiler.bytecode.Bytecode;
import jdk.graal.compiler.bytecode.BytecodeStream;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.java.BciBlockMapping;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ResolvedJavaMethod;

final class DeoptimizationTargetBciBlockMapping
extends BciBlockMapping {
    private final Set<DeoptEntryInsertionPoint> insertedBlocks;

    private DeoptimizationTargetBciBlockMapping(Bytecode code, DebugContext debug) {
        super(code, debug);
        VMError.guarantee(SubstrateCompilationDirectives.isDeoptTarget(code.getMethod()), "Deoptimization Target expected.");
        this.insertedBlocks = new HashSet<DeoptEntryInsertionPoint>();
    }

    public static BciBlockMapping create(BytecodeStream stream, Bytecode code, OptionValues options, DebugContext debug, boolean hasAsyncExceptions) {
        DeoptimizationTargetBciBlockMapping map = new DeoptimizationTargetBciBlockMapping(code, debug);
        DeoptimizationTargetBciBlockMapping.buildMap((BytecodeStream)stream, (Bytecode)code, (OptionValues)options, (DebugContext)debug, (BciBlockMapping)map, (boolean)hasAsyncExceptions);
        return map;
    }

    protected BciBlockMapping.BciBlock getInstructionBlock(int bci) {
        BciBlockMapping.BciBlock current = this.blockMap[bci];
        assert (!(current instanceof BciBlockMapping.ExceptionDispatchBlock));
        if (current instanceof DeoptBciBlock) {
            assert (!(current.getSuccessor(0) instanceof DeoptBciBlock));
            return current.getSuccessor(0);
        }
        return current;
    }

    private boolean isDeoptEntry(int bci, FrameState.StackState stackState) {
        ResolvedJavaMethod method = this.code.getMethod();
        return SubstrateCompilationDirectives.singleton().isDeoptEntry((MultiMethod)method, bci, stackState);
    }

    private boolean isRegisteredDeoptEntry(int bci, FrameState.StackState stackState) {
        return SubstrateCompilationDirectives.singleton().isRegisteredDeoptEntry((MultiMethod)this.code.getMethod(), bci, stackState);
    }

    protected boolean isStartOfNewBlock(BciBlockMapping.BciBlock current, int bci) {
        if (this.isDeoptEntry(bci, FrameState.StackState.BeforePop)) {
            return true;
        }
        return super.isStartOfNewBlock(current, bci);
    }

    private void recordInsertedBlock(DeoptEntryInsertionPoint block) {
        ++this.blocksNotYetAssignedId;
        assert (this.insertedBlocks.add(block));
    }

    protected void addInvokeNormalSuccessor(int invokeBci, BciBlockMapping.BciBlock sux) {
        if (sux.isExceptionEntry()) {
            throw new PermanentBailoutException("Exception handler can be reached by both normal and exceptional control flow");
        }
        if (this.isDeoptEntry(invokeBci, FrameState.StackState.AfterPop)) {
            if (!(sux instanceof DeoptBciBlock)) {
                DeoptBciBlock proxyBlock = DeoptBciBlock.createDeoptProxy(sux.getStartBci(), invokeBci);
                this.recordInsertedBlock(proxyBlock);
                this.getInstructionBlock(invokeBci).addSuccessor((BciBlockMapping.BciBlock)proxyBlock);
                proxyBlock.addSuccessor(sux);
                return;
            }
            ((DeoptBciBlock)sux).setProxifiedInvokeBci(invokeBci);
        }
        super.addInvokeNormalSuccessor(invokeBci, sux);
    }

    private void addExceptionHandlerEdge(DeoptBciBlock block) {
        BciBlockMapping.ExceptionDispatchBlock deoptExceptionHandler = this.handleExceptions(block.getStartBci(), false, false);
        if (deoptExceptionHandler != null) {
            block.addSuccessor((BciBlockMapping.BciBlock)deoptExceptionHandler);
        }
    }

    protected BciBlockMapping.BciBlock startNewBlock(int bci) {
        BciBlockMapping.BciBlock currentBlock = this.blockMap[bci];
        if (currentBlock != null) {
            assert (currentBlock.getStartBci() == bci);
            return currentBlock;
        }
        BciBlockMapping.BciBlock newBlock = new BciBlockMapping.BciBlock(bci);
        ++this.blocksNotYetAssignedId;
        if (this.isDeoptEntry(bci, FrameState.StackState.BeforePop)) {
            DeoptBciBlock deoptEntry = DeoptBciBlock.createDeoptEntry(bci);
            this.recordInsertedBlock(deoptEntry);
            deoptEntry.addSuccessor(newBlock);
            newBlock = deoptEntry;
        }
        this.blockMap[bci] = newBlock;
        return newBlock;
    }

    protected Set<BciBlockMapping.BciBlock> makeExceptionEntries(boolean splitRanges) {
        Set requestedBlockStarts = super.makeExceptionEntries(splitRanges);
        for (BciBlockMapping.BciBlock block : requestedBlockStarts) {
            if (!(block instanceof DeoptBciBlock)) continue;
            this.addExceptionHandlerEdge((DeoptBciBlock)block);
        }
        return requestedBlockStarts;
    }

    protected BciBlockMapping.BciBlock processNewBciBlock(int bci, BciBlockMapping.BciBlock newBlock) {
        if (this.isDeoptEntry(bci, FrameState.StackState.BeforePop)) {
            DeoptBciBlock deoptBciBlock = DeoptBciBlock.createDeoptEntry(bci);
            this.recordInsertedBlock(deoptBciBlock);
            deoptBciBlock.addSuccessor(newBlock);
            this.addExceptionHandlerEdge(deoptBciBlock);
            this.blockMap[bci] = deoptBciBlock;
            return deoptBciBlock;
        }
        return newBlock;
    }

    protected BciBlockMapping.ExceptionDispatchBlock processNewExceptionDispatchBlock(int bci, boolean isInvoke, BciBlockMapping.ExceptionDispatchBlock handler) {
        boolean isInvokeProxy;
        boolean isDeoptEntry = this.isDeoptEntry(bci, FrameState.StackState.Rethrow);
        boolean bl = isInvokeProxy = isInvoke && this.isDeoptEntry(bci, FrameState.StackState.AfterPop);
        if (isDeoptEntry || isInvokeProxy) {
            DeoptExceptionDispatchBlock block;
            if (handler == null) {
                block = new DeoptExceptionDispatchBlock(bci, isDeoptEntry, isInvokeProxy);
            } else {
                block = new DeoptExceptionDispatchBlock(handler, bci, isDeoptEntry, isInvokeProxy);
                block.addSuccessor((BciBlockMapping.BciBlock)handler);
            }
            this.recordInsertedBlock(block);
            return block;
        }
        return handler;
    }

    protected boolean verify() {
        HashSet<Long> coveredEncodedBcis = new HashSet<Long>();
        for (DeoptEntryInsertionPoint deopt : this.insertedBlocks) {
            FrameState.StackState stackState;
            BciBlockMapping.BciBlock block = deopt.asBlock();
            int bci = deopt.frameStateBci();
            boolean isExceptionDispatch = deopt.isExceptionDispatch();
            boolean isProxy = deopt.isProxy();
            boolean proxifysInvoke = deopt.proxifysInvoke();
            boolean coversInvoke = false;
            boolean coversDeoptEntry = false;
            FrameState.StackState stackState2 = stackState = isExceptionDispatch ? FrameState.StackState.Rethrow : FrameState.StackState.BeforePop;
            if (deopt.proxifysInvoke()) {
                int proxifiedInvokeBci = deopt.proxifiedInvokeBci();
                assert (proxifiedInvokeBci >= 0);
                coversInvoke = this.isRegisteredDeoptEntry(proxifiedInvokeBci, FrameState.StackState.AfterPop);
            }
            if (!isProxy) {
                coversDeoptEntry = this.isRegisteredDeoptEntry(bci, stackState);
            }
            if (block.getId() < 0) {
                assert (!coversInvoke && !coversDeoptEntry);
                continue;
            }
            if (proxifysInvoke) assert (coversInvoke);
            if (isProxy) {
                assert (proxifysInvoke);
            } else {
                assert (coversDeoptEntry);
                assert (coveredEncodedBcis.add(FrameInfoEncoder.encodeBci(bci, stackState))) : "Deoptimization entry points must be unique.";
            }
            assert (block.getSuccessorCount() <= 2) : "DeoptEntryInsertionPoint must have at most 2 successors";
            for (BciBlockMapping.BciBlock sux : block.getSuccessors()) {
                assert (!(sux instanceof DeoptEntryInsertionPoint)) : "Successor of DeoptEntryInsertionPoint should not be a DeoptEntryInsertionPoint.";
            }
            assert (!block.isDuplicate()) : "DeoptEntryInsertionPoint must be unique";
        }
        return super.verify();
    }

    static final class DeoptBciBlock
    extends BciBlockMapping.BciBlock
    implements DeoptEntryInsertionPoint {
        public final int deoptEntryBci;
        public int proxifiedInvokeBci;

        private DeoptBciBlock(int startBci, int deoptEntryBci, int proxifiedInvokeBci) {
            super(startBci, startBci);
            this.deoptEntryBci = deoptEntryBci;
            this.proxifiedInvokeBci = proxifiedInvokeBci;
        }

        static DeoptBciBlock createDeoptEntry(int bci) {
            assert (bci >= 0);
            return new DeoptBciBlock(bci, bci, -5);
        }

        static DeoptBciBlock createDeoptProxy(int successorBci, int proxifiedInvokeBci) {
            assert (proxifiedInvokeBci >= 0);
            return new DeoptBciBlock(successorBci, -5, proxifiedInvokeBci);
        }

        public void setEndBci(int bci) {
            throw GraalError.unimplementedOverride();
        }

        public boolean isInstructionBlock() {
            return false;
        }

        @Override
        public int proxifiedInvokeBci() {
            return this.proxifiedInvokeBci;
        }

        public void setProxifiedInvokeBci(int bci) {
            assert (this.proxifiedInvokeBci == -5);
            this.proxifiedInvokeBci = bci;
        }

        @Override
        public boolean isProxy() {
            assert (this.deoptEntryBci >= 0 || this.deoptEntryBci == -5);
            return this.deoptEntryBci == -5;
        }

        @Override
        public int frameStateBci() {
            return this.getStartBci();
        }

        @Override
        public boolean isExceptionDispatch() {
            return false;
        }

        @Override
        public BciBlockMapping.BciBlock asBlock() {
            return this;
        }

        public String toString() {
            return super.toString() + " (DeoptBciBlock)";
        }
    }

    static interface DeoptEntryInsertionPoint {
        public int proxifiedInvokeBci();

        public boolean isExceptionDispatch();

        public int frameStateBci();

        public BciBlockMapping.BciBlock asBlock();

        default public boolean proxifysInvoke() {
            if (!1.$assertionsDisabled && this.proxifiedInvokeBci() < 0 && this.proxifiedInvokeBci() != -5) {
                throw new AssertionError();
            }
            return this.proxifiedInvokeBci() != -5;
        }

        public boolean isProxy();

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }

    static class DeoptExceptionDispatchBlock
    extends BciBlockMapping.ExceptionDispatchBlock
    implements DeoptEntryInsertionPoint {
        final boolean isDeoptEntry;
        final boolean isInvokeProxy;

        DeoptExceptionDispatchBlock(int bci, boolean isDeoptEntry, boolean isInvokeProxy) {
            super(bci);
            this.isDeoptEntry = isDeoptEntry;
            this.isInvokeProxy = isInvokeProxy;
        }

        DeoptExceptionDispatchBlock(BciBlockMapping.ExceptionDispatchBlock dispatch, int bci, boolean isDeoptEntry, boolean isInvokeProxy) {
            super(dispatch.handler, dispatch.handlerID, bci);
            this.isDeoptEntry = isDeoptEntry;
            this.isInvokeProxy = isInvokeProxy;
        }

        @Override
        public int proxifiedInvokeBci() {
            return this.isInvokeProxy ? this.deoptBci : -5;
        }

        @Override
        public boolean isProxy() {
            return !this.isDeoptEntry;
        }

        @Override
        public int frameStateBci() {
            return this.deoptBci;
        }

        @Override
        public boolean isExceptionDispatch() {
            return true;
        }

        @Override
        public BciBlockMapping.BciBlock asBlock() {
            return this;
        }

        public String toString() {
            return super.toString() + " (DeoptExceptionDispatchBlock)";
        }
    }
}

