/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect.proxy;

import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.util.LogUtils;
import java.util.List;
import java.util.function.BiConsumer;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class ProxyRegistry
extends ConditionalConfigurationRegistry
implements BiConsumer<ConfigurationCondition, List<String>> {
    private final DynamicProxyRegistry dynamicProxySupport;
    private final ImageClassLoader imageClassLoader;

    public ProxyRegistry(DynamicProxyRegistry dynamicProxySupport, ImageClassLoader imageClassLoader) {
        this.dynamicProxySupport = dynamicProxySupport;
        this.imageClassLoader = imageClassLoader;
    }

    @Override
    public void accept(ConfigurationCondition condition, List<String> proxies) {
        Class[] interfaces = this.checkIfInterfacesAreValid(proxies);
        if (interfaces != null) {
            this.registerConditionalConfiguration(condition, cnd -> this.dynamicProxySupport.addProxyClass((ConfigurationCondition)cnd, interfaces));
        }
    }

    public Class<?> createProxyClassForSerialization(List<String> proxies) {
        Class<?>[] interfaces = this.checkIfInterfacesAreValid(proxies);
        if (interfaces != null) {
            return this.dynamicProxySupport.getProxyClassHosted(interfaces);
        }
        return null;
    }

    private Class<?>[] checkIfInterfacesAreValid(List<String> proxyInterfaceNames) {
        Class[] interfaces = new Class[proxyInterfaceNames.size()];
        for (int i = 0; i < proxyInterfaceNames.size(); ++i) {
            Class clazz;
            String interfaceName = proxyInterfaceNames.get(i);
            if (!ProxyRegistry.checkClass(proxyInterfaceNames, interfaceName, clazz = (Class)this.imageClassLoader.findClass(interfaceName).get())) {
                return null;
            }
            interfaces[i] = clazz;
        }
        return interfaces;
    }

    private static boolean checkClass(List<String> interfaceNames, String className, Class<?> clazz) {
        if (clazz == null) {
            ProxyRegistry.warning(interfaceNames, "Class " + className + " not found.");
            return false;
        }
        if (!clazz.isInterface()) {
            ProxyRegistry.warning(interfaceNames, "Class " + className + " is not an interface.");
            return false;
        }
        return true;
    }

    private static void warning(List<String> interfaceNames, String reason) {
        LogUtils.warning((String)"Cannot register dynamic proxy for interface list: %s. Reason: %s.", (Object[])new Object[]{String.join((CharSequence)", ", interfaceNames), reason});
    }
}

