/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import com.oracle.svm.interpreter.BuildTimeConstantPool;
import com.oracle.svm.interpreter.InterpreterFeature;
import com.oracle.svm.interpreter.InterpreterToVM;
import com.oracle.svm.interpreter.InterpreterUtil;
import com.oracle.svm.interpreter.metadata.BytecodeStream;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaField;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedPrimitiveType;
import com.oracle.svm.interpreter.metadata.InterpreterUniverseImpl;
import com.oracle.svm.interpreter.metadata.InterpreterUnresolvedSignature;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import com.oracle.svm.interpreter.metadata.ReferenceConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaField;
import jdk.vm.ci.meta.UnresolvedJavaMethod;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class BuildTimeInterpreterUniverse {
    private static BuildTimeInterpreterUniverse INSTANCE;
    private final Map<ResolvedJavaType, InterpreterResolvedJavaType> types = new ConcurrentHashMap<ResolvedJavaType, InterpreterResolvedJavaType>();
    private final Map<String, UnresolvedJavaType> unresolvedTypes;
    private final Map<String, UnresolvedJavaMethod> unresolvedMethods;
    private final Map<String, UnresolvedJavaField> unresolvedFields;
    private final Map<ResolvedJavaField, InterpreterResolvedJavaField> fields = new ConcurrentHashMap<ResolvedJavaField, InterpreterResolvedJavaField>();
    private final Map<ResolvedJavaMethod, InterpreterResolvedJavaMethod> methods = new ConcurrentHashMap<ResolvedJavaMethod, InterpreterResolvedJavaMethod>();
    private final Map<String, InterpreterUnresolvedSignature> signatures = new ConcurrentHashMap<String, InterpreterUnresolvedSignature>();
    private final Map<Number, PrimitiveConstant> primitiveConstants = new ConcurrentHashMap<Number, PrimitiveConstant>();
    private final Map<String, ReferenceConstant<String>> strings = new ConcurrentHashMap<String, ReferenceConstant<String>>();
    private final Map<ImageHeapConstant, ReferenceConstant<?>> objectConstants = new ConcurrentHashMap();
    private final Map<ExceptionHandler, ExceptionHandler> exceptionHandlers = new ConcurrentHashMap<ExceptionHandler, ExceptionHandler>();
    private SnippetReflectionProvider snippetReflectionProvider;
    private final Map<LocalWrapper, LocalWrapper> locals = new ConcurrentHashMap<LocalWrapper, LocalWrapper>();
    private final Map<LocalVariableTableWrapper, LocalVariableTableWrapper> localVariableTables = new ConcurrentHashMap<LocalVariableTableWrapper, LocalVariableTableWrapper>();
    private final Map<JavaConstant, JavaConstant> indyAppendices;
    private Map<InterpreterResolvedObjectType, List<InterpreterResolvedJavaMethod>> classToMethods;
    private Map<InterpreterResolvedObjectType, List<InterpreterResolvedJavaField>> classToFields;

    public static void freshSingletonInstance() {
        INSTANCE = new BuildTimeInterpreterUniverse();
    }

    public SnippetReflectionProvider getSnippetReflectionProvider() {
        return this.snippetReflectionProvider;
    }

    private void setSnippetReflectionProvider(SnippetReflectionProvider snippetReflectionProvider) {
        this.snippetReflectionProvider = snippetReflectionProvider;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static InterpreterResolvedObjectType createResolvedObjectType(ResolvedJavaType resolvedJavaType) {
        BuildTimeInterpreterUniverse universe = BuildTimeInterpreterUniverse.singleton();
        String name = universe.dedup(resolvedJavaType.getName());
        Class clazz = OriginalClassProvider.getJavaClass((JavaType)resolvedJavaType);
        ResolvedJavaType originalType = MetadataUtil.requireNonNull(resolvedJavaType);
        int modifiers = resolvedJavaType.getModifiers();
        InterpreterResolvedJavaType componentType = originalType.isArray() ? universe.getOrCreateType(originalType.getComponentType()) : null;
        String sourceFileName = universe.dedup(resolvedJavaType.getSourceFileName());
        ResolvedJavaType originalSuperclass = resolvedJavaType.getSuperclass();
        InterpreterResolvedObjectType superclass = null;
        if (originalSuperclass != null) {
            superclass = (InterpreterResolvedObjectType)universe.getOrCreateType(originalSuperclass);
        }
        ResolvedJavaType[] originalInterfaces = resolvedJavaType.getInterfaces();
        InterpreterResolvedObjectType[] interfaces = new InterpreterResolvedObjectType[originalInterfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = (InterpreterResolvedObjectType)universe.getOrCreateType(originalInterfaces[i]);
        }
        return InterpreterResolvedObjectType.createAtBuildTime(resolvedJavaType, name, modifiers, componentType, superclass, interfaces, null, clazz, sourceFileName);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static InterpreterResolvedJavaField createResolvedJavaField(ResolvedJavaField resolvedJavaField) {
        ResolvedJavaField originalField = resolvedJavaField;
        BuildTimeInterpreterUniverse universe = BuildTimeInterpreterUniverse.singleton();
        String name = universe.dedup(resolvedJavaField.getName());
        int modifiers = resolvedJavaField.getModifiers();
        JavaType fieldType = originalField.getType();
        InterpreterResolvedJavaType type = universe.getOrCreateType((ResolvedJavaType)fieldType);
        InterpreterResolvedObjectType declaringClass = universe.referenceType(originalField.getDeclaringClass());
        return InterpreterResolvedJavaField.create(originalField, name, modifiers, type, declaringClass, 0, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static InterpreterResolvedJavaMethod createResolveJavaMethod(ResolvedJavaMethod originalMethod) {
        assert (originalMethod instanceof AnalysisMethod);
        MetadataUtil.requireNonNull(originalMethod);
        BuildTimeInterpreterUniverse universe = BuildTimeInterpreterUniverse.singleton();
        String name = universe.dedup(originalMethod.getName());
        int maxLocals = originalMethod.getMaxLocals();
        int maxStackSize = originalMethod.getMaxStackSize();
        int modifiers = originalMethod.getModifiers();
        InterpreterResolvedObjectType declaringClass = universe.referenceType(originalMethod.getDeclaringClass());
        InterpreterUnresolvedSignature signature = universe.unresolvedSignature(originalMethod.getSignature());
        byte[] interpretedCode = originalMethod.getCode() == null ? null : (byte[])originalMethod.getCode().clone();
        AnalysisMethod analysisMethod = (AnalysisMethod)originalMethod;
        ResolvedJavaMethod resolvedJavaMethod = analysisMethod.wrapped;
        if (resolvedJavaMethod instanceof SubstitutionMethod) {
            SubstitutionMethod substitutionMethod = (SubstitutionMethod)resolvedJavaMethod;
            modifiers = substitutionMethod.getOriginal().getModifiers();
            if (substitutionMethod.hasBytecodes()) {
                modifiers &= 0xFFFFFEFF;
            }
        }
        LineNumberTable lineNumberTable = originalMethod.getLineNumberTable();
        return InterpreterResolvedJavaMethod.create(originalMethod, name, maxLocals, maxStackSize, modifiers, declaringClass, signature, interpretedCode, null, lineNumberTable, null, null, -1, -2, -5, 0);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static InterpreterUnresolvedSignature createUnresolvedSignature(Signature originalSignature) {
        MetadataUtil.requireNonNull(originalSignature);
        JavaType returnType = BuildTimeInterpreterUniverse.singleton().primitiveOrUnresolvedType(originalSignature.getReturnType(null));
        int parameterCount = originalSignature.getParameterCount(false);
        JavaType[] parameterTypes = new JavaType[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            parameterTypes[i] = BuildTimeInterpreterUniverse.singleton().primitiveOrUnresolvedType(originalSignature.getParameterType(i, null));
        }
        return InterpreterUnresolvedSignature.create(originalSignature, returnType, parameterTypes);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static LocalVariableTable processLocalVariableTable(LocalVariableTable hostLocalVariableTable) {
        Local[] hostLocals = hostLocalVariableTable.getLocals();
        if (hostLocals.length == 0) {
            return InterpreterResolvedJavaMethod.EMPTY_LOCAL_VARIABLE_TABLE;
        }
        Local[] locals = new Local[hostLocals.length];
        for (int i = 0; i < locals.length; ++i) {
            Local host = hostLocals[i];
            JavaType hostType = host.getType();
            JavaType interpreterType = null;
            if (hostType == null) {
                InterpreterUtil.log("[processLocalVariableTable] BUG? host=%s.  Remove local entry?", host);
            } else {
                interpreterType = BuildTimeInterpreterUniverse.singleton().typeOrUnresolved(hostType);
            }
            if (!(hostType instanceof AnalysisType) || !((AnalysisType)hostType).isReachable()) {
                // empty if block
            }
            locals[i] = BuildTimeInterpreterUniverse.singleton().local(new Local(host.getName(), interpreterType, host.getStartBCI(), host.getEndBCI(), host.getSlot()));
        }
        return BuildTimeInterpreterUniverse.singleton().localVariableTable(new LocalVariableTable(locals));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void setNeedMethodBody(InterpreterResolvedJavaMethod thiz, boolean needMethodBody, MetaAccessProvider metaAccessProvider) {
        if (thiz.needMethodBody && needMethodBody) {
            return;
        }
        if (!needMethodBody) {
            thiz.needMethodBody = needMethodBody;
            return;
        }
        byte[] code = thiz.getInterpretedCode();
        if (code == null) {
            return;
        }
        thiz.needMethodBody = true;
        int bci = 0;
        while (bci < BytecodeStream.endBCI(code)) {
            int opcode = BytecodeStream.opcode(code, bci);
            switch (opcode) {
                case 182: 
                case 185: {
                    char originalCPI = BytecodeStream.readCPI(code, bci);
                    try {
                        JavaMethod method = thiz.getOriginalMethod().getConstantPool().lookupMethod((int)originalCPI, opcode);
                        if (!(method instanceof ResolvedJavaMethod)) break;
                        ResolvedJavaMethod resolvedJavaMethod = (ResolvedJavaMethod)method;
                        if (!InterpreterFeature.callableByInterpreter(resolvedJavaMethod, metaAccessProvider)) {
                            return;
                        }
                        BuildTimeInterpreterUniverse.singleton().getOrCreateMethodWithMethodBody(resolvedJavaMethod, metaAccessProvider);
                        break;
                    }
                    catch (UnsupportedFeatureException | UserError.UserException e) {
                        InterpreterUtil.log("[process invokes] lookup in method %s failed due to:", thiz.getOriginalMethod());
                        InterpreterUtil.log(e);
                    }
                }
            }
            bci = BytecodeStream.nextBCI(code, bci);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setUnmaterializedConstantValue(InterpreterResolvedJavaField thiz, JavaConstant constant) {
        assert (constant == JavaConstant.NULL_POINTER || constant instanceof PrimitiveConstant || constant instanceof ImageHeapConstant);
        BuildTimeInterpreterUniverse buildTimeInterpreterUniverse = BuildTimeInterpreterUniverse.singleton();
        switch (thiz.getJavaKind()) {
            case Boolean: 
            case Byte: 
            case Short: 
            case Char: 
            case Int: 
            case Float: 
            case Long: 
            case Double: {
                assert (constant instanceof PrimitiveConstant);
                thiz.setUnmaterializedConstant(buildTimeInterpreterUniverse.constant(constant));
                break;
            }
            case Object: {
                if (constant.isNull()) {
                    thiz.setUnmaterializedConstant(buildTimeInterpreterUniverse.constant(JavaConstant.NULL_POINTER));
                    break;
                }
                if (constant.getJavaKind() == JavaKind.Illegal) {
                    thiz.setUnmaterializedConstant(buildTimeInterpreterUniverse.constant((JavaConstant)JavaConstant.ILLEGAL));
                    break;
                }
                if (thiz.getType().isWordType()) {
                    thiz.setUnmaterializedConstant(buildTimeInterpreterUniverse.constant(constant));
                    break;
                }
                if (constant instanceof ImageHeapConstant) {
                    ImageHeapConstant imageHeapConstant = (ImageHeapConstant)constant;
                    thiz.setUnmaterializedConstant(ReferenceConstant.createFromImageHeapConstant(imageHeapConstant));
                    break;
                }
                throw VMError.shouldNotReachHere("Unsupported unmaterialized constant value: " + String.valueOf(constant));
            }
            default: {
                throw VMError.shouldNotReachHere("Invalid field kind: " + String.valueOf(thiz.getJavaKind()));
            }
        }
        if (!thiz.isUndefined()) {
            if (thiz.getType().isWordType()) {
                VMError.guarantee(thiz.getUnmaterializedConstant().getJavaKind() == InterpreterToVM.wordJavaKind());
            } else {
                VMError.guarantee(thiz.getUnmaterializedConstant().getJavaKind() == thiz.getJavaKind());
            }
        }
    }

    public BuildTimeInterpreterUniverse() {
        this.unresolvedTypes = new ConcurrentHashMap<String, UnresolvedJavaType>();
        this.unresolvedMethods = new ConcurrentHashMap<String, UnresolvedJavaMethod>();
        this.unresolvedFields = new ConcurrentHashMap<String, UnresolvedJavaField>();
        this.indyAppendices = new ConcurrentHashMap<JavaConstant, JavaConstant>();
    }

    public static BuildTimeInterpreterUniverse singleton() {
        return INSTANCE;
    }

    public InterpreterResolvedObjectType referenceType(ResolvedJavaType resolvedJavaType) {
        return (InterpreterResolvedObjectType)this.getOrCreateType(resolvedJavaType);
    }

    public String dedup(String string) {
        return HostedStringDeduplication.singleton().deduplicate(string, false);
    }

    public InterpreterResolvedPrimitiveType primitiveType(ResolvedJavaType resolvedJavaType) {
        return (InterpreterResolvedPrimitiveType)this.getOrCreateType(resolvedJavaType);
    }

    public InterpreterResolvedJavaType getType(ResolvedJavaType resolvedJavaType) {
        return this.types.get(resolvedJavaType);
    }

    public InterpreterResolvedJavaType getOrCreateType(ResolvedJavaType resolvedJavaType) {
        assert (resolvedJavaType instanceof AnalysisType);
        InterpreterResolvedJavaType result = this.getType(resolvedJavaType);
        if (result != null) {
            return result;
        }
        result = resolvedJavaType.isPrimitive() ? InterpreterResolvedPrimitiveType.fromKind(JavaKind.fromPrimitiveOrVoidTypeChar((char)resolvedJavaType.getName().charAt(0))) : BuildTimeInterpreterUniverse.createResolvedObjectType(resolvedJavaType);
        InterpreterResolvedJavaType previous = this.types.putIfAbsent(resolvedJavaType, result);
        if (previous != null) {
            return previous;
        }
        InterpreterUtil.log("[universe] Adding type '%s'", resolvedJavaType);
        return result;
    }

    public InterpreterResolvedJavaField getOrCreateField(ResolvedJavaField resolvedJavaField) {
        assert (resolvedJavaField instanceof AnalysisField);
        InterpreterResolvedJavaField result = this.fields.get(resolvedJavaField);
        if (result != null) {
            return result;
        }
        result = BuildTimeInterpreterUniverse.createResolvedJavaField(resolvedJavaField);
        InterpreterResolvedJavaField previous = this.fields.putIfAbsent(resolvedJavaField, result);
        if (previous != null) {
            return previous;
        }
        InterpreterUtil.log("[universe] Adding field '%s'", resolvedJavaField);
        return result;
    }

    public InterpreterResolvedJavaMethod getMethod(ResolvedJavaMethod method) {
        ResolvedJavaMethod wrapped = method;
        if (wrapped instanceof HostedMethod) {
            HostedMethod hostedMethod = (HostedMethod)wrapped;
            wrapped = hostedMethod.getWrapped();
        }
        return this.methods.get(wrapped);
    }

    public InterpreterResolvedJavaMethod getOrCreateMethod(ResolvedJavaMethod resolvedJavaMethod) {
        assert (resolvedJavaMethod instanceof AnalysisMethod);
        InterpreterResolvedJavaMethod result = this.getMethod(resolvedJavaMethod);
        if (result != null) {
            return result;
        }
        result = BuildTimeInterpreterUniverse.createResolveJavaMethod(resolvedJavaMethod);
        InterpreterResolvedJavaMethod previous = this.methods.putIfAbsent(resolvedJavaMethod, result);
        if (previous != null) {
            return previous;
        }
        InterpreterUtil.log("[universe] Adding method '%s'", resolvedJavaMethod);
        return result;
    }

    public InterpreterResolvedJavaMethod getOrCreateMethodWithMethodBody(ResolvedJavaMethod resolvedJavaMethod, MetaAccessProvider metaAccessProvider) {
        InterpreterResolvedJavaMethod result = this.getOrCreateMethod(resolvedJavaMethod);
        BuildTimeInterpreterUniverse.setNeedMethodBody(result, true, metaAccessProvider);
        return result;
    }

    public JavaConstant weakObjectConstant(ImageHeapConstant imageHeapConstant) {
        Object value;
        if (imageHeapConstant.isBackedByHostedObject() && (value = this.snippetReflectionProvider.asObject(Object.class, imageHeapConstant.getHostedObject())) != null) {
            return this.objectConstants.computeIfAbsent(imageHeapConstant, key -> ReferenceConstant.createFromNonNullReference(value));
        }
        return this.objectConstants.computeIfAbsent(imageHeapConstant, key -> ReferenceConstant.createFromImageHeapConstant(imageHeapConstant));
    }

    public JavaConstant primitiveConstant(int value) {
        return (JavaConstant)this.primitiveConstants.computeIfAbsent(value, key -> JavaConstant.forInt((int)value));
    }

    public JavaConstant primitiveConstant(long value) {
        return (JavaConstant)this.primitiveConstants.computeIfAbsent(value, key -> JavaConstant.forLong((long)value));
    }

    public JavaConstant primitiveConstant(float value) {
        return (JavaConstant)this.primitiveConstants.computeIfAbsent(Float.valueOf(value), key -> JavaConstant.forFloat((float)value));
    }

    public JavaConstant primitiveConstant(double value) {
        return (JavaConstant)this.primitiveConstants.computeIfAbsent(value, key -> JavaConstant.forDouble((double)value));
    }

    public JavaConstant stringConstant(String value) {
        return this.strings.computeIfAbsent(value, key -> ReferenceConstant.createFromNonNullReference(Objects.requireNonNull(value)));
    }

    public JavaType primitiveOrUnresolvedType(JavaType type) {
        if (type.getJavaKind().isPrimitive()) {
            return InterpreterResolvedPrimitiveType.fromKind(type.getJavaKind());
        }
        return (JavaType)this.unresolvedTypes.computeIfAbsent(this.dedup(MetadataUtil.toUniqueString(type)), UnresolvedJavaType::create);
    }

    public JavaConstant appendix(JavaConstant appendix) {
        Objects.requireNonNull(appendix);
        JavaConstant result = this.indyAppendices.get(appendix);
        if (result != null) {
            return result;
        }
        if (appendix instanceof ImageHeapConstant) {
            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)appendix;
            result = this.weakObjectConstant(imageHeapConstant);
        } else {
            VMError.shouldNotReachHere("unexpected appendix: " + String.valueOf(appendix));
        }
        JavaConstant previous = this.indyAppendices.putIfAbsent(appendix, result);
        if (previous != null) {
            return previous;
        }
        return result;
    }

    public InterpreterUnresolvedSignature unresolvedSignature(Signature signature) {
        return this.signatures.computeIfAbsent(MetadataUtil.toUniqueString(signature), key -> BuildTimeInterpreterUniverse.createUnresolvedSignature(signature));
    }

    public JavaType typeOrUnresolved(JavaType type) {
        JavaType result = (JavaType)this.types.get(type);
        if (result == null) {
            result = this.primitiveOrUnresolvedType(type);
        }
        return result;
    }

    public ExceptionHandler exceptionHandler(ExceptionHandler handler) {
        return this.exceptionHandlers.computeIfAbsent(handler, Function.identity());
    }

    public Local local(Local local) {
        return this.locals.computeIfAbsent((LocalWrapper)new LocalWrapper((Local)local), Function.identity()).local;
    }

    public LocalVariableTable localVariableTable(LocalVariableTable localVariableTable) {
        return this.localVariableTables.computeIfAbsent((LocalVariableTableWrapper)new LocalVariableTableWrapper((LocalVariableTable)localVariableTable), Function.identity()).localVariableTable;
    }

    public JavaField fieldOrUnresolved(JavaField field) {
        JavaField result = (JavaField)this.fields.get(field);
        if (result == null) {
            JavaType holder = this.primitiveOrUnresolvedType(field.getDeclaringClass());
            JavaType type = this.primitiveOrUnresolvedType(field.getType());
            result = (JavaField)this.unresolvedFields.computeIfAbsent(MetadataUtil.toUniqueString(field), key -> new UnresolvedJavaField(holder, this.dedup(field.getName()), type));
        }
        return result;
    }

    public JavaMethod methodOrUnresolved(JavaMethod method0) {
        JavaMethod javaMethod;
        if (method0 instanceof HostedMethod) {
            HostedMethod hostedMethod = (HostedMethod)method0;
            javaMethod = hostedMethod.wrapped;
        } else {
            javaMethod = method0;
        }
        JavaMethod method = javaMethod;
        JavaMethod result = (JavaMethod)this.methods.get(method);
        if (result == null) {
            JavaType holder = this.primitiveOrUnresolvedType(method.getDeclaringClass());
            InterpreterUnresolvedSignature signature = this.unresolvedSignature(method.getSignature());
            result = (JavaMethod)this.unresolvedMethods.computeIfAbsent(MetadataUtil.toUniqueString(method), key -> new UnresolvedJavaMethod(this.dedup(method.getName()), signature, holder));
        }
        return result;
    }

    public void createConstantPools(HostedUniverse hUniverse) {
        InterpreterResolvedObjectType referenceType;
        this.setSnippetReflectionProvider(hUniverse.getSnippetReflection());
        this.classToMethods = this.methods.values().stream().collect(Collectors.groupingBy(InterpreterResolvedJavaMethod::getDeclaringClass));
        this.classToFields = this.fields.values().stream().collect(Collectors.groupingBy(InterpreterResolvedJavaField::getDeclaringClass));
        boolean needsAnotherRound = true;
        int iterations = 0;
        while (needsAnotherRound) {
            needsAnotherRound = false;
            InterpreterUtil.log("[weedout] iteration %s", ++iterations);
            for (InterpreterResolvedJavaType type : this.types.values()) {
                if (!(type instanceof InterpreterResolvedObjectType)) continue;
                referenceType = (InterpreterResolvedObjectType)type;
                needsAnotherRound |= BuildTimeConstantPool.weedOut(referenceType, hUniverse);
            }
        }
        for (InterpreterResolvedJavaType type : this.types.values()) {
            if (!(type instanceof InterpreterResolvedObjectType)) continue;
            referenceType = (InterpreterResolvedObjectType)type;
            BuildTimeConstantPool buildTimeConstantPool = BuildTimeConstantPool.create(referenceType);
            referenceType.setConstantPool(buildTimeConstantPool.snapshot());
        }
    }

    public List<InterpreterResolvedJavaMethod> allDeclaredMethods(InterpreterResolvedObjectType type) {
        return this.classToMethods.getOrDefault(type, Collections.emptyList());
    }

    public List<InterpreterResolvedJavaField> allDeclaredFields(InterpreterResolvedObjectType type) {
        return this.classToFields.getOrDefault(type, Collections.emptyList());
    }

    public Collection<InterpreterResolvedJavaField> getFields() {
        return this.fields.values();
    }

    public Collection<InterpreterResolvedJavaMethod> getMethods() {
        return this.methods.values();
    }

    public Collection<InterpreterResolvedJavaType> getTypes() {
        return this.types.values();
    }

    private static boolean isReachable(InterpreterResolvedJavaType type) {
        if (type instanceof InterpreterResolvedPrimitiveType) {
            return true;
        }
        AnalysisType originalType = (AnalysisType)((InterpreterResolvedObjectType)type).getOriginalType();
        return originalType.isReachable();
    }

    static boolean isReachable(InterpreterResolvedJavaField field) {
        AnalysisField originalField = (AnalysisField)field.getOriginalField();
        return field.isArtificiallyReachable() || originalField.isReachable() && originalField.getDeclaringClass().isReachable();
    }

    static boolean isReachable(InterpreterResolvedJavaMethod method) {
        AnalysisMethod originalMethod = (AnalysisMethod)method.getOriginalMethod();
        return originalMethod.isReachable() && originalMethod.getDeclaringClass().isReachable();
    }

    public void purgeUnreachable(MetaAccessProvider metaAccessProvider) {
        ArrayList<InterpreterResolvedObjectType> nonReachableTypes = new ArrayList<InterpreterResolvedObjectType>();
        for (InterpreterResolvedJavaType type : this.types.values()) {
            if (BuildTimeInterpreterUniverse.isReachable(type)) continue;
            nonReachableTypes.add((InterpreterResolvedObjectType)type);
        }
        Iterator<Map.Entry<ResolvedJavaMethod, InterpreterResolvedJavaMethod>> iteratorMethods = this.methods.entrySet().iterator();
        while (iteratorMethods.hasNext()) {
            Map.Entry<ResolvedJavaMethod, InterpreterResolvedJavaMethod> next = iteratorMethods.next();
            InterpreterResolvedJavaMethod interpreterMethod = next.getValue();
            InterpreterResolvedObjectType declaringClass = interpreterMethod.getDeclaringClass();
            if (BuildTimeInterpreterUniverse.isReachable(interpreterMethod) && interpreterMethod.isInterpreterExecutable() && !BuildTimeInterpreterUniverse.isReachable(declaringClass)) {
                InterpreterUtil.log("[purge] declaring class=%s of method=%s is not reachable, which cannot be represented in the interpreter universe currently", declaringClass, interpreterMethod);
                VMError.shouldNotReachHere("declaring class should be reachable");
            }
            int removeMethodReason = 0;
            if (!BuildTimeInterpreterUniverse.isReachable(interpreterMethod) || !interpreterMethod.isInterpreterExecutable()) {
                InterpreterUtil.log("[purge] downgrading method=%s", interpreterMethod);
                BuildTimeInterpreterUniverse.setNeedMethodBody(interpreterMethod, false, metaAccessProvider);
                if (!BuildTimeInterpreterUniverse.isReachable(declaringClass)) {
                    InterpreterUtil.log("[purge] remove declaring class=%s", declaringClass);
                    nonReachableTypes.add(declaringClass);
                    removeMethodReason |= 1;
                }
            }
            if (!BuildTimeInterpreterUniverse.isReachable(interpreterMethod)) {
                AnalysisMethod analysisMethod = (AnalysisMethod)interpreterMethod.getOriginalMethod();
                boolean isRoot = analysisMethod.isDirectRootMethod() || analysisMethod.isVirtualRootMethod() || analysisMethod.isInvoked();
                int implementations = analysisMethod.collectMethodImplementations(true).size();
                if (!isRoot && (next.getValue().isStatic() || implementations <= 1)) {
                    removeMethodReason |= 2;
                }
            }
            if (removeMethodReason <= 0) continue;
            InterpreterUtil.log("[purge] remove method '%s' with reason %s", interpreterMethod, Integer.toBinaryString(removeMethodReason));
            iteratorMethods.remove();
        }
        Iterator<Map.Entry<ResolvedJavaField, InterpreterResolvedJavaField>> iteratorFields = this.fields.entrySet().iterator();
        while (iteratorFields.hasNext()) {
            Map.Entry<ResolvedJavaField, InterpreterResolvedJavaField> next = iteratorFields.next();
            if (BuildTimeInterpreterUniverse.isReachable(next.getValue()) && BuildTimeInterpreterUniverse.isReachable(next.getValue().getDeclaringClass()) && BuildTimeInterpreterUniverse.isReachable(next.getValue().getType())) continue;
            InterpreterUtil.log("[purge] remove field '%s'", next.getValue());
            iteratorFields.remove();
        }
        for (InterpreterResolvedObjectType nonReachableType : nonReachableTypes) {
            InterpreterUtil.log("[purge] remove type '%s'", nonReachableType);
            this.types.remove(nonReachableType.getOriginalType());
        }
        for (InterpreterResolvedJavaType type : this.types.values()) {
            VMError.guarantee(BuildTimeInterpreterUniverse.isReachable(type));
        }
        for (InterpreterResolvedJavaField field : this.fields.values()) {
            VMError.guarantee(BuildTimeInterpreterUniverse.isReachable(field));
        }
        for (InterpreterResolvedJavaMethod method : this.methods.values()) {
            VMError.guarantee(BuildTimeInterpreterUniverse.isReachable(method) || !method.isStatic(), "non reachable");
        }
    }

    static void topSort(ResolvedJavaType type, List<ResolvedJavaType> order, Set<ResolvedJavaType> seen) {
        if (type == null || seen.contains(type)) {
            return;
        }
        BuildTimeInterpreterUniverse.topSort(type.getSuperclass(), order, seen);
        BuildTimeInterpreterUniverse.topSort(type.getComponentType(), order, seen);
        for (ResolvedJavaType interf : type.getInterfaces()) {
            BuildTimeInterpreterUniverse.topSort(interf, order, seen);
        }
        order.add(type);
        seen.add(type);
    }

    static List<ResolvedJavaType> topologicalOrder(Collection<? extends ResolvedJavaType> types) {
        ArrayList<ResolvedJavaType> order = new ArrayList<ResolvedJavaType>(types.size());
        Set<ResolvedJavaType> seen = Collections.newSetFromMap(new IdentityHashMap(types.size()));
        for (ResolvedJavaType resolvedJavaType : types) {
            BuildTimeInterpreterUniverse.topSort(resolvedJavaType, order, seen);
        }
        assert (types.size() == order.size());
        return order;
    }

    public InterpreterUniverseImpl snapshot() {
        Collection<InterpreterResolvedJavaType> values = this.types.values();
        List<ResolvedJavaType> topologicalOrder = BuildTimeInterpreterUniverse.topologicalOrder(values);
        assert (BuildTimeInterpreterUniverse.checkOrder(topologicalOrder));
        assert (topologicalOrder.stream().allMatch(type -> type instanceof InterpreterResolvedJavaType));
        List<ResolvedJavaType> result = topologicalOrder;
        return new InterpreterUniverseImpl(result, this.fields.values(), this.methods.values());
    }

    private static List<ResolvedJavaType> dependencies(ResolvedJavaType type) {
        ArrayList<ResolvedJavaType> result = new ArrayList<ResolvedJavaType>(Arrays.asList(type.getInterfaces()));
        if (type.getSuperclass() != null) {
            result.add(type.getSuperclass());
        }
        if (type.getComponentType() != null) {
            result.add(type.getComponentType());
        }
        return result;
    }

    private static boolean checkOrder(List<ResolvedJavaType> order) {
        Set seen = Collections.newSetFromMap(new IdentityHashMap(order.size()));
        for (ResolvedJavaType type : order) {
            for (ResolvedJavaType strictlyBefore : BuildTimeInterpreterUniverse.dependencies(type)) {
                if (seen.contains(strictlyBefore)) continue;
                return false;
            }
            seen.add(type);
        }
        return true;
    }

    public JavaConstant constant(JavaConstant constant) {
        if (constant.getClass() == PrimitiveConstant.class) {
            PrimitiveConstant primitiveConstant = (PrimitiveConstant)constant;
            switch (primitiveConstant.getJavaKind()) {
                case Int: {
                    return this.primitiveConstant(primitiveConstant.asInt());
                }
                case Float: {
                    return this.primitiveConstant(primitiveConstant.asFloat());
                }
                case Long: {
                    return this.primitiveConstant(primitiveConstant.asLong());
                }
                case Double: {
                    return this.primitiveConstant(primitiveConstant.asDouble());
                }
            }
            return constant;
        }
        if (constant.isNull()) {
            return JavaConstant.NULL_POINTER;
        }
        throw VMError.shouldNotReachHere("unsupported constant: " + String.valueOf(constant));
    }

    public void mirrorSVMVTable(HostedType hostedType, Consumer<Object> rescanFieldInHeap) {
        AnalysisType analysisType = hostedType.getWrapped();
        InterpreterResolvedJavaType iType = this.getType((ResolvedJavaType)analysisType);
        if (!(iType instanceof InterpreterResolvedObjectType)) {
            return;
        }
        InterpreterResolvedObjectType objectType = (InterpreterResolvedObjectType)iType;
        if (hostedType.getVTable().length == 0) {
            return;
        }
        InterpreterResolvedJavaMethod[] iVTable = new InterpreterResolvedJavaMethod[hostedType.getVTable().length];
        for (int i = 0; i < iVTable.length; ++i) {
            iVTable[i] = this.getMethod((ResolvedJavaMethod)hostedType.getVTable()[i].getWrapped());
        }
        objectType.setVtable(iVTable);
        rescanFieldInHeap.accept(objectType);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final class LocalWrapper {
        final int hash;
        final Local local;

        private LocalWrapper(Local local) {
            this.local = MetadataUtil.requireNonNull(local);
            this.hash = LocalWrapper.hashCode(this.local);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof LocalWrapper) {
                LocalWrapper thatWrapper = (LocalWrapper)other;
                Local that = thatWrapper.local;
                return this.local.getName().equals(that.getName()) && this.local.getStartBCI() == that.getStartBCI() && this.local.getEndBCI() == that.getEndBCI() && this.local.getSlot() == that.getSlot() && MetadataUtil.equals(this.local.getType(), that.getType());
            }
            return false;
        }

        public static int hashCode(Local local) {
            int h = MetadataUtil.hashCode(local.getName());
            h = h * 31 + local.getStartBCI();
            h = h * 31 + local.getEndBCI();
            h = h * 31 + local.getSlot();
            h = h * 31 + MetadataUtil.hashCode(local.getType());
            return h;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final class LocalVariableTableWrapper {
        final LocalVariableTable localVariableTable;
        final Local[] locals;
        final int hash;

        private LocalVariableTableWrapper(LocalVariableTable localVariableTable) {
            this.localVariableTable = localVariableTable;
            this.locals = localVariableTable.getLocals();
            int h = 0;
            for (Local local : this.locals) {
                h = h * 31 + LocalWrapper.hashCode(local);
            }
            this.hash = h;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof LocalVariableTableWrapper) {
                LocalVariableTableWrapper thatWrapper = (LocalVariableTableWrapper)other;
                if (this.localVariableTable == thatWrapper.localVariableTable) {
                    return true;
                }
                return Arrays.equals(this.locals, thatWrapper.locals);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

