/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.ConstantBytecodes;
import com.oracle.svm.interpreter.EspressoFrame;
import com.oracle.svm.interpreter.InterpreterFrame;
import com.oracle.svm.interpreter.InterpreterOptions;
import com.oracle.svm.interpreter.InterpreterToVM;
import com.oracle.svm.interpreter.InterpreterUtil;
import com.oracle.svm.interpreter.SemanticJavaException;
import com.oracle.svm.interpreter.debug.DebuggerEvents;
import com.oracle.svm.interpreter.debug.EventKind;
import com.oracle.svm.interpreter.debug.SteppingControl;
import com.oracle.svm.interpreter.metadata.BytecodeStream;
import com.oracle.svm.interpreter.metadata.Bytecodes;
import com.oracle.svm.interpreter.metadata.InterpreterConstantPool;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaField;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.InterpreterUnresolvedSignature;
import com.oracle.svm.interpreter.metadata.LookupSwitch;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import com.oracle.svm.interpreter.metadata.ReferenceConstant;
import com.oracle.svm.interpreter.metadata.TableSwitch;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;

@InternalVMMethod
public final class Interpreter {
    static final String FAILURE_CONSTANT_NOT_PART_OF_IMAGE_HEAP = "Trying to load constant that is not part of the Native Image heap";
    public static final ThreadLocal<Integer> logIndent = ThreadLocal.withInitial(() -> 0);

    private Interpreter() {
        throw VMError.shouldNotReachHere("private constructor");
    }

    private static void initArguments(InterpreterFrame frame, InterpreterResolvedJavaMethod method) {
        Object[] arguments = frame.getArguments();
        boolean hasReceiver = !method.isStatic();
        int receiverSlot = hasReceiver ? 1 : 0;
        int curSlot = 0;
        if (hasReceiver) {
            assert (arguments[0] != null) : "null receiver in init arguments !";
            Object receiver = arguments[0];
            EspressoFrame.setLocalObject(frame, curSlot, receiver);
            curSlot += JavaKind.Object.getSlotCount();
        }
        InterpreterUnresolvedSignature methodSignature = method.getSignature();
        for (int i = 0; i < methodSignature.getParameterCount(false); ++i) {
            JavaKind argType = methodSignature.getParameterKind(i);
            switch (argType) {
                case Boolean: {
                    EspressoFrame.setLocalInt(frame, curSlot, (Boolean)arguments[i + receiverSlot] != false ? 1 : 0);
                    break;
                }
                case Byte: {
                    EspressoFrame.setLocalInt(frame, curSlot, ((Byte)arguments[i + receiverSlot]).byteValue());
                    break;
                }
                case Short: {
                    EspressoFrame.setLocalInt(frame, curSlot, ((Short)arguments[i + receiverSlot]).shortValue());
                    break;
                }
                case Char: {
                    EspressoFrame.setLocalInt(frame, curSlot, ((Character)arguments[i + receiverSlot]).charValue());
                    break;
                }
                case Int: {
                    EspressoFrame.setLocalInt(frame, curSlot, (Integer)arguments[i + receiverSlot]);
                    break;
                }
                case Float: {
                    EspressoFrame.setLocalFloat(frame, curSlot, ((Float)arguments[i + receiverSlot]).floatValue());
                    break;
                }
                case Long: {
                    EspressoFrame.setLocalLong(frame, curSlot, (Long)arguments[i + receiverSlot]);
                    ++curSlot;
                    break;
                }
                case Double: {
                    EspressoFrame.setLocalDouble(frame, curSlot, (Double)arguments[i + receiverSlot]);
                    ++curSlot;
                    break;
                }
                case Object: {
                    Object argument = arguments[i + receiverSlot];
                    EspressoFrame.setLocalObject(frame, curSlot, argument);
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHereAtRuntime();
                }
            }
            ++curSlot;
        }
    }

    public static void initializeFrame(InterpreterFrame frame, InterpreterResolvedJavaMethod method) {
        Interpreter.initArguments(frame, method);
    }

    public static Object execute(InterpreterResolvedJavaMethod method, Object[] args) {
        return Interpreter.execute(method, args, false);
    }

    public static Object execute(InterpreterResolvedJavaMethod method, InterpreterFrame frame) {
        return Interpreter.execute0(method, frame, false);
    }

    public static Object execute(InterpreterResolvedJavaMethod method, Object[] args, boolean forceStayInInterpreter) {
        InterpreterFrame frame = EspressoFrame.allocate(method.getMaxLocals(), method.getMaxStackSize(), args);
        InterpreterUtil.guarantee(!method.isNative(), "trying to interpret native method %s", method);
        Interpreter.initializeFrame(frame, method);
        return Interpreter.execute0(method, frame, forceStayInInterpreter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object execute0(InterpreterResolvedJavaMethod method, InterpreterFrame frame, boolean stayInInterpreter) {
        try {
            if (method.isSynchronized()) {
                Class<?> lockTarget;
                Class<?> clazz = lockTarget = method.isStatic() ? method.getDeclaringClass().getJavaClass() : EspressoFrame.getThis(frame);
                assert (lockTarget != null);
                InterpreterToVM.monitorEnter(frame, InterpreterToVM.nullCheck(lockTarget));
            }
            int startTop = EspressoFrame.startingStackOffset(method.getMaxLocals());
            Object object = Root.executeBodyFromBCI(frame, method, 0, startTop, stayInInterpreter);
            return object;
        }
        finally {
            InterpreterToVM.releaseInterpreterFrameLocks(frame);
        }
    }

    private static int getLogIndent() {
        if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
            return logIndent.get();
        }
        return 0;
    }

    private static void setLogIndent(int indent) {
        if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
            logIndent.set(indent);
        }
    }

    private static void traceInterpreterEnter(InterpreterResolvedJavaMethod method, int indent, int curBCI, int top) {
        if (!InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
            return;
        }
        Interpreter.setLogIndent(indent + 2);
        InterpreterUtil.traceInterpreter(" ".repeat(indent)).string("[interp] Entered ").string(method.getDeclaringClass().getName()).string("::").string(method.getName()).string(method.getSignature().toMethodDescriptor()).string(" with bci=").unsigned(curBCI).string("/top=").unsigned(top).newline();
    }

    private static void traceInterpreterReturn(InterpreterResolvedJavaMethod method, int indent, int curBCI, int top) {
        if (!InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
            return;
        }
        Interpreter.setLogIndent(indent);
        InterpreterUtil.traceInterpreter(" ".repeat(indent));
        InterpreterUtil.traceInterpreter("[interp] Leave ").string(method.getDeclaringClass().getName()).string("::").string(method.getName()).string(method.getSignature().toMethodDescriptor()).string(" with bci=").unsigned(curBCI).string("/top=").unsigned(top).newline();
    }

    private static void traceInterpreterInstruction(InterpreterFrame frame, int indent, int curBCI, int top, int curOpcode) {
        if (!InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
            return;
        }
        InterpreterUtil.traceInterpreter(" ".repeat(indent)).string("bci=").unsigned(curBCI).string(" ").string(Bytecodes.nameOf(curOpcode));
        for (int slot = top - 1; slot >= 0; --slot) {
            InterpreterUtil.traceInterpreter(", s").unsigned(slot).string("=").hex(frame.getLongStatic(slot)).string("/").object(frame.getObjectStatic(slot));
        }
        InterpreterUtil.traceInterpreter("").newline();
    }

    private static void traceInterpreterException(InterpreterResolvedJavaMethod method, int indent, int curBCI, int top) {
        if (!InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
            return;
        }
        Interpreter.setLogIndent(indent);
        InterpreterUtil.traceInterpreter(" ".repeat(indent)).string("[interp] Exception ").string(method.getDeclaringClass().getName()).string("::").string(method.getName()).string(method.getSignature().toMethodDescriptor()).string(" with bci=").unsigned(curBCI).string("/top=").unsigned(top).newline();
    }

    private static <T extends Throwable> RuntimeException uncheckedThrow(Throwable e) throws T {
        throw e;
    }

    private static Object getReturnValueAsObject(InterpreterFrame frame, InterpreterResolvedJavaMethod method, int top) {
        JavaKind returnType = method.getSignature().getReturnKind();
        return switch (returnType) {
            case JavaKind.Boolean -> Interpreter.stackIntToBoolean(EspressoFrame.popInt(frame, top - 1));
            case JavaKind.Byte -> (byte)EspressoFrame.popInt(frame, top - 1);
            case JavaKind.Short -> (short)EspressoFrame.popInt(frame, top - 1);
            case JavaKind.Char -> Character.valueOf((char)EspressoFrame.popInt(frame, top - 1));
            case JavaKind.Int -> EspressoFrame.popInt(frame, top - 1);
            case JavaKind.Long -> EspressoFrame.popLong(frame, top - 1);
            case JavaKind.Float -> Float.valueOf(EspressoFrame.popFloat(frame, top - 1));
            case JavaKind.Double -> EspressoFrame.popDouble(frame, top - 1);
            case JavaKind.Void -> null;
            case JavaKind.Object -> EspressoFrame.popObject(frame, top - 1);
            default -> throw VMError.shouldNotReachHereAtRuntime();
        };
    }

    private static void clearOperandStack(InterpreterFrame frame, InterpreterResolvedJavaMethod method, int top) {
        int stackStart = EspressoFrame.startingStackOffset(method.getMaxLocals());
        for (int slot = top - 1; slot >= stackStart; --slot) {
            EspressoFrame.clear(frame, slot);
        }
    }

    private static boolean takeBranchRef1(Object operand, int opcode) {
        assert (198 <= opcode && opcode <= 199);
        return switch (opcode) {
            case 198 -> {
                if (operand == null) {
                    yield true;
                }
                yield false;
            }
            case 199 -> {
                if (operand != null) {
                    yield true;
                }
                yield false;
            }
            default -> throw VMError.shouldNotReachHereAtRuntime();
        };
    }

    private static boolean takeBranchPrimitive1(int operand, int opcode) {
        assert (153 <= opcode && opcode <= 158);
        return switch (opcode) {
            case 153 -> {
                if (operand == 0) {
                    yield true;
                }
                yield false;
            }
            case 154 -> {
                if (operand != 0) {
                    yield true;
                }
                yield false;
            }
            case 155 -> {
                if (operand < 0) {
                    yield true;
                }
                yield false;
            }
            case 156 -> {
                if (operand >= 0) {
                    yield true;
                }
                yield false;
            }
            case 157 -> {
                if (operand > 0) {
                    yield true;
                }
                yield false;
            }
            case 158 -> {
                if (operand <= 0) {
                    yield true;
                }
                yield false;
            }
            default -> throw VMError.shouldNotReachHereAtRuntime();
        };
    }

    private static boolean takeBranchPrimitive2(int operand1, int operand2, int opcode) {
        assert (159 <= opcode && opcode <= 164);
        return switch (opcode) {
            case 159 -> {
                if (operand1 == operand2) {
                    yield true;
                }
                yield false;
            }
            case 160 -> {
                if (operand1 != operand2) {
                    yield true;
                }
                yield false;
            }
            case 161 -> {
                if (operand1 > operand2) {
                    yield true;
                }
                yield false;
            }
            case 162 -> {
                if (operand1 <= operand2) {
                    yield true;
                }
                yield false;
            }
            case 163 -> {
                if (operand1 < operand2) {
                    yield true;
                }
                yield false;
            }
            case 164 -> {
                if (operand1 >= operand2) {
                    yield true;
                }
                yield false;
            }
            default -> throw VMError.shouldNotReachHereAtRuntime();
        };
    }

    private static boolean takeBranchRef2(Object operand1, Object operand2, int opcode) {
        assert (165 <= opcode && opcode <= 166);
        return switch (opcode) {
            case 165 -> {
                if (operand1 == operand2) {
                    yield true;
                }
                yield false;
            }
            case 166 -> {
                if (operand1 != operand2) {
                    yield true;
                }
                yield false;
            }
            default -> throw VMError.shouldNotReachHereAtRuntime();
        };
    }

    private static void arrayLoad(InterpreterFrame frame, int top, int loadOpcode) {
        assert (46 <= loadOpcode && loadOpcode <= 53);
        int index = EspressoFrame.popInt(frame, top - 1);
        Object array = InterpreterToVM.nullCheck(EspressoFrame.popObject(frame, top - 2));
        switch (loadOpcode) {
            case 51: {
                EspressoFrame.putInt(frame, top - 2, InterpreterToVM.getArrayByte(index, array));
                break;
            }
            case 53: {
                EspressoFrame.putInt(frame, top - 2, InterpreterToVM.getArrayShort(index, (short[])array));
                break;
            }
            case 52: {
                EspressoFrame.putInt(frame, top - 2, InterpreterToVM.getArrayChar(index, (char[])array));
                break;
            }
            case 46: {
                EspressoFrame.putInt(frame, top - 2, InterpreterToVM.getArrayInt(index, (int[])array));
                break;
            }
            case 48: {
                EspressoFrame.putFloat(frame, top - 2, InterpreterToVM.getArrayFloat(index, (float[])array));
                break;
            }
            case 47: {
                EspressoFrame.putLong(frame, top - 2, InterpreterToVM.getArrayLong(index, (long[])array));
                break;
            }
            case 49: {
                EspressoFrame.putDouble(frame, top - 2, InterpreterToVM.getArrayDouble(index, (double[])array));
                break;
            }
            case 50: {
                EspressoFrame.putObject(frame, top - 2, InterpreterToVM.getArrayObject(index, (Object[])array));
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
    }

    private static void arrayStore(InterpreterFrame frame, int top, int storeOpcode) {
        assert (79 <= storeOpcode && storeOpcode <= 86);
        int offset = storeOpcode == 80 || storeOpcode == 82 ? 2 : 1;
        int index = EspressoFrame.popInt(frame, top - 1 - offset);
        Object array = InterpreterToVM.nullCheck(EspressoFrame.popObject(frame, top - 2 - offset));
        switch (storeOpcode) {
            case 84: {
                InterpreterToVM.setArrayByte((byte)EspressoFrame.popInt(frame, top - 1), index, array);
                break;
            }
            case 86: {
                InterpreterToVM.setArrayShort((short)EspressoFrame.popInt(frame, top - 1), index, (short[])array);
                break;
            }
            case 85: {
                InterpreterToVM.setArrayChar((char)EspressoFrame.popInt(frame, top - 1), index, (char[])array);
                break;
            }
            case 79: {
                InterpreterToVM.setArrayInt(EspressoFrame.popInt(frame, top - 1), index, (int[])array);
                break;
            }
            case 81: {
                InterpreterToVM.setArrayFloat(EspressoFrame.popFloat(frame, top - 1), index, (float[])array);
                break;
            }
            case 80: {
                InterpreterToVM.setArrayLong(EspressoFrame.popLong(frame, top - 1), index, (long[])array);
                break;
            }
            case 82: {
                InterpreterToVM.setArrayDouble(EspressoFrame.popDouble(frame, top - 1), index, (double[])array);
                break;
            }
            case 83: {
                InterpreterToVM.setArrayObject(EspressoFrame.popObject(frame, top - 1), index, (Object[])array);
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
    }

    private static int beforeJumpChecks(InterpreterFrame frame, int curBCI, int targetBCI, int top) {
        if (targetBCI <= curBCI) {
            // empty if block
        }
        return targetBCI;
    }

    private static ExceptionHandler resolveExceptionHandler(InterpreterResolvedJavaMethod method, int bci, Throwable ex) {
        ExceptionHandler[] handlers = method.getExceptionHandlers();
        ExceptionHandler resolved = null;
        for (ExceptionHandler toCheck : handlers) {
            if (bci < toCheck.getStartBCI() || bci >= toCheck.getEndBCI()) continue;
            JavaType catchType = null;
            if (!toCheck.isCatchAll() && (catchType = Interpreter.resolveTypeOrUnresolved(method, 193, (char)toCheck.catchTypeCPI())) instanceof UnresolvedJavaType || catchType != null && !InterpreterToVM.instanceOf((Object)ex, (InterpreterResolvedObjectType)catchType)) continue;
            resolved = toCheck;
            break;
        }
        return resolved;
    }

    private static SemanticJavaException noClassDefFoundError(int opcode, JavaType javaType) {
        String message = javaType != null ? javaType.toJavaName() : MetadataUtil.fmt("%s: (cpi = 0) unknown type", Bytecodes.nameOf(opcode));
        throw SemanticJavaException.raise(new NoClassDefFoundError(message));
    }

    private static SemanticJavaException noSuchMethodError(int opcode, JavaMethod javaMethod) {
        String message = javaMethod != null ? javaMethod.format("%H.%n(%P)") : MetadataUtil.fmt("%s: (cpi = 0) unknown method", Bytecodes.nameOf(opcode));
        throw SemanticJavaException.raise(new NoSuchMethodError(message));
    }

    private static SemanticJavaException noSuchFieldError(int opcode, JavaField javaField) {
        String message = javaField != null ? javaField.format("%H.%n") : MetadataUtil.fmt("%s: (cpi = 0) unknown field", Bytecodes.nameOf(opcode));
        throw SemanticJavaException.raise(new NoSuchFieldError(message));
    }

    private static void loadConstant(InterpreterFrame frame, InterpreterResolvedJavaMethod method, int top, char cpi, int opcode) {
        assert (opcode == 18 || opcode == 19 || opcode == 20);
        if (GraalDirectives.injectBranchProbability((double)1.0E-4, (cpi == '\u0000' ? 1 : 0) != 0)) {
            VMError.guarantee(opcode != 20);
            throw Interpreter.noClassDefFoundError(opcode, null);
        }
        InterpreterConstantPool pool = Interpreter.getConstantPool(method);
        Object constant = pool.lookupConstant(cpi);
        if (constant instanceof PrimitiveConstant) {
            PrimitiveConstant primitiveConstant = (PrimitiveConstant)constant;
            JavaKind kind = primitiveConstant.getJavaKind();
            assert (!kind.needsTwoSlots() || opcode == 20);
            assert (kind.needsTwoSlots() || opcode == 18 || opcode == 19);
            switch (kind) {
                case Int: {
                    EspressoFrame.putInt(frame, top, primitiveConstant.asInt());
                    break;
                }
                case Float: {
                    EspressoFrame.putFloat(frame, top, primitiveConstant.asFloat());
                    break;
                }
                case Long: {
                    EspressoFrame.putLong(frame, top, primitiveConstant.asLong());
                    break;
                }
                case Double: {
                    EspressoFrame.putDouble(frame, top, primitiveConstant.asDouble());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHereAtRuntime();
                }
            }
        } else if (constant instanceof JavaType) {
            InterpreterResolvedJavaType resolvedType = Interpreter.resolveType(method, opcode, cpi);
            EspressoFrame.putObject(frame, top, resolvedType.getJavaClass());
        } else if (constant instanceof ReferenceConstant) {
            ReferenceConstant referenceConstant = (ReferenceConstant)constant;
            VMError.guarantee(referenceConstant.isNonNull(), FAILURE_CONSTANT_NOT_PART_OF_IMAGE_HEAP);
            Object constantValue = referenceConstant.getReferent();
            EspressoFrame.putObject(frame, top, constantValue);
        } else if (constant.equals(JavaConstant.NULL_POINTER)) {
            EspressoFrame.putObject(frame, top, null);
        } else {
            throw VMError.unimplemented("LDC* constant pool type");
        }
    }

    private static InterpreterConstantPool getConstantPool(InterpreterResolvedJavaMethod method) {
        return method.getConstantPool();
    }

    private static int invoke(InterpreterFrame callerFrame, InterpreterResolvedJavaMethod method, byte[] code, int top, int curBCI, int opcode, boolean forceStayInInterpreter, boolean preferStayInInterpreter) {
        boolean isVirtual;
        int invokeTop = top;
        char cpi = BytecodeStream.readCPI2(code, curBCI);
        InterpreterResolvedJavaMethod seedMethod = Interpreter.resolveMethod(method, opcode, cpi);
        boolean hasReceiver = !seedMethod.isStatic();
        boolean bl = isVirtual = opcode == 182 || opcode == 185;
        if (opcode == 186) {
            int appendixCPI = BytecodeStream.readCPI4(code, curBCI) & 0xFFFF;
            if (appendixCPI != 0) {
                Object appendix;
                JavaConstant appendixConstant = method.getConstantPool().lookupAppendix(appendixCPI, opcode);
                if (JavaConstant.NULL_POINTER.equals((Object)appendixConstant)) {
                    appendix = null;
                } else {
                    if (!(appendixConstant instanceof ReferenceConstant)) {
                        throw VMError.shouldNotReachHere("Unexpected INVOKEDYNAMIC appendix constant: " + String.valueOf(appendixConstant));
                    }
                    ReferenceConstant referenceConstant = (ReferenceConstant)appendixConstant;
                    appendix = referenceConstant.getReferent();
                    if (appendix == null) {
                        throw SemanticJavaException.raise(new IncompatibleClassChangeError("INVOKEDYNAMIC appendix was not included in the image heap"));
                    }
                }
                EspressoFrame.putObject(callerFrame, top, appendix);
                invokeTop = top + 1;
            } else {
                throw VMError.shouldNotReachHere("Appendix-less INVOKEDYNAMIC");
            }
        }
        InterpreterUnresolvedSignature seedSignature = seedMethod.getSignature();
        int resultAt = invokeTop - seedSignature.slotsForParameters(hasReceiver);
        int retStackEffect = resultAt - top;
        Object[] calleeArgs = EspressoFrame.popArguments(callerFrame, invokeTop, hasReceiver, seedSignature);
        if (!seedMethod.isStatic()) {
            InterpreterToVM.nullCheck(calleeArgs[0]);
        }
        Object retObj = InterpreterToVM.dispatchInvocation(seedMethod, calleeArgs, isVirtual, forceStayInInterpreter, preferStayInInterpreter, opcode == 185);
        return (retStackEffect += EspressoFrame.putKind(callerFrame, resultAt, retObj, seedSignature.getReturnKind())) - Bytecodes.stackEffectOf(opcode);
    }

    private static JavaType resolveTypeOrUnresolved(InterpreterResolvedJavaMethod method, int opcode, char cpi) {
        assert (opcode == 193 || opcode == 192 || opcode == 187 || opcode == 189 || opcode == 197 || opcode == 18 || opcode == 19);
        if (GraalDirectives.injectBranchProbability((double)1.0E-4, (cpi == '\u0000' ? 1 : 0) != 0)) {
            throw Interpreter.noClassDefFoundError(opcode, null);
        }
        return Interpreter.getConstantPool(method).lookupType(cpi, opcode);
    }

    private static InterpreterResolvedJavaType resolveType(InterpreterResolvedJavaMethod method, int opcode, char cpi) {
        JavaType javaType = Interpreter.resolveTypeOrUnresolved(method, opcode, cpi);
        if (GraalDirectives.injectBranchProbability((double)0.9999, (boolean)(javaType instanceof InterpreterResolvedJavaType))) {
            return (InterpreterResolvedJavaType)javaType;
        }
        throw Interpreter.noClassDefFoundError(opcode, javaType);
    }

    private static JavaMethod resolveMethodOrUnresolved(InterpreterResolvedJavaMethod method, int opcode, char cpi) {
        assert (Bytecodes.isInvoke(opcode));
        if (GraalDirectives.injectBranchProbability((double)1.0E-4, (cpi == '\u0000' ? 1 : 0) != 0)) {
            throw Interpreter.noSuchMethodError(opcode, null);
        }
        return Interpreter.getConstantPool(method).lookupMethod(cpi, opcode);
    }

    static InterpreterResolvedJavaMethod resolveMethod(InterpreterResolvedJavaMethod method, int opcode, char cpi) {
        JavaMethod javaMethod = Interpreter.resolveMethodOrUnresolved(method, opcode, cpi);
        if (GraalDirectives.injectBranchProbability((double)0.9999, (boolean)(javaMethod instanceof InterpreterResolvedJavaMethod))) {
            return (InterpreterResolvedJavaMethod)javaMethod;
        }
        throw Interpreter.noSuchMethodError(opcode, javaMethod);
    }

    private static JavaField resolveFieldOrUnresolved(InterpreterResolvedJavaMethod method, int opcode, char cpi) {
        assert (opcode == 180 || opcode == 178 || opcode == 181 || opcode == 179);
        if (GraalDirectives.injectBranchProbability((double)1.0E-4, (cpi == '\u0000' ? 1 : 0) != 0)) {
            throw Interpreter.noSuchFieldError(opcode, null);
        }
        return Interpreter.getConstantPool(method).lookupField(cpi, method, opcode);
    }

    private static InterpreterResolvedJavaField resolveField(InterpreterResolvedJavaMethod method, int opcode, char cpi) {
        JavaField javaField = Interpreter.resolveFieldOrUnresolved(method, opcode, cpi);
        if (GraalDirectives.injectBranchProbability((double)0.9999, (boolean)(javaField instanceof InterpreterResolvedJavaField))) {
            return (InterpreterResolvedJavaField)javaField;
        }
        throw Interpreter.noSuchFieldError(opcode, javaField);
    }

    private static int allocateMultiArray(InterpreterFrame frame, int top, ResolvedJavaType multiArrayType, int allocatedDimensions) {
        assert (multiArrayType.isArray()) : multiArrayType;
        assert (allocatedDimensions > 0) : allocatedDimensions;
        assert (multiArrayType.getElementalType().getJavaKind() != JavaKind.Void);
        int[] dimensions = new int[allocatedDimensions];
        for (int i = 0; i < allocatedDimensions; ++i) {
            dimensions[i] = EspressoFrame.popInt(frame, top - allocatedDimensions + i);
        }
        Object value = InterpreterToVM.createMultiArray((InterpreterResolvedJavaType)multiArrayType, dimensions);
        EspressoFrame.putObject(frame, top - allocatedDimensions, value);
        return -allocatedDimensions;
    }

    private static boolean stackIntToBoolean(int result) {
        return (result & 1) != 0;
    }

    private static int divInt(int divisor, int dividend) {
        try {
            return dividend / divisor;
        }
        catch (ArithmeticException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    private static long divLong(long divisor, long dividend) {
        try {
            return dividend / divisor;
        }
        catch (ArithmeticException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    private static float divFloat(float divisor, float dividend) {
        return dividend / divisor;
    }

    private static double divDouble(double divisor, double dividend) {
        return dividend / divisor;
    }

    private static int remInt(int divisor, int dividend) {
        try {
            return dividend % divisor;
        }
        catch (ArithmeticException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    private static long remLong(long divisor, long dividend) {
        try {
            return dividend % divisor;
        }
        catch (ArithmeticException e) {
            throw SemanticJavaException.raise(e);
        }
    }

    private static float remFloat(float divisor, float dividend) {
        return dividend % divisor;
    }

    private static double remDouble(double divisor, double dividend) {
        return dividend % divisor;
    }

    private static int shiftLeftInt(int bits, int value) {
        return value << bits;
    }

    private static long shiftLeftLong(int bits, long value) {
        return value << bits;
    }

    private static int shiftRightSignedInt(int bits, int value) {
        return value >> bits;
    }

    private static long shiftRightSignedLong(int bits, long value) {
        return value >> bits;
    }

    private static int shiftRightUnsignedInt(int bits, int value) {
        return value >>> bits;
    }

    private static long shiftRightUnsignedLong(int bits, long value) {
        return value >>> bits;
    }

    private static int compareLong(long y, long x) {
        return Long.compare(x, y);
    }

    private static int compareFloatGreater(float y, float x) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static int compareFloatLess(float y, float x) {
        return x > y ? 1 : (x == y ? 0 : -1);
    }

    private static int compareDoubleGreater(double y, double x) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static int compareDoubleLess(double y, double x) {
        return x > y ? 1 : (x == y ? 0 : -1);
    }

    private static int putField(InterpreterFrame frame, int top, InterpreterResolvedJavaField field, int opcode) {
        Object receiver;
        assert (opcode == 181 || opcode == 179);
        assert (field.isStatic() == (opcode == 179));
        assert (!field.isUnmaterializedConstant());
        JavaKind kind = field.getJavaKind();
        assert (kind != JavaKind.Illegal);
        int slotCount = kind.getSlotCount();
        Object object = opcode == 179 ? (kind.isPrimitive() ? StaticFieldsSupport.getStaticPrimitiveFieldsAtRuntime(0) : StaticFieldsSupport.getStaticObjectFieldsAtRuntime(0)) : (receiver = InterpreterToVM.nullCheck(EspressoFrame.popObject(frame, top - slotCount - 1)));
        if (field.isStatic()) {
            InterpreterToVM.ensureClassInitialized(field.getDeclaringClass());
        }
        switch (kind) {
            case Boolean: {
                InterpreterToVM.setFieldBoolean(Interpreter.stackIntToBoolean(EspressoFrame.popInt(frame, top - 1)), receiver, field);
                break;
            }
            case Byte: {
                InterpreterToVM.setFieldByte((byte)EspressoFrame.popInt(frame, top - 1), receiver, field);
                break;
            }
            case Char: {
                InterpreterToVM.setFieldChar((char)EspressoFrame.popInt(frame, top - 1), receiver, field);
                break;
            }
            case Short: {
                InterpreterToVM.setFieldShort((short)EspressoFrame.popInt(frame, top - 1), receiver, field);
                break;
            }
            case Int: {
                InterpreterToVM.setFieldInt(EspressoFrame.popInt(frame, top - 1), receiver, field);
                break;
            }
            case Double: {
                InterpreterToVM.setFieldDouble(EspressoFrame.popDouble(frame, top - 1), receiver, field);
                break;
            }
            case Float: {
                InterpreterToVM.setFieldFloat(EspressoFrame.popFloat(frame, top - 1), receiver, field);
                break;
            }
            case Long: {
                InterpreterToVM.setFieldLong(EspressoFrame.popLong(frame, top - 1), receiver, field);
                break;
            }
            case Object: {
                InterpreterToVM.setFieldObject(EspressoFrame.popObject(frame, top - 1), receiver, field);
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
        return -slotCount + 1;
    }

    private static int getField(InterpreterFrame frame, int top, InterpreterResolvedJavaField field, int opcode) {
        Object receiver;
        assert (opcode == 180 || opcode == 178);
        assert (field.isStatic() == (opcode == 178));
        JavaKind kind = field.getJavaKind();
        assert (kind != JavaKind.Illegal);
        Object object = opcode == 178 ? (kind.isPrimitive() ? StaticFieldsSupport.getStaticPrimitiveFieldsAtRuntime(0) : StaticFieldsSupport.getStaticObjectFieldsAtRuntime(0)) : (receiver = InterpreterToVM.nullCheck(EspressoFrame.popObject(frame, top - 1)));
        if (field.isStatic()) {
            InterpreterToVM.ensureClassInitialized(field.getDeclaringClass());
        }
        int resultAt = field.isStatic() ? top : top - 1;
        switch (kind) {
            case Boolean: {
                EspressoFrame.putInt(frame, resultAt, InterpreterToVM.getFieldBoolean(receiver, field) ? 1 : 0);
                break;
            }
            case Byte: {
                EspressoFrame.putInt(frame, resultAt, InterpreterToVM.getFieldByte(receiver, field));
                break;
            }
            case Char: {
                EspressoFrame.putInt(frame, resultAt, InterpreterToVM.getFieldChar(receiver, field));
                break;
            }
            case Short: {
                EspressoFrame.putInt(frame, resultAt, InterpreterToVM.getFieldShort(receiver, field));
                break;
            }
            case Int: {
                EspressoFrame.putInt(frame, resultAt, InterpreterToVM.getFieldInt(receiver, field));
                break;
            }
            case Double: {
                EspressoFrame.putDouble(frame, resultAt, InterpreterToVM.getFieldDouble(receiver, field));
                break;
            }
            case Float: {
                EspressoFrame.putFloat(frame, resultAt, InterpreterToVM.getFieldFloat(receiver, field));
                break;
            }
            case Long: {
                EspressoFrame.putLong(frame, resultAt, InterpreterToVM.getFieldLong(receiver, field));
                break;
            }
            case Object: {
                EspressoFrame.putObject(frame, resultAt, InterpreterToVM.getFieldObject(receiver, field));
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
        return kind.getSlotCount() - 1;
    }

    public static final class Root {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object executeBodyFromBCI(InterpreterFrame frame, InterpreterResolvedJavaMethod method, int startBCI, int startTop, boolean forceStayInInterpreter) {
            int curBCI = startBCI;
            int top = startTop;
            byte[] code = method.getInterpretedCode();
            assert (method.isStatic() || EspressoFrame.getThis(frame) != null);
            InterpreterUtil.guarantee(code != null, "no bytecode stream for %s", method);
            int indent = Interpreter.getLogIndent();
            Interpreter.traceInterpreterEnter(method, indent, curBCI, top);
            int debuggerEventFlags = 0;
            if (DebuggerEvents.singleton().isEventEnabled(Thread.currentThread(), EventKind.METHOD_ENTRY) && method.getDeclaringClass().isMethodEnterEvent()) {
                debuggerEventFlags |= EventKind.METHOD_ENTRY.getFlag();
            }
            block146: while (true) {
                SteppingControl steppingControl;
                int curOpcode = BytecodeStream.opaqueOpcode(code, curBCI);
                if (DebuggerEvents.singleton().isEventEnabled(Thread.currentThread(), EventKind.SINGLE_STEP)) {
                    int stepSize;
                    Thread currentThread = Thread.currentThread();
                    steppingControl = DebuggerEvents.singleton().getSteppingControl(currentThread);
                    if (steppingControl != null && steppingControl.isActiveAtCurrentFrameDepth() && ((stepSize = steppingControl.getSize()) == -1 || stepSize == -2 && !steppingControl.withinSameLine(method, curBCI))) {
                        debuggerEventFlags |= EventKind.SINGLE_STEP.getFlag();
                    }
                }
                if (curOpcode == 202) {
                    if (DebuggerEvents.singleton().isEventEnabled(Thread.currentThread(), EventKind.BREAKPOINT)) {
                        debuggerEventFlags |= EventKind.BREAKPOINT.getFlag();
                    }
                    curOpcode = method.getOriginalOpcodeAt(curBCI);
                }
                if (debuggerEventFlags != 0) {
                    DebuggerEvents.singleton().getEventHandler().onEventAt(Thread.currentThread(), method, curBCI, null, debuggerEventFlags);
                    debuggerEventFlags = 0;
                }
                try {
                    Interpreter.traceInterpreterInstruction(frame, indent, curBCI, top, curOpcode);
                    switch (curOpcode) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            EspressoFrame.putObject(frame, top, null);
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            EspressoFrame.putInt(frame, top, curOpcode - 3);
                            break;
                        }
                        case 9: 
                        case 10: {
                            EspressoFrame.putLong(frame, top, curOpcode - 9);
                            break;
                        }
                        case 11: 
                        case 12: 
                        case 13: {
                            EspressoFrame.putFloat(frame, top, curOpcode - 11);
                            break;
                        }
                        case 14: 
                        case 15: {
                            EspressoFrame.putDouble(frame, top, curOpcode - 14);
                            break;
                        }
                        case 16: {
                            EspressoFrame.putInt(frame, top, BytecodeStream.readByte(code, curBCI));
                            break;
                        }
                        case 17: {
                            EspressoFrame.putInt(frame, top, BytecodeStream.readShort(code, curBCI));
                            break;
                        }
                        case 18: {
                            Interpreter.loadConstant(frame, method, top, BytecodeStream.readCPI1(code, curBCI), curOpcode);
                            break;
                        }
                        case 19: 
                        case 20: {
                            Interpreter.loadConstant(frame, method, top, BytecodeStream.readCPI2(code, curBCI), curOpcode);
                            break;
                        }
                        case 21: {
                            EspressoFrame.putInt(frame, top, EspressoFrame.getLocalInt(frame, BytecodeStream.readLocalIndex1(code, curBCI)));
                            break;
                        }
                        case 22: {
                            EspressoFrame.putLong(frame, top, EspressoFrame.getLocalLong(frame, BytecodeStream.readLocalIndex1(code, curBCI)));
                            break;
                        }
                        case 23: {
                            EspressoFrame.putFloat(frame, top, EspressoFrame.getLocalFloat(frame, BytecodeStream.readLocalIndex1(code, curBCI)));
                            break;
                        }
                        case 24: {
                            EspressoFrame.putDouble(frame, top, EspressoFrame.getLocalDouble(frame, BytecodeStream.readLocalIndex1(code, curBCI)));
                            break;
                        }
                        case 25: {
                            EspressoFrame.putObject(frame, top, EspressoFrame.getLocalObject(frame, BytecodeStream.readLocalIndex1(code, curBCI)));
                            break;
                        }
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: {
                            EspressoFrame.putInt(frame, top, EspressoFrame.getLocalInt(frame, curOpcode - 26));
                            break;
                        }
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: {
                            EspressoFrame.putLong(frame, top, EspressoFrame.getLocalLong(frame, curOpcode - 30));
                            break;
                        }
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: {
                            EspressoFrame.putFloat(frame, top, EspressoFrame.getLocalFloat(frame, curOpcode - 34));
                            break;
                        }
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: {
                            EspressoFrame.putDouble(frame, top, EspressoFrame.getLocalDouble(frame, curOpcode - 38));
                            break;
                        }
                        case 42: {
                            EspressoFrame.putObject(frame, top, EspressoFrame.getLocalObject(frame, 0));
                            break;
                        }
                        case 43: 
                        case 44: 
                        case 45: {
                            EspressoFrame.putObject(frame, top, EspressoFrame.getLocalObject(frame, curOpcode - 42));
                            break;
                        }
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: {
                            Interpreter.arrayLoad(frame, top, curOpcode);
                            break;
                        }
                        case 54: {
                            EspressoFrame.setLocalInt(frame, BytecodeStream.readLocalIndex1(code, curBCI), EspressoFrame.popInt(frame, top - 1));
                            break;
                        }
                        case 55: {
                            EspressoFrame.setLocalLong(frame, BytecodeStream.readLocalIndex1(code, curBCI), EspressoFrame.popLong(frame, top - 1));
                            break;
                        }
                        case 56: {
                            EspressoFrame.setLocalFloat(frame, BytecodeStream.readLocalIndex1(code, curBCI), EspressoFrame.popFloat(frame, top - 1));
                            break;
                        }
                        case 57: {
                            EspressoFrame.setLocalDouble(frame, BytecodeStream.readLocalIndex1(code, curBCI), EspressoFrame.popDouble(frame, top - 1));
                            break;
                        }
                        case 58: {
                            EspressoFrame.setLocalObjectOrReturnAddress(frame, BytecodeStream.readLocalIndex1(code, curBCI), EspressoFrame.popReturnAddressOrObject(frame, top - 1));
                            break;
                        }
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: {
                            EspressoFrame.setLocalInt(frame, curOpcode - 59, EspressoFrame.popInt(frame, top - 1));
                            break;
                        }
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: {
                            EspressoFrame.setLocalLong(frame, curOpcode - 63, EspressoFrame.popLong(frame, top - 1));
                            break;
                        }
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: {
                            EspressoFrame.setLocalFloat(frame, curOpcode - 67, EspressoFrame.popFloat(frame, top - 1));
                            break;
                        }
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: {
                            EspressoFrame.setLocalDouble(frame, curOpcode - 71, EspressoFrame.popDouble(frame, top - 1));
                            break;
                        }
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: {
                            EspressoFrame.setLocalObjectOrReturnAddress(frame, curOpcode - 75, EspressoFrame.popReturnAddressOrObject(frame, top - 1));
                            break;
                        }
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: {
                            Interpreter.arrayStore(frame, top, curOpcode);
                            break;
                        }
                        case 88: {
                            EspressoFrame.clear(frame, top - 1);
                            EspressoFrame.clear(frame, top - 2);
                            break;
                        }
                        case 87: {
                            EspressoFrame.clear(frame, top - 1);
                            break;
                        }
                        case 89: {
                            EspressoFrame.dup1(frame, top);
                            break;
                        }
                        case 90: {
                            EspressoFrame.dupx1(frame, top);
                            break;
                        }
                        case 91: {
                            EspressoFrame.dupx2(frame, top);
                            break;
                        }
                        case 92: {
                            EspressoFrame.dup2(frame, top);
                            break;
                        }
                        case 93: {
                            EspressoFrame.dup2x1(frame, top);
                            break;
                        }
                        case 94: {
                            EspressoFrame.dup2x2(frame, top);
                            break;
                        }
                        case 95: {
                            EspressoFrame.swapSingle(frame, top);
                            break;
                        }
                        case 96: {
                            EspressoFrame.putInt(frame, top - 2, EspressoFrame.popInt(frame, top - 1) + EspressoFrame.popInt(frame, top - 2));
                            break;
                        }
                        case 97: {
                            EspressoFrame.putLong(frame, top - 4, EspressoFrame.popLong(frame, top - 1) + EspressoFrame.popLong(frame, top - 3));
                            break;
                        }
                        case 98: {
                            EspressoFrame.putFloat(frame, top - 2, EspressoFrame.popFloat(frame, top - 1) + EspressoFrame.popFloat(frame, top - 2));
                            break;
                        }
                        case 99: {
                            EspressoFrame.putDouble(frame, top - 4, EspressoFrame.popDouble(frame, top - 1) + EspressoFrame.popDouble(frame, top - 3));
                            break;
                        }
                        case 100: {
                            EspressoFrame.putInt(frame, top - 2, EspressoFrame.popInt(frame, top - 2) - EspressoFrame.popInt(frame, top - 1));
                            break;
                        }
                        case 101: {
                            EspressoFrame.putLong(frame, top - 4, EspressoFrame.popLong(frame, top - 3) - EspressoFrame.popLong(frame, top - 1));
                            break;
                        }
                        case 102: {
                            EspressoFrame.putFloat(frame, top - 2, EspressoFrame.popFloat(frame, top - 2) - EspressoFrame.popFloat(frame, top - 1));
                            break;
                        }
                        case 103: {
                            EspressoFrame.putDouble(frame, top - 4, EspressoFrame.popDouble(frame, top - 3) - EspressoFrame.popDouble(frame, top - 1));
                            break;
                        }
                        case 104: {
                            EspressoFrame.putInt(frame, top - 2, EspressoFrame.popInt(frame, top - 1) * EspressoFrame.popInt(frame, top - 2));
                            break;
                        }
                        case 105: {
                            EspressoFrame.putLong(frame, top - 4, EspressoFrame.popLong(frame, top - 1) * EspressoFrame.popLong(frame, top - 3));
                            break;
                        }
                        case 106: {
                            EspressoFrame.putFloat(frame, top - 2, EspressoFrame.popFloat(frame, top - 1) * EspressoFrame.popFloat(frame, top - 2));
                            break;
                        }
                        case 107: {
                            EspressoFrame.putDouble(frame, top - 4, EspressoFrame.popDouble(frame, top - 1) * EspressoFrame.popDouble(frame, top - 3));
                            break;
                        }
                        case 108: {
                            EspressoFrame.putInt(frame, top - 2, Interpreter.divInt(EspressoFrame.popInt(frame, top - 1), EspressoFrame.popInt(frame, top - 2)));
                            break;
                        }
                        case 109: {
                            EspressoFrame.putLong(frame, top - 4, Interpreter.divLong(EspressoFrame.popLong(frame, top - 1), EspressoFrame.popLong(frame, top - 3)));
                            break;
                        }
                        case 110: {
                            EspressoFrame.putFloat(frame, top - 2, Interpreter.divFloat(EspressoFrame.popFloat(frame, top - 1), EspressoFrame.popFloat(frame, top - 2)));
                            break;
                        }
                        case 111: {
                            EspressoFrame.putDouble(frame, top - 4, Interpreter.divDouble(EspressoFrame.popDouble(frame, top - 1), EspressoFrame.popDouble(frame, top - 3)));
                            break;
                        }
                        case 112: {
                            EspressoFrame.putInt(frame, top - 2, Interpreter.remInt(EspressoFrame.popInt(frame, top - 1), EspressoFrame.popInt(frame, top - 2)));
                            break;
                        }
                        case 113: {
                            EspressoFrame.putLong(frame, top - 4, Interpreter.remLong(EspressoFrame.popLong(frame, top - 1), EspressoFrame.popLong(frame, top - 3)));
                            break;
                        }
                        case 114: {
                            EspressoFrame.putFloat(frame, top - 2, Interpreter.remFloat(EspressoFrame.popFloat(frame, top - 1), EspressoFrame.popFloat(frame, top - 2)));
                            break;
                        }
                        case 115: {
                            EspressoFrame.putDouble(frame, top - 4, Interpreter.remDouble(EspressoFrame.popDouble(frame, top - 1), EspressoFrame.popDouble(frame, top - 3)));
                            break;
                        }
                        case 116: {
                            EspressoFrame.putInt(frame, top - 1, -EspressoFrame.popInt(frame, top - 1));
                            break;
                        }
                        case 117: {
                            EspressoFrame.putLong(frame, top - 2, -EspressoFrame.popLong(frame, top - 1));
                            break;
                        }
                        case 118: {
                            EspressoFrame.putFloat(frame, top - 1, -EspressoFrame.popFloat(frame, top - 1));
                            break;
                        }
                        case 119: {
                            EspressoFrame.putDouble(frame, top - 2, -EspressoFrame.popDouble(frame, top - 1));
                            break;
                        }
                        case 120: {
                            EspressoFrame.putInt(frame, top - 2, Interpreter.shiftLeftInt(EspressoFrame.popInt(frame, top - 1), EspressoFrame.popInt(frame, top - 2)));
                            break;
                        }
                        case 121: {
                            EspressoFrame.putLong(frame, top - 3, Interpreter.shiftLeftLong(EspressoFrame.popInt(frame, top - 1), EspressoFrame.popLong(frame, top - 2)));
                            break;
                        }
                        case 122: {
                            EspressoFrame.putInt(frame, top - 2, Interpreter.shiftRightSignedInt(EspressoFrame.popInt(frame, top - 1), EspressoFrame.popInt(frame, top - 2)));
                            break;
                        }
                        case 123: {
                            EspressoFrame.putLong(frame, top - 3, Interpreter.shiftRightSignedLong(EspressoFrame.popInt(frame, top - 1), EspressoFrame.popLong(frame, top - 2)));
                            break;
                        }
                        case 124: {
                            EspressoFrame.putInt(frame, top - 2, Interpreter.shiftRightUnsignedInt(EspressoFrame.popInt(frame, top - 1), EspressoFrame.popInt(frame, top - 2)));
                            break;
                        }
                        case 125: {
                            EspressoFrame.putLong(frame, top - 3, Interpreter.shiftRightUnsignedLong(EspressoFrame.popInt(frame, top - 1), EspressoFrame.popLong(frame, top - 2)));
                            break;
                        }
                        case 126: {
                            EspressoFrame.putInt(frame, top - 2, EspressoFrame.popInt(frame, top - 1) & EspressoFrame.popInt(frame, top - 2));
                            break;
                        }
                        case 127: {
                            EspressoFrame.putLong(frame, top - 4, EspressoFrame.popLong(frame, top - 1) & EspressoFrame.popLong(frame, top - 3));
                            break;
                        }
                        case 128: {
                            EspressoFrame.putInt(frame, top - 2, EspressoFrame.popInt(frame, top - 1) | EspressoFrame.popInt(frame, top - 2));
                            break;
                        }
                        case 129: {
                            EspressoFrame.putLong(frame, top - 4, EspressoFrame.popLong(frame, top - 1) | EspressoFrame.popLong(frame, top - 3));
                            break;
                        }
                        case 130: {
                            EspressoFrame.putInt(frame, top - 2, EspressoFrame.popInt(frame, top - 1) ^ EspressoFrame.popInt(frame, top - 2));
                            break;
                        }
                        case 131: {
                            EspressoFrame.putLong(frame, top - 4, EspressoFrame.popLong(frame, top - 1) ^ EspressoFrame.popLong(frame, top - 3));
                            break;
                        }
                        case 132: {
                            EspressoFrame.setLocalInt(frame, BytecodeStream.readLocalIndex1(code, curBCI), EspressoFrame.getLocalInt(frame, BytecodeStream.readLocalIndex1(code, curBCI)) + BytecodeStream.readIncrement1(code, curBCI));
                            break;
                        }
                        case 133: {
                            EspressoFrame.putLong(frame, top - 1, EspressoFrame.popInt(frame, top - 1));
                            break;
                        }
                        case 134: {
                            EspressoFrame.putFloat(frame, top - 1, EspressoFrame.popInt(frame, top - 1));
                            break;
                        }
                        case 135: {
                            EspressoFrame.putDouble(frame, top - 1, EspressoFrame.popInt(frame, top - 1));
                            break;
                        }
                        case 136: {
                            EspressoFrame.putInt(frame, top - 2, (int)EspressoFrame.popLong(frame, top - 1));
                            break;
                        }
                        case 137: {
                            EspressoFrame.putFloat(frame, top - 2, EspressoFrame.popLong(frame, top - 1));
                            break;
                        }
                        case 138: {
                            EspressoFrame.putDouble(frame, top - 2, EspressoFrame.popLong(frame, top - 1));
                            break;
                        }
                        case 139: {
                            EspressoFrame.putInt(frame, top - 1, (int)EspressoFrame.popFloat(frame, top - 1));
                            break;
                        }
                        case 140: {
                            EspressoFrame.putLong(frame, top - 1, (long)EspressoFrame.popFloat(frame, top - 1));
                            break;
                        }
                        case 141: {
                            EspressoFrame.putDouble(frame, top - 1, EspressoFrame.popFloat(frame, top - 1));
                            break;
                        }
                        case 142: {
                            EspressoFrame.putInt(frame, top - 2, (int)EspressoFrame.popDouble(frame, top - 1));
                            break;
                        }
                        case 143: {
                            EspressoFrame.putLong(frame, top - 2, (long)EspressoFrame.popDouble(frame, top - 1));
                            break;
                        }
                        case 144: {
                            EspressoFrame.putFloat(frame, top - 2, (float)EspressoFrame.popDouble(frame, top - 1));
                            break;
                        }
                        case 145: {
                            EspressoFrame.putInt(frame, top - 1, (byte)EspressoFrame.popInt(frame, top - 1));
                            break;
                        }
                        case 146: {
                            EspressoFrame.putInt(frame, top - 1, (char)EspressoFrame.popInt(frame, top - 1));
                            break;
                        }
                        case 147: {
                            EspressoFrame.putInt(frame, top - 1, (short)EspressoFrame.popInt(frame, top - 1));
                            break;
                        }
                        case 148: {
                            EspressoFrame.putInt(frame, top - 4, Interpreter.compareLong(EspressoFrame.popLong(frame, top - 1), EspressoFrame.popLong(frame, top - 3)));
                            break;
                        }
                        case 149: {
                            EspressoFrame.putInt(frame, top - 2, Interpreter.compareFloatLess(EspressoFrame.popFloat(frame, top - 1), EspressoFrame.popFloat(frame, top - 2)));
                            break;
                        }
                        case 150: {
                            EspressoFrame.putInt(frame, top - 2, Interpreter.compareFloatGreater(EspressoFrame.popFloat(frame, top - 1), EspressoFrame.popFloat(frame, top - 2)));
                            break;
                        }
                        case 151: {
                            EspressoFrame.putInt(frame, top - 4, Interpreter.compareDoubleLess(EspressoFrame.popDouble(frame, top - 1), EspressoFrame.popDouble(frame, top - 3)));
                            break;
                        }
                        case 152: {
                            EspressoFrame.putInt(frame, top - 4, Interpreter.compareDoubleGreater(EspressoFrame.popDouble(frame, top - 1), EspressoFrame.popDouble(frame, top - 3)));
                            break;
                        }
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: {
                            if (Interpreter.takeBranchPrimitive1(EspressoFrame.popInt(frame, top - 1), curOpcode)) {
                                curBCI = Interpreter.beforeJumpChecks(frame, curBCI, BytecodeStream.readBranchDest2(code, curBCI), top += ConstantBytecodes.stackEffectOf(158));
                                continue block146;
                            }
                            break;
                        }
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: {
                            if (Interpreter.takeBranchPrimitive2(EspressoFrame.popInt(frame, top - 1), EspressoFrame.popInt(frame, top - 2), curOpcode)) {
                                curBCI = Interpreter.beforeJumpChecks(frame, curBCI, BytecodeStream.readBranchDest2(code, curBCI), top += ConstantBytecodes.stackEffectOf(164));
                                continue block146;
                            }
                            break;
                        }
                        case 165: 
                        case 166: {
                            if (Interpreter.takeBranchRef2(EspressoFrame.popObject(frame, top - 1), EspressoFrame.popObject(frame, top - 2), curOpcode)) {
                                curBCI = Interpreter.beforeJumpChecks(frame, curBCI, BytecodeStream.readBranchDest2(code, curBCI), top += ConstantBytecodes.stackEffectOf(166));
                                continue block146;
                            }
                            break;
                        }
                        case 198: 
                        case 199: {
                            if (Interpreter.takeBranchRef1(EspressoFrame.popObject(frame, top - 1), curOpcode)) {
                                curBCI = Interpreter.beforeJumpChecks(frame, curBCI, BytecodeStream.readBranchDest2(code, curBCI), top += ConstantBytecodes.stackEffectOf(199));
                                continue block146;
                            }
                            break;
                        }
                        case 167: {
                            curBCI = Interpreter.beforeJumpChecks(frame, curBCI, BytecodeStream.readBranchDest2(code, curBCI), top);
                            continue block146;
                        }
                        case 200: {
                            curBCI = Interpreter.beforeJumpChecks(frame, curBCI, BytecodeStream.readBranchDest4(code, curBCI), top);
                            continue block146;
                        }
                        case 168: {
                            EspressoFrame.putReturnAddress(frame, top, curBCI + ConstantBytecodes.lengthOf(168));
                            int stackEffect = 1;
                            curBCI = Interpreter.beforeJumpChecks(frame, curBCI, BytecodeStream.readBranchDest2(code, curBCI), top += stackEffect);
                            continue block146;
                        }
                        case 201: {
                            EspressoFrame.putReturnAddress(frame, top, curBCI + ConstantBytecodes.lengthOf(201));
                            int stackEffect = 1;
                            curBCI = Interpreter.beforeJumpChecks(frame, curBCI, BytecodeStream.readBranchDest4(code, curBCI), top += stackEffect);
                            continue block146;
                        }
                        case 169: {
                            curBCI = Interpreter.beforeJumpChecks(frame, curBCI, EspressoFrame.getLocalReturnAddress(frame, BytecodeStream.readLocalIndex1(code, curBCI)), top += ConstantBytecodes.stackEffectOf(169));
                            continue block146;
                        }
                        case 170: {
                            int index = EspressoFrame.popInt(frame, top - 1);
                            int low = TableSwitch.lowKey(code, curBCI);
                            int high = TableSwitch.highKey(code, curBCI);
                            assert (low <= high);
                            int targetBCI = low <= index && index <= high ? TableSwitch.targetAt(code, curBCI, index - low) : TableSwitch.defaultTarget(code, curBCI);
                            curBCI = Interpreter.beforeJumpChecks(frame, curBCI, targetBCI, top += ConstantBytecodes.stackEffectOf(170));
                            continue block146;
                        }
                        case 171: {
                            int key = EspressoFrame.popInt(frame, top - 1);
                            int low = 0;
                            int high = LookupSwitch.numberOfCases(code, curBCI) - 1;
                            while (low <= high) {
                                int mid = low + high >>> 1;
                                int midVal = LookupSwitch.keyAt(code, curBCI, mid);
                                if (midVal < key) {
                                    low = mid + 1;
                                    continue;
                                }
                                if (midVal > key) {
                                    high = mid - 1;
                                    continue;
                                }
                                int targetBCI = curBCI + LookupSwitch.offsetAt(code, curBCI, mid);
                                curBCI = Interpreter.beforeJumpChecks(frame, curBCI, targetBCI, top += ConstantBytecodes.stackEffectOf(171));
                                continue block146;
                            }
                            int targetBCI = LookupSwitch.defaultTarget(code, curBCI);
                            curBCI = Interpreter.beforeJumpChecks(frame, curBCI, targetBCI, top += ConstantBytecodes.stackEffectOf(171));
                            continue block146;
                        }
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: {
                            Object returnValue = Interpreter.getReturnValueAsObject(frame, method, top);
                            Interpreter.traceInterpreterReturn(method, indent, curBCI, top);
                            if (DebuggerEvents.singleton().isEventEnabled(Thread.currentThread(), EventKind.METHOD_EXIT) && method.getDeclaringClass().isMethodExitEvent()) {
                                int flags = EventKind.METHOD_EXIT.getFlag() | EventKind.METHOD_EXIT_WITH_RETURN_VALUE.getFlag();
                                DebuggerEvents.singleton().getEventHandler().onEventAt(Thread.currentThread(), method, curBCI, returnValue, flags);
                            }
                            return returnValue;
                        }
                        case 178: 
                        case 180: {
                            top += Interpreter.getField(frame, top, Interpreter.resolveField(method, curOpcode, BytecodeStream.readCPI2(code, curBCI)), curOpcode);
                            break;
                        }
                        case 179: 
                        case 181: {
                            top += Interpreter.putField(frame, top, Interpreter.resolveField(method, curOpcode, BytecodeStream.readCPI2(code, curBCI)), curOpcode);
                            break;
                        }
                        case 182: 
                        case 183: 
                        case 184: 
                        case 185: 
                        case 186: {
                            boolean preferStayInInterpreter = forceStayInInterpreter;
                            steppingControl = null;
                            boolean stepEventDisabled = false;
                            Thread currentThread = Thread.currentThread();
                            if (DebuggerEvents.singleton().isEventEnabled(currentThread, EventKind.SINGLE_STEP) && (steppingControl = DebuggerEvents.singleton().getSteppingControl(currentThread)) != null) {
                                steppingControl.pushFrame();
                                if (!steppingControl.isActiveAtCurrentFrameDepth()) {
                                    DebuggerEvents.singleton().setEventEnabled(currentThread, EventKind.SINGLE_STEP, false);
                                    stepEventDisabled = true;
                                }
                                if (steppingControl.getDepth() == 1) {
                                    preferStayInInterpreter = true;
                                }
                            }
                            try {
                                top += Interpreter.invoke(frame, method, code, top, curBCI, curOpcode, forceStayInInterpreter, preferStayInInterpreter);
                                SteppingControl newSteppingControl = DebuggerEvents.singleton().getSteppingControl(currentThread);
                                if (newSteppingControl != null) {
                                    if (DebuggerEvents.singleton().isEventEnabled(currentThread, EventKind.SINGLE_STEP)) {
                                        newSteppingControl.popFrame();
                                        break;
                                    }
                                    if (steppingControl == newSteppingControl && stepEventDisabled) {
                                        DebuggerEvents.singleton().setEventEnabled(currentThread, EventKind.SINGLE_STEP, true);
                                        newSteppingControl.popFrame();
                                    }
                                }
                                break;
                            }
                            catch (Throwable throwable) {
                                SteppingControl newSteppingControl = DebuggerEvents.singleton().getSteppingControl(currentThread);
                                if (newSteppingControl != null) {
                                    if (DebuggerEvents.singleton().isEventEnabled(currentThread, EventKind.SINGLE_STEP)) {
                                        newSteppingControl.popFrame();
                                    } else if (steppingControl == newSteppingControl && stepEventDisabled) {
                                        DebuggerEvents.singleton().setEventEnabled(currentThread, EventKind.SINGLE_STEP, true);
                                        newSteppingControl.popFrame();
                                    }
                                }
                                throw throwable;
                            }
                        }
                        case 187: {
                            EspressoFrame.putObject(frame, top, InterpreterToVM.createNewReference(Interpreter.resolveType(method, 187, BytecodeStream.readCPI2(code, curBCI))));
                            break;
                        }
                        case 188: {
                            EspressoFrame.putObject(frame, top - 1, InterpreterToVM.createNewPrimitiveArray(BytecodeStream.readByte(code, curBCI), EspressoFrame.popInt(frame, top - 1)));
                            break;
                        }
                        case 189: {
                            EspressoFrame.putObject(frame, top - 1, InterpreterToVM.createNewReferenceArray(Interpreter.resolveType(method, 189, BytecodeStream.readCPI2(code, curBCI)), EspressoFrame.popInt(frame, top - 1)));
                            break;
                        }
                        case 190: {
                            EspressoFrame.putInt(frame, top - 1, InterpreterToVM.arrayLength(InterpreterToVM.nullCheck(EspressoFrame.popObject(frame, top - 1))));
                            break;
                        }
                        case 191: {
                            throw SemanticJavaException.raise((Throwable)InterpreterToVM.nullCheck(EspressoFrame.popObject(frame, top - 1)));
                        }
                        case 192: {
                            Object receiver = EspressoFrame.peekObject(frame, top - 1);
                            if (receiver != null) {
                                InterpreterToVM.checkCast(receiver, Interpreter.resolveType(method, 192, BytecodeStream.readCPI2(code, curBCI)));
                            }
                            break;
                        }
                        case 193: {
                            Object receiver = EspressoFrame.popObject(frame, top - 1);
                            EspressoFrame.putInt(frame, top - 1, receiver != null && InterpreterToVM.instanceOf(receiver, Interpreter.resolveType(method, 193, BytecodeStream.readCPI2(code, curBCI))) ? 1 : 0);
                            break;
                        }
                        case 194: {
                            InterpreterToVM.monitorEnter(frame, InterpreterToVM.nullCheck(EspressoFrame.popObject(frame, top - 1)));
                            break;
                        }
                        case 195: {
                            InterpreterToVM.monitorExit(frame, InterpreterToVM.nullCheck(EspressoFrame.popObject(frame, top - 1)));
                            break;
                        }
                        case 196: {
                            int wideOpcode = BytecodeStream.opcode(code, curBCI + 1);
                            switch (wideOpcode) {
                                case 21: {
                                    EspressoFrame.putInt(frame, top, EspressoFrame.getLocalInt(frame, BytecodeStream.readLocalIndex2(code, curBCI)));
                                    break;
                                }
                                case 22: {
                                    EspressoFrame.putLong(frame, top, EspressoFrame.getLocalLong(frame, BytecodeStream.readLocalIndex2(code, curBCI)));
                                    break;
                                }
                                case 23: {
                                    EspressoFrame.putFloat(frame, top, EspressoFrame.getLocalFloat(frame, BytecodeStream.readLocalIndex2(code, curBCI)));
                                    break;
                                }
                                case 24: {
                                    EspressoFrame.putDouble(frame, top, EspressoFrame.getLocalDouble(frame, BytecodeStream.readLocalIndex2(code, curBCI)));
                                    break;
                                }
                                case 25: {
                                    EspressoFrame.putObject(frame, top, EspressoFrame.getLocalObject(frame, BytecodeStream.readLocalIndex2(code, curBCI)));
                                    break;
                                }
                                case 54: {
                                    EspressoFrame.setLocalInt(frame, BytecodeStream.readLocalIndex2(code, curBCI), EspressoFrame.popInt(frame, top - 1));
                                    break;
                                }
                                case 55: {
                                    EspressoFrame.setLocalLong(frame, BytecodeStream.readLocalIndex2(code, curBCI), EspressoFrame.popLong(frame, top - 1));
                                    break;
                                }
                                case 56: {
                                    EspressoFrame.setLocalFloat(frame, BytecodeStream.readLocalIndex2(code, curBCI), EspressoFrame.popFloat(frame, top - 1));
                                    break;
                                }
                                case 57: {
                                    EspressoFrame.setLocalDouble(frame, BytecodeStream.readLocalIndex2(code, curBCI), EspressoFrame.popDouble(frame, top - 1));
                                    break;
                                }
                                case 58: {
                                    EspressoFrame.setLocalObjectOrReturnAddress(frame, BytecodeStream.readLocalIndex2(code, curBCI), EspressoFrame.popReturnAddressOrObject(frame, top - 1));
                                    break;
                                }
                                case 132: {
                                    EspressoFrame.setLocalInt(frame, BytecodeStream.readLocalIndex2(code, curBCI), EspressoFrame.getLocalInt(frame, BytecodeStream.readLocalIndex2(code, curBCI)) + BytecodeStream.readIncrement2(code, curBCI));
                                    break;
                                }
                                case 169: {
                                    curBCI = Interpreter.beforeJumpChecks(frame, curBCI, EspressoFrame.getLocalReturnAddress(frame, BytecodeStream.readLocalIndex2(code, curBCI)), top += ConstantBytecodes.stackEffectOf(169));
                                    continue block146;
                                }
                                default: {
                                    throw VMError.shouldNotReachHere(Bytecodes.nameOf(curOpcode));
                                }
                            }
                            top += Bytecodes.stackEffectOf(wideOpcode);
                            curBCI += wideOpcode == 132 ? 6 : 4;
                            continue block146;
                        }
                        case 197: {
                            top += Interpreter.allocateMultiArray(frame, top, Interpreter.resolveType(method, 197, BytecodeStream.readCPI2(code, curBCI)), BytecodeStream.readUByte(code, curBCI + 3));
                            break;
                        }
                        default: {
                            throw VMError.shouldNotReachHere(Bytecodes.nameOf(curOpcode));
                        }
                    }
                }
                catch (SemanticJavaException | OutOfMemoryError | StackOverflowError e) {
                    Throwable exception = e instanceof SemanticJavaException ? e.getCause() : e;
                    ExceptionHandler handler = Interpreter.resolveExceptionHandler(method, curBCI, exception);
                    if (handler != null) {
                        Interpreter.clearOperandStack(frame, method, top);
                        top = EspressoFrame.startingStackOffset(method.getMaxLocals());
                        EspressoFrame.putObject(frame, top, exception);
                        curBCI = Interpreter.beforeJumpChecks(frame, curBCI, handler.getHandlerBCI(), ++top);
                        continue;
                    }
                    Interpreter.traceInterpreterException(method, indent, curBCI, top);
                    throw Interpreter.uncheckedThrow(exception);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw VMError.shouldNotReachHere("Unexpected host exception reached the interpreter", e);
                }
                assert (curOpcode != 196 && curOpcode != 171 && curOpcode != 170);
                top += Bytecodes.stackEffectOf(curOpcode);
                curBCI += Bytecodes.lengthOf(curOpcode);
            }
        }
    }
}

