/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.pltgot.GOTAccess;
import com.oracle.svm.core.pltgot.GOTHeapSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.DebuggerSupport;
import com.oracle.svm.interpreter.Interpreter;
import com.oracle.svm.interpreter.InterpreterDirectivesSupport;
import com.oracle.svm.interpreter.InterpreterOptions;
import com.oracle.svm.interpreter.InterpreterStubSection;
import com.oracle.svm.interpreter.InterpreterStubTable;
import com.oracle.svm.interpreter.InterpreterUtil;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterUniverse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

@InternalVMMethod
final class InterpreterDirectivesSupportImpl
implements InterpreterDirectivesSupport {
    final Map<InterpreterResolvedJavaMethod, Long> rememberCompiledEntry = new HashMap<InterpreterResolvedJavaMethod, Long>();

    InterpreterDirectivesSupportImpl() {
    }

    @Override
    public boolean forceInterpreterExecution(Object method) {
        InterpreterResolvedJavaMethod interpreterMethod = InterpreterDirectivesSupportImpl.getInterpreterMethod(method);
        if (interpreterMethod == null) {
            return false;
        }
        if (interpreterMethod.getGotOffset() == -2) {
            return false;
        }
        if (interpreterMethod.getEnterStubOffset() == -5) {
            return false;
        }
        if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
            InterpreterUtil.traceInterpreter("[forceInterpreterExecution] ").string(interpreterMethod.toString()).newline();
        }
        int estOffset = ConfigurationValues.getTarget().wordSize * interpreterMethod.getEnterStubOffset();
        Pointer estBase = InterpreterStubTable.getBaseForEnterStubTable();
        UnsignedWord estEntry = (UnsignedWord)estBase.add(estOffset).readWord(0);
        Word previousEntry = GOTAccess.readFromGotEntry(interpreterMethod.getGotOffset());
        this.rememberCompiledEntry.put(interpreterMethod, previousEntry.rawValue());
        InterpreterDirectivesSupportImpl.writeGOTHelper(interpreterMethod, estEntry);
        return true;
    }

    private static void writeGOTHelper(InterpreterResolvedJavaMethod interpreterMethod, UnsignedWord estEntry) {
        GOTHeapSupport.get().makeGOTWritable();
        GOTAccess.writeToGotEntry(interpreterMethod.getGotOffset(), estEntry);
        GOTHeapSupport.get().makeGOTReadOnly();
    }

    @Override
    public void resetInterpreterExecution(Object method) {
        InterpreterResolvedJavaMethod interpreterMethod = InterpreterDirectivesSupportImpl.getInterpreterMethod(method);
        if (interpreterMethod == null) {
            return;
        }
        if (!this.rememberCompiledEntry.containsKey(interpreterMethod)) {
            return;
        }
        long previousEntry = this.rememberCompiledEntry.get(interpreterMethod);
        InterpreterDirectivesSupportImpl.writeGOTHelper(interpreterMethod, (UnsignedWord)Word.pointer((long)previousEntry));
    }

    @Override
    public Object ensureInterpreterExecution(Object method) {
        InterpreterResolvedJavaMethod interpreterMethod = InterpreterDirectivesSupportImpl.getInterpreterMethod(method);
        InterpreterOpToken token = new InterpreterOpToken(this);
        if (interpreterMethod == null) {
            return null;
        }
        if (InterpreterOptions.InterpreterTraceSupport.getValue().booleanValue()) {
            InterpreterUtil.traceInterpreter("[ensureInterpreterExecution] ").string(interpreterMethod.toString()).newline();
        }
        for (InterpreterResolvedJavaMethod inliner : interpreterMethod.getInlinedBy()) {
            if (!this.forceInterpreterExecution(inliner)) continue;
            token.changedExecutionState.add(0, inliner);
        }
        if (this.forceInterpreterExecution(interpreterMethod)) {
            token.changedExecutionState.add(0, interpreterMethod);
        }
        return token;
    }

    @Override
    public void undoExecutionOperation(Object t) {
        if (t == null) {
            return;
        }
        InterpreterOpToken token = (InterpreterOpToken)t;
        if (!token.valid) {
            throw new IllegalStateException("Token is expired.");
        }
        VMError.guarantee(token.valid);
        VMError.guarantee(token.changedExecutionState != null);
        for (InterpreterResolvedJavaMethod m : token.changedExecutionState) {
            VMError.guarantee(m != null);
            this.resetInterpreterExecution(m);
        }
        token.valid = false;
    }

    @Override
    public void markKlass(Class<?> targetKlass) {
        GraalError.unimplemented((String)"should be replaced");
    }

    @Override
    public Object callIntoInterpreter(Object method, Object ... args) {
        InterpreterResolvedJavaMethod interpreterMethod = InterpreterDirectivesSupportImpl.getInterpreterMethod(method);
        return Interpreter.execute(interpreterMethod, args, true);
    }

    @Override
    public Object callIntoUnknown(Object method, Object ... args) {
        InterpreterResolvedJavaMethod interpreterMethod = InterpreterDirectivesSupportImpl.getInterpreterMethod(method);
        MethodPointer calleeFtnPtr = interpreterMethod.getNativeEntryPoint();
        return InterpreterStubSection.leaveInterpreter(calleeFtnPtr, interpreterMethod, interpreterMethod.getDeclaringClass(), args);
    }

    private static String getDescriptor(Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Class<?> param : parameterTypes) {
            sb.append(param.descriptorString());
        }
        sb.append(")");
        sb.append(returnType.descriptorString());
        return sb.toString();
    }

    private static InterpreterResolvedJavaMethod getInterpreterMethod(Object testMethod) {
        VMError.guarantee(testMethod != null);
        VMError.guarantee(testMethod instanceof InterpreterResolvedJavaMethod);
        return (InterpreterResolvedJavaMethod)testMethod;
    }

    static InterpreterResolvedJavaType getInterpreterType(Class<?> clazz) {
        VMError.guarantee(clazz != null);
        return InterpreterDirectivesSupportImpl.findInterpreterResolvedJavaType(clazz);
    }

    private static InterpreterResolvedJavaType findInterpreterResolvedJavaType(Class<?> clazz) {
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        return (InterpreterResolvedJavaType)universe.lookupType(clazz);
    }

    static InterpreterResolvedJavaMethod getInterpreterMethod(InterpreterResolvedJavaType clazz, String targetName, Class<?> returnType, Class<?>[] parameterTypes) {
        InterpreterUniverse universe = DebuggerSupport.singleton().getUniverse();
        Collection<? extends ResolvedJavaMethod> allDeclaredMethods = universe.getAllDeclaredMethods(clazz);
        String targetDescriptor = returnType == null ? null : InterpreterDirectivesSupportImpl.getDescriptor(returnType, parameterTypes);
        for (ResolvedJavaMethod resolvedJavaMethod : allDeclaredMethods) {
            if (!targetName.equals(resolvedJavaMethod.getName()) || targetDescriptor != null && !targetDescriptor.equals(resolvedJavaMethod.getSignature().toMethodDescriptor())) continue;
            return (InterpreterResolvedJavaMethod)resolvedJavaMethod;
        }
        return null;
    }

    private class InterpreterOpToken {
        List<InterpreterResolvedJavaMethod> changedExecutionState = new ArrayList<InterpreterResolvedJavaMethod>();
        boolean valid = true;

        InterpreterOpToken(InterpreterDirectivesSupportImpl interpreterDirectivesSupportImpl) {
        }
    }
}

