/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.svm.interpreter.InterpreterOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class InterpreterOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(InterpreterOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "DebuggerWithInterpreter": {
                return OptionDescriptor.create((String)"DebuggerWithInterpreter", (OptionType)OptionType.Expert, Boolean.class, (String)"Adds support to divert execution from AOT compiled methods to the interpreter at run-time.", (Object)this.getContainer(), InterpreterOptions.DebuggerWithInterpreter, (String)"DebuggerWithInterpreter", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InterpreterBuildTimeLogging": {
                return OptionDescriptor.create((String)"InterpreterBuildTimeLogging", (OptionType)OptionType.Expert, Boolean.class, (String)"Enables logging at build time related to the interpreter setup", (Object)this.getContainer(), InterpreterOptions.InterpreterBuildTimeLogging, (String)"InterpreterBuildTimeLogging", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InterpreterDumpClassFiles": {
                return OptionDescriptor.create((String)"InterpreterDumpClassFiles", (OptionType)OptionType.Expert, String.class, (String)"Path to dump interpreter universe metadata as .class files", (Object)this.getContainer(), InterpreterOptions.InterpreterDumpClassFiles, (String)"InterpreterDumpClassFiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InterpreterTrace": {
                return OptionDescriptor.create((String)"InterpreterTrace", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace Interpreter execution", (Object)this.getContainer(), InterpreterOptions.InterpreterTrace, (String)"InterpreterTrace", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InterpreterTraceSupport": {
                return OptionDescriptor.create((String)"InterpreterTraceSupport", (OptionType)OptionType.Debug, Boolean.class, (String)"Include interpreter tracing code in image", (Object)this.getContainer(), InterpreterOptions.InterpreterTraceSupport, (String)"InterpreterTraceSupport", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 5;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return InterpreterOptions_OptionDescriptors.this.get("DebuggerWithInterpreter");
                    }
                    case 1: {
                        return InterpreterOptions_OptionDescriptors.this.get("InterpreterBuildTimeLogging");
                    }
                    case 2: {
                        return InterpreterOptions_OptionDescriptors.this.get("InterpreterDumpClassFiles");
                    }
                    case 3: {
                        return InterpreterOptions_OptionDescriptors.this.get("InterpreterTrace");
                    }
                    case 4: {
                        return InterpreterOptions_OptionDescriptors.this.get("InterpreterTraceSupport");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

