/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.interpreter.InterpreterStubSection;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.graalvm.word.Pointer;

public class InterpreterStubTable {
    final SectionName section;
    private RelocatableBuffer tableBuffer;
    private ObjectFile.ProgbitsSectionImpl tableBufferImpl;
    private int offsetHash;
    private static final String SYMBOL_NAME = "__svm_interp_enter_table";
    private static final CGlobalData<Pointer> BASE = CGlobalDataFactory.forSymbol("__svm_interp_enter_table");

    public InterpreterStubTable() {
        String sectionName = "s_intrp_ent";
        VMError.guarantee(sectionName.length() <= 16, "mach-O limitation");
        this.section = new SectionName.ProgbitsSectionName(sectionName);
    }

    protected void installAdditionalInfoIntoImageObjectFile(AbstractImage image, Collection<InterpreterResolvedJavaMethod> methods) {
        ObjectFile objectFile = image.getObjectFile();
        int wordSize = ConfigurationValues.getTarget().wordSize;
        int hashSize = 18;
        assert (hashSize == 18);
        int size = methods.size() * wordSize + hashSize;
        this.offsetHash = size - hashSize;
        this.tableBuffer = new RelocatableBuffer(size, objectFile.getByteOrder());
        this.tableBufferImpl = new BasicProgbitsSectionImpl(this.tableBuffer.getBackingArray());
        ObjectFile.Section tableSection = objectFile.newProgbitsSection(this.section.getFormatDependentName(objectFile.getFormat()), objectFile.getPageSize(), true, false, this.tableBufferImpl);
        objectFile.createDefinedSymbol(SYMBOL_NAME, (ObjectFile.Element)tableSection, 0L, 0, false, SubstrateOptions.InternalSymbolsAreGlobal.getValue().booleanValue());
        objectFile.createDefinedSymbol("__svm_interp_hash", (ObjectFile.Element)tableSection, (long)this.offsetHash, 0, true, true);
        ObjectFile.RelocationKind relocationKind = ObjectFile.RelocationKind.getDirect((int)wordSize);
        for (InterpreterResolvedJavaMethod method : methods) {
            int offset = wordSize * method.getEnterStubOffset();
            assert (offset < size);
            this.tableBufferImpl.markRelocationSite(offset, relocationKind, InterpreterStubSection.nameForInterpMethod(method), 0L);
        }
    }

    protected void writeMetadataHashString(byte[] metadataHash) {
        assert (metadataHash.length == 14) : metadataHash.length;
        ByteBuffer bb = this.tableBuffer.getByteBuffer();
        bb.position(this.offsetHash);
        bb.putInt(metadataHash.length);
        bb.put(metadataHash);
    }

    public static Pointer getBaseForEnterStubTable() {
        return BASE.get();
    }
}

