/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.debug;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.debug.Location;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public final class SteppingControl {
    public static final int STEP_INTO = 1;
    public static final int STEP_OVER = 2;
    public static final int STEP_OUT = 3;
    public static final int STEP_MIN = -1;
    public static final int STEP_LINE = -2;
    private final Thread thread;
    private final int depth;
    private final int size;
    private int currentFrameDepth;
    private Location startingLocation;

    public boolean isActiveAtCurrentFrameDepth() {
        switch (this.getDepth()) {
            case 3: {
                return this.currentFrameDepth < 0;
            }
            case 2: {
                return this.currentFrameDepth <= 0;
            }
            case 1: {
                return true;
            }
        }
        throw VMError.shouldNotReachHere("unknown stepping depth");
    }

    public SteppingControl(Thread thread, int depth, int size) {
        VMError.guarantee(size == -1 || size == -2);
        VMError.guarantee(depth == 1 || depth == 2 || depth == 3);
        this.thread = thread;
        this.depth = depth;
        this.size = size;
        this.currentFrameDepth = 0;
    }

    public int getSize() {
        return this.size;
    }

    public int getDepth() {
        return this.depth;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setStartingLocation(Location location) {
        this.startingLocation = location;
    }

    public boolean withinSameLine(ResolvedJavaMethod method, int bci) {
        if (this.startingLocation == null) {
            return false;
        }
        if (!method.equals((Object)this.startingLocation.method())) {
            return false;
        }
        int startingLine = this.startingLocation.lineNumber();
        int currentLine = Location.getLineNumber(method, bci);
        return currentLine == startingLine;
    }

    public void popFrame() {
        --this.currentFrameDepth;
    }

    public void pushFrame() {
        ++this.currentFrameDepth;
    }
}

