/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import java.util.List;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class InterpreterConstantPool
implements ConstantPool {
    private final InterpreterResolvedObjectType holder;
    @UnknownObjectField(types={Object[].class})
    private Object[] entries;

    Object at(int cpi) {
        if (cpi == 0) {
            throw VMError.shouldNotReachHere("Cannot resolve CP entry 0");
        }
        return this.entries[cpi];
    }

    private InterpreterConstantPool(InterpreterResolvedObjectType holder, Object[] entries) {
        this.holder = MetadataUtil.requireNonNull(holder);
        this.entries = MetadataUtil.requireNonNull(entries);
    }

    public static InterpreterConstantPool create(InterpreterResolvedObjectType holder, Object[] entries) {
        return new InterpreterConstantPool(holder, entries);
    }

    public int length() {
        return this.entries.length;
    }

    public JavaField lookupField(int cpi, ResolvedJavaMethod method, int opcode) {
        return (JavaField)this.at(cpi);
    }

    public JavaMethod lookupMethod(int cpi, int opcode) {
        return (JavaMethod)this.at(cpi);
    }

    public JavaMethod lookupMethod(int cpi, int opcode, ResolvedJavaMethod caller) {
        throw VMError.intentionallyUnimplemented();
    }

    public List<ConstantPool.BootstrapMethodInvocation> lookupBootstrapMethodInvocations(boolean invokeDynamic) {
        throw VMError.intentionallyUnimplemented();
    }

    public JavaType lookupType(int cpi, int opcode) {
        return (JavaType)this.at(cpi);
    }

    public Object lookupConstant(int cpi) {
        Object entry = this.at(cpi);
        if (entry instanceof JavaConstant) {
            return entry;
        }
        if (entry instanceof JavaType) {
            return entry;
        }
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public Object lookupConstant(int cpi, boolean resolve) {
        throw VMError.intentionallyUnimplemented();
    }

    public JavaConstant lookupAppendix(int cpi, int opcode) {
        assert (opcode == 186);
        return (JavaConstant)this.at(cpi);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object[] getEntries() {
        return this.entries;
    }

    public InterpreterResolvedObjectType getHolder() {
        return this.holder;
    }

    public void loadReferencedType(int cpi, int opcode) {
        throw VMError.intentionallyUnimplemented();
    }

    public JavaType lookupReferencedType(int cpi, int opcode) {
        throw VMError.intentionallyUnimplemented();
    }

    public String lookupUtf8(int cpi) {
        throw VMError.intentionallyUnimplemented();
    }

    public Signature lookupSignature(int cpi) {
        throw VMError.intentionallyUnimplemented();
    }
}

