/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

public final class FrameId {
    private static final int FRAME_DEPTH_BITS = 16;
    private static final int FRAME_DEPTH_MASK = 65535;

    public static int getFrameDepth(long frameId) {
        return (int)(frameId & 0xFFFFL);
    }

    public static long getFrameGeneration(long frameId) {
        return frameId >>> 16;
    }

    public static long createFrameId(long frameGeneration, int frameDepth) {
        assert (frameDepth < 65536);
        assert (frameGeneration < 0x1000000000000L);
        return frameGeneration << 16 | (long)frameDepth;
    }
}

