/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge.nativebridge;

import com.oracle.svm.jdwp.bridge.nativebridge.NativeIsolate;
import com.oracle.svm.jdwp.bridge.nativebridge.NativeIsolateThread;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public abstract class NativeObjectCleaner<T>
extends WeakReference<T> {
    private static final Object INVALID_ISOLATE_THREAD = new Object();
    private static final ReferenceQueue<Object> cleanersQueue = new ReferenceQueue();
    final NativeIsolate isolate;

    protected NativeObjectCleaner(T referent, NativeIsolate isolate) {
        super(referent, cleanersQueue);
        this.isolate = isolate;
    }

    public final NativeObjectCleaner<T> register() {
        NativeObjectCleaner.processPendingCleaners();
        if (!this.isolate.isDisposed()) {
            this.isolate.cleaners.add(this);
        }
        return this;
    }

    protected abstract void cleanUp(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processPendingCleaners() {
        HashMap enteredThreads = null;
        try {
            NativeObjectCleaner cleaner;
            while ((cleaner = (NativeObjectCleaner)cleanersQueue.poll()) != null) {
                Object enteredThread;
                NativeIsolate isolate = cleaner.isolate;
                if (!isolate.cleaners.remove(cleaner)) continue;
                if (enteredThreads == null) {
                    enteredThreads = new HashMap();
                    enteredThread = null;
                } else {
                    enteredThread = enteredThreads.get(isolate);
                }
                if (enteredThread == null) {
                    enteredThread = isolate.tryEnter();
                    if (enteredThread == null) {
                        enteredThread = INVALID_ISOLATE_THREAD;
                    }
                    enteredThreads.put(isolate, enteredThread);
                }
                if (enteredThread == INVALID_ISOLATE_THREAD) continue;
                NativeObjectCleaner.cleanImpl(((NativeIsolateThread)enteredThread).getIsolateThreadId(), cleaner);
            }
        }
        finally {
            if (enteredThreads != null) {
                for (Object enteredThread : enteredThreads.values()) {
                    if (enteredThread == INVALID_ISOLATE_THREAD) continue;
                    ((NativeIsolateThread)enteredThread).leave();
                }
            }
        }
    }

    private static void cleanImpl(long isolateThread, NativeObjectCleaner<?> cleaner) {
        cleaner.cleanUp(isolateThread);
    }
}

