/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver.launcher;

import com.oracle.svm.driver.launcher.ContainerSupport;
import com.oracle.svm.driver.launcher.configuration.BundleArgsParser;
import com.oracle.svm.driver.launcher.configuration.BundleEnvironmentParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BundleLauncher {
    static final String BUNDLE_INFO_MESSAGE_PREFIX = "Native Image Bundles: ";
    private static final String BUNDLE_TEMP_DIR_PREFIX = "bundleRoot-";
    private static final String BUNDLE_FILE_EXTENSION = ".nib";
    private static final String HELP_TEXT = BundleLauncher.getResource("/com/oracle/svm/driver/launcher/BundleLauncherHelp.txt");
    private static Path rootDir;
    private static Path inputDir;
    private static Path outputDir;
    private static Path stageDir;
    private static Path classPathDir;
    private static Path modulePathDir;
    private static Path bundleFilePath;
    private static String bundleName;
    private static Path agentOutputDir;
    private static String newBundleName;
    private static boolean updateBundle;
    private static boolean verbose;
    private static ContainerSupport containerSupport;
    private static final List<String> launchArgs;
    private static final List<String> applicationArgs;
    private static final Map<String, String> launcherEnvironment;
    private static final Path buildTimeJavaHome;
    private static final AtomicBoolean deleteBundleRoot;
    private static final String deletedFileSuffix = ".deleted";

    static String getResource(String resourceName) {
        String string;
        block8: {
            InputStream input = BundleLauncher.class.getResourceAsStream(resourceName);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
                string = reader.lines().collect(Collectors.joining("\n"));
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
            input.close();
        }
        return string;
    }

    public static void main(String[] args) {
        int exitCode;
        String bundleLauncherPath = BundleLauncher.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        bundleFilePath = Paths.get(BundleLauncher.isWindows() ? bundleLauncherPath.substring(1) : bundleLauncherPath, new String[0]);
        bundleName = bundleFilePath.getFileName().toString().replace(BUNDLE_FILE_EXTENSION, "");
        agentOutputDir = bundleFilePath.getParent().resolve(Paths.get(bundleName + ".output", "launcher"));
        BundleLauncher.unpackBundle();
        if (!Files.exists(stageDir.resolve("run.json"), new LinkOption[0])) {
            BundleLauncher.showMessage("Native Image Bundles: Bundle " + String.valueOf(bundleFilePath) + " is not executable!");
            System.exit(1);
        }
        BundleLauncher.parseBundleLauncherArgs(args);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        Path environmentFile = stageDir.resolve("environment.json");
        if (Files.isReadable(environmentFile)) {
            try (BufferedReader reader = Files.newBufferedReader(environmentFile);){
                new BundleEnvironmentParser(launcherEnvironment).parseAndRegister(reader);
                pb.environment().putAll(launcherEnvironment);
            }
            catch (IOException e2) {
                throw new Error("Failed to read bundle-file " + String.valueOf(environmentFile), e2);
            }
        }
        pb.command(BundleLauncher.createLaunchCommand());
        if (verbose) {
            List<String> environmentList = pb.environment().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).sorted().toList();
            BundleLauncher.showMessage("Executing [");
            BundleLauncher.showMessage(String.join((CharSequence)(" \\" + System.lineSeparator()), environmentList));
            BundleLauncher.showMessage(String.join((CharSequence)(" \\" + System.lineSeparator()), pb.command()));
            BundleLauncher.showMessage("]");
        }
        Process p = null;
        try {
            p = pb.inheritIO().start();
            exitCode = p.waitFor();
        }
        catch (IOException | InterruptedException e3) {
            throw new Error("Failed to run bundled application");
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        if (updateBundle) {
            exitCode = BundleLauncher.updateBundle();
        }
        System.exit(exitCode);
    }

    private static boolean useContainer() {
        return containerSupport != null;
    }

    private static List<String> createLaunchCommand() {
        ArrayList<String> command = new ArrayList<String>();
        Path javaExecutable = BundleLauncher.getJavaExecutable().toAbsolutePath().normalize();
        if (BundleLauncher.useContainer()) {
            Path javaHome = javaExecutable.getParent().getParent();
            Map<Path, ContainerSupport.TargetPath> mountMapping = ContainerSupport.mountMappingFor(javaHome, inputDir, outputDir);
            if (Files.isDirectory(agentOutputDir, new LinkOption[0])) {
                mountMapping.put(agentOutputDir, ContainerSupport.TargetPath.of(agentOutputDir, false));
                launcherEnvironment.put("LD_LIBRARY_PATH", ContainerSupport.GRAAL_VM_HOME.resolve("lib").toString());
            }
            containerSupport.initializeImage();
            command.addAll(containerSupport.createCommand(launcherEnvironment, mountMapping));
            command.add(ContainerSupport.GRAAL_VM_HOME.resolve(javaHome.relativize(javaExecutable)).toString());
        } else {
            command.add(javaExecutable.toString());
        }
        command.addAll(launchArgs);
        ArrayList classpath = new ArrayList();
        if (Files.isDirectory(classPathDir, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(classPathDir, 1, new FileVisitOption[0]);){
                walk.filter(path -> path.toString().endsWith(".jar") || Files.isDirectory(path, new LinkOption[0])).map(path -> BundleLauncher.useContainer() ? Paths.get("/", new String[0]).resolve(rootDir.relativize((Path)path)) : path).map(Path::toString).forEach(classpath::add);
            }
            catch (IOException e) {
                throw new Error("Failed to iterate through directory " + String.valueOf(classPathDir), e);
            }
            command.add("-cp");
            command.add(String.join((CharSequence)File.pathSeparator, classpath));
        }
        ArrayList modulePath = new ArrayList();
        if (Files.isDirectory(modulePathDir, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(modulePathDir, 1, new FileVisitOption[0]);){
                walk.filter(path -> Files.isDirectory(path, new LinkOption[0]) && !path.equals(modulePathDir) || path.toString().endsWith(".jar")).map(path -> BundleLauncher.useContainer() ? Paths.get("/", new String[0]).resolve(rootDir.relativize((Path)path)) : path).map(Path::toString).forEach(modulePath::add);
            }
            catch (IOException e) {
                throw new Error("Failed to iterate through directory " + String.valueOf(modulePathDir), e);
            }
            if (!modulePath.isEmpty()) {
                command.add("-p");
                command.add(String.join((CharSequence)File.pathSeparator, modulePath));
            }
        }
        Path argsFile = stageDir.resolve("run.json");
        try (BufferedReader reader = Files.newBufferedReader(argsFile);){
            ArrayList<String> argsFromFile = new ArrayList<String>();
            new BundleArgsParser(argsFromFile).parseAndRegister(reader);
            command.addAll(argsFromFile);
        }
        catch (IOException e) {
            throw new Error("Failed to read bundle-file " + String.valueOf(argsFile), e);
        }
        command.addAll(applicationArgs);
        return command;
    }

    private static int updateBundle() {
        ArrayList<String> command = new ArrayList<String>();
        Path nativeImageExecutable = BundleLauncher.getNativeImageExecutable().toAbsolutePath().normalize();
        command.add(nativeImageExecutable.toString());
        Path newBundleFilePath = newBundleName == null ? bundleFilePath : bundleFilePath.getParent().resolve(newBundleName + BUNDLE_FILE_EXTENSION);
        command.add("--bundle-apply=" + String.valueOf(bundleFilePath));
        command.add("--bundle-create=" + String.valueOf(newBundleFilePath) + ",dry-run");
        command.add("-cp");
        command.add(agentOutputDir.toString());
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = null;
        try {
            p = pb.inheritIO().start();
            int n = p.waitFor();
            return n;
        }
        catch (IOException | InterruptedException e) {
            throw new Error("Failed to create updated bundle.");
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseBundleLauncherArgs(String[] args) {
        ArrayDeque<String> argQueue = new ArrayDeque<String>(Arrays.asList(args));
        block12: while (!argQueue.isEmpty()) {
            String option;
            String arg = (String)argQueue.removeFirst();
            if (arg.startsWith("--with-native-image-agent")) {
                if (arg.indexOf(44) >= 0) {
                    option = arg.substring(arg.indexOf(44) + 1);
                    if (!option.startsWith("update-bundle")) throw new Error(String.format("Unknown option %s. Valid option is: update-bundle[=<new-bundle-name>].", option));
                    updateBundle = true;
                    if (option.indexOf(61) >= 0) {
                        newBundleName = option.substring(option.indexOf(61)).replace(BUNDLE_FILE_EXTENSION, "");
                    }
                }
                Path configOutputDir = agentOutputDir.resolve(Paths.get("META-INF", "native-image", bundleName + "-agent"));
                try {
                    Files.createDirectories(configOutputDir, new FileAttribute[0]);
                    BundleLauncher.showMessage("Native Image Bundles: Native image agent output written to " + String.valueOf(agentOutputDir));
                    launchArgs.add("-agentlib:native-image-agent=config-output-dir=" + String.valueOf(configOutputDir));
                    continue;
                }
                catch (IOException e) {
                    throw new Error("Failed to create native image agent output dir");
                }
            }
            if (arg.startsWith("--container")) {
                if (BundleLauncher.useContainer()) {
                    throw new Error("native-image launcher allows option container to be specified only once.");
                }
                if (!System.getProperty("os.name").equals("Linux")) {
                    throw new Error("container option is only supported for Linux");
                }
                containerSupport = new ContainerSupport(stageDir, Error::new, BundleLauncher::showWarning, BundleLauncher::showMessage);
                if (arg.indexOf(44) != -1) {
                    option = arg.substring(arg.indexOf(44) + 1);
                    arg = arg.substring(0, arg.indexOf(44));
                    if (!option.startsWith("dockerfile")) throw new Error(String.format("Unknown option %s. Valid option is: dockerfile=path/to/Dockerfile.", option));
                    if (option.indexOf(61) == -1) throw new Error("container option dockerfile requires a dockerfile argument. E.g. dockerfile=path/to/Dockerfile.");
                    BundleLauncher.containerSupport.dockerfile = Paths.get(option.substring(option.indexOf(61) + 1), new String[0]);
                    if (!Files.isReadable(BundleLauncher.containerSupport.dockerfile)) {
                        throw new Error(String.format("Dockerfile '%s' is not readable", BundleLauncher.containerSupport.dockerfile.toAbsolutePath()));
                    }
                }
                if (arg.indexOf(61) == -1) continue;
                BundleLauncher.containerSupport.tool = arg.substring(arg.indexOf(61) + 1);
                continue;
            }
            switch (arg) {
                case "--help": {
                    BundleLauncher.showMessage(HELP_TEXT);
                    System.exit(0);
                    continue block12;
                }
                case "--verbose": {
                    verbose = true;
                    continue block12;
                }
                case "--": {
                    applicationArgs.addAll(argQueue);
                    argQueue.clear();
                    continue block12;
                }
            }
            applicationArgs.add(arg);
        }
    }

    private static void showMessage(String msg) {
        System.out.println(msg);
    }

    private static void showWarning(String msg) {
        System.out.println("Warning: " + msg);
    }

    private static Path getJavaExecutable() {
        Path binJava = Paths.get("bin", System.getProperty("os.name").contains("Windows") ? "java.exe" : "java");
        if (Files.isExecutable(buildTimeJavaHome.resolve(binJava))) {
            return buildTimeJavaHome.resolve(binJava);
        }
        return BundleLauncher.getJavaHomeExecutable(binJava);
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    private static Path getJavaHomeExecutable(Path executable) {
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            throw new Error("Environment variable JAVA_HOME is not set");
        }
        Path javaHomeDir = Paths.get(javaHome, new String[0]);
        if (!Files.isDirectory(javaHomeDir, new LinkOption[0])) {
            throw new Error("Environment variable JAVA_HOME does not refer to a directory");
        }
        if (!Files.isExecutable(javaHomeDir.resolve(executable))) {
            throw new Error("Environment variable JAVA_HOME does not refer to a directory with a " + String.valueOf(executable) + " executable");
        }
        return javaHomeDir.resolve(executable);
    }

    private static Path getNativeImageExecutable() {
        Path graalVMHomeDir;
        Path binNativeImage = Paths.get("bin", BundleLauncher.isWindows() ? "native-image.exe" : "native-image");
        if (Files.isExecutable(buildTimeJavaHome.resolve(binNativeImage))) {
            return buildTimeJavaHome.resolve(binNativeImage);
        }
        String graalVMHome = System.getenv("GRAALVM_HOME");
        if (graalVMHome != null && Files.isDirectory(graalVMHomeDir = Paths.get(graalVMHome, new String[0]), new LinkOption[0]) && Files.isExecutable(graalVMHomeDir.resolve(binNativeImage))) {
            return graalVMHomeDir.resolve(binNativeImage);
        }
        return BundleLauncher.getJavaHomeExecutable(binNativeImage);
    }

    private static Path createBundleRootDir() throws IOException {
        Path bundleRoot = Files.createTempDirectory(BUNDLE_TEMP_DIR_PREFIX, new FileAttribute[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            deleteBundleRoot.set(true);
            BundleLauncher.deleteAllFiles(bundleRoot);
        }));
        return bundleRoot;
    }

    private static boolean isDeletedPath(Path toDelete) {
        return toDelete.getFileName().toString().endsWith(deletedFileSuffix);
    }

    private static void deleteAllFiles(Path toDelete) {
        try {
            Path deletedPath = toDelete;
            if (!BundleLauncher.isDeletedPath(deletedPath)) {
                deletedPath = toDelete.resolveSibling(String.valueOf(toDelete.getFileName()) + deletedFileSuffix);
                Files.move(toDelete, deletedPath, new CopyOption[0]);
            }
            try (Stream<Path> walk = Files.walk(deletedPath, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        catch (IOException e) {
            BundleLauncher.showMessage("Could not recursively delete path: " + String.valueOf(toDelete));
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unpackBundle() {
        try {
            rootDir = BundleLauncher.createBundleRootDir();
            inputDir = rootDir.resolve("input");
            try (JarFile archive = new JarFile(bundleFilePath.toFile());){
                Enumeration<JarEntry> jarEntries = archive.entries();
                while (jarEntries.hasMoreElements() && !deleteBundleRoot.get()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    Path bundleEntry = rootDir.resolve(jarEntry.getName());
                    try {
                        Path bundleFileParent = bundleEntry.getParent();
                        if (bundleFileParent != null) {
                            Files.createDirectories(bundleFileParent, new FileAttribute[0]);
                        }
                        Files.copy(archive.getInputStream(jarEntry), bundleEntry, new CopyOption[0]);
                    }
                    catch (IOException e) {
                        throw new Error("Unable to copy " + jarEntry.getName() + " from bundle " + String.valueOf(bundleEntry) + " to " + String.valueOf(bundleEntry), e);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new Error("Unable to expand bundle directory layout from bundle file " + String.valueOf(bundleFilePath), e);
        }
        if (deleteBundleRoot.get()) {
            throw new Error(null, null);
        }
        try {
            stageDir = Files.createDirectories(inputDir.resolve("stage"), new FileAttribute[0]);
            Path classesDir = inputDir.resolve("classes");
            classPathDir = Files.createDirectories(classesDir.resolve("cp"), new FileAttribute[0]);
            modulePathDir = Files.createDirectories(classesDir.resolve("p"), new FileAttribute[0]);
            outputDir = Files.createDirectories(rootDir.resolve("output"), new FileAttribute[0]);
            return;
        }
        catch (IOException e) {
            throw new Error("Unable to create bundle directory layout", e);
        }
    }

    static {
        newBundleName = null;
        updateBundle = false;
        verbose = false;
        launchArgs = new ArrayList<String>();
        applicationArgs = new ArrayList<String>();
        launcherEnvironment = new HashMap<String, String>();
        buildTimeJavaHome = Paths.get(System.getProperty("java.home"), new String[0]);
        deleteBundleRoot = new AtomicBoolean();
    }
}

