/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import java.util.EnumSet;
import java.util.Optional;
import org.graalvm.collections.EconomicMap;

public abstract class ConditionalConfigurationParser
extends ConfigurationParser {
    public static final String CONDITIONAL_KEY = "condition";

    protected ConditionalConfigurationParser(EnumSet<ConfigurationParserOption> parserOptions) {
        super(parserOptions);
    }

    @Override
    protected EnumSet<ConfigurationParserOption> supportedOptions() {
        EnumSet<ConfigurationParserOption> base = super.supportedOptions();
        base.add(ConfigurationParserOption.TREAT_ALL_TYPE_REACHABLE_CONDITIONS_AS_TYPE_REACHED);
        return base;
    }

    protected UnresolvedConfigurationCondition parseCondition(EconomicMap<String, Object> data, boolean runtimeCondition) {
        Object conditionData = data.get((Object)CONDITIONAL_KEY);
        if (conditionData != null) {
            EconomicMap<String, Object> conditionObject = ConditionalConfigurationParser.asMap(conditionData, "Attribute 'condition' must be an object");
            if (conditionObject.containsKey((Object)"typeReachable") && conditionObject.containsKey((Object)"typeReached")) {
                ConditionalConfigurationParser.failOnSchemaError("condition can not have both 'typeReached' and 'typeReachable' set.");
            }
            if (conditionObject.containsKey((Object)"typeReached")) {
                Object object;
                Optional<ConfigurationTypeDescriptor> condition;
                if (!runtimeCondition) {
                    ConditionalConfigurationParser.failOnSchemaError("'typeReached' condition cannot be used in older schemas. Please migrate the file to the latest schema.");
                }
                if ((condition = this.parseTypeContents(object = conditionObject.get((Object)"typeReached"))).isPresent()) {
                    NamedConfigurationTypeDescriptor namedDescriptor = ConditionalConfigurationParser.checkConditionType(condition.get());
                    return UnresolvedConfigurationCondition.create(namedDescriptor);
                }
            } else if (conditionObject.containsKey((Object)"typeReachable")) {
                Object object;
                Optional<ConfigurationTypeDescriptor> condition;
                if (runtimeCondition && !this.checkOption(ConfigurationParserOption.TREAT_ALL_TYPE_REACHABLE_CONDITIONS_AS_TYPE_REACHED)) {
                    ConditionalConfigurationParser.failOnSchemaError("'typeReachable' condition can not be used with the latest schema. Please use 'typeReached'.");
                }
                if ((condition = this.parseTypeContents(object = conditionObject.get((Object)"typeReachable"))).isPresent()) {
                    NamedConfigurationTypeDescriptor namedDescriptor = ConditionalConfigurationParser.checkConditionType(condition.get());
                    return UnresolvedConfigurationCondition.create(namedDescriptor, this.checkOption(ConfigurationParserOption.TREAT_ALL_TYPE_REACHABLE_CONDITIONS_AS_TYPE_REACHED));
                }
            }
        }
        return UnresolvedConfigurationCondition.alwaysTrue();
    }

    private static NamedConfigurationTypeDescriptor checkConditionType(ConfigurationTypeDescriptor type) {
        if (!(type instanceof NamedConfigurationTypeDescriptor)) {
            ConditionalConfigurationParser.failOnSchemaError("condition should be a fully qualified class name.");
        }
        return (NamedConfigurationTypeDescriptor)type;
    }
}

