/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.ReflectionConfigurationParser;
import com.oracle.svm.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.util.TypeResult;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

final class LegacyReflectionConfigurationParser<C, T>
extends ReflectionConfigurationParser<C, T> {
    private static final List<String> OPTIONAL_REFLECT_CONFIG_OBJECT_ATTRS = Arrays.asList("allDeclaredConstructors", "allPublicConstructors", "allDeclaredMethods", "allPublicMethods", "allDeclaredFields", "allPublicFields", "allDeclaredClasses", "allRecordComponents", "allPermittedSubclasses", "allNestMembers", "allSigners", "allPublicClasses", "methods", "queriedMethods", "fields", "condition", "queryAllDeclaredConstructors", "queryAllPublicConstructors", "queryAllDeclaredMethods", "queryAllPublicMethods", "unsafeAllocated", "serializable");

    LegacyReflectionConfigurationParser(ConfigurationConditionResolver<C> conditionResolver, ReflectionConfigurationParserDelegate<C, T> delegate, EnumSet<ConfigurationParserOption> parserOptions) {
        super(conditionResolver, delegate, parserOptions);
    }

    @Override
    protected EnumSet<ConfigurationParserOption> supportedOptions() {
        EnumSet<ConfigurationParserOption> base = super.supportedOptions();
        base.add(ConfigurationParserOption.TREAT_ALL_NAME_ENTRIES_AS_TYPE);
        return base;
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        this.parseClassArray(LegacyReflectionConfigurationParser.asList(json, "first level of document must be an array of class descriptors"));
    }

    @Override
    protected void parseClass(EconomicMap<String, Object> data) {
        this.checkAttributes(data, "reflection class descriptor object", List.of("name"), OPTIONAL_REFLECT_CONFIG_OBJECT_ATTRS);
        Optional<ConfigurationParser.TypeDescriptorWithOrigin> type = LegacyReflectionConfigurationParser.parseName(data, this.checkOption(ConfigurationParserOption.TREAT_ALL_NAME_ENTRIES_AS_TYPE));
        if (type.isEmpty()) {
            return;
        }
        ConfigurationTypeDescriptor typeDescriptor = type.get().typeDescriptor();
        boolean isType = type.get().definedAsType();
        UnresolvedConfigurationCondition unresolvedCondition = this.parseCondition(data, false);
        TypeResult conditionResult = this.conditionResolver.resolveCondition(unresolvedCondition);
        if (!conditionResult.isPresent()) {
            return;
        }
        boolean jniParser = this.checkOption(ConfigurationParserOption.JNI_PARSER);
        Object condition = conditionResult.get();
        TypeResult result = this.delegate.resolveType(condition, typeDescriptor, true, jniParser);
        if (!result.isPresent()) {
            this.handleMissingElement("Could not resolve " + String.valueOf(typeDescriptor) + " for reflection configuration.", result.getException());
            return;
        }
        Object queryCondition = isType ? this.conditionResolver.alwaysTrue() : condition;
        Object clazz = result.get();
        this.delegate.registerType(conditionResult.get(), clazz);
        if (jniParser) {
            this.delegate.registerAsJniAccessed(condition, clazz);
        }
        this.registerIfNotDefault(data, false, clazz, "allDeclaredConstructors", () -> this.delegate.registerDeclaredConstructors(condition, false, jniParser, clazz));
        this.registerIfNotDefault(data, false, clazz, "allPublicConstructors", () -> this.delegate.registerPublicConstructors(condition, false, jniParser, clazz));
        this.registerIfNotDefault(data, false, clazz, "allDeclaredMethods", () -> this.delegate.registerDeclaredMethods(condition, false, jniParser, clazz));
        this.registerIfNotDefault(data, false, clazz, "allPublicMethods", () -> this.delegate.registerPublicMethods(condition, false, jniParser, clazz));
        this.registerIfNotDefault(data, false, clazz, "allDeclaredFields", () -> this.delegate.registerDeclaredFields(condition, false, jniParser, clazz));
        this.registerIfNotDefault(data, false, clazz, "allPublicFields", () -> this.delegate.registerPublicFields(condition, false, jniParser, clazz));
        this.registerIfNotDefault(data, !jniParser && isType, clazz, "allDeclaredClasses", () -> this.delegate.registerDeclaredClasses(queryCondition, clazz));
        this.registerIfNotDefault(data, !jniParser && isType, clazz, "allRecordComponents", () -> this.delegate.registerRecordComponents(queryCondition, clazz));
        this.registerIfNotDefault(data, !jniParser && isType, clazz, "allPermittedSubclasses", () -> this.delegate.registerPermittedSubclasses(queryCondition, clazz));
        this.registerIfNotDefault(data, !jniParser && isType, clazz, "allNestMembers", () -> this.delegate.registerNestMembers(queryCondition, clazz));
        this.registerIfNotDefault(data, !jniParser && isType, clazz, "allSigners", () -> this.delegate.registerSigners(queryCondition, clazz));
        this.registerIfNotDefault(data, !jniParser && isType, clazz, "allPublicClasses", () -> this.delegate.registerPublicClasses(queryCondition, clazz));
        this.registerIfNotDefault(data, isType, clazz, "queryAllDeclaredConstructors", () -> this.delegate.registerDeclaredConstructors(queryCondition, true, jniParser, clazz));
        this.registerIfNotDefault(data, isType, clazz, "queryAllPublicConstructors", () -> this.delegate.registerPublicConstructors(queryCondition, true, jniParser, clazz));
        this.registerIfNotDefault(data, isType, clazz, "queryAllDeclaredMethods", () -> this.delegate.registerDeclaredMethods(queryCondition, true, jniParser, clazz));
        this.registerIfNotDefault(data, isType, clazz, "queryAllPublicMethods", () -> this.delegate.registerPublicMethods(queryCondition, true, jniParser, clazz));
        if (isType) {
            this.delegate.registerDeclaredFields(queryCondition, true, jniParser, clazz);
            this.delegate.registerPublicFields(queryCondition, true, jniParser, clazz);
        }
        this.registerIfNotDefault(data, false, clazz, "unsafeAllocated", () -> this.delegate.registerUnsafeAllocated(condition, clazz));
        MapCursor cursor = data.getEntries();
        while (cursor.advance()) {
            String name = (String)cursor.getKey();
            Object value = cursor.getValue();
            try {
                switch (name) {
                    case "methods": {
                        this.parseMethods(condition, false, LegacyReflectionConfigurationParser.asList(value, "Attribute 'methods' must be an array of method descriptors"), clazz, jniParser);
                        break;
                    }
                    case "queriedMethods": {
                        this.parseMethods(condition, true, LegacyReflectionConfigurationParser.asList(value, "Attribute 'queriedMethods' must be an array of method descriptors"), clazz, jniParser);
                        break;
                    }
                    case "fields": {
                        this.parseFields(condition, LegacyReflectionConfigurationParser.asList(value, "Attribute 'fields' must be an array of field descriptors"), clazz, jniParser);
                    }
                }
            }
            catch (LinkageError e) {
                this.handleMissingElement("Could not register " + this.delegate.getTypeName(clazz) + ": " + name + " for reflection.", e);
            }
        }
    }
}

