/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import java.util.Objects;

public final class UnresolvedConfigurationCondition
implements Comparable<UnresolvedConfigurationCondition> {
    private static final UnresolvedConfigurationCondition JAVA_LANG_OBJECT_REACHED = new UnresolvedConfigurationCondition(NamedConfigurationTypeDescriptor.fromTypeName(Object.class.getTypeName()), true);
    public static final String TYPE_REACHED_KEY = "typeReached";
    public static final String TYPE_REACHABLE_KEY = "typeReachable";
    private final NamedConfigurationTypeDescriptor type;
    private final boolean runtimeChecked;

    public static UnresolvedConfigurationCondition create(NamedConfigurationTypeDescriptor type) {
        return UnresolvedConfigurationCondition.create(type, true);
    }

    public static UnresolvedConfigurationCondition create(NamedConfigurationTypeDescriptor type, boolean runtimeChecked) {
        Objects.requireNonNull(type);
        if (JAVA_LANG_OBJECT_REACHED.getTypeName().equals(type.name())) {
            return JAVA_LANG_OBJECT_REACHED;
        }
        return new UnresolvedConfigurationCondition(type, runtimeChecked);
    }

    private UnresolvedConfigurationCondition(NamedConfigurationTypeDescriptor type, boolean runtimeChecked) {
        this.type = type;
        this.runtimeChecked = runtimeChecked;
    }

    public static UnresolvedConfigurationCondition alwaysTrue() {
        return JAVA_LANG_OBJECT_REACHED;
    }

    public String getTypeName() {
        return this.type.name();
    }

    public boolean isRuntimeChecked() {
        return this.runtimeChecked;
    }

    public boolean isAlwaysTrue() {
        return this.getTypeName().equals(JAVA_LANG_OBJECT_REACHED.getTypeName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnresolvedConfigurationCondition that = (UnresolvedConfigurationCondition)o;
        return this.runtimeChecked == that.runtimeChecked && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.runtimeChecked);
    }

    @Override
    public int compareTo(UnresolvedConfigurationCondition o) {
        int res = Boolean.compare(this.runtimeChecked, o.runtimeChecked);
        if (res != 0) {
            return res;
        }
        return this.type.compareTo(o.type);
    }

    public String toString() {
        String field = this.runtimeChecked ? TYPE_REACHED_KEY : TYPE_REACHABLE_KEY;
        return "[" + field + ": \"" + this.getTypeName() + "\"]";
    }
}

