/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config.conditional;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.ConfigurationFile;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.conditional.MethodInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public final class MethodCallNode {
    public final MethodInfo methodInfo;
    public final MethodCallNode parent;
    public final Map<MethodInfo, MethodCallNode> calledMethods;
    public volatile ConfigurationSet configuration;

    private MethodCallNode(MethodInfo methodInfo, MethodCallNode parent) {
        this.methodInfo = methodInfo;
        this.parent = parent;
        this.calledMethods = new ConcurrentHashMap<MethodInfo, MethodCallNode>();
        this.configuration = null;
    }

    public MethodCallNode getOrCreateChild(MethodInfo info) {
        return this.calledMethods.computeIfAbsent(info, key -> new MethodCallNode((MethodInfo)key, this));
    }

    public static MethodCallNode createRoot() {
        return new MethodCallNode(null, null);
    }

    public Set<MethodCallNode> getNodesWithNonEmptyConfig(ConfigurationFile configFile) {
        HashSet<MethodCallNode> nodesWithNonEmptyConfig = new HashSet<MethodCallNode>();
        this.visitPostOrder(node -> {
            if (node.hasConfig(configFile)) {
                nodesWithNonEmptyConfig.add((MethodCallNode)node);
            }
            if (nodesWithNonEmptyConfig.contains(node) && node.parent != null) {
                nodesWithNonEmptyConfig.add(node.parent);
            }
        });
        return nodesWithNonEmptyConfig;
    }

    public void mergeSubTree(MethodCallNode other, boolean mergeConfig) {
        if (mergeConfig) {
            this.configuration = this.getConfiguration().copyAndMerge(other.getConfiguration());
        }
        for (MethodCallNode child : other.calledMethods.values()) {
            this.calledMethods.compute(child.methodInfo, (key, value) -> {
                if (value == null) {
                    return child;
                }
                value.mergeSubTree(child, true);
                return value;
            });
        }
    }

    public boolean hasConfig(ConfigurationFile configFile) {
        return this.configuration != null && !((ConfigurationBase)this.configuration.getConfiguration(configFile)).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationSet getConfiguration() {
        if (this.configuration == null) {
            MethodCallNode methodCallNode = this;
            synchronized (methodCallNode) {
                if (this.configuration == null) {
                    this.configuration = new ConfigurationSet();
                }
            }
        }
        return this.configuration;
    }

    public void visitPostOrder(Consumer<MethodCallNode> methodCallNodeConsumer) {
        for (MethodCallNode node : this.calledMethods.values()) {
            node.visitPostOrder(methodCallNodeConsumer);
        }
        methodCallNodeConsumer.accept(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodCallNode that = (MethodCallNode)o;
        return this.methodInfo.equals(that.methodInfo) && Objects.equals(this.parent, that.parent) && this.calledMethods.equals(that.calledMethods);
    }

    public int hashCode() {
        return Objects.hash(this.methodInfo, this.parent);
    }
}

