/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.ClassNameSupport;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SignatureUtil;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.graal.compiler.phases.common.LazyValue;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.collections.EconomicMap;

class ReflectionProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;
    private boolean trackReflectionMetadata = true;

    ReflectionProcessor(AccessAdvisor advisor) {
        this.advisor = advisor;
    }

    public void setTrackReflectionMetadata(boolean trackReflectionMetadata) {
        this.trackReflectionMetadata = trackReflectionMetadata;
    }

    @Override
    public void processEntry(EconomicMap<String, Object> entry, ConfigurationSet configurationSet) {
        boolean isLoadClass;
        boolean invalidResult = Boolean.FALSE.equals(entry.get((Object)"result"));
        UnresolvedConfigurationCondition condition = UnresolvedConfigurationCondition.alwaysTrue();
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get((Object)"function");
        List args = (List)entry.get((Object)"args");
        ResourceConfiguration resourceConfiguration = configurationSet.getResourceConfiguration();
        switch (function) {
            case "findResource": 
            case "findResourceAsStream": {
                ReflectionProcessor.expectSize(args, 2);
                String module = (String)args.get(0);
                String resource = (String)args.get(1);
                if (!this.advisor.shouldIgnoreResourceLookup(LazyValueUtils.lazyValue(resource), entry)) {
                    resourceConfiguration.addGlobPattern(condition, resource, module);
                }
                return;
            }
            case "getResource": 
            case "getSystemResource": 
            case "getSystemResourceAsStream": 
            case "getResources": 
            case "getSystemResources": 
            case "getEntry": {
                String literal = (String)ReflectionProcessor.singleElement(args);
                if (!this.advisor.shouldIgnoreResourceLookup(LazyValueUtils.lazyValue(literal), entry)) {
                    resourceConfiguration.addGlobPattern(condition, literal, null);
                }
                return;
            }
        }
        TypeConfiguration configuration = configurationSet.getReflectionConfiguration();
        String callerClass = (String)entry.get((Object)"caller_class");
        boolean bl = isLoadClass = function.equals("loadClass") || function.equals("findSystemClass");
        if (isLoadClass || function.equals("forName") || function.equals("findClass")) {
            String name = (String)ReflectionProcessor.singleElement(args);
            if (isLoadClass) {
                name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
            }
            if (!(this.advisor.shouldIgnore(LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(callerClass), entry) || isLoadClass && this.advisor.shouldIgnoreLoadClass(LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(callerClass), entry) || !ClassNameSupport.isValidReflectionName(name))) {
                configuration.getOrCreateType(condition, NamedConfigurationTypeDescriptor.fromReflectionName(name));
            }
            return;
        }
        if (function.equals("methodTypeDescriptor")) {
            List typeNames = (List)ReflectionProcessor.singleElement(args);
            for (String type : typeNames) {
                if (this.advisor.shouldIgnore(LazyValueUtils.lazyValue(type), LazyValueUtils.lazyValue(callerClass), this.copyWithUniqueEntry(entry, "ignoredDescriptorType", type))) continue;
                configuration.getOrCreateType(condition, NamedConfigurationTypeDescriptor.fromReflectionName(type));
            }
            return;
        }
        ConfigurationTypeDescriptor clazz = ReflectionProcessor.descriptorForClass(entry.get((Object)"class"));
        if (clazz != null) {
            for (String className : clazz.getAllQualifiedJavaNames()) {
                if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(className), LazyValueUtils.lazyValue(callerClass), false, this.copyWithUniqueEntry(entry, "ignoredClassName", className))) continue;
                return;
            }
        }
        ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration = ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC;
        ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility = ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED;
        ConfigurationTypeDescriptor clazzOrDeclaringClass = entry.containsKey((Object)"declaring_class") ? ReflectionProcessor.descriptorForClass(entry.get((Object)"declaring_class")) : clazz;
        switch (function) {
            case "getDeclaredFields": 
            case "getFields": 
            case "getDeclaredMethods": 
            case "getMethods": 
            case "getDeclaredConstructors": 
            case "getConstructors": 
            case "getDeclaredClasses": 
            case "getClasses": 
            case "getRecordComponents": 
            case "getPermittedSubclasses": 
            case "getNestMembers": 
            case "getSigners": {
                configuration.getOrCreateType(condition, clazz);
                break;
            }
            case "getDeclaredField": 
            case "getField": 
            case "getDeclaredMethod": 
            case "getMethod": 
            case "getDeclaredConstructor": 
            case "getConstructor": {
                configuration.getOrCreateType(condition, clazz);
                if (clazzOrDeclaringClass.equals(clazz)) break;
                configuration.getOrCreateType(condition, clazz);
                break;
            }
            case "accessField": {
                ReflectionProcessor.expectSize(args, 1);
                String name = (String)args.get(0);
                configuration.getOrCreateType(condition, clazz).addField(name, ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, false);
                break;
            }
            case "asInterfaceInstance": {
                accessibility = ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED;
                configuration.getOrCreateType(condition, clazz).setAllPublicMethods(accessibility);
                break;
            }
            case "objectFieldOffset": 
            case "findFieldHandle": 
            case "unreflectField": {
                declaration = "findFieldHandle".equals(function) ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT : ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED;
                configuration.getOrCreateType(condition, clazzOrDeclaringClass).addField((String)ReflectionProcessor.singleElement(args), declaration, false);
                if (clazzOrDeclaringClass.equals(clazz)) break;
                configuration.getOrCreateType(condition, clazz);
                break;
            }
            case "findMethodHandle": 
            case "invokeMethod": {
                ReflectionProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                List parameterTypes = (List)args.get(1);
                if (parameterTypes == null) {
                    parameterTypes = Collections.emptyList();
                }
                configuration.getOrCreateType(condition, clazzOrDeclaringClass).addMethod(name, SignatureUtil.toInternalSignature(parameterTypes), ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT, ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
                if (this.trackReflectionMetadata || clazzOrDeclaringClass.equals(clazz)) break;
                configuration.getOrCreateType(condition, clazz);
                break;
            }
            case "findConstructorHandle": 
            case "invokeConstructor": {
                declaration = ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT;
                accessibility = ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED;
                List parameterTypes = (List)ReflectionProcessor.singleElement(args);
                if (parameterTypes == null) {
                    parameterTypes = Collections.emptyList();
                }
                String signature = SignatureUtil.toInternalSignature(parameterTypes);
                assert (clazz.equals(clazzOrDeclaringClass)) : "Constructor can only be accessed via declaring class";
                configuration.getOrCreateType(condition, clazzOrDeclaringClass).addMethod("<init>", signature, declaration, accessibility);
                break;
            }
            case "getProxyClass": {
                ReflectionProcessor.expectSize(args, 2);
                this.addDynamicProxy((List)args.get(1), LazyValueUtils.lazyValue(callerClass), configuration, entry);
                break;
            }
            case "newProxyInstance": {
                ReflectionProcessor.expectSize(args, 3);
                this.addDynamicProxy((List)args.get(1), LazyValueUtils.lazyValue(callerClass), configuration, entry);
                break;
            }
            case "newMethodHandleProxyInstance": {
                ReflectionProcessor.expectSize(args, 1);
                this.addDynamicProxyUnchecked((List)args.get(0), Collections.singletonList("sun.invoke.WrapperInstance"), LazyValueUtils.lazyValue(callerClass), configuration, entry);
                break;
            }
            case "getEnclosingConstructor": 
            case "getEnclosingMethod": {
                String result = (String)entry.get((Object)"result");
                ReflectionProcessor.addFullyQualifiedDeclaredMethod(result, configuration);
                break;
            }
            case "newInstance": {
                if (clazz.toString().equals("java.lang.reflect.Array")) {
                    configuration.getOrCreateType(condition, ReflectionProcessor.descriptorForClass(args.get(0)));
                    break;
                }
                configuration.getOrCreateType(condition, clazz).addMethod("<init>", "()V", ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
                break;
            }
            case "getBundleImpl": {
                ReflectionProcessor.expectSize(args, 5);
                String baseName = (String)args.get(2);
                if (baseName == null) break;
                resourceConfiguration.addBundle(condition, baseName);
                break;
            }
            case "allocateInstance": {
                configuration.getOrCreateType(condition, clazz).setUnsafeAllocated();
                break;
            }
            default: {
                System.err.println("Unsupported reflection method: " + function);
            }
        }
    }

    private static void addFullyQualifiedDeclaredMethod(String descriptor, TypeConfiguration configuration) {
        int sigbegin = descriptor.indexOf(40);
        int classend = descriptor.lastIndexOf(46, sigbegin - 1);
        String qualifiedClass = descriptor.substring(0, classend);
        String methodName = descriptor.substring(classend + 1, sigbegin);
        String signature = descriptor.substring(sigbegin);
        configuration.getOrCreateType(UnresolvedConfigurationCondition.alwaysTrue(), NamedConfigurationTypeDescriptor.fromReflectionName(qualifiedClass)).addMethod(methodName, signature, ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED);
    }

    private void addDynamicProxy(List<?> interfaceList, LazyValue<String> callerClass, TypeConfiguration configuration, EconomicMap<String, Object> entry) {
        ConfigurationTypeDescriptor typeDescriptor = ReflectionProcessor.descriptorForClass(interfaceList);
        for (String iface : typeDescriptor.getAllQualifiedJavaNames()) {
            if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(iface), callerClass, this.copyWithUniqueEntry(entry, "ignoredInterface", iface))) continue;
            return;
        }
        configuration.getOrCreateType(UnresolvedConfigurationCondition.alwaysTrue(), typeDescriptor);
    }

    private void addDynamicProxyUnchecked(List<?> checkedInterfaceList, List<?> uncheckedInterfaceList, LazyValue<String> callerClass, TypeConfiguration configuration, EconomicMap<String, Object> entry) {
        List<?> checkedInterfaces = checkedInterfaceList;
        for (String iface : checkedInterfaces) {
            if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(iface), callerClass, this.copyWithUniqueEntry(entry, "ignoredInterface", iface))) continue;
            return;
        }
        List<?> uncheckedInterfaces = uncheckedInterfaceList;
        ArrayList interfaces = new ArrayList();
        interfaces.addAll(checkedInterfaces);
        interfaces.addAll(uncheckedInterfaces);
        configuration.getOrCreateType(UnresolvedConfigurationCondition.alwaysTrue(), ReflectionProcessor.descriptorForClass(interfaces));
    }
}

