/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import java.util.List;
import org.graalvm.collections.EconomicMap;

public class SerializationProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;

    public SerializationProcessor(AccessAdvisor advisor) {
        this.advisor = advisor;
    }

    @Override
    void processEntry(EconomicMap<String, Object> entry, ConfigurationSet configurationSet) {
        boolean invalidResult = Boolean.FALSE.equals(entry.get((Object)"result"));
        if (invalidResult) {
            return;
        }
        UnresolvedConfigurationCondition condition = UnresolvedConfigurationCondition.alwaysTrue();
        String function = (String)entry.get((Object)"function");
        List args = (List)entry.get((Object)"args");
        SerializationConfiguration serializationConfiguration = configurationSet.getSerializationConfiguration();
        TypeConfiguration reflectionConfiguration = configurationSet.getReflectionConfiguration();
        if ("ObjectStreamClass.<init>".equals(function) || "ObjectInputStream.readClassDescriptor".equals(function)) {
            SerializationProcessor.expectSize(args, 1);
            if (this.advisor.shouldIgnore(LazyValueUtils.lazyValue((String)args.get(0)), LazyValueUtils.lazyValue(null), false, entry)) {
                return;
            }
            String reflectionName = (String)args.get(0);
            if (reflectionName.contains("$$Lambda")) {
                serializationConfiguration.registerLambdaCapturingClass(condition, reflectionName);
            } else {
                reflectionConfiguration.getOrCreateType(condition, NamedConfigurationTypeDescriptor.fromReflectionName(reflectionName)).setSerializable();
            }
        } else if ("SerializedLambda.readResolve".equals(function)) {
            SerializationProcessor.expectSize(args, 1);
            if (this.advisor.shouldIgnore(LazyValueUtils.lazyValue((String)args.get(0)), LazyValueUtils.lazyValue(null), entry)) {
                return;
            }
            serializationConfiguration.registerLambdaCapturingClass(condition, (String)args.get(0));
        } else if ("ProxyClassSerialization".equals(function)) {
            SerializationProcessor.expectSize(args, 1);
            List interfaces = (List)args.get(0);
            for (String iface : interfaces) {
                if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(iface), LazyValueUtils.lazyValue(null), this.copyWithUniqueEntry(entry, "ignoredInterface", iface))) continue;
                return;
            }
            serializationConfiguration.registerProxyClass(condition, (List<String>)((List)args.get(0)));
        }
    }
}

