/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.io.Utf8;
import java.nio.charset.StandardCharsets;

abstract class CVUtil {
    CVUtil() {
    }

    static int putByte(byte value, byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + 1;
        }
        int pos = initialPos;
        buffer[pos++] = value;
        return pos;
    }

    static int putShort(short value, byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + 2;
        }
        int pos = initialPos;
        buffer[pos++] = (byte)(value & 0xFF);
        buffer[pos++] = (byte)(value >> 8 & 0xFF);
        return pos;
    }

    static int putInt(int value, byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + 4;
        }
        int pos = initialPos;
        buffer[pos++] = (byte)(value & 0xFF);
        buffer[pos++] = (byte)(value >> 8 & 0xFF);
        buffer[pos++] = (byte)(value >> 16 & 0xFF);
        buffer[pos++] = (byte)(value >> 24 & 0xFF);
        return pos;
    }

    static int putLongAsInt(long value, byte[] buffer, int initialPos) {
        assert (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE);
        return CVUtil.putInt((int)value, buffer, initialPos);
    }

    static int putLong(long value, byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + 8;
        }
        int pos = initialPos;
        buffer[pos++] = (byte)(value & 0xFFL);
        buffer[pos++] = (byte)(value >> 8 & 0xFFL);
        buffer[pos++] = (byte)(value >> 16 & 0xFFL);
        buffer[pos++] = (byte)(value >> 24 & 0xFFL);
        buffer[pos++] = (byte)(value >> 32 & 0xFFL);
        buffer[pos++] = (byte)(value >> 40 & 0xFFL);
        buffer[pos++] = (byte)(value >> 48 & 0xFFL);
        buffer[pos++] = (byte)(value >> 56 & 0xFFL);
        return pos;
    }

    static int putBytes(byte[] inbuff, byte[] buffer, int initialPos) {
        if (buffer == null) {
            return initialPos + inbuff.length;
        }
        int pos = initialPos;
        for (byte b : inbuff) {
            buffer[pos++] = b;
        }
        return pos;
    }

    static int putUTF8StringBytes(String s, byte[] buffer, int initialPos) {
        assert (!s.contains("\u0000"));
        if (buffer == null) {
            return initialPos + Utf8.utf8Length(s) + 1;
        }
        byte[] buff = s.getBytes(StandardCharsets.UTF_8);
        int pos = CVUtil.putBytes(buff, buffer, initialPos);
        buffer[pos++] = 0;
        return pos;
    }

    static int putLfNumeric(long value, byte[] buffer, int initialPos) {
        if (0L <= value && value < 32768L) {
            return CVUtil.putShort((short)value, buffer, initialPos);
        }
        if (-128L <= value && value <= 127L) {
            int pos = CVUtil.putShort((short)Short.MIN_VALUE, buffer, initialPos);
            return CVUtil.putByte((byte)value, buffer, pos);
        }
        if (-32768L <= value && value <= 32767L) {
            int pos = CVUtil.putShort((short)-32767, buffer, initialPos);
            return CVUtil.putShort((short)value, buffer, pos);
        }
        if (0L <= value && value <= 65535L) {
            int pos = CVUtil.putShort((short)-32766, buffer, initialPos);
            return CVUtil.putShort((short)value, buffer, pos);
        }
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            int pos = CVUtil.putShort((short)-32765, buffer, initialPos);
            return CVUtil.putInt((int)value, buffer, pos);
        }
        if (0L <= value && value <= 0xFFFFFFFFL) {
            int pos = CVUtil.putShort((short)-32764, buffer, initialPos);
            return CVUtil.putInt((int)value, buffer, pos);
        }
        int pos = CVUtil.putShort((short)-32759, buffer, initialPos);
        return CVUtil.putLong(value, buffer, pos);
    }

    static int align4(int initialPos) {
        int pos = initialPos;
        while ((pos & 3) != 0) {
            ++pos;
        }
        return pos;
    }
}

