/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.EventKind;
import com.oracle.svm.jdwp.server.api.BreakpointInfo;
import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import com.oracle.svm.jdwp.server.impl.UnknownLocationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class Breakpoints {
    private final Map<Location, List<BreakpointInfo>> locationBreakpoints = new HashMap<Location, List<BreakpointInfo>>();
    private final Map<Long, List<BreakpointInfo>> methodEnterBreakpoints = new HashMap<Long, List<BreakpointInfo>>();
    private final Map<Long, List<BreakpointInfo>> methodExitBreakpoints = new HashMap<Long, List<BreakpointInfo>>();

    public synchronized void addLines(Collection<BreakpointInfo> infos) throws UnknownLocationException {
        for (BreakpointInfo info : infos) {
            assert (info.getEventKind() == EventKind.BREAKPOINT) : info.getEventKind();
            Location location = new Location(info.getMethodId(), info.getBci());
            try {
                this.locationBreakpoints.computeIfAbsent(location, loc -> {
                    long methodId = info.getMethodId();
                    long bci = loc.bci();
                    if (ServerJDWP.LOGGER.isLoggable()) {
                        long classId = info.getClassId();
                        ResolvedJavaMethod resolvedJavaMethod = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaMethod(methodId);
                        ResolvedJavaType declaringType = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaType(classId);
                        ServerJDWP.LOGGER.log(() -> "Breakpoints.add: BCI=" + bci + ", class id = " + classId + ", method id = " + methodId + "\n  class = " + declaringType.getName() + "\n  method = " + resolvedJavaMethod.getName());
                    }
                    ServerJDWP.BRIDGE.toggleBreakpoint(methodId, (int)bci, true);
                    ServerJDWP.BRIDGE.setEventEnabled(0L, EventKind.BREAKPOINT.ordinal(), true);
                    return new ArrayList(1);
                }).add(info);
            }
            catch (IllegalArgumentException e) {
                throw new UnknownLocationException(e);
            }
        }
    }

    public synchronized void addMethods(Collection<BreakpointInfo> infos) {
        block4: for (BreakpointInfo info : infos) {
            EventKind kind = info.getEventKind();
            assert (kind == EventKind.METHOD_ENTRY || kind == EventKind.METHOD_EXIT || kind == EventKind.METHOD_EXIT_WITH_RETURN_VALUE) : kind;
            switch (kind) {
                case METHOD_ENTRY: {
                    this.methodEnterBreakpoints.computeIfAbsent(info.getClassId(), id -> {
                        if (ServerJDWP.LOGGER.isLoggable()) {
                            ResolvedJavaType declaringType = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaType(id.longValue());
                            ServerJDWP.LOGGER.log(() -> "Breakpoints.add method enter: class id = " + id + " class = " + declaringType.getName());
                        }
                        ServerJDWP.BRIDGE.toggleMethodEnterEvent(id.longValue(), true);
                        ServerJDWP.BRIDGE.setEventEnabled(0L, EventKind.METHOD_ENTRY.ordinal(), true);
                        return new ArrayList(1);
                    }).add(info);
                    continue block4;
                }
                case METHOD_EXIT: 
                case METHOD_EXIT_WITH_RETURN_VALUE: {
                    this.methodExitBreakpoints.computeIfAbsent(info.getClassId(), id -> {
                        if (ServerJDWP.LOGGER.isLoggable()) {
                            ResolvedJavaType declaringType = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaType(id.longValue());
                            ServerJDWP.LOGGER.log(() -> "Breakpoints.add method exit: class id = " + id + " class = " + declaringType.getName());
                        }
                        ServerJDWP.BRIDGE.toggleMethodExitEvent(id.longValue(), true);
                        ServerJDWP.BRIDGE.setEventEnabled(0L, EventKind.METHOD_EXIT.ordinal(), true);
                        return new ArrayList(1);
                    }).add(info);
                    continue block4;
                }
            }
            throw new IllegalStateException("Event kind " + String.valueOf(kind));
        }
    }

    public synchronized void removeAll(Collection<BreakpointInfo> infos) {
        for (BreakpointInfo info : infos) {
            this.doRemove(info);
        }
    }

    synchronized void remove(BreakpointInfo info) {
        this.doRemove(info);
    }

    private void doRemove(BreakpointInfo info) {
        assert (Thread.holdsLock(this));
        EventKind kind = info.getEventKind();
        switch (kind) {
            case BREAKPOINT: {
                this.removeLocation(info);
                break;
            }
            case METHOD_ENTRY: {
                this.removeMethodEnter(info);
                break;
            }
            case METHOD_EXIT: 
            case METHOD_EXIT_WITH_RETURN_VALUE: {
                this.removeMethodExit(info);
                break;
            }
            default: {
                throw new IllegalStateException("Event kind " + String.valueOf(kind));
            }
        }
    }

    private void removeLocation(BreakpointInfo info) {
        long bci;
        long methodId = info.getMethodId();
        Location location = new Location(methodId, bci = info.getBci());
        List<BreakpointInfo> infoList = this.locationBreakpoints.get(location);
        if (infoList != null) {
            infoList.remove(info);
            if (infoList.isEmpty()) {
                if (ServerJDWP.LOGGER.isLoggable()) {
                    long classId = info.getClassId();
                    ResolvedJavaMethod resolvedJavaMethod = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaMethod(methodId);
                    ResolvedJavaType declaringType = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaType(classId);
                    ServerJDWP.LOGGER.log(() -> "Breakpoints.remove: BCI=" + bci + ", class id = " + classId + ", method id = " + methodId + "\n  class = " + declaringType.getName() + "\n  method = " + resolvedJavaMethod.getName());
                }
                ServerJDWP.BRIDGE.toggleBreakpoint(methodId, (int)bci, false);
                this.locationBreakpoints.remove(location);
                if (this.locationBreakpoints.isEmpty()) {
                    ServerJDWP.BRIDGE.setEventEnabled(0L, EventKind.BREAKPOINT.ordinal(), false);
                }
            }
        }
    }

    private void removeMethodEnter(BreakpointInfo info) {
        long classId = info.getClassId();
        List<BreakpointInfo> infoList = this.methodEnterBreakpoints.get(classId);
        if (infoList != null) {
            infoList.remove(info);
            if (infoList.isEmpty()) {
                if (ServerJDWP.LOGGER.isLoggable()) {
                    ResolvedJavaType declaringType = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaType(classId);
                    ServerJDWP.LOGGER.log(() -> "Breakpoints.remove method enter: class id = " + classId + "  class = " + declaringType.getName());
                }
                ServerJDWP.BRIDGE.toggleMethodEnterEvent(classId, false);
                this.methodEnterBreakpoints.remove(classId);
                if (this.methodEnterBreakpoints.isEmpty()) {
                    ServerJDWP.BRIDGE.setEventEnabled(0L, EventKind.METHOD_ENTRY.ordinal(), false);
                }
            }
        }
    }

    private void removeMethodExit(BreakpointInfo info) {
        long classId = info.getClassId();
        List<BreakpointInfo> infoList = this.methodExitBreakpoints.get(classId);
        if (infoList != null) {
            infoList.remove(info);
            if (infoList.isEmpty()) {
                if (ServerJDWP.LOGGER.isLoggable()) {
                    ResolvedJavaType declaringType = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaType(classId);
                    ServerJDWP.LOGGER.log(() -> "Breakpoints.remove method exit: class id = " + classId + "  class = " + declaringType.getName());
                }
                ServerJDWP.BRIDGE.toggleMethodExitEvent(classId, false);
                this.methodExitBreakpoints.remove(classId);
                if (this.methodExitBreakpoints.isEmpty()) {
                    ServerJDWP.BRIDGE.setEventEnabled(0L, EventKind.METHOD_EXIT.ordinal(), false);
                }
            }
        }
    }

    private record Location(long methodId, long bci) {
    }
}

