/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.DebugOptions;
import com.oracle.svm.jdwp.server.impl.SocketConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;

public final class HandshakeController
implements AutoCloseable {
    private static final String JDWP_HANDSHAKE = "JDWP-Handshake";
    private ServerSocket currentServerSocket;
    private final DebugOptions.Options options;

    public HandshakeController(DebugOptions.Options options) {
        this.options = Objects.requireNonNull(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketConnection createSocketConnection(Collection<Thread> activeThreads) throws IOException {
        Socket connectionSocket;
        String connectionHost = this.options.host();
        if (connectionHost == null) {
            connectionHost = "localhost";
        }
        if (this.options.server()) {
            ServerSocket serverSocket = new ServerSocket();
            serverSocket.setSoTimeout(this.options.timeout());
            serverSocket.setReuseAddress(this.options.port() != 0);
            if ("*".equals(this.options.host())) {
                serverSocket.bind(new InetSocketAddress((InetAddress)null, this.options.port()));
            } else {
                serverSocket.bind(new InetSocketAddress(connectionHost, this.options.port()));
            }
            if (!this.options.quiet()) {
                System.out.println("Listening for transport " + this.options.transport() + " at address: " + serverSocket.getLocalPort());
            }
            HandshakeController handshakeController = this;
            synchronized (handshakeController) {
                assert (this.currentServerSocket == null);
                this.currentServerSocket = serverSocket;
            }
            connectionSocket = serverSocket.accept();
        } else {
            connectionSocket = new Socket();
            connectionSocket.connect(new InetSocketAddress(connectionHost, this.options.port()), this.options.timeout());
        }
        if (!HandshakeController.handshake(connectionSocket)) {
            throw new IOException("Unable to handshake with debugger");
        }
        SocketConnection connection = new SocketConnection(connectionSocket);
        Thread jdwpSender = connection.startSenderThread();
        activeThreads.add(jdwpSender);
        return connection;
    }

    @Override
    public synchronized void close() {
        if (this.currentServerSocket != null) {
            if (!this.currentServerSocket.isClosed()) {
                try {
                    this.currentServerSocket.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close the server socket used to listen for transport " + this.options.transport(), e);
                }
            }
            this.currentServerSocket = null;
        }
    }

    private static boolean handshake(Socket s) throws IOException {
        int n;
        byte[] hello = JDWP_HANDSHAKE.getBytes(StandardCharsets.UTF_8);
        byte[] b = new byte[hello.length];
        for (int received = 0; received < hello.length; received += n) {
            try {
                n = s.getInputStream().read(b, received, hello.length - received);
            }
            catch (SocketTimeoutException x) {
                throw new IOException("Handshake timeout");
            }
            if (n >= 0) continue;
            s.close();
            throw new IOException("Handshake failed - connection prematurely closed");
        }
        for (int i = 0; i < hello.length; ++i) {
            if (b[i] == hello[i]) continue;
            throw new IOException("Handshake failed - unrecognized message from the debugger");
        }
        s.getOutputStream().write(hello);
        return true;
    }
}

