/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.server.ClassUtils;
import com.oracle.svm.jdwp.server.impl.Breakpoints;
import com.oracle.svm.jdwp.server.impl.CallFrame;
import com.oracle.svm.jdwp.server.impl.ThreadRef;
import com.oracle.svm.jdwp.server.impl.ThreadsCollector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class JDWPContext {
    private final ThreadsCollector threads = new ThreadsCollector();
    private final Map<Long, CallFrame> frames = new ConcurrentHashMap<Long, CallFrame>();
    private final Breakpoints breakpoints = new Breakpoints();

    public JDWPContext() {
        assert (ClassUtils.UNIVERSE != null);
    }

    void registerCallFrames(CallFrame ... newFrames) {
        for (CallFrame f : newFrames) {
            this.frames.put(f.getFrameId(), f);
        }
    }

    void unregisterCallFrames(CallFrame ... newFrames) {
        for (CallFrame f : newFrames) {
            this.frames.remove(f.getFrameId());
        }
    }

    public ThreadRef getThreadRef(long threadId) {
        return this.threads.getThreadRef(threadId);
    }

    public ThreadRef getThreadRefIfExists(long threadId) {
        return this.threads.getThreadRefIfExists(threadId);
    }

    public ThreadsCollector getThreadsCollector() {
        return this.threads;
    }

    public Breakpoints getBreakpoints() {
        return this.breakpoints;
    }
}

