/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;

final class ServerToResidentCallThread
extends Thread {
    private final BlockingQueue<ResidentCall> callQueue = new LinkedBlockingQueue<ResidentCall>();

    private ServerToResidentCallThread() {
        this.setName(ServerToResidentCallThread.class.getName());
    }

    static ServerToResidentCallThread create() {
        ServerToResidentCallThread t = new ServerToResidentCallThread();
        t.setDaemon(true);
        t.start();
        return t;
    }

    void threadResume(long threadId) {
        this.callQueue.add(new ResidentCall(ResidentCall.Kind.THREAD_RESUME, threadId));
    }

    long[] vmSuspend(long[] threadIds) {
        ResidentCall call = new ResidentCall(ResidentCall.Kind.VM_SUSPEND, threadIds);
        call.completionFuture = new CompletableFuture();
        this.callQueue.add(call);
        try {
            call.completionFuture.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex.getCause());
        }
        return call.ids;
    }

    @Override
    public void run() {
        while (true) {
            ResidentCall call;
            try {
                call = this.callQueue.take();
            }
            catch (InterruptedException ex) {
                break;
            }
            call.call();
        }
    }

    private static final class ResidentCall {
        private final Kind kind;
        long id;
        long[] ids;
        CompletableFuture<ResidentCall> completionFuture;

        ResidentCall(Kind kind, long id) {
            this.kind = kind;
            this.id = id;
        }

        ResidentCall(Kind kind, long[] ids) {
            this.kind = kind;
            this.ids = ids;
        }

        public void call() {
            switch (this.kind.ordinal()) {
                case 0: {
                    ServerJDWP.BRIDGE.threadResume(this.id);
                    break;
                }
                case 1: {
                    this.ids = ServerJDWP.BRIDGE.vmSuspend(this.ids);
                }
            }
            if (this.completionFuture != null) {
                this.completionFuture.complete(this);
            }
        }

        static enum Kind {
            THREAD_RESUME,
            VM_SUSPEND;

        }
    }
}

