/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.server.impl.RequestFilter;
import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public record StepInfo(RequestFilter filter, int size, int depth, long threadId, Location startLocation) {
    public int getInterpreterDepth() {
        return switch (this.depth) {
            case 0 -> 1;
            case 1 -> 2;
            case 2 -> 3;
            default -> throw new IllegalArgumentException(Integer.toString(this.depth));
        };
    }

    public int getInterpreterSize() {
        return switch (this.size) {
            case 0 -> -1;
            case 1 -> -2;
            default -> throw new IllegalArgumentException(Integer.toString(this.size));
        };
    }

    public static final class Location {
        private final boolean computeLine;
        private long methodId;
        private ResolvedJavaMethod method;
        private int bci;
        private int lineNumber;

        public Location(long methodId, int bci, boolean computeLine) {
            this.methodId = methodId;
            this.bci = bci;
            this.computeLine = computeLine;
            if (computeLine) {
                this.method = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaMethod(methodId);
                LineNumberTable lineNumberTable = this.method.getLineNumberTable();
                if (lineNumberTable != null) {
                    this.lineNumber = lineNumberTable.getLineNumber(bci);
                }
            }
        }

        public long getMethodId() {
            return this.methodId;
        }

        public int getBci() {
            return this.bci;
        }

        public boolean differsAndUpdate(long newMethodId, int newBci) {
            boolean differs;
            if (this.methodId != newMethodId) {
                this.methodId = newMethodId;
                this.bci = newBci;
                this.method = null;
                return true;
            }
            boolean bl = differs = this.bci != newBci;
            if (!differs) {
                return false;
            }
            if (!this.computeLine) {
                this.bci = newBci;
            } else {
                int newLineNumber;
                if (this.method == null) {
                    this.method = ServerJDWP.SYMBOLIC_REFS.toResolvedJavaMethod(this.methodId);
                    this.lineNumber = Location.getLineAt(this.method, this.bci);
                }
                boolean bl2 = differs = (newLineNumber = Location.getLineAt(this.method, newBci)) == -1 || this.lineNumber != newLineNumber;
                if (differs) {
                    this.lineNumber = newLineNumber;
                }
            }
            return differs;
        }

        private static int getLineAt(ResolvedJavaMethod method, int bci) {
            LineNumberTable lineNumberTable = method.getLineNumberTable();
            if (lineNumberTable != null) {
                return lineNumberTable.getLineNumber(bci);
            }
            return -1;
        }
    }
}

