/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.replacements.processor;

import java.io.PrintWriter;
import java.util.Set;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import jdk.graal.compiler.processor.AbstractProcessor;
import jdk.graal.compiler.replacements.processor.InjectedDependencies;

public abstract class GeneratedPlugin {
    protected final ExecutableElement intrinsicMethod;
    private boolean needInjectionProvider;
    private String pluginName;

    public GeneratedPlugin(ExecutableElement intrinsicMethod) {
        this.intrinsicMethod = intrinsicMethod;
        this.needInjectionProvider = false;
        this.pluginName = "Plugin_" + String.valueOf(intrinsicMethod.getEnclosingElement().getSimpleName()) + "_" + intrinsicMethod.getSimpleName().toString();
    }

    protected abstract TypeElement getAnnotationClass(AbstractProcessor var1);

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    protected abstract String pluginSuperclass();

    public void generate(AbstractProcessor processor, PrintWriter out) {
        out.printf("//        class: %s\n", this.intrinsicMethod.getEnclosingElement());
        out.printf("//       method: %s\n", this.intrinsicMethod);
        out.printf("// generated-by: %s\n", this.getClass().getName());
        out.printf("final class %s extends %s {\n", this.pluginName, this.pluginSuperclass());
        out.printf("\n", new Object[0]);
        out.printf("    @Override\n", new Object[0]);
        out.printf("    public boolean execute(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode[] args) {\n", new Object[0]);
        out.printf("        if (!b.isPluginEnabled(this)) {\n", new Object[0]);
        out.printf("            return false;\n", new Object[0]);
        out.printf("        }\n", new Object[0]);
        InjectedDependencies deps = new InjectedDependencies(true, this.intrinsicMethod);
        this.createExecute(processor, out, deps);
        out.printf("    }\n", new Object[0]);
        this.createPrivateMembersAndConstructor(processor, out, deps, this.pluginName);
        out.printf("}\n", new Object[0]);
        this.createOtherClasses(processor, out, deps);
    }

    protected void createOtherClasses(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps) {
        String name = this.getReplacementName();
        out.printf("//        class: %s\n", this.intrinsicMethod.getEnclosingElement());
        out.printf("//       method: %s\n", this.intrinsicMethod);
        out.printf("// generated-by: %s\n", this.getClass().getName());
        out.printf("@ExcludeFromJacocoGeneratedReport(\"deferred plugin support that is only called in libgraal\")\n", new Object[0]);
        out.printf("final class %s implements PluginReplacementNode.ReplacementFunction {\n", name);
        out.printf("    static PluginReplacementNode.ReplacementFunction FUNCTION = new %s();\n", name);
        this.createHelpers(processor, out, deps);
        out.printf("}\n", new Object[0]);
    }

    protected abstract void createHelpers(AbstractProcessor var1, PrintWriter var2, InjectedDependencies var3);

    protected String getReplacementName() {
        return "PluginReplacementNode_" + this.getBaseName();
    }

    private String getBaseName() {
        assert (this.getPluginName().startsWith("Plugin_"));
        return this.getPluginName().substring("Plugin_".length());
    }

    public void register(PrintWriter out) {
        out.printf("        plugins.register(%s.class, new %s(", this.intrinsicMethod.getEnclosingElement(), this.pluginName);
        if (this.needInjectionProvider) {
            out.printf("injection", new Object[0]);
        }
        out.printf("));\n", new Object[0]);
    }

    public abstract void extraImports(AbstractProcessor var1, Set<String> var2);

    protected abstract void createExecute(AbstractProcessor var1, PrintWriter var2, InjectedDependencies var3);

    static String getErasedType(TypeMirror type) {
        switch (type.getKind()) {
            case DECLARED: {
                DeclaredType declared = (DeclaredType)type;
                TypeElement element = (TypeElement)declared.asElement();
                return element.getQualifiedName().toString();
            }
            case TYPEVAR: {
                return GeneratedPlugin.getErasedType(((TypeVariable)type).getUpperBound());
            }
            case WILDCARD: {
                return GeneratedPlugin.getErasedType(((WildcardType)type).getExtendsBound());
            }
            case ARRAY: {
                return GeneratedPlugin.getErasedType(((ArrayType)type).getComponentType()) + "[]";
            }
        }
        return type.toString();
    }

    static boolean hasRawtypeWarning(TypeMirror type) {
        switch (type.getKind()) {
            case DECLARED: {
                DeclaredType declared = (DeclaredType)type;
                return declared.getTypeArguments().size() > 0;
            }
            case TYPEVAR: {
                return false;
            }
            case WILDCARD: {
                return false;
            }
            case ARRAY: {
                return GeneratedPlugin.hasRawtypeWarning(((ArrayType)type).getComponentType());
            }
        }
        return false;
    }

    static boolean hasUncheckedWarning(TypeMirror type) {
        switch (type.getKind()) {
            case DECLARED: {
                DeclaredType declared = (DeclaredType)type;
                for (TypeMirror typeMirror : declared.getTypeArguments()) {
                    if (!GeneratedPlugin.hasUncheckedWarning(typeMirror)) continue;
                    return true;
                }
                return false;
            }
            case TYPEVAR: {
                return true;
            }
            case WILDCARD: {
                return ((WildcardType)type).getExtendsBound() != null;
            }
            case ARRAY: {
                return GeneratedPlugin.hasUncheckedWarning(((ArrayType)type).getComponentType());
            }
        }
        return false;
    }

    protected void createPrivateMembersAndConstructor(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps, String constructorName) {
        if (!deps.isEmpty()) {
            out.printf("\n", new Object[0]);
            for (InjectedDependencies.Dependency dependency : deps) {
                out.printf("    private final %s %s;\n", dependency.getType(), dependency.getName(processor, this.intrinsicMethod));
            }
            this.needInjectionProvider = true;
        }
        out.printf("\n", new Object[0]);
        out.printf("    %s(%s) {\n", constructorName, this.needInjectionProvider ? "GeneratedPluginInjectionProvider injection" : "");
        out.printf("        super(\"%s\"", this.intrinsicMethod.getSimpleName());
        if (!this.intrinsicMethod.getModifiers().contains((Object)Modifier.STATIC)) {
            out.printf(", InvocationPlugin.Receiver.class", new Object[0]);
        }
        for (VariableElement variableElement : this.intrinsicMethod.getParameters()) {
            out.printf(", %s.class", GeneratedPlugin.getErasedType(variableElement.asType()));
        }
        out.printf(");\n", new Object[0]);
        for (InjectedDependencies.Dependency dependency : deps) {
            out.printf("        this.%s = %s;\n", dependency.getName(processor, this.intrinsicMethod), dependency.getExpression(processor, this.intrinsicMethod));
        }
        out.printf("    }\n", new Object[0]);
    }

    protected boolean needsReplacement(AbstractProcessor processor) {
        return true;
    }

    protected boolean isWithExceptionReplacement(AbstractProcessor processor) {
        Element nodeElement = this.intrinsicMethod.getEnclosingElement();
        TypeMirror withExceptionNodeType = processor.getType("jdk.graal.compiler.nodes.WithExceptionNode");
        return processor.env().getTypeUtils().isAssignable(nodeElement.asType(), withExceptionNodeType);
    }

    protected static String getReturnKind(ExecutableElement method) {
        switch (method.getReturnType().getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: {
                return "Int";
            }
            case LONG: {
                return "Long";
            }
            case FLOAT: {
                return "Float";
            }
            case DOUBLE: {
                return "Double";
            }
            case VOID: {
                return "Void";
            }
            case DECLARED: 
            case TYPEVAR: 
            case ARRAY: {
                return "Object";
            }
        }
        throw new IllegalArgumentException(method.getReturnType().toString());
    }

    protected String constantArgument(AbstractProcessor processor, PrintWriter out, InjectedDependencies deps, int argIdx, TypeMirror type, int nodeIdx, boolean checkShouldDefer) {
        Function<Integer, String> argFormatter = i -> String.format("args[%d]", i);
        if (GeneratedPlugin.hasRawtypeWarning(type)) {
            out.printf("        @SuppressWarnings({\"rawtypes\"})\n", new Object[0]);
        }
        String argName = "arg" + argIdx;
        out.printf("        %s %s;\n", GeneratedPlugin.getErasedType(type), argName);
        out.printf("        if (%s.isConstant()) {\n", argFormatter.apply(nodeIdx));
        if (type.equals(processor.getType("jdk.vm.ci.meta.ResolvedJavaType"))) {
            out.printf("            jdk.vm.ci.meta.JavaConstant cst = %s.asJavaConstant();\n", argFormatter.apply(nodeIdx));
            out.printf("            %s = %s.asJavaType(cst);\n", argName, deps.use(processor, InjectedDependencies.WellKnownDependency.CONSTANT_REFLECTION));
            out.printf("            if (%s == null) {\n", argName);
            out.printf("                %s = %s.asObject(jdk.vm.ci.meta.ResolvedJavaType.class, cst);\n", argName, deps.use(processor, InjectedDependencies.WellKnownDependency.SNIPPET_REFLECTION));
            out.printf("            }\n", new Object[0]);
        } else {
            switch (type.getKind()) {
                case BOOLEAN: {
                    out.printf("            %s = %s.asJavaConstant().asInt() != 0;\n", argName, argFormatter.apply(nodeIdx));
                    break;
                }
                case BYTE: {
                    out.printf("            %s = (byte) %s.asJavaConstant().asInt();\n", argName, argFormatter.apply(nodeIdx));
                    break;
                }
                case CHAR: {
                    out.printf("            %s = (char) %s.asJavaConstant().asInt();\n", argName, argFormatter.apply(nodeIdx));
                    break;
                }
                case SHORT: {
                    out.printf("            %s = (short) %s.asJavaConstant().asInt();\n", argName, argFormatter.apply(nodeIdx));
                    break;
                }
                case INT: {
                    out.printf("            %s = %s.asJavaConstant().asInt();\n", argName, argFormatter.apply(nodeIdx));
                    break;
                }
                case LONG: {
                    out.printf("            %s = %s.asJavaConstant().asLong();\n", argName, argFormatter.apply(nodeIdx));
                    break;
                }
                case FLOAT: {
                    out.printf("            %s = %s.asJavaConstant().asFloat();\n", argName, argFormatter.apply(nodeIdx));
                    break;
                }
                case DOUBLE: {
                    out.printf("            %s = %s.asJavaConstant().asDouble();\n", argName, argFormatter.apply(nodeIdx));
                    break;
                }
                case DECLARED: 
                case ARRAY: {
                    out.printf("            %s = %s.asObject(%s.class, %s.asJavaConstant());\n", argName, deps.use(processor, InjectedDependencies.WellKnownDependency.SNIPPET_REFLECTION), GeneratedPlugin.getErasedType(type), argFormatter.apply(nodeIdx));
                    out.printf("            assert %s != null;\n", argName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(type.toString());
                }
            }
        }
        out.printf("        } else {\n", new Object[0]);
        if (checkShouldDefer) {
            out.printf("            if (b.shouldDeferPlugin(this)) {\n", new Object[0]);
            out.printf("                b.replacePlugin%s(this, targetMethod, args, %s.FUNCTION);\n", this.getReplacementFunctionSuffix(processor), this.getReplacementName());
            out.printf("                return true;\n", new Object[0]);
            out.printf("            }\n", new Object[0]);
            out.printf("            assert b.canDeferPlugin(this) : b.getClass().toString() + \" \" + %s;\n", argFormatter.apply(nodeIdx));
        }
        out.printf("            return false;\n", new Object[0]);
        out.printf("        }\n", new Object[0]);
        return argName;
    }

    protected String getReplacementFunctionSuffix(AbstractProcessor processor) {
        return this.isWithExceptionReplacement(processor) ? "WithException" : "";
    }
}

