/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.JNIHandleSet;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

public class NativeImageAgentJNIHandleSet
extends JNIHandleSet {
    final JNIObjectHandle javaLangClass;
    final JNIMethodId javaLangClassForName3;
    final JNIObjectHandle javaLangClassNotFoundException;
    final JNIMethodId javaLangClassGetName;
    final JNIMethodId javaLangClassGetInterfaces;
    final JNIMethodId javaLangReflectMemberGetName;
    final JNIMethodId javaLangReflectMemberGetDeclaringClass;
    private JNIMethodId javaLangReflectExecutableGetParameterTypes = (JNIMethodId)WordFactory.nullPointer();
    final JNIMethodId javaUtilEnumerationHasMoreElements;
    final JNIObjectHandle javaLangClassLoader;
    final JNIMethodId javaLangClassLoaderGetResource;
    final JNIObjectHandle jdkInternalReflectDelegatingClassLoader;
    final JNIMethodId javaLangObjectGetClass;
    final JNIMethodId javaLangObjectToString;
    final JNIObjectHandle javaLangStackOverflowError;
    private JNIMethodId javaLangInvokeMethodTypeParameterArray = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangInvokeMethodTypeReturnType = (JNIMethodId)WordFactory.nullPointer();
    final JNIObjectHandle javaLangIllegalAccessException;
    final JNIObjectHandle javaLangIllegalAccessError;
    final JNIObjectHandle javaLangInvokeWrongMethodTypeException;
    final JNIObjectHandle javaLangIllegalArgumentException;
    private JNIMethodId javaUtilResourceBundleGetBundleImplSLCC;
    private boolean queriedJavaUtilResourceBundleGetBundleImplSLCC;
    private JNIMethodId javaIoObjectStreamClassForClass;
    private JNIMethodId javaIoObjectStreamClassGetName;
    private JNIMethodId javaIoObjectStreamClassGetClassDataLayout0;
    private JNIObjectHandle javaIOObjectStreamClassClassDataSlot;
    private JNIFieldId javaIOObjectStreamClassClassDataSlotDesc;
    private JNIFieldId javaIOObjectStreamClassClassDataSlotHasData;
    private JNIMethodId javaUtilZipZipFileGetName;
    private JNIMethodId javaLangReflectConstructorDeclaringClassName;
    private JNIObjectHandle javaLangReflectProxy = (JNIObjectHandle)WordFactory.nullPointer();
    private JNIMethodId javaLangReflectProxyIsProxyClass = (JNIMethodId)WordFactory.nullPointer();
    final JNIObjectHandle javaUtilLocale;
    final JNIMethodId javaUtilLocaleGetLanguage;
    final JNIMethodId javaUtilLocaleGetCountry;
    final JNIMethodId javaUtilLocaleGetVariant;
    final JNIMethodId javaUtilLocaleForLanguageTag;
    final JNIMethodId javaUtilLocaleToLanguageTag;
    final JNIMethodId javaUtilLocaleEquals;
    private JNIObjectHandle javaUtilOptional;
    private JNIMethodId javaUtilOptionalIsEmpty;
    private JNIMethodId javaUtilOptionalGet;
    private JNIMethodId javaUtilListToArray;
    final JNIFieldId javaLangInvokeSerializedLambdaCapturingClass;
    final JNIMethodId javaLangModuleGetName;
    private JNIMethodId javaLangInvokeCallSiteMakeSite = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangInvokeMethodHandleNativesLinkCallSiteImpl = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangInvokeMethodHandleNativesLinkCallSite = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangForeignFunctionDescriptorReturnLayout = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangForeignFunctionDescriptorArgumentLayouts = (JNIMethodId)WordFactory.nullPointer();
    private JNIObjectHandle javaLangForeignMemorySegment = (JNIObjectHandle)WordFactory.nullPointer();
    private JNIObjectHandle javaLangForeignStructLayout = (JNIObjectHandle)WordFactory.nullPointer();
    private JNIObjectHandle javaLangForeignUnionLayout = (JNIObjectHandle)WordFactory.nullPointer();
    private JNIObjectHandle javaLangForeignSequenceLayout = (JNIObjectHandle)WordFactory.nullPointer();
    private JNIObjectHandle javaLangForeignValueLayout = (JNIObjectHandle)WordFactory.nullPointer();
    private JNIObjectHandle javaLangForeignPaddingLayout = (JNIObjectHandle)WordFactory.nullPointer();
    private JNIMethodId javaLangForeignGroupLayoutMemberLayouts = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangForeignMemoryLayoutByteSize = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangForeignValueLayoutCarrier = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangForeignSequenceLayoutElementCount = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangForeignSequenceLayoutElementLayout = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId jdkInternalForeignLayoutAbstractLayoutHasNaturalAlignment = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId jdkInternalForeignLayoutAbstractLayoutByteAlignment = (JNIMethodId)WordFactory.nullPointer();
    private JNIObjectHandle javaLangConstantDirectMethodHandleDesc = (JNIObjectHandle)WordFactory.nullPointer();
    private JNIMethodId javaLangInvokeMethodHandleDescribeConstable = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangConstantDirectMethodHandleDescRefKind = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangConstantDirectMethodHandleDescOwner = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangConstantDirectMethodHandleDescMethodName = (JNIMethodId)WordFactory.nullPointer();
    private JNIMethodId javaLangConstantClassDescDescriptorString = (JNIMethodId)WordFactory.nullPointer();

    NativeImageAgentJNIHandleSet(JNIEnvironment env) {
        super(env);
        this.javaLangClass = this.newClassGlobalRef(env, "java/lang/Class");
        this.javaLangClassForName3 = this.getMethodId(env, this.javaLangClass, "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", true);
        this.javaLangClassNotFoundException = this.newClassGlobalRef(env, "java/lang/ClassNotFoundException");
        this.javaLangClassGetName = this.getMethodId(env, this.javaLangClass, "getName", "()Ljava/lang/String;", false);
        this.javaLangClassGetInterfaces = this.getMethodId(env, this.javaLangClass, "getInterfaces", "()[Ljava/lang/Class;", false);
        JNIObjectHandle javaLangReflectMember = this.findClass(env, "java/lang/reflect/Member");
        this.javaLangReflectMemberGetName = this.getMethodId(env, javaLangReflectMember, "getName", "()Ljava/lang/String;", false);
        this.javaLangReflectMemberGetDeclaringClass = this.getMethodId(env, javaLangReflectMember, "getDeclaringClass", "()Ljava/lang/Class;", false);
        JNIObjectHandle javaUtilEnumeration = this.findClass(env, "java/util/Enumeration");
        this.javaUtilEnumerationHasMoreElements = this.getMethodId(env, javaUtilEnumeration, "hasMoreElements", "()Z", false);
        this.javaLangClassLoader = this.newClassGlobalRef(env, "java/lang/ClassLoader");
        this.javaLangClassLoaderGetResource = this.getMethodId(env, this.javaLangClassLoader, "getResource", "(Ljava/lang/String;)Ljava/net/URL;", false);
        JNIObjectHandle reflectLoader = this.findClassOptional(env, "jdk/internal/reflect/DelegatingClassLoader");
        this.jdkInternalReflectDelegatingClassLoader = reflectLoader.equal((ComparableWord)JNIObjectHandles.nullHandle()) ? (JNIObjectHandle)JNIObjectHandles.nullHandle() : this.newTrackedGlobalRef(env, reflectLoader);
        JNIObjectHandle javaLangObject = this.findClass(env, "java/lang/Object");
        this.javaLangObjectGetClass = this.getMethodId(env, javaLangObject, "getClass", "()Ljava/lang/Class;", false);
        this.javaLangObjectToString = this.getMethodId(env, javaLangObject, "toString", "()Ljava/lang/String;", false);
        this.javaLangStackOverflowError = this.newClassGlobalRef(env, "java/lang/StackOverflowError");
        this.javaLangIllegalAccessException = this.newClassGlobalRef(env, "java/lang/IllegalAccessException");
        this.javaLangIllegalAccessError = this.newClassGlobalRef(env, "java/lang/IllegalAccessError");
        this.javaLangInvokeWrongMethodTypeException = this.newClassGlobalRef(env, "java/lang/invoke/WrongMethodTypeException");
        this.javaLangIllegalArgumentException = this.newClassGlobalRef(env, "java/lang/IllegalArgumentException");
        JNIObjectHandle serializedLambda = this.findClass(env, "java/lang/invoke/SerializedLambda");
        this.javaLangInvokeSerializedLambdaCapturingClass = this.getFieldId(env, serializedLambda, "capturingClass", "Ljava/lang/Class;", false);
        JNIObjectHandle javaLangModule = this.findClass(env, "java/lang/Module");
        this.javaLangModuleGetName = this.getMethodId(env, javaLangModule, "getName", "()Ljava/lang/String;", false);
        this.javaUtilLocale = this.newClassGlobalRef(env, "java/util/Locale");
        this.javaUtilLocaleGetLanguage = this.getMethodId(env, this.javaUtilLocale, "getLanguage", "()Ljava/lang/String;", false);
        this.javaUtilLocaleGetCountry = this.getMethodId(env, this.javaUtilLocale, "getCountry", "()Ljava/lang/String;", false);
        this.javaUtilLocaleGetVariant = this.getMethodId(env, this.javaUtilLocale, "getVariant", "()Ljava/lang/String;", false);
        this.javaUtilLocaleForLanguageTag = this.getMethodId(env, this.javaUtilLocale, "forLanguageTag", "(Ljava/lang/String;)Ljava/util/Locale;", true);
        this.javaUtilLocaleEquals = this.getMethodId(env, this.javaUtilLocale, "equals", "(Ljava/lang/Object;)Z", false);
        this.javaUtilLocaleToLanguageTag = this.getMethodId(env, this.javaUtilLocale, "toLanguageTag", "()Ljava/lang/String;", false);
    }

    private void initializeForeignHandles(JNIEnvironment env) {
        this.javaLangForeignMemorySegment = this.newClassGlobalRef(env, "java/lang/foreign/MemorySegment");
        this.javaLangForeignStructLayout = this.newClassGlobalRef(env, "java/lang/foreign/StructLayout");
        this.javaLangForeignUnionLayout = this.newClassGlobalRef(env, "java/lang/foreign/UnionLayout");
        this.javaLangForeignSequenceLayout = this.newClassGlobalRef(env, "java/lang/foreign/SequenceLayout");
        this.javaLangForeignValueLayout = this.newClassGlobalRef(env, "java/lang/foreign/ValueLayout");
        this.javaLangForeignPaddingLayout = this.newClassGlobalRef(env, "java/lang/foreign/PaddingLayout");
        JNIObjectHandle groupLayout = this.findClass(env, "java/lang/foreign/GroupLayout");
        this.javaLangForeignGroupLayoutMemberLayouts = this.getMethodId(env, groupLayout, "memberLayouts", "()Ljava/util/List;", false);
        JNIObjectHandle memoryLayout = this.findClass(env, "java/lang/foreign/MemoryLayout");
        this.javaLangForeignMemoryLayoutByteSize = this.getMethodId(env, memoryLayout, "byteSize", "()J", false);
        this.javaLangForeignValueLayoutCarrier = this.getMethodId(env, this.javaLangForeignValueLayout, "carrier", "()Ljava/lang/Class;", false);
        this.javaLangForeignSequenceLayoutElementCount = this.getMethodId(env, this.javaLangForeignSequenceLayout, "elementCount", "()J", false);
        this.javaLangForeignSequenceLayoutElementLayout = this.getMethodId(env, this.javaLangForeignSequenceLayout, "elementLayout", "()Ljava/lang/foreign/MemoryLayout;", false);
        JNIObjectHandle javaLangInvokeAbstractLayout = this.findClass(env, "jdk/internal/foreign/layout/AbstractLayout");
        this.jdkInternalForeignLayoutAbstractLayoutHasNaturalAlignment = this.getMethodId(env, javaLangInvokeAbstractLayout, "hasNaturalAlignment", "()Z", false);
        this.jdkInternalForeignLayoutAbstractLayoutByteAlignment = this.getMethodId(env, javaLangInvokeAbstractLayout, "byteAlignment", "()J", false);
        JNIObjectHandle javaLangInvokeMethodHandle = this.findClass(env, "java/lang/invoke/MethodHandle");
        this.javaLangInvokeMethodHandleDescribeConstable = this.getMethodId(env, javaLangInvokeMethodHandle, "describeConstable", "()Ljava/util/Optional;", false);
        this.javaLangConstantDirectMethodHandleDesc = this.newClassGlobalRef(env, "java/lang/constant/DirectMethodHandleDesc");
        this.javaLangConstantDirectMethodHandleDescRefKind = this.getMethodId(env, this.javaLangConstantDirectMethodHandleDesc, "refKind", "()I", false);
        this.javaLangConstantDirectMethodHandleDescOwner = this.getMethodId(env, this.javaLangConstantDirectMethodHandleDesc, "owner", "()Ljava/lang/constant/ClassDesc;", false);
        this.javaLangConstantDirectMethodHandleDescMethodName = this.getMethodId(env, this.javaLangConstantDirectMethodHandleDesc, "methodName", "()Ljava/lang/String;", false);
        JNIObjectHandle javaLangConstantClassDesc = this.findClass(env, "java/lang/constant/ClassDesc");
        this.javaLangConstantClassDescDescriptorString = this.getMethodId(env, javaLangConstantClassDesc, "descriptorString", "()Ljava/lang/String;", false);
    }

    JNIMethodId getJavaLangReflectExecutableGetParameterTypes(JNIEnvironment env) {
        if (this.javaLangReflectExecutableGetParameterTypes.isNull()) {
            JNIObjectHandle javaLangReflectExecutable = this.findClass(env, "java/lang/reflect/Executable");
            this.javaLangReflectExecutableGetParameterTypes = this.getMethodId(env, javaLangReflectExecutable, "getParameterTypes", "()[Ljava/lang/Class;", false);
        }
        return this.javaLangReflectExecutableGetParameterTypes;
    }

    JNIMethodId getJavaLangInvokeMethodTypeReturnType(JNIEnvironment env) {
        if (this.javaLangInvokeMethodTypeReturnType.isNull()) {
            JNIObjectHandle javaLangInvokeMethodType = this.newClassGlobalRef(env, "java/lang/invoke/MethodType");
            this.javaLangInvokeMethodTypeReturnType = this.getMethodId(env, javaLangInvokeMethodType, "returnType", "()Ljava/lang/Class;", false);
        }
        return this.javaLangInvokeMethodTypeReturnType;
    }

    JNIMethodId getJavaLangInvokeMethodTypeParameterArray(JNIEnvironment env) {
        if (this.javaLangInvokeMethodTypeParameterArray.isNull()) {
            JNIObjectHandle javaLangInvokeMethodType = this.newClassGlobalRef(env, "java/lang/invoke/MethodType");
            this.javaLangInvokeMethodTypeParameterArray = this.getMethodId(env, javaLangInvokeMethodType, "parameterArray", "()[Ljava/lang/Class;", false);
        }
        return this.javaLangInvokeMethodTypeParameterArray;
    }

    JNIMethodId tryGetJavaUtilResourceBundleGetBundleImplSLCC(JNIEnvironment env) {
        if (!this.queriedJavaUtilResourceBundleGetBundleImplSLCC) {
            JNIObjectHandle javaUtilResourceBundle = this.findClass(env, "java/util/ResourceBundle");
            this.javaUtilResourceBundleGetBundleImplSLCC = this.getMethodIdOptional(env, javaUtilResourceBundle, "getBundleImpl", "(Ljava/lang/String;Ljava/util/Locale;Ljava/lang/Class;Ljava/util/ResourceBundle$Control;)Ljava/util/ResourceBundle;", true);
            this.queriedJavaUtilResourceBundleGetBundleImplSLCC = true;
        }
        return this.javaUtilResourceBundleGetBundleImplSLCC;
    }

    JNIMethodId getJavaIoObjectStreamClassForClass(JNIEnvironment env, JNIObjectHandle javaIoObjectStreamClassParam) {
        if (this.javaIoObjectStreamClassForClass.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIoObjectStreamClassForClass = this.getMethodId(env, javaIoObjectStreamClassParam, "forClass", "()Ljava/lang/Class;", false);
        }
        return this.javaIoObjectStreamClassForClass;
    }

    JNIMethodId getJavaIoObjectStreamClassGetName(JNIEnvironment env) {
        if (this.javaIoObjectStreamClassGetName.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            JNIObjectHandle javaIoObjectStreamClass = this.findClass(env, "java/io/ObjectStreamClass");
            this.javaIoObjectStreamClassGetName = this.getMethodId(env, javaIoObjectStreamClass, "getName", "()Ljava/lang/String;", false);
        }
        return this.javaIoObjectStreamClassGetName;
    }

    JNIMethodId getJavaIoObjectStreamClassGetClassDataLayout0(JNIEnvironment env, JNIObjectHandle javaIoObjectStreamClassParam) {
        if (this.javaIoObjectStreamClassGetClassDataLayout0.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIoObjectStreamClassGetClassDataLayout0 = this.getMethodId(env, javaIoObjectStreamClassParam, "getClassDataLayout0", "()[Ljava/io/ObjectStreamClass$ClassDataSlot;", false);
        }
        return this.javaIoObjectStreamClassGetClassDataLayout0;
    }

    JNIObjectHandle getJavaIOObjectStreamClassClassDataSlot(JNIEnvironment env) {
        if (this.javaIOObjectStreamClassClassDataSlot.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIOObjectStreamClassClassDataSlot = this.newClassGlobalRef(env, "java/io/ObjectStreamClass$ClassDataSlot");
        }
        return this.javaIOObjectStreamClassClassDataSlot;
    }

    JNIFieldId getJavaIOObjectStreamClassClassDataSlotDesc(JNIEnvironment env) {
        if (this.javaIOObjectStreamClassClassDataSlotDesc.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIOObjectStreamClassClassDataSlotDesc = this.getFieldId(env, this.getJavaIOObjectStreamClassClassDataSlot(env), "desc", "Ljava/io/ObjectStreamClass;", false);
        }
        return this.javaIOObjectStreamClassClassDataSlotDesc;
    }

    JNIFieldId getJavaIOObjectStreamClassClassDataSlotHasData(JNIEnvironment env) {
        if (this.javaIOObjectStreamClassClassDataSlotHasData.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaIOObjectStreamClassClassDataSlotHasData = this.getFieldId(env, this.getJavaIOObjectStreamClassClassDataSlot(env), "hasData", "Z", false);
        }
        return this.javaIOObjectStreamClassClassDataSlotHasData;
    }

    JNIMethodId getJavaUtilZipZipFileGetName(JNIEnvironment env) {
        if (this.javaUtilZipZipFileGetName.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            JNIObjectHandle javaUtilZipZipFile = this.findClass(env, "java/util/zip/ZipFile");
            this.javaUtilZipZipFileGetName = this.getMethodId(env, javaUtilZipZipFile, "getName", "()Ljava/lang/String;", false);
        }
        return this.javaUtilZipZipFileGetName;
    }

    JNIMethodId getJavaLangReflectConstructorDeclaringClassName(JNIEnvironment env, JNIObjectHandle customSerializationConstructorClass) {
        if (this.javaLangReflectConstructorDeclaringClassName.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaLangReflectConstructorDeclaringClassName = this.getMethodId(env, customSerializationConstructorClass, "getName", "()Ljava/lang/String;", false);
        }
        return this.javaLangReflectConstructorDeclaringClassName;
    }

    JNIObjectHandle getJavaLangReflectProxy(JNIEnvironment env) {
        if (this.javaLangReflectProxy.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaLangReflectProxy = this.newClassGlobalRef(env, "java/lang/reflect/Proxy");
        }
        return this.javaLangReflectProxy;
    }

    JNIMethodId getJavaLangReflectProxyIsProxyClass(JNIEnvironment env) {
        if (this.javaLangReflectProxyIsProxyClass.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaLangReflectProxyIsProxyClass = this.getMethodId(env, this.getJavaLangReflectProxy(env), "isProxyClass", "(Ljava/lang/Class;)Z", true);
        }
        return this.javaLangReflectProxyIsProxyClass;
    }

    public JNIMethodId getJavaLangInvokeCallSiteMakeSite(JNIEnvironment env) {
        if (this.javaLangInvokeCallSiteMakeSite.isNull()) {
            JNIObjectHandle javaLangInvokeCallSite = this.findClass(env, "java/lang/invoke/CallSite");
            this.javaLangInvokeCallSiteMakeSite = this.getMethodId(env, javaLangInvokeCallSite, "makeSite", "(Ljava/lang/invoke/MethodHandle;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/invoke/CallSite;", true);
        }
        return this.javaLangInvokeCallSiteMakeSite;
    }

    public JNIMethodId getJavaLangInvokeMethodHandleNativesLinkCallSiteImpl(JNIEnvironment env) {
        if (this.javaLangInvokeMethodHandleNativesLinkCallSiteImpl.isNull()) {
            JNIObjectHandle javaLangInvokeMethodHandleNatives = this.findClass(env, "java/lang/invoke/MethodHandleNatives");
            this.javaLangInvokeMethodHandleNativesLinkCallSiteImpl = this.getMethodId(env, javaLangInvokeMethodHandleNatives, "linkCallSiteImpl", "(Ljava/lang/Class;Ljava/lang/invoke/MethodHandle;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/invoke/MemberName;", true);
        }
        return this.javaLangInvokeMethodHandleNativesLinkCallSiteImpl;
    }

    public JNIMethodId getJavaLangInvokeMethodHandleNativesLinkCallSite(JNIEnvironment env) {
        if (this.javaLangInvokeMethodHandleNativesLinkCallSite.isNull()) {
            JNIObjectHandle javaLangInvokeMethodHandleNatives = this.findClass(env, "java/lang/invoke/MethodHandleNatives");
            this.javaLangInvokeMethodHandleNativesLinkCallSite = this.getMethodIdOptional(env, javaLangInvokeMethodHandleNatives, "linkCallSite", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/invoke/MemberName;", true);
        }
        return this.javaLangInvokeMethodHandleNativesLinkCallSite;
    }

    JNIObjectHandle getJavaUtilOptional(JNIEnvironment env) {
        if (this.javaUtilOptional.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.javaUtilOptional = this.newClassGlobalRef(env, "java/util/Optional");
        }
        return this.javaUtilOptional;
    }

    JNIMethodId getJavaUtilOptionalIsEmpty(JNIEnvironment env) {
        if (this.javaUtilOptionalIsEmpty.isNull()) {
            this.javaUtilOptionalIsEmpty = this.getMethodId(env, this.getJavaUtilOptional(env), "isEmpty", "()Z", false);
        }
        return this.javaUtilOptionalIsEmpty;
    }

    JNIMethodId getJavaUtilOptionalGet(JNIEnvironment env) {
        if (this.javaUtilOptionalGet.isNull()) {
            this.javaUtilOptionalGet = this.getMethodId(env, this.getJavaUtilOptional(env), "get", "()Ljava/lang/Object;", false);
        }
        return this.javaUtilOptionalGet;
    }

    JNIMethodId getJavaUtilListToArray(JNIEnvironment env) {
        if (this.javaUtilListToArray.isNull()) {
            JNIObjectHandle javaUtilList = this.findClass(env, "java/util/List");
            this.javaUtilListToArray = this.getMethodId(env, javaUtilList, "toArray", "()[Ljava/lang/Object;", false);
        }
        return this.javaUtilListToArray;
    }

    JNIMethodId getJavaLangForeignFunctionDescriptorReturnLayout(JNIEnvironment env) {
        if (this.javaLangForeignFunctionDescriptorReturnLayout.isNull()) {
            JNIObjectHandle javaLangForeignFunctionDescriptor = this.findClass(env, "java/lang/foreign/FunctionDescriptor");
            this.javaLangForeignFunctionDescriptorReturnLayout = this.getMethodIdOptional(env, javaLangForeignFunctionDescriptor, "returnLayout", "()Ljava/util/Optional;", false);
        }
        return this.javaLangForeignFunctionDescriptorReturnLayout;
    }

    JNIMethodId getJavaLangForeignFunctionDescriptorArgumentLayouts(JNIEnvironment env) {
        if (this.javaLangForeignFunctionDescriptorArgumentLayouts.isNull()) {
            JNIObjectHandle javaLangForeignFunctionDescriptor = this.findClass(env, "java/lang/foreign/FunctionDescriptor");
            this.javaLangForeignFunctionDescriptorArgumentLayouts = this.getMethodIdOptional(env, javaLangForeignFunctionDescriptor, "argumentLayouts", "()Ljava/util/List;", false);
        }
        return this.javaLangForeignFunctionDescriptorArgumentLayouts;
    }

    JNIMethodId getJavaLangForeignGroupLayoutMemberLayouts(JNIEnvironment env) {
        if (this.javaLangForeignGroupLayoutMemberLayouts.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignGroupLayoutMemberLayouts;
    }

    JNIMethodId getJavaLangForeignSequenceLayoutElementCount(JNIEnvironment env) {
        if (this.javaLangForeignSequenceLayoutElementCount.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignSequenceLayoutElementCount;
    }

    JNIMethodId getJavaLangForeignSequenceLayoutElementLayout(JNIEnvironment env) {
        if (this.javaLangForeignSequenceLayoutElementLayout.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignSequenceLayoutElementLayout;
    }

    JNIMethodId getJavaLangForeignValueLayoutCarrier(JNIEnvironment env) {
        if (this.javaLangForeignValueLayoutCarrier.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignValueLayoutCarrier;
    }

    JNIMethodId getJavaLangForeignMemoryLayoutByteSize(JNIEnvironment env) {
        if (this.javaLangForeignMemoryLayoutByteSize.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignMemoryLayoutByteSize;
    }

    JNIObjectHandle getJavaLangForeignPaddingLayout(JNIEnvironment env) {
        if (this.javaLangForeignPaddingLayout.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignPaddingLayout;
    }

    JNIObjectHandle getJavaLangForeignUnionLayout(JNIEnvironment env) {
        if (this.javaLangForeignUnionLayout.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignUnionLayout;
    }

    JNIObjectHandle getJavaLangForeignStructLayout(JNIEnvironment env) {
        if (this.javaLangForeignStructLayout.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignStructLayout;
    }

    JNIObjectHandle getJavaLangForeignSequenceLayout(JNIEnvironment env) {
        if (this.javaLangForeignSequenceLayout.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignSequenceLayout;
    }

    JNIObjectHandle getJavaLangForeignValueLayout(JNIEnvironment env) {
        if (this.javaLangForeignValueLayout.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignValueLayout;
    }

    JNIObjectHandle getJavaLangForeignMemorySegment(JNIEnvironment env) {
        if (this.javaLangForeignMemorySegment.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangForeignMemorySegment;
    }

    public JNIMethodId getJdkInternalForeignLayoutAbstractLayoutHasNaturalAlignment(JNIEnvironment env) {
        if (this.jdkInternalForeignLayoutAbstractLayoutHasNaturalAlignment.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.jdkInternalForeignLayoutAbstractLayoutHasNaturalAlignment;
    }

    public JNIMethodId getJdkInternalForeignLayoutAbstractLayoutByteAlignment(JNIEnvironment env) {
        if (this.jdkInternalForeignLayoutAbstractLayoutByteAlignment.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.jdkInternalForeignLayoutAbstractLayoutByteAlignment;
    }

    public JNIMethodId getJavaLangInvokeMethodHandleDescribeConstable(JNIEnvironment env) {
        if (this.javaLangInvokeMethodHandleDescribeConstable.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangInvokeMethodHandleDescribeConstable;
    }

    public JNIObjectHandle getJavaLangConstantDirectMethodHandleDesc(JNIEnvironment env) {
        if (this.javaLangConstantDirectMethodHandleDesc.equal((ComparableWord)JNIObjectHandles.nullHandle())) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangConstantDirectMethodHandleDesc;
    }

    public JNIMethodId getJavaLangConstantDirectMethodHandleDescRefKind(JNIEnvironment env) {
        if (this.javaLangConstantDirectMethodHandleDescRefKind.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangConstantDirectMethodHandleDescRefKind;
    }

    public JNIMethodId getJavaLangConstantDirectMethodHandleDescOwner(JNIEnvironment env) {
        if (this.javaLangConstantDirectMethodHandleDescOwner.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangConstantDirectMethodHandleDescOwner;
    }

    public JNIMethodId getJavaLangConstantDirectMethodHandleDescMethodName(JNIEnvironment env) {
        if (this.javaLangConstantDirectMethodHandleDescMethodName.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangConstantDirectMethodHandleDescMethodName;
    }

    public JNIMethodId getJavaLangConstantClassDescDescriptorString(JNIEnvironment env) {
        if (this.javaLangConstantClassDescDescriptorString.isNull()) {
            this.initializeForeignHandles(env);
        }
        return this.javaLangConstantClassDescDescriptorString;
    }
}

