/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.stackaccess;

import com.oracle.svm.agent.stackaccess.InterceptedState;
import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.jvmtiagentbase.Support;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiEnv;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiError;
import com.oracle.svm.jvmtiagentbase.jvmti.JvmtiFrameInfo;
import java.util.function.Supplier;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class EagerlyLoadedJavaStackAccess
extends InterceptedState {
    private static final int STACK_FRAMES_PER_ITERATION = 256;
    private final JNIMethodId[] fullJavaStackTrace = EagerlyLoadedJavaStackAccess.getCurrentThreadStackTrace();

    private EagerlyLoadedJavaStackAccess() {
    }

    private static int getCurrentThreadStackFrameCount(JvmtiEnv jvmti) {
        CIntPointer countPointer = (CIntPointer)StackValue.get(CIntPointer.class);
        JvmtiError error = jvmti.getFunctions().GetFrameCount().invoke(jvmti, (JNIObjectHandle)JNIObjectHandles.nullHandle(), countPointer);
        if (error.equals((Object)JvmtiError.JVMTI_ERROR_WRONG_PHASE)) {
            return -1;
        }
        Support.check((JvmtiError)error);
        return countPointer.read();
    }

    private static JNIMethodId[] getCurrentThreadStackTrace() {
        JvmtiEnv jvmti = Support.jvmtiEnv();
        int threadStackFrameCount = EagerlyLoadedJavaStackAccess.getCurrentThreadStackFrameCount(jvmti);
        if (threadStackFrameCount < 0) {
            return new JNIMethodId[0];
        }
        boolean wrongPhase = false;
        int iterationCount = threadStackFrameCount / 256;
        if (threadStackFrameCount % 256 > 0) {
            ++iterationCount;
        }
        JNIMethodId[] stackTraceJMethodIDs = new JNIMethodId[threadStackFrameCount];
        int frameInfoSize = SizeOf.get(JvmtiFrameInfo.class);
        Pointer stackFramesBuffer = (Pointer)UnmanagedMemory.malloc((int)(frameInfoSize * 256));
        CIntPointer readFrameCount = (CIntPointer)StackValue.get(CIntPointer.class);
        for (int i = 0; i < iterationCount; ++i) {
            JvmtiError error = jvmti.getFunctions().GetStackTrace().invoke(jvmti, (JNIObjectHandle)JNIObjectHandles.nullHandle(), i * 256, 256, (WordPointer)stackFramesBuffer, readFrameCount);
            if (error.equals((Object)JvmtiError.JVMTI_ERROR_WRONG_PHASE)) {
                wrongPhase = true;
                break;
            }
            Support.check((JvmtiError)error);
            for (int j = 0; j < readFrameCount.read(); ++j) {
                JvmtiFrameInfo frameInfo = (JvmtiFrameInfo)stackFramesBuffer.add(j * frameInfoSize);
                stackTraceJMethodIDs[i * 256 + j] = frameInfo.getMethod();
            }
        }
        UnmanagedMemory.free((PointerBase)stackFramesBuffer);
        return wrongPhase ? null : stackTraceJMethodIDs;
    }

    @Override
    public JNIMethodId getCallerMethod(int depth) {
        if (this.fullJavaStackTrace == null) {
            return (JNIMethodId)JNIObjectHandles.nullHandle();
        }
        assert (depth >= 0);
        if (depth >= this.fullJavaStackTrace.length) {
            return (JNIMethodId)WordFactory.nullPointer();
        }
        return this.fullJavaStackTrace[depth];
    }

    @Override
    public JNIMethodId[] getFullStackTraceOrNull() {
        return this.fullJavaStackTrace;
    }

    public static Supplier<InterceptedState> stackAccessSupplier() {
        return EagerlyLoadedJavaStackAccess::new;
    }
}

