/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile;

import com.oracle.svm.espresso.classfile.descriptors.ErrorUtil;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;

public final class JavaKind
extends Enum<JavaKind> {
    public static final /* enum */ JavaKind Boolean = new JavaKind('Z', 4, "boolean", 1, true, java.lang.Boolean.TYPE, Boolean.class);
    public static final /* enum */ JavaKind Byte = new JavaKind('B', 8, "byte", 1, true, java.lang.Byte.TYPE, Byte.class);
    public static final /* enum */ JavaKind Short = new JavaKind('S', 9, "short", 1, true, java.lang.Short.TYPE, Short.class);
    public static final /* enum */ JavaKind Char = new JavaKind('C', 5, "char", 1, true, Character.TYPE, Character.class);
    public static final /* enum */ JavaKind Int = new JavaKind('I', 10, "int", 1, true, Integer.TYPE, Integer.class);
    public static final /* enum */ JavaKind Float = new JavaKind('F', 6, "float", 1, false, java.lang.Float.TYPE, Float.class);
    public static final /* enum */ JavaKind Long = new JavaKind('J', 11, "long", 2, false, java.lang.Long.TYPE, Long.class);
    public static final /* enum */ JavaKind Double = new JavaKind('D', 7, "double", 2, false, java.lang.Double.TYPE, Double.class);
    public static final /* enum */ JavaKind Object = new JavaKind('A', 12, "Object", 1, false, null, null);
    public static final /* enum */ JavaKind Void = new JavaKind('V', 14, "void", 0, false, java.lang.Void.TYPE, Void.class);
    public static final /* enum */ JavaKind ReturnAddress = new JavaKind('r', 98, "return address", 1, false, null, null);
    public static final /* enum */ JavaKind Illegal = new JavaKind('-', 99, "illegal", 0, false, null, null);
    private final char typeChar;
    private final String javaName;
    private final boolean isStackInt;
    private final Class<?> primitiveJavaClass;
    private final Class<?> boxedJavaClass;
    private final int slotCount;
    private final int basicType;
    private final Symbol<Type> type;
    private final Symbol<Name> name;
    private final String unwrapMethodName;
    private final String unwrapMethodDesc;
    private final String wrapperValueOfDesc;
    private static final /* synthetic */ JavaKind[] $VALUES;

    public static JavaKind[] values() {
        return (JavaKind[])$VALUES.clone();
    }

    public static JavaKind valueOf(String name) {
        return Enum.valueOf(JavaKind.class, name);
    }

    private JavaKind(char typeChar, int basicType, String javaName, int slotCount, boolean isStackInt, Class<?> primitiveJavaClass, Class<?> boxedJavaClass) {
        this.typeChar = typeChar;
        this.javaName = javaName;
        this.slotCount = slotCount;
        this.isStackInt = isStackInt;
        this.primitiveJavaClass = primitiveJavaClass;
        this.boxedJavaClass = boxedJavaClass;
        this.basicType = basicType;
        this.type = primitiveJavaClass != null ? ParserSymbols.SYMBOLS.putType("" + typeChar) : null;
        this.name = ParserSymbols.SYMBOLS.putName(javaName);
        this.unwrapMethodName = primitiveJavaClass != null ? javaName + "Value" : null;
        this.unwrapMethodDesc = primitiveJavaClass != null ? "()" + typeChar : null;
        String string2 = this.wrapperValueOfDesc = primitiveJavaClass != null ? "(" + typeChar + ")Ljava/lang/" + boxedJavaClass.getSimpleName() + ";" : null;
        assert (primitiveJavaClass == null || javaName.equals(primitiveJavaClass.getName()));
    }

    public static void ensureInitialized() {
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public boolean needsTwoSlots() {
        return this.slotCount == 2;
    }

    public char getTypeChar() {
        return this.typeChar;
    }

    public int getBasicType() {
        return this.basicType;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public boolean isPrimitive() {
        return this.primitiveJavaClass != null;
    }

    public JavaKind getStackKind() {
        if (this.isStackInt) {
            return Int;
        }
        return this;
    }

    public boolean isNumericInteger() {
        return this.isStackInt || this == Long;
    }

    public boolean isUnsigned() {
        return this == Boolean || this == Char;
    }

    public boolean isNumericFloat() {
        return this == Float || this == Double;
    }

    public boolean isObject() {
        return this == Object;
    }

    public static JavaKind fromTypeString(String typeString) {
        assert (!typeString.isEmpty());
        char first = typeString.charAt(0);
        if (first == '[' || first == 'L') {
            return Object;
        }
        return JavaKind.fromPrimitiveOrVoidTypeChar(first);
    }

    public static JavaKind fromWordSize(int wordSizeInBytes) {
        if (wordSizeInBytes == 8) {
            return Long;
        }
        assert (wordSizeInBytes == 4) : "Unsupported word size!";
        return Int;
    }

    public static JavaKind fromPrimitiveOrVoidTypeChar(char ch) {
        JavaKind kind = JavaKind.fromPrimitiveOrVoidTypeCharOrNull(ch);
        if (kind == null) {
            throw new IllegalArgumentException(JavaKind.invalidTypeCharMessage(ch));
        }
        return kind;
    }

    public static JavaKind fromPrimitiveOrVoidTypeCharOrNull(char ch) {
        return switch (ch) {
            case 'Z' -> Boolean;
            case 'C' -> Char;
            case 'F' -> Float;
            case 'D' -> Double;
            case 'B' -> Byte;
            case 'S' -> Short;
            case 'I' -> Int;
            case 'J' -> Long;
            case 'V' -> Void;
            default -> null;
        };
    }

    private static String invalidTypeCharMessage(char ch) {
        return "unknown primitive or void type character: " + ch;
    }

    public Class<?> toJavaClass() {
        return this.primitiveJavaClass;
    }

    public Class<?> toBoxedJavaClass() {
        return this.boxedJavaClass;
    }

    public String toString() {
        return this.javaName;
    }

    public long getMinValue() {
        switch (this.ordinal()) {
            case 0: {
                return 0L;
            }
            case 1: {
                return -128L;
            }
            case 3: {
                return 0L;
            }
            case 2: {
                return -32768L;
            }
            case 4: {
                return Integer.MIN_VALUE;
            }
            case 6: {
                return java.lang.Long.MIN_VALUE;
            }
            case 5: {
                return java.lang.Float.floatToRawIntBits(java.lang.Float.MIN_VALUE);
            }
            case 7: {
                return java.lang.Double.doubleToRawLongBits(java.lang.Double.MIN_VALUE);
            }
        }
        throw new IllegalArgumentException("illegal call to minValue on " + String.valueOf((Object)this));
    }

    public long getMaxValue() {
        switch (this.ordinal()) {
            case 0: {
                return 1L;
            }
            case 1: {
                return 127L;
            }
            case 3: {
                return 65535L;
            }
            case 2: {
                return 32767L;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
            case 6: {
                return java.lang.Long.MAX_VALUE;
            }
            case 5: {
                return java.lang.Float.floatToRawIntBits(java.lang.Float.MAX_VALUE);
            }
            case 7: {
                return java.lang.Double.doubleToRawLongBits(java.lang.Double.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException("illegal call to maxValue on " + String.valueOf((Object)this));
    }

    public int getByteCount() {
        if (this == Boolean) {
            return 1;
        }
        return this.getBitCount() >> 3;
    }

    public int getBitCount() {
        switch (this.ordinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 8;
            }
            case 2: 
            case 3: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 4: {
                return 32;
            }
            case 7: {
                return 64;
            }
            case 6: {
                return 64;
            }
        }
        throw new IllegalArgumentException("illegal call to bits on " + String.valueOf((Object)this));
    }

    public Symbol<Type> getType() {
        return this.type;
    }

    public Symbol<Name> getPrimitiveBinaryName() {
        ErrorUtil.guarantee(this.isPrimitive(), "not a primitive");
        return this.name;
    }

    public String getUnwrapMethodName() {
        return this.unwrapMethodName;
    }

    public String getUnwrapMethodDesc() {
        return this.unwrapMethodDesc;
    }

    public String getWrapperValueOfDesc() {
        return this.wrapperValueOfDesc;
    }

    public static boolean isToStringSafe(Class<?> c) {
        return c == Boolean.class || c == Byte.class || c == Character.class || c == Short.class || c == Integer.class || c == Float.class || c == Long.class || c == Double.class;
    }

    public boolean isSubWord() {
        return this.isStackInt || this == Float;
    }

    public boolean isStackInt() {
        return this.isStackInt;
    }

    private static /* synthetic */ JavaKind[] $values() {
        return new JavaKind[]{Boolean, Byte, Short, Char, Int, Float, Long, Double, Object, Void, ReturnAddress, Illegal};
    }

    static {
        $VALUES = JavaKind.$values();
    }
}

