/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile;

import com.oracle.svm.espresso.classfile.ParserConstantPool;
import com.oracle.svm.espresso.classfile.ParserField;
import com.oracle.svm.espresso.classfile.ParserMethod;
import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;

public final class ParserKlass {
    private final Symbol<Name> name;
    private final Symbol<Type> type;
    private final Symbol<Type> superKlass;
    private final Symbol<Type>[] superInterfaces;
    private final int flags;
    private final ParserMethod[] methods;
    private final ParserField[] fields;
    private final Attribute[] attributes;
    private final ParserConstantPool pool;
    private final char majorVersion;
    private final char minorVersion;
    private final int thisKlassIndex;
    private final long hiddenKlassId;

    public ParserKlass(ParserConstantPool pool, int flags, Symbol<Name> name, Symbol<Type> type, Symbol<Type> superKlass, Symbol<Type>[] superInterfaces, ParserMethod[] methods, ParserField[] fields, Attribute[] attributes, int thisKlassIndex, int majorVersion, int minorVersion, long hiddenKlassId) {
        assert (majorVersion == (char)majorVersion);
        assert (minorVersion == (char)minorVersion);
        this.pool = pool;
        this.flags = flags;
        this.name = name;
        this.type = type;
        this.superKlass = superKlass;
        this.superInterfaces = superInterfaces;
        this.methods = methods;
        this.fields = fields;
        this.attributes = attributes;
        this.thisKlassIndex = thisKlassIndex;
        this.majorVersion = (char)majorVersion;
        this.minorVersion = (char)minorVersion;
        this.hiddenKlassId = hiddenKlassId;
    }

    public int getFlags() {
        return this.flags;
    }

    public Symbol<Name> getName() {
        return this.name;
    }

    public Symbol<Type> getType() {
        return this.type;
    }

    public Symbol<Type> getSuperKlass() {
        return this.superKlass;
    }

    public Symbol<Type>[] getSuperInterfaces() {
        return this.superInterfaces;
    }

    public ParserConstantPool getConstantPool() {
        return this.pool;
    }

    public ParserMethod[] getMethods() {
        return this.methods;
    }

    public ParserField[] getFields() {
        return this.fields;
    }

    public Attribute getAttribute(Symbol<Name> attributeName) {
        for (Attribute attribute : this.attributes) {
            if (!attributeName.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public int getThisKlassIndex() {
        return this.thisKlassIndex;
    }

    public long getHiddenKlassId() {
        return this.hiddenKlassId;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String toString() {
        return "ParserKlass<" + String.valueOf(this.getType()) + ">";
    }
}

