/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.JavaKind;
import com.oracle.svm.espresso.classfile.attributes.LocalRef;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.TypeSymbols;
import java.util.Objects;
import org.graalvm.collections.Equivalence;

public final class Local
implements LocalRef {
    public static final Equivalence localEquivalence = new Equivalence(){

        public boolean equals(Object a, Object b) {
            if (a instanceof Local && b instanceof Local) {
                return ((Local)a).sameLocal((Local)b);
            }
            return false;
        }

        public int hashCode(Object o) {
            if (o instanceof Local) {
                return ((Local)o).sameLocalHash();
            }
            return o.hashCode();
        }
    };
    public static final Local[] EMPTY_ARRAY = new Local[0];
    private final Symbol<Name> name;
    private final Symbol<?> typeOrDesc;
    private final char startBci;
    private final char endBci;
    private final char slot;

    public Local(Symbol<Name> name, Symbol<Type> type, Symbol<?> typeDesc, int startBci, int endBci, int slot) {
        assert (type != null || typeDesc != null);
        this.name = name;
        this.startBci = (char)startBci;
        this.endBci = (char)endBci;
        this.slot = (char)slot;
        this.typeOrDesc = type != null ? type : typeDesc;
    }

    @Override
    public int getStartBCI() {
        return this.startBci;
    }

    @Override
    public int getEndBCI() {
        return this.endBci;
    }

    public Symbol<Name> getName() {
        return this.name;
    }

    public Symbol<?> getTypeOrDesc() {
        return this.typeOrDesc;
    }

    public JavaKind getJavaKind() {
        if (TypeSymbols.isPrimitive(this.typeOrDesc)) {
            return JavaKind.fromPrimitiveOrVoidTypeChar((char)this.typeOrDesc.byteAt(0));
        }
        return JavaKind.Object;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    public boolean sameLocal(Local other) {
        return this.startBci == other.startBci && this.endBci == other.endBci && this.slot == other.slot && this.name.equals(other.name);
    }

    public int sameLocalHash() {
        return Objects.hash(Character.valueOf(this.startBci), Character.valueOf(this.endBci), Character.valueOf(this.slot), this.name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Local)) {
            return false;
        }
        Local that = (Local)obj;
        return this.name.equals(that.name) && this.startBci == that.startBci && this.endBci == that.endBci && this.slot == that.slot && this.typeOrDesc.equals(that.typeOrDesc);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.typeOrDesc, Character.valueOf(this.startBci), Character.valueOf(this.endBci), Character.valueOf(this.slot));
    }

    public String toString() {
        return "Local<name=" + String.valueOf(this.getName()) + ", type=" + String.valueOf(this.getTypeOrDesc()) + ", startBci=" + this.getStartBCI() + ", endBci=" + this.getEndBCI() + ", slot=" + this.getSlot() + ">";
    }

    @Override
    public String getNameAsString() {
        return this.name.toString();
    }

    @Override
    public String getTypeAsString() {
        return this.typeOrDesc.toString();
    }
}

