/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.JavaKind;
import com.oracle.svm.espresso.classfile.ParserException;
import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.Descriptor;
import com.oracle.svm.espresso.classfile.descriptors.ErrorUtil;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Signature;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Symbols;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.TypeSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Validation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public final class SignatureSymbols {
    private final TypeSymbols typeSymbols;
    private final Symbols symbols;

    public SignatureSymbols(Symbols symbols, TypeSymbols typeSymbols) {
        this.symbols = symbols;
        this.typeSymbols = typeSymbols;
    }

    public Symbol<Signature> lookupValidSignature(String signatureString) {
        return this.lookupValidSignature(ByteSequence.create(signatureString));
    }

    public Symbol<Signature> lookupValidSignature(ByteSequence signatureBytes) {
        if (!Validation.validSignatureDescriptor(signatureBytes)) {
            return null;
        }
        return this.symbols.lookup(signatureBytes);
    }

    public Symbol<Signature> getOrCreateValidSignature(ByteSequence signatureBytes) {
        return this.getOrCreateValidSignature(signatureBytes, false);
    }

    public Symbol<Signature> getOrCreateValidSignature(ByteSequence signatureBytes, boolean ensureStrongReference) {
        if (!Validation.validSignatureDescriptor(signatureBytes)) {
            return null;
        }
        return this.symbols.getOrCreate(signatureBytes, ensureStrongReference);
    }

    public TypeSymbols getTypes() {
        return this.typeSymbols;
    }

    public Symbol<Type>[] parsed(Symbol<Signature> signature) {
        return SignatureSymbols.parse(this.getTypes(), signature, 0);
    }

    public Symbol<Signature> toBasic(Symbol<Signature> raw, boolean keepLastArg) {
        Symbol<Type>[] sig = this.parsed(raw);
        int pcount = SignatureSymbols.parameterCount(sig);
        int params = Math.max(pcount - (keepLastArg ? 0 : 1), 0);
        ArrayList<Symbol<Type>> buf = new ArrayList<Symbol<Type>>();
        for (int i = 0; i < params; ++i) {
            Symbol<Type> t = SignatureSymbols.parameterType(sig, i);
            if (i == params - 1 && keepLastArg) {
                buf.add(t);
                continue;
            }
            buf.add(SignatureSymbols.toBasic(t));
        }
        Symbol<Type> rtype = SignatureSymbols.toBasic(SignatureSymbols.returnType(sig));
        return this.makeRaw(rtype, buf.toArray(Symbol.EMPTY_ARRAY));
    }

    private static Symbol<Type> toBasic(Symbol<Type> type) {
        if (type == ParserSymbols.ParserTypes.java_lang_Object || TypeSymbols.isArray(type)) {
            return ParserSymbols.ParserTypes.java_lang_Object;
        }
        if (type == ParserSymbols.ParserTypes._int || type == ParserSymbols.ParserTypes._short || type == ParserSymbols.ParserTypes._boolean || type == ParserSymbols.ParserTypes._char) {
            return ParserSymbols.ParserTypes._int;
        }
        return type;
    }

    static Symbol<Type>[] parse(TypeSymbols typeSymbols, Symbol<Signature> signature, int startIndex) throws ParserException.ClassFormatError {
        Symbol<Type> descriptor;
        if (startIndex > signature.length() - 3 || signature.byteAt(startIndex) != 40) {
            throw new ParserException.ClassFormatError("Invalid method signature: " + String.valueOf(signature));
        }
        ArrayList<Symbol<Type>> buf = new ArrayList<Symbol<Type>>();
        int i = startIndex + 1;
        while (signature.byteAt(i) != 41) {
            descriptor = typeSymbols.parse(signature, i, true);
            buf.add(descriptor);
            if ((i += descriptor.length()) < signature.length()) continue;
            throw new ParserException.ClassFormatError("Invalid method signature: " + String.valueOf(signature));
        }
        if (++i + (descriptor = typeSymbols.parse(signature, i, true)).length() != signature.length()) {
            throw new ParserException.ClassFormatError("Invalid method signature: " + String.valueOf(signature));
        }
        Symbol[] descriptors = buf.toArray(new Symbol[buf.size() + 1]);
        descriptors[buf.size()] = descriptor;
        return descriptors;
    }

    public static Symbol<Signature> fromDescriptor(Symbol<? extends Descriptor> descriptor) {
        ErrorUtil.guarantee(Validation.validSignatureDescriptor(descriptor), "invalid signature");
        return descriptor;
    }

    public static Symbol<Signature> fromDescriptorUnsafe(Symbol<? extends Descriptor> descriptor) {
        assert (Validation.validSignatureDescriptor(descriptor)) : "invalid signature " + String.valueOf(descriptor);
        return descriptor;
    }

    public static Symbol<Type> returnType(Symbol<Type>[] signature) {
        return signature[signature.length - 1];
    }

    public static JavaKind returnKind(Symbol<Type>[] signature) {
        return TypeSymbols.getJavaKind(SignatureSymbols.returnType(signature));
    }

    public static int getNumberOfSlots(Symbol<Type>[] signature) {
        int slots = 0;
        for (Symbol<Type> type : signature) {
            slots += TypeSymbols.getJavaKind(type).getSlotCount();
        }
        return slots;
    }

    public static int slotsForParameters(Symbol<Type>[] signature) {
        int slots = 0;
        int count = SignatureSymbols.parameterCount(signature);
        for (int i = 0; i < count; ++i) {
            slots += SignatureSymbols.parameterKind(signature, i).getSlotCount();
        }
        return slots;
    }

    public static int parameterCount(Symbol<Type>[] signature) {
        return signature.length - 1;
    }

    public static Iterable<Symbol<Type>> iterable(Symbol<Type>[] signature, boolean reverse, boolean withReturnType) {
        return new SignatureIter(signature, reverse, withReturnType);
    }

    public static JavaKind parameterKind(Symbol<Type>[] signature, int paramIndex) {
        return TypeSymbols.getJavaKind(signature[paramIndex]);
    }

    public static Symbol<Type> parameterType(Symbol<Type>[] signature, int paramIndex) {
        assert (paramIndex + 1 < signature.length);
        return signature[paramIndex];
    }

    @SafeVarargs
    public static Symbol<Type>[] makeParsedUncached(Symbol<Type> returnType, Symbol<Type> ... parameterTypes) {
        Symbol<Type>[] signature = Arrays.copyOf(parameterTypes, parameterTypes.length + 1);
        signature[signature.length - 1] = returnType;
        return signature;
    }

    @SafeVarargs
    public final Symbol<Signature> makeRaw(Symbol<Type> returnType, Symbol<Type> ... parameterTypes) {
        return this.symbols.getOrCreate(SignatureSymbols.createSignature(returnType, parameterTypes));
    }

    @SafeVarargs
    static ByteSequence createSignature(Symbol<Type> returnType, Symbol<Type> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            byte[] bytes = new byte[2 + returnType.length()];
            bytes[0] = 40;
            bytes[1] = 41;
            returnType.writeTo(bytes, 2);
            return ByteSequence.wrap(bytes);
        }
        int totalLength = returnType.length();
        for (Symbol<Type> param : parameterTypes) {
            totalLength += param.length();
        }
        byte[] bytes = new byte[totalLength + 2];
        int pos = 0;
        bytes[pos++] = 40;
        for (Symbol<Type> param : parameterTypes) {
            param.writeTo(bytes, pos);
            pos += param.length();
        }
        bytes[pos++] = 41;
        returnType.writeTo(bytes, pos);
        assert ((pos += returnType.length()) == totalLength + 2);
        return ByteSequence.wrap(bytes);
    }

    public static boolean returnsVoid(ByteSequence signature) {
        return signature.length() > 2 && signature.byteAt(signature.length() - 2) == 41 && signature.byteAt(signature.length() - 1) == 86;
    }

    private static final class SignatureIter
    implements Iterable<Symbol<Type>>,
    Iterator<Symbol<Type>> {
        private final Symbol<Type>[] signature;
        private final int start;
        private final int end;
        private final int step;
        private int pos;

        private SignatureIter(Symbol<Type>[] signature, boolean reverse, boolean withReturnType) {
            this.signature = signature;
            int tmpStart = 0;
            int tmpEnd = SignatureSymbols.parameterCount(signature);
            int tmpStep = 1;
            if (withReturnType) {
                tmpEnd = signature.length;
            }
            this.pos = tmpStart;
            if (reverse) {
                tmpStep = -1;
                this.pos = tmpEnd;
            }
            this.start = tmpStart;
            this.end = tmpEnd;
            this.step = tmpStep;
        }

        @Override
        public Iterator<Symbol<Type>> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            int next = this.nextIdx();
            return next >= this.start && next < this.end;
        }

        @Override
        public Symbol<Type> next() {
            assert (this.hasNext());
            int nextIdx = this.nextIdx();
            Symbol<Type> next = this.signature[nextIdx];
            this.pos = nextIdx;
            return next;
        }

        private int nextIdx() {
            return this.pos + this.step;
        }
    }
}

