/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.tables;

import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class EntryTable<T extends NamedEntry, K> {
    private final HashMap<Symbol<Name>, T> entries = new HashMap();
    private final BlockLock readBlock;
    private final BlockLock writeBlock;

    protected EntryTable(ReadWriteLock lock) {
        this.readBlock = new BlockLock(lock.readLock());
        this.writeBlock = new BlockLock(lock.writeLock());
    }

    public void collectValues(Consumer<T> consumer) {
        try (BlockLock block = this.read();){
            this.entries.values().forEach(consumer);
        }
    }

    public void collectEntries(BiConsumer<Symbol<Name>, T> consumer) {
        try (BlockLock block = this.read();){
            this.entries.forEach(consumer::accept);
        }
    }

    public BlockLock read() {
        return this.readBlock.enter();
    }

    public BlockLock write() {
        return this.writeBlock.enter();
    }

    protected abstract T createEntry(Symbol<Name> var1, K var2);

    public T lookup(Symbol<Name> name) {
        try (BlockLock block = this.read();){
            NamedEntry namedEntry = (NamedEntry)this.entries.get(name);
            return (T)namedEntry;
        }
    }

    public T lookupOrCreate(Symbol<Name> name, K data) {
        T entry = this.lookup(name);
        if (entry != null) {
            return entry;
        }
        try (BlockLock block = this.write();){
            entry = this.lookup(name);
            if (entry != null) {
                T t = entry;
                return t;
            }
            T t = this.addEntry(name, data);
            return t;
        }
    }

    public T createAndAddEntry(Symbol<Name> name, K data) {
        try (BlockLock block = this.write();){
            if (this.lookup(name) != null) {
                T t = null;
                return t;
            }
            T t = this.addEntry(name, data);
            return t;
        }
    }

    private T addEntry(Symbol<Name> name, K data) {
        T entry = this.createEntry(name, data);
        this.entries.put(name, entry);
        return entry;
    }

    public static final class BlockLock
    implements AutoCloseable {
        private final Lock lock;

        private BlockLock(Lock lock) {
            this.lock = lock;
        }

        private BlockLock enter() {
            this.lock.lock();
            return this;
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }

    public static abstract class NamedEntry {
        protected final Symbol<Name> name;

        protected NamedEntry(Symbol<Name> name) {
            this.name = name;
        }

        public final Symbol<Name> getName() {
            return this.name;
        }

        public final String getNameAsString() {
            if (this.name == null) {
                return "unnamed";
            }
            return this.name.toString();
        }

        public final int hashCode() {
            if (this.name == null) {
                return 0;
            }
            return this.name.hashCode();
        }

        public final boolean equals(Object obj) {
            if (obj instanceof NamedEntry) {
                return Objects.equals(((NamedEntry)obj).getName(), this.getName());
            }
            return false;
        }
    }
}

