/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.meta;

import java.lang.reflect.Modifier;

public interface ModifiersProvider {
    public int getModifiers();

    default public boolean isVarargs() {
        return Modifier.isTransient(this.getModifiers());
    }

    default public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    default public boolean isSynchronized() {
        return Modifier.isSynchronized(this.getModifiers());
    }

    default public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    default public boolean isFinalFlagSet() {
        return Modifier.isFinal(this.getModifiers());
    }

    default public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    default public boolean isPackagePrivate() {
        return (7 & this.getModifiers()) == 0;
    }

    default public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    default public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    default public boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    default public boolean isStrict() {
        return Modifier.isStrict(this.getModifiers());
    }

    default public boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    default public boolean isNative() {
        return Modifier.isNative(this.getModifiers());
    }

    default public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    default public boolean isConcrete() {
        return !this.isAbstract();
    }

    default public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }
}

