/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.shared.verifier.VerificationTypeInfo;
import com.oracle.svm.espresso.shared.verifier.VerifierError;
import java.io.PrintStream;

abstract class StackMapFrame {
    protected final int frameType;

    public int getFrameType() {
        return this.frameType;
    }

    StackMapFrame(int frameType) {
        this.frameType = frameType;
    }

    public int getChopped() {
        throw VerifierError.fatal("Asking for chopped value of non chopped frame");
    }

    public VerificationTypeInfo getStackItem() {
        throw VerifierError.fatal("Asking for stack item of incompatible stackMap frame");
    }

    public VerificationTypeInfo[] getStack() {
        throw VerifierError.fatal("Asking for stack of incompatible stackMap frame");
    }

    public VerificationTypeInfo[] getLocals() {
        throw VerifierError.fatal("Asking for locals of incompatible stackMap frame");
    }

    public abstract int getOffset();

    public void print(ConstantPool pool, PrintStream out) {
        out.println("        " + this.getClass().getSimpleName() + " {");
        out.println("            Offset: " + this.getOffset());
    }
}

