/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shaded.org.capnproto;

import com.oracle.svm.shaded.org.capnproto.FromPointerBuilderBlobDefault;
import com.oracle.svm.shaded.org.capnproto.FromPointerReaderBlobDefault;
import com.oracle.svm.shaded.org.capnproto.PointerFactory;
import com.oracle.svm.shaded.org.capnproto.SegmentBuilder;
import com.oracle.svm.shaded.org.capnproto.SegmentReader;
import com.oracle.svm.shaded.org.capnproto.SetPointerBuilder;
import com.oracle.svm.shaded.org.capnproto.WireHelpers;
import java.nio.ByteBuffer;

public final class Data {
    public static final Factory factory = new Factory();

    public static final class Factory
    implements FromPointerReaderBlobDefault<Reader>,
    PointerFactory<Builder, Reader>,
    FromPointerBuilderBlobDefault<Builder>,
    SetPointerBuilder<Builder, Reader> {
        @Override
        public final Reader fromPointerReaderBlobDefault(SegmentReader segment, int pointer, ByteBuffer defaultBuffer, int defaultOffset, int defaultSize) {
            return WireHelpers.readDataPointer(segment, pointer, defaultBuffer, defaultOffset, defaultSize);
        }

        @Override
        public final Reader fromPointerReader(SegmentReader segment, int pointer, int nestingLimit) {
            return WireHelpers.readDataPointer(segment, pointer, null, 0, 0);
        }

        @Override
        public final Builder fromPointerBuilderBlobDefault(SegmentBuilder segment, int pointer, ByteBuffer defaultBuffer, int defaultOffset, int defaultSize) {
            return WireHelpers.getWritableDataPointer(pointer, segment, defaultBuffer, defaultOffset, defaultSize);
        }

        @Override
        public final Builder fromPointerBuilder(SegmentBuilder segment, int pointer) {
            return WireHelpers.getWritableDataPointer(pointer, segment, null, 0, 0);
        }

        @Override
        public final Builder initFromPointerBuilder(SegmentBuilder segment, int pointer, int size) {
            return WireHelpers.initDataPointer(pointer, segment, size);
        }

        @Override
        public final void setPointerBuilder(SegmentBuilder segment, int pointer, Reader value) {
            WireHelpers.setDataPointer(pointer, segment, value);
        }
    }

    public static final class Builder {
        public final ByteBuffer buffer;
        public final int offset;
        public final int size;

        public Builder() {
            this.buffer = ByteBuffer.allocate(0);
            this.offset = 0;
            this.size = 0;
        }

        public Builder(ByteBuffer buffer, int offset, int size) {
            this.buffer = buffer;
            this.offset = offset;
            this.size = size;
        }

        public ByteBuffer asByteBuffer() {
            ByteBuffer dup = this.buffer.duplicate();
            dup.position(this.offset);
            ByteBuffer result = dup.slice();
            result.limit(this.size);
            return result;
        }

        public byte[] toArray() {
            ByteBuffer dup = this.buffer.duplicate();
            byte[] result = new byte[this.size];
            dup.position(this.offset);
            dup.get(result, 0, this.size);
            return result;
        }
    }

    public static final class Reader {
        public final ByteBuffer buffer;
        public final int offset;
        public final int size;

        public Reader() {
            this.buffer = ByteBuffer.allocate(0);
            this.offset = 0;
            this.size = 0;
        }

        public Reader(ByteBuffer buffer, int offset, int size) {
            this.buffer = buffer;
            this.offset = offset * 8;
            this.size = size;
        }

        public Reader(byte[] bytes) {
            this.buffer = ByteBuffer.wrap(bytes);
            this.offset = 0;
            this.size = bytes.length;
        }

        public final int size() {
            return this.size;
        }

        public ByteBuffer asByteBuffer() {
            ByteBuffer dup = this.buffer.asReadOnlyBuffer();
            dup.position(this.offset);
            ByteBuffer result = dup.slice();
            result.limit(this.size);
            return result;
        }

        public byte[] toArray() {
            ByteBuffer dup = this.buffer.duplicate();
            byte[] result = new byte[this.size];
            dup.position(this.offset);
            dup.get(result, 0, this.size);
            return result;
        }
    }
}

