/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.aarch64.SubstrateAArch64MacroAssembler;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.ForeignFunctionsRuntime;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.util.BasedOnJDKClass;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.internal.foreign.abi.Binding;
import jdk.internal.foreign.abi.CallingSequence;
import jdk.internal.foreign.abi.DowncallLinker;
import jdk.internal.foreign.abi.LinkerOptions;
import jdk.internal.foreign.abi.SharedUtils;
import jdk.internal.foreign.abi.UpcallLinker;
import jdk.internal.foreign.abi.VMStorage;
import jdk.internal.foreign.abi.aarch64.AArch64Architecture;
import jdk.internal.foreign.abi.aarch64.linux.LinuxAArch64CallArranger;
import jdk.internal.foreign.abi.aarch64.linux.LinuxAArch64Linker;
import jdk.internal.foreign.abi.aarch64.macos.MacOsAArch64CallArranger;
import jdk.internal.foreign.abi.aarch64.macos.MacOsAArch64Linker;
import jdk.internal.foreign.abi.x64.X86_64Architecture;
import jdk.internal.foreign.abi.x64.sysv.CallArranger;
import jdk.internal.foreign.abi.x64.sysv.SysVx64Linker;
import jdk.internal.foreign.abi.x64.windows.Windowsx64Linker;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

class ABIs {
    public static final String REQUIRES_LIB_C_SUPPORT = "Capturing call state requires libc support";

    ABIs() {
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+11/src/java.base/share/classes/jdk/internal/foreign/abi/UpcallLinker.java#L124-L134")
    static class Upcalls {
        Upcalls() {
        }

        static Binding.VMLoad[] argMoveBindings(CallingSequence callingSequence) {
            return (Binding.VMLoad[])callingSequence.argumentBindings().filter(Binding.VMLoad.class::isInstance).map(Binding.VMLoad.class::cast).toArray(Binding.VMLoad[]::new);
        }

        static Binding.VMStore[] retMoveBindings(CallingSequence callingSequence) {
            return (Binding.VMStore[])callingSequence.returnBindings().stream().filter(Binding.VMStore.class::isInstance).map(Binding.VMStore.class::cast).toArray(Binding.VMStore[]::new);
        }
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+11/src/java.base/share/classes/jdk/internal/foreign/abi/DowncallLinker.java#L122-L140")
    static class Downcalls {
        Downcalls() {
        }

        protected static Stream<Binding.VMStore> argMoveBindingsStream(CallingSequence callingSequence) {
            return callingSequence.argumentBindings().filter(Binding.VMStore.class::isInstance).map(Binding.VMStore.class::cast);
        }

        protected static Stream<Binding.VMLoad> retMoveBindingsStream(CallingSequence callingSequence) {
            return callingSequence.returnBindings().stream().filter(Binding.VMLoad.class::isInstance).map(Binding.VMLoad.class::cast);
        }

        protected static Binding.VMLoad[] retMoveBindings(CallingSequence callingSequence) {
            return (Binding.VMLoad[])Downcalls.retMoveBindingsStream(callingSequence).toArray(Binding.VMLoad[]::new);
        }

        static VMStorage[] toStorageArray(Binding.Move[] moves) {
            return (VMStorage[])Arrays.stream(moves).map(Binding.Move::storage).toArray(VMStorage[]::new);
        }
    }

    @BasedOnJDKClass.List(value={@BasedOnJDKClass(value=Windowsx64Linker.class), @BasedOnJDKClass(value=jdk.internal.foreign.abi.x64.windows.CallArranger.class)})
    static final class Win64
    extends X86_64 {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        private static final Method IS_IN_MEMORY_RETURN = ReflectionUtil.lookupMethod(jdk.internal.foreign.abi.x64.windows.CallArranger.class, (String)"isInMemoryReturn", (Class[])new Class[]{Optional.class});

        Win64() {
        }

        @Override
        protected CallingSequence makeCallingSequence(MethodType type, FunctionDescriptor desc, boolean forUpcall, LinkerOptions options) {
            return jdk.internal.foreign.abi.x64.windows.CallArranger.getBindings(type, desc, forUpcall, options).callingSequence();
        }

        @Override
        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected List<AbiUtils.Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
            List<AbiUtils.Adapter.Adaptation> adaptations = super.generateAdaptations(nep);
            AMD64 target = (AMD64)((SubstrateTargetDescription)ImageSingletons.lookup(SubstrateTargetDescription.class)).arch;
            boolean previousMatched = false;
            PlatformKind previousKind = null;
            for (int i = adaptations.size() - 1; i >= 0; --i) {
                PlatformKind kind = target.getPlatformKind(JavaKind.fromJavaClass((Class)nep.methodType().parameterType(i)));
                if ((kind.equals((Object)target.getPlatformKind(JavaKind.Float)) || kind.equals((Object)target.getPlatformKind(JavaKind.Double))) && nep.parametersAssignment()[i].type() == 0) {
                    assert (Objects.equals(previousKind, kind) && previousMatched);
                    assert (adaptations.get(i) == null);
                    adaptations.set(i, AbiUtils.Adapter.reinterpret(JavaKind.Long));
                    previousMatched = false;
                } else {
                    previousMatched = true;
                }
                previousKind = kind;
            }
            return adaptations;
        }

        @Override
        public void checkLibrarySupport() {
            VMError.guarantee((boolean)ForeignFunctionsRuntime.isLibcSupported(), (String)ABIs.REQUIRES_LIB_C_SUPPORT);
            VMError.guarantee((boolean)ForeignFunctionsRuntime.isWindowsApiSupported(), (String)"Capturing call state requires Windows API support");
        }

        @Override
        public Map<String, MemoryLayout> canonicalLayouts() {
            return SharedUtils.canonicalLayouts((ValueLayout)ValueLayout.JAVA_INT, (ValueLayout)ValueLayout.JAVA_LONG, (ValueLayout)ValueLayout.JAVA_CHAR);
        }

        @Override
        @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+13/src/java.base/share/classes/jdk/internal/foreign/abi/x64/windows/CallArranger.java#L139")
        public boolean dropReturn() {
            return false;
        }

        @Override
        public boolean isInMemoryReturn(Optional<MemoryLayout> returnLayout) {
            return (Boolean)ReflectionUtil.invokeMethod((Method)IS_IN_MEMORY_RETURN, null, (Object[])new Object[]{returnLayout});
        }
    }

    @BasedOnJDKClass.List(value={@BasedOnJDKClass(value=SysVx64Linker.class), @BasedOnJDKClass(value=CallArranger.class)})
    static final class SysV
    extends X86_64 {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        private static final Method IS_IN_MEMORY_RETURN = ReflectionUtil.lookupMethod(CallArranger.class, (String)"isInMemoryReturn", (Class[])new Class[]{Optional.class});

        SysV() {
        }

        @Override
        protected CallingSequence makeCallingSequence(MethodType type, FunctionDescriptor desc, boolean forUpcall, LinkerOptions options) {
            return CallArranger.getBindings(type, desc, forUpcall, options).callingSequence();
        }

        @Override
        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected List<AbiUtils.Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
            int last;
            VMStorage lastAssignment;
            List<AbiUtils.Adapter.Adaptation> adaptations = super.generateAdaptations(nep);
            VMStorage[] assignments = nep.parametersAssignment();
            if (assignments.length > 0 && (lastAssignment = assignments[last = assignments.length - 1]) != null && lastAssignment.equals(X86_64Architecture.Regs.rax)) {
                adaptations.set(last, AbiUtils.Adapter.drop());
            }
            return adaptations;
        }

        @Override
        public void checkLibrarySupport() {
            VMError.guarantee((boolean)ForeignFunctionsRuntime.isLibcSupported(), (String)ABIs.REQUIRES_LIB_C_SUPPORT);
        }

        @Override
        public Map<String, MemoryLayout> canonicalLayouts() {
            return SharedUtils.canonicalLayouts((ValueLayout)ValueLayout.JAVA_LONG, (ValueLayout)ValueLayout.JAVA_LONG, (ValueLayout)ValueLayout.JAVA_INT);
        }

        @Override
        @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+13/src/java.base/share/classes/jdk/internal/foreign/abi/x64/sysv/CallArranger.java#L147")
        public boolean dropReturn() {
            return true;
        }

        @Override
        public boolean isInMemoryReturn(Optional<MemoryLayout> returnLayout) {
            return (Boolean)ReflectionUtil.invokeMethod((Method)IS_IN_MEMORY_RETURN, null, (Object[])new Object[]{returnLayout});
        }
    }

    @BasedOnJDKClass.List(value={@BasedOnJDKClass(value=X86_64Architecture.class), @BasedOnJDKClass(value=DowncallLinker.class), @BasedOnJDKClass(value=UpcallLinker.class)})
    static abstract class X86_64
    extends AbiUtils {
        X86_64() {
        }

        @Override
        protected abstract CallingSequence makeCallingSequence(MethodType var1, FunctionDescriptor var2, boolean var3, LinkerOptions var4);

        @Override
        public AssignedLocation[] toMemoryAssignment(VMStorage[] argMoves, boolean forReturn) {
            block10: for (VMStorage move : argMoves) {
                if (move == null) continue;
                switch (move.type()) {
                    case 2: {
                        throw VMError.unsupportedFeature((String)"Unsupported register kind: X87");
                    }
                    case 3: {
                        if (!forReturn) continue block10;
                        throw VMError.unsupportedFeature((String)"Unsupported register kind for return: STACK");
                    }
                }
            }
            AssignedLocation[] storages = new AssignedLocation[argMoves.length];
            int i = 0;
            for (VMStorage move : argMoves) {
                if (move == null) {
                    storages[i++] = AssignedLocation.placeholder();
                    continue;
                }
                int n = i++;
                storages[n] = switch (move.type()) {
                    case 4 -> AssignedLocation.placeholder();
                    case 0 -> {
                        Register reg = (Register)AMD64.cpuRegisters.get(move.indexOrOffset());
                        if (!$assertionsDisabled && !reg.name.equals(move.debugName())) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && !reg.getRegisterCategory().equals((Object)AMD64.CPU)) {
                            throw new AssertionError();
                        }
                        yield AssignedLocation.forRegister((Register)reg, (JavaKind)JavaKind.Long);
                    }
                    case 1 -> {
                        Register reg = (Register)AMD64.xmmRegistersSSE.get(move.indexOrOffset());
                        if (!$assertionsDisabled && !reg.name.equals(move.debugName())) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && !reg.getRegisterCategory().equals((Object)AMD64.XMM)) {
                            throw new AssertionError();
                        }
                        yield AssignedLocation.forRegister((Register)reg, (JavaKind)JavaKind.Double);
                    }
                    case 3 -> AssignedLocation.forStack((int)move.indexOrOffset());
                    default -> throw VMError.unsupportedFeature((String)("Unhandled VMStorage: " + String.valueOf(move)));
                };
            }
            assert (i == storages.length);
            return storages;
        }

        @Override
        public AbiUtils.Registers upcallSpecialArgumentsRegisters() {
            return new AbiUtils.Registers(AMD64.r10, AMD64.r11);
        }

        @Override
        public int trampolineSize() {
            return 128;
        }

        @Override
        @Platforms(value={Platform.HOSTED_ONLY.class})
        public AbiUtils.TrampolineTemplate generateTrampolineTemplate() {
            AMD64Assembler asm = new AMD64Assembler((TargetDescription)ConfigurationValues.getTarget());
            ArrayList odas = new ArrayList(3);
            asm.setCodePatchingAnnotationConsumer(ca -> {
                if (ca instanceof AMD64BaseAssembler.OperandDataAnnotation) {
                    AMD64BaseAssembler.OperandDataAnnotation oda = (AMD64BaseAssembler.OperandDataAnnotation)ca;
                    odas.add(oda);
                }
            });
            Register mhRegister = this.upcallSpecialArgumentsRegisters().methodHandle();
            Register isolateRegister = this.upcallSpecialArgumentsRegisters().isolate();
            asm.movq(isolateRegister, 0L, true);
            asm.movq(mhRegister, 0L, true);
            asm.movq(mhRegister, new AMD64Address(mhRegister));
            asm.movq(AMD64.rax, 0L, true);
            asm.jmp(new AMD64Address(AMD64.rax, 0));
            assert (this.trampolineSize() - asm.position() >= 0);
            asm.nop(this.trampolineSize() - asm.position());
            byte[] assembly = asm.close(true);
            assert (assembly.length == this.trampolineSize());
            assert (odas.size() == 3);
            assert (odas.stream().allMatch(oda -> oda.operandSize == 8));
            return new AbiUtils.TrampolineTemplate(assembly, ((AMD64BaseAssembler.OperandDataAnnotation)odas.get((int)0)).operandPosition, ((AMD64BaseAssembler.OperandDataAnnotation)odas.get((int)1)).operandPosition, ((AMD64BaseAssembler.OperandDataAnnotation)odas.get((int)2)).operandPosition);
        }
    }

    @BasedOnJDKClass.List(value={@BasedOnJDKClass(value=MacOsAArch64Linker.class), @BasedOnJDKClass(value=MacOsAArch64CallArranger.class)})
    static final class MacOsAArch64
    extends ARM64 {
        MacOsAArch64() {
        }

        @Override
        protected CallingSequence makeCallingSequence(MethodType type, FunctionDescriptor desc, boolean forUpcall, LinkerOptions options) {
            return jdk.internal.foreign.abi.aarch64.CallArranger.MACOS.getBindings(type, desc, forUpcall, options).callingSequence();
        }

        @Override
        public void checkLibrarySupport() {
            VMError.guarantee((boolean)ForeignFunctionsRuntime.isLibcSupported(), (String)ABIs.REQUIRES_LIB_C_SUPPORT);
        }
    }

    @BasedOnJDKClass.List(value={@BasedOnJDKClass(value=LinuxAArch64Linker.class), @BasedOnJDKClass(value=LinuxAArch64CallArranger.class)})
    static final class LinuxAArch64
    extends ARM64 {
        LinuxAArch64() {
        }

        @Override
        protected CallingSequence makeCallingSequence(MethodType type, FunctionDescriptor desc, boolean forUpcall, LinkerOptions options) {
            return jdk.internal.foreign.abi.aarch64.CallArranger.LINUX.getBindings(type, desc, forUpcall, options).callingSequence();
        }

        @Override
        public void checkLibrarySupport() {
            VMError.guarantee((boolean)ForeignFunctionsRuntime.isLibcSupported(), (String)ABIs.REQUIRES_LIB_C_SUPPORT);
        }
    }

    @BasedOnJDKClass.List(value={@BasedOnJDKClass(value=AArch64Architecture.class), @BasedOnJDKClass(value=DowncallLinker.class), @BasedOnJDKClass(value=UpcallLinker.class)})
    static abstract class ARM64
    extends AbiUtils {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        private static final Method IS_IN_MEMORY_RETURN = ReflectionUtil.lookupMethod(jdk.internal.foreign.abi.aarch64.CallArranger.class, (String)"isInMemoryReturn", (Class[])new Class[]{Optional.class});

        ARM64() {
        }

        @Override
        public AbiUtils.Registers upcallSpecialArgumentsRegisters() {
            return new AbiUtils.Registers(SubstrateAArch64MacroAssembler.scratch1, SubstrateAArch64MacroAssembler.scratch2);
        }

        @Override
        public AssignedLocation[] toMemoryAssignment(VMStorage[] argMoves, boolean forReturn) {
            AssignedLocation[] storages = new AssignedLocation[argMoves.length];
            int i = 0;
            for (VMStorage move : argMoves) {
                if (move == null) {
                    storages[i++] = AssignedLocation.placeholder();
                    continue;
                }
                int n = i++;
                storages[n] = switch (move.type()) {
                    case 3 -> AssignedLocation.placeholder();
                    case 0 -> {
                        Register reg = (Register)AArch64.cpuRegisters.get(move.indexOrOffset());
                        if (!$assertionsDisabled && !reg.name.equals(move.debugName())) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && !reg.getRegisterCategory().equals((Object)AArch64.CPU)) {
                            throw new AssertionError();
                        }
                        yield AssignedLocation.forRegister((Register)reg, (JavaKind)JavaKind.Long);
                    }
                    case 1 -> {
                        Register reg = (Register)AArch64.simdRegisters.get(move.indexOrOffset());
                        if (!$assertionsDisabled && !reg.name.equals(move.debugName())) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && !reg.getRegisterCategory().equals((Object)AArch64.SIMD)) {
                            throw new AssertionError();
                        }
                        yield AssignedLocation.forRegister((Register)reg, (JavaKind)JavaKind.Double);
                    }
                    case 2 -> AssignedLocation.forStack((int)move.indexOrOffset());
                    default -> throw VMError.unsupportedFeature((String)("Unhandled VMStorage: " + String.valueOf(move)));
                };
            }
            assert (i == storages.length);
            return storages;
        }

        @Override
        public Map<String, MemoryLayout> canonicalLayouts() {
            return SharedUtils.canonicalLayouts((ValueLayout)ValueLayout.JAVA_LONG, (ValueLayout)ValueLayout.JAVA_LONG, (ValueLayout)ValueLayout.JAVA_INT);
        }

        @Override
        public int trampolineSize() {
            return 64;
        }

        @Override
        @Platforms(value={Platform.HOSTED_ONLY.class})
        public AbiUtils.TrampolineTemplate generateTrampolineTemplate() {
            SubstrateAArch64MacroAssembler masm = new SubstrateAArch64MacroAssembler((TargetDescription)ConfigurationValues.getTarget());
            Register mhRegister = this.upcallSpecialArgumentsRegisters().methodHandle();
            Register isolateRegister = this.upcallSpecialArgumentsRegisters().isolate();
            Label loadIsolate = new Label();
            masm.jmp(loadIsolate);
            int posIsolate = masm.position();
            masm.emitLong(1229801703532086340L);
            int posMHArray = masm.position();
            masm.emitLong(6148933456521300104L);
            int posCallTarget = masm.position();
            masm.emitLong(-7378678864199037748L);
            masm.bind(loadIsolate);
            masm.ldr(64, isolateRegister, AArch64Address.createPCLiteralAddress((int)64, (int)(posIsolate - masm.position())));
            masm.ldr(64, mhRegister, AArch64Address.createPCLiteralAddress((int)64, (int)(posMHArray - masm.position())));
            masm.ldr(64, mhRegister, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)mhRegister, (int)0));
            Register scratch = AArch64.r11;
            assert (!scratch.equals((Object)mhRegister) && !scratch.equals((Object)isolateRegister));
            masm.ldr(64, scratch, AArch64Address.createPCLiteralAddress((int)64, (int)(posCallTarget - masm.position())));
            masm.ldr(64, scratch, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, (Register)scratch, (int)0));
            masm.jmp(scratch);
            assert (this.trampolineSize() >= masm.position());
            masm.align(this.trampolineSize());
            byte[] assembly = masm.close(true);
            assert (assembly.length == this.trampolineSize());
            return new AbiUtils.TrampolineTemplate(assembly, posIsolate, posMHArray, posCallTarget);
        }

        @Override
        @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+13/src/java.base/share/classes/jdk/internal/foreign/abi/aarch64/CallArranger.java#L195")
        public boolean dropReturn() {
            return true;
        }

        @Override
        public boolean isInMemoryReturn(Optional<MemoryLayout> returnLayout) {
            return (Boolean)ReflectionUtil.invokeMethod((Method)IS_IN_MEMORY_RETURN, null, (Object[])new Object[]{returnLayout});
        }
    }

    static final class Unsupported
    extends AbiUtils {
        private final String name;

        Unsupported(String name) {
            this.name = name;
        }

        private <Z> Z fail() {
            throw VMError.unsupportedFeature((String)this.name());
        }

        private String name() {
            return "Unsupported ABI: " + this.name;
        }

        @Override
        protected CallingSequence makeCallingSequence(MethodType type, FunctionDescriptor desc, boolean forUpcall, LinkerOptions options) {
            return (CallingSequence)this.fail();
        }

        @Override
        public AssignedLocation[] toMemoryAssignment(VMStorage[] moves, boolean forReturn) {
            return (AssignedLocation[])this.fail();
        }

        @Override
        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected List<AbiUtils.Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
            return (List)this.fail();
        }

        @Override
        public void checkLibrarySupport() {
        }

        @Override
        public Map<String, MemoryLayout> canonicalLayouts() {
            return (Map)this.fail();
        }

        @Override
        public AbiUtils.Registers upcallSpecialArgumentsRegisters() {
            return (AbiUtils.Registers)this.fail();
        }

        @Override
        public int trampolineSize() {
            return (Integer)this.fail();
        }

        @Override
        public AbiUtils.TrampolineTemplate generateTrampolineTemplate() {
            return null;
        }

        @Override
        public boolean dropReturn() {
            return (Boolean)this.fail();
        }

        @Override
        public boolean isInMemoryReturn(Optional<MemoryLayout> returnLayout) {
            return (Boolean)this.fail();
        }
    }
}

