/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.foreign.ABIs;
import com.oracle.svm.core.foreign.JavaEntryPointInfo;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.foreign.Target_jdk_internal_foreign_abi_UpcallLinker_CallRegs;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.util.BasedOnJDKClass;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.MemoryLayout;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.word.Word;
import jdk.graal.compiler.word.WordCastNode;
import jdk.internal.foreign.CABI;
import jdk.internal.foreign.abi.Binding;
import jdk.internal.foreign.abi.CallingSequence;
import jdk.internal.foreign.abi.LinkerOptions;
import jdk.internal.foreign.abi.SharedUtils;
import jdk.internal.foreign.abi.VMStorage;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

@BasedOnJDKClass(value=SharedUtils.class)
public abstract class AbiUtils {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static AbiUtils create() {
        return switch (CABI.current()) {
            case CABI.SYS_V -> new ABIs.SysV();
            case CABI.WIN_64 -> new ABIs.Win64();
            case CABI.MAC_OS_AARCH_64 -> new ABIs.MacOsAArch64();
            case CABI.LINUX_AARCH_64 -> new ABIs.LinuxAArch64();
            default -> new ABIs.Unsupported(CABI.current().name());
        };
    }

    @Fold
    public static AbiUtils singleton() {
        return (AbiUtils)ImageSingletons.lookup(AbiUtils.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public abstract boolean dropReturn();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public abstract boolean isInMemoryReturn(Optional<MemoryLayout> var1);

    protected abstract CallingSequence makeCallingSequence(MethodType var1, FunctionDescriptor var2, boolean var3, LinkerOptions var4);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/java.base/share/classes/jdk/internal/foreign/abi/AbstractLinker.java#L99"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/java.base/share/classes/jdk/internal/foreign/abi/DowncallLinker.java#L71-L85")})
    public final NativeEntryPointInfo makeNativeEntrypoint(FunctionDescriptor desc, LinkerOptions linkerOptions) {
        MethodType type = desc.toMethodType();
        CallingSequence callingSequence = this.makeCallingSequence(type, desc, false, linkerOptions);
        Binding.Move[] argMoveBindings = (Binding.VMStore[])ABIs.Downcalls.argMoveBindingsStream(callingSequence).toArray(Binding.VMStore[]::new);
        VMStorage[] argMoves = ABIs.Downcalls.toStorageArray(argMoveBindings);
        VMStorage[] returnMoves = ABIs.Downcalls.toStorageArray(ABIs.Downcalls.retMoveBindings(callingSequence));
        MethodType boundaryType = callingSequence.calleeMethodType();
        boolean needsReturnBuffer = callingSequence.needsReturnBuffer();
        return NativeEntryPointInfo.make(argMoves, returnMoves, boundaryType, needsReturnBuffer, callingSequence.capturedStateMask(), callingSequence.needsTransition(), linkerOptions.allowsHeapAccess());
    }

    @BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+13/src/java.base/share/classes/jdk/internal/foreign/abi/AbstractLinker.java#L126"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/java.base/share/classes/jdk/internal/foreign/abi/UpcallLinker.java#L62-L110")})
    public final JavaEntryPointInfo makeJavaEntryPoint(FunctionDescriptor desc, LinkerOptions linkerOptions) {
        MethodType type = desc.toMethodType();
        CallingSequence callingSequence = this.makeCallingSequence(type, desc, true, linkerOptions);
        Binding.VMLoad[] argMoves = ABIs.Upcalls.argMoveBindings(callingSequence);
        Binding.VMStore[] retMoves = ABIs.Upcalls.retMoveBindings(callingSequence);
        VMStorage[] args = (VMStorage[])Arrays.stream(argMoves).map(Binding.Move::storage).toArray(VMStorage[]::new);
        VMStorage[] rets = (VMStorage[])Arrays.stream(retMoves).map(Binding.Move::storage).toArray(VMStorage[]::new);
        Target_jdk_internal_foreign_abi_UpcallLinker_CallRegs cr = new Target_jdk_internal_foreign_abi_UpcallLinker_CallRegs(args, rets);
        return JavaEntryPointInfo.make(callingSequence.callerMethodType(), cr, callingSequence.needsReturnBuffer(), callingSequence.returnBufferSize());
    }

    public abstract AssignedLocation[] toMemoryAssignment(VMStorage[] var1, boolean var2);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public final Adapter.Result.FullNativeAdaptation adapt(List<ValueNode> arguments, NativeEntryPointInfo nep) {
        return Adapter.adaptToNative(this, this.generateAdaptations(nep), arguments, nep);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public final Adapter.Result.TypeAdaptation adapt(JavaEntryPointInfo jep) {
        return Adapter.adaptFromNative(this, this.generateAdaptations(jep), jep);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/java.base/share/classes/jdk/internal/foreign/abi/CallingSequenceBuilder.java#L103-L147")
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected List<Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
        ArrayList<Object> adaptations = new ArrayList<Object>(Collections.nCopies(nep.methodType().parameterCount(), null));
        int current = 0;
        if (nep.needsReturnBuffer()) {
            adaptations.set(current++, Adapter.check(Long.TYPE));
        }
        adaptations.set(current++, Adapter.extract(Adapter.Extracted.CallTarget, Long.TYPE));
        VMStorage[] storages = nep.parametersAssignment();
        if (nep.capturesCallState()) {
            if (nep.allowHeapAccess()) {
                VMError.guarantee((storages[current] != null && storages[current + 1] == null ? 1 : 0) != 0);
                AbiUtils.handleCriticalWithHeapAccess(nep, current + 1, adaptations, Adapter.extractSegmentPair(Adapter.Extracted.CaptureBufferAddress));
                current += 2;
            } else {
                adaptations.set(current, Adapter.extract(Adapter.Extracted.CaptureBufferAddress, Long.TYPE));
                ++current;
            }
        }
        for (int i = current; i < storages.length; ++i) {
            VMStorage storage = storages[i];
            if (storage != null) continue;
            AbiUtils.handleCriticalWithHeapAccess(nep, i, adaptations, Adapter.computeAddressFromSegmentPair());
        }
        return adaptations;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/java.base/share/classes/jdk/internal/foreign/abi/x64/sysv/CallArranger.java#L280-L290")
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void handleCriticalWithHeapAccess(NativeEntryPointInfo nep, int i, List<Adapter.Adaptation> adaptations, Adapter.Adaptation adaptation) {
        VMError.guarantee((boolean)nep.allowHeapAccess(), (String)"A storage may only be null when the Linker.Option.critical(true) option is passed.");
        VMError.guarantee((JavaKind.fromJavaClass(nep.methodType().parameterArray()[i]) == JavaKind.Long && JavaKind.fromJavaClass(nep.methodType().parameterArray()[i - 1]) == JavaKind.Object ? 1 : 0) != 0, (String)"Storage is null, but the other parameters are inconsistent.\nStorage may be null only if its kind is Long and previous kind is Object.\nSee jdk/internal/foreign/abi/x64/sysv/CallArranger.java:286");
        VMError.guarantee((adaptations.get(i) == null && adaptations.get(i - 1) == null ? 1 : 0) != 0, (String)"This parameter already has an adaptation when it should not.");
        adaptations.set(i, Adapter.drop());
        adaptations.set(i - 1, adaptation);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected List<Adapter.Adaptation> generateAdaptations(JavaEntryPointInfo jep) {
        ArrayList<Object> adaptations = new ArrayList<Object>(Collections.nCopies(jep.handleType().parameterCount(), null));
        if (jep.buffersReturn()) {
            adaptations.set(0, Adapter.drop());
        }
        return adaptations;
    }

    public abstract void checkLibrarySupport();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public abstract Map<String, MemoryLayout> canonicalLayouts();

    public abstract Registers upcallSpecialArgumentsRegisters();

    public abstract int trampolineSize();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    abstract TrampolineTemplate generateTrampolineTemplate();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class Adapter {
        private static final Adaptation NOOP = new Adaptation(){

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                return List.of(parameter);
            }

            @Override
            public List<AssignedLocation> apply(AssignedLocation parameter) {
                return List.of(parameter);
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments, List<ValueNode> originalArguments, int originalArgumentIndex, Consumer<Node> appendToGraph) {
                return List.of(parameter);
            }
        };

        private static boolean allEqual(int reference, int ... values) {
            return Arrays.stream(values).allMatch(v -> v == reference);
        }

        private static boolean allSameSize(List<?> reference, List<?> ... others) {
            return Arrays.stream(others).allMatch(v -> v.size() == reference.size());
        }

        private Adapter() {
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public static Result.FullNativeAdaptation adaptToNative(AbiUtils self, List<Adaptation> adaptations, List<ValueNode> originalArguments, NativeEntryPointInfo nep) {
            List<ValueNode> originalUnmodifiableArguments = Collections.unmodifiableList(originalArguments);
            AssignedLocation[] originalAssignment = self.toMemoryAssignment(nep.parametersAssignment(), false);
            VMError.guarantee((boolean)Adapter.allEqual(adaptations.size(), originalUnmodifiableArguments.size(), nep.methodType().parameterCount(), originalAssignment.length));
            EnumMap<Extracted, ValueNode> extractedArguments = new EnumMap<Extracted, ValueNode>(Extracted.class);
            ArrayList<ValueNode> arguments = new ArrayList<ValueNode>();
            ArrayList<AssignedLocation> assignment = new ArrayList<AssignedLocation>();
            ArrayList argumentTypes = new ArrayList();
            ArrayList<Node> nodesToAppendToGraph = new ArrayList<Node>();
            int i = 0;
            for (Adaptation a : adaptations) {
                Adaptation adaptation = a;
                if (adaptation == null) {
                    adaptation = NOOP;
                }
                arguments.addAll(adaptation.apply(originalUnmodifiableArguments.get(i), extractedArguments, originalUnmodifiableArguments, i, nodesToAppendToGraph::add));
                assignment.addAll(adaptation.apply(originalAssignment[i]));
                argumentTypes.addAll(adaptation.apply((Class<?>)nep.methodType().parameterType(i)));
                VMError.guarantee((boolean)Adapter.allSameSize(arguments, assignment, argumentTypes));
                ++i;
            }
            assert (i == nep.methodType().parameterCount());
            VMError.guarantee((boolean)extractedArguments.containsKey((Object)Extracted.CallTarget));
            VMError.guarantee((!nep.capturesCallState() || extractedArguments.containsKey((Object)Extracted.CaptureBufferAddress) ? 1 : 0) != 0);
            for (int j = 0; j < arguments.size(); ++j) {
                VMError.guarantee((arguments.get(j) != null ? 1 : 0) != 0);
                VMError.guarantee((!((AssignedLocation)assignment.get(j)).isPlaceholder() || j == 0 && nep.needsReturnBuffer() ? 1 : 0) != 0);
            }
            return new Result.FullNativeAdaptation(extractedArguments, arguments, assignment, Arrays.stream(self.toMemoryAssignment(nep.returnsAssignment(), true)).toList(), MethodType.methodType(nep.methodType().returnType(), argumentTypes), nodesToAppendToGraph);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public static Result.TypeAdaptation adaptFromNative(AbiUtils self, List<Adaptation> adaptations, JavaEntryPointInfo jep) {
            AssignedLocation[] originalAssignment = self.toMemoryAssignment(jep.parametersAssignment(), false);
            ArrayList<AssignedLocation> assignment = new ArrayList<AssignedLocation>();
            ArrayList argumentTypes = new ArrayList();
            int i = 0;
            for (Adaptation a : adaptations) {
                Adaptation adaptation = a;
                if (adaptation == null) {
                    adaptation = NOOP;
                }
                assignment.addAll(adaptation.apply(originalAssignment[i]));
                argumentTypes.addAll(adaptation.apply((Class<?>)jep.handleType().parameterType(i)));
                ++i;
            }
            assert (i == jep.handleType().parameterCount());
            return new Result.TypeAdaptation(assignment, MethodType.methodType(jep.handleType().returnType(), argumentTypes));
        }

        public static Adaptation check(Class<?> type) {
            return new CheckType(Objects.requireNonNull(type));
        }

        public static Adaptation extract(Extracted as, Class<?> type) {
            return new ExtractSingle(as, type);
        }

        public static Adaptation extractSegmentPair(Extracted as) {
            return new ExtractSegmentPair(as);
        }

        public static Adaptation drop() {
            return Drop.SINGLETON;
        }

        public static Adaptation reinterpret(JavaKind to) {
            return new Reinterpret(to);
        }

        public static Adaptation computeAddressFromSegmentPair() {
            return ComputeAddressFromSegmentPair.SINGLETON;
        }

        public static enum Extracted {
            CallTarget,
            CaptureBufferAddress;

        }

        public static abstract class Adaptation {
            public abstract List<Class<?>> apply(Class<?> var1);

            public abstract List<AssignedLocation> apply(AssignedLocation var1);

            public abstract List<ValueNode> apply(ValueNode var1, Map<Extracted, ValueNode> var2, List<ValueNode> var3, int var4, Consumer<Node> var5);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public static class Result {

            @Platforms(value={Platform.HOSTED_ONLY.class})
            public record TypeAdaptation(List<AssignedLocation> parametersAssignment, MethodType callType) {
            }

            @Platforms(value={Platform.HOSTED_ONLY.class})
            public record FullNativeAdaptation(Map<Extracted, ValueNode> extractedArguments, List<ValueNode> arguments, List<AssignedLocation> parametersAssignment, List<AssignedLocation> returnsAssignment, MethodType callType, List<Node> nodesToAppendToGraph) {
                public ValueNode getArgument(Extracted id) {
                    return this.extractedArguments.get((Object)id);
                }
            }
        }

        private static final class CheckType
        extends Adaptation {
            private final Class<?> expected;

            private CheckType(Class<?> expected) {
                this.expected = expected;
            }

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                if (parameter != this.expected) {
                    throw new IllegalArgumentException("Expected type " + String.valueOf(this.expected) + ", got " + String.valueOf(parameter));
                }
                return List.of(parameter);
            }

            @Override
            public List<AssignedLocation> apply(AssignedLocation parameter) {
                return List.of(parameter);
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments, List<ValueNode> originalArguments, int originalArgumentIndex, Consumer<Node> appendToGraph) {
                return List.of(parameter);
            }
        }

        private static final class ExtractSingle
        extends Extract {
            private final Class<?> type;

            private ExtractSingle(Extracted as, Class<?> type) {
                super(Objects.requireNonNull(as));
                this.type = Objects.requireNonNull(type);
            }

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                if (this.type != null && parameter != this.type) {
                    throw new IllegalArgumentException("Expected type " + String.valueOf(this.type) + ", got " + String.valueOf(parameter));
                }
                return List.of();
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments, List<ValueNode> originalArguments, int originalArgumentIndex, Consumer<Node> appendToGraph) {
                if (this.as != null) {
                    if (extractedArguments.containsKey((Object)this.as)) {
                        throw new IllegalStateException("%s was already extracted (%s).".formatted(new Object[]{this.as, extractedArguments.get((Object)this.as)}));
                    }
                    extractedArguments.put(this.as, parameter);
                }
                return List.of();
            }
        }

        private static final class ExtractSegmentPair
        extends Extract {
            private ExtractSegmentPair(Extracted as) {
                super(Objects.requireNonNull(as));
            }

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                if (parameter != Object.class) {
                    throw new IllegalArgumentException("Expected type " + String.valueOf(Object.class) + ", got " + String.valueOf(parameter));
                }
                return List.of();
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments, List<ValueNode> originalArguments, int originalArgumentIndex, Consumer<Node> appendToGraph) {
                assert (this.as != null);
                if (extractedArguments.containsKey((Object)this.as)) {
                    throw new IllegalStateException("%s was already extracted (%s).".formatted(new Object[]{this.as, extractedArguments.get((Object)this.as)}));
                }
                ValueNode extracted = ComputeAddressFromSegmentPair.computeAbsolutePointerFromSegmentPair(parameter, originalArguments, originalArgumentIndex, appendToGraph);
                extractedArguments.put(this.as, extracted);
                return List.of();
            }
        }

        private static final class Drop
        extends Extract {
            private static final Drop SINGLETON = new Drop();

            private Drop() {
                super(null);
            }

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                return List.of();
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments, List<ValueNode> originalArguments, int originalArgumentIndex, Consumer<Node> appendToGraph) {
                return List.of();
            }
        }

        private static final class Reinterpret
        extends Adaptation {
            private final JavaKind to;

            private Reinterpret(JavaKind to) {
                this.to = to;
            }

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                return List.of(this.to.toJavaClass());
            }

            @Override
            public List<AssignedLocation> apply(AssignedLocation parameter) {
                return List.of(parameter);
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments, List<ValueNode> originalArguments, int originalArgumentIndex, Consumer<Node> appendToGraph) {
                ValueNode reinterpreted = ReinterpretNode.reinterpret((JavaKind)this.to, (ValueNode)parameter);
                appendToGraph.accept((Node)reinterpreted);
                return List.of(reinterpreted);
            }
        }

        private static final class ComputeAddressFromSegmentPair
        extends Adaptation {
            private static final ComputeAddressFromSegmentPair SINGLETON = new ComputeAddressFromSegmentPair();

            private ComputeAddressFromSegmentPair() {
            }

            @Override
            public List<Class<?>> apply(Class<?> parameter) {
                return List.of(Long.TYPE);
            }

            @Override
            public List<AssignedLocation> apply(AssignedLocation parameter) {
                return List.of(parameter);
            }

            @Override
            public List<ValueNode> apply(ValueNode parameter, Map<Extracted, ValueNode> extractedArguments, List<ValueNode> originalArguments, int originalArgumentIndex, Consumer<Node> appendToGraph) {
                return List.of(ComputeAddressFromSegmentPair.computeAbsolutePointerFromSegmentPair(parameter, originalArguments, originalArgumentIndex, appendToGraph));
            }

            static ValueNode computeAbsolutePointerFromSegmentPair(ValueNode parameter, List<ValueNode> originalArguments, int originalArgumentIndex, Consumer<Node> appendToGraph) {
                ValueNode offsetArg = originalArguments.get(originalArgumentIndex + 1);
                WordCastNode basePointer = WordCastNode.objectToUntrackedPointer((ValueNode)parameter, (JavaKind)ConfigurationValues.getWordKind());
                appendToGraph.accept((Node)basePointer);
                ValueNode absolutePointer = AddNode.add((ValueNode)basePointer, (ValueNode)offsetArg);
                appendToGraph.accept((Node)absolutePointer);
                return absolutePointer;
            }
        }

        private static abstract class Extract
        extends Adaptation {
            final Extracted as;

            private Extract(Extracted as) {
                this.as = as;
            }

            @Override
            public final List<AssignedLocation> apply(AssignedLocation parameter) {
                return List.of();
            }
        }
    }

    record TrampolineTemplate(byte[] assemblyTemplate, int isolateOffset, int methodHandleOffset, int stubOffset) {
        public Pointer write(Pointer at, Isolate isolate, Word methodHandle, Word stubPointer) {
            for (int i = 0; i < this.assemblyTemplate.length; ++i) {
                at.writeByte(i, this.assemblyTemplate[i]);
            }
            at.writeWord(this.isolateOffset, (WordBase)isolate);
            at.writeWord(this.methodHandleOffset, (WordBase)methodHandle);
            at.writeWord(this.stubOffset, (WordBase)stubPointer);
            return at.add(this.assemblyTemplate.length);
        }
    }

    public record Registers(Register methodHandle, Register isolate) {
    }
}

