/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.foreign.Target_jdk_internal_foreign_abi_UpcallLinker_CallRegs;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Objects;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.internal.foreign.abi.ABIDescriptor;
import jdk.internal.foreign.abi.VMStorage;

public final class JavaEntryPointInfo {
    private final MethodType methodType;
    private final VMStorage[] argumentsAssignment;
    private final VMStorage[] returnAssignment;
    private final int returnBufferSize;

    private JavaEntryPointInfo(MethodType methodType, VMStorage[] argumentsAssignment, VMStorage[] returnAssignment, long returnBufferSize) {
        this.methodType = Objects.requireNonNull(methodType);
        this.argumentsAssignment = Objects.requireNonNull(argumentsAssignment);
        this.returnAssignment = Objects.requireNonNull(returnAssignment);
        this.returnBufferSize = NumUtil.safeToInt((long)returnBufferSize);
    }

    static JavaEntryPointInfo make(MethodType mt, Target_jdk_internal_foreign_abi_UpcallLinker_CallRegs conv, boolean needsReturnBuffer, long returnBufferSize) {
        assert (needsReturnBuffer == conv.retRegs().length >= 2);
        return new JavaEntryPointInfo(mt, conv.argRegs(), conv.retRegs(), returnBufferSize);
    }

    static JavaEntryPointInfo make(MethodHandle mh, ABIDescriptor abi, Target_jdk_internal_foreign_abi_UpcallLinker_CallRegs conv, boolean needsReturnBuffer, long returnBufferSize) {
        return JavaEntryPointInfo.make(mh.type(), conv, needsReturnBuffer, returnBufferSize);
    }

    public MethodType cMethodType() {
        MethodType mt = this.methodType;
        if (this.buffersReturn()) {
            mt = mt.dropParameterTypes(0, 1);
        }
        return mt;
    }

    public MethodType handleType() {
        return this.methodType;
    }

    public boolean buffersReturn() {
        return this.returnAssignment.length >= 2;
    }

    public VMStorage[] parametersAssignment() {
        return this.argumentsAssignment;
    }

    public VMStorage[] returnAssignment() {
        return this.returnAssignment;
    }

    public int returnBufferSize() {
        assert (this.buffersReturn());
        return this.returnBufferSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaEntryPointInfo that = (JavaEntryPointInfo)o;
        return this.returnBufferSize == that.returnBufferSize && Objects.equals(this.methodType, that.methodType) && Arrays.equals(this.argumentsAssignment, that.argumentsAssignment) && Arrays.equals(this.returnAssignment, that.returnAssignment);
    }

    public int hashCode() {
        return Objects.hash(this.methodType, this.returnBufferSize, Arrays.hashCode(this.argumentsAssignment), Arrays.hashCode(this.returnAssignment));
    }
}

