/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.AbstractRuntimeCodeInstaller;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

final class TrampolineSet {
    private static final int FREED = -1;
    private final List<PinnedObject> pins = new ArrayList<PinnedObject>();
    private int assigned = 0;
    private int freed = 0;
    private final int trampolineCount = TrampolineSet.maxTrampolineCount();
    private final PointerBase[] methodHandles = new PointerBase[this.trampolineCount];
    private final CFunctionPointer[] stubs = new CFunctionPointer[this.trampolineCount];
    private final BitSet patchedStubs;
    private final Pointer trampolines;

    private static UnsignedWord allocationSize() {
        return VirtualMemoryProvider.get().getGranularity();
    }

    private static UnsignedWord alignment() {
        return Word.unsigned((int)SubstrateOptions.codeAlignment());
    }

    private static int maxTrampolineCount() {
        long result = TrampolineSet.allocationSize().rawValue() / (long)AbiUtils.singleton().trampolineSize();
        return NumUtil.safeToInt((long)result);
    }

    public static Pointer getAllocationBase(Pointer ptr) {
        UnsignedWord offset = ptr.unsignedRemainder(TrampolineSet.allocationSize());
        assert (offset.belowOrEqual(TrampolineSet.allocationSize()));
        assert (offset.belowOrEqual(Integer.MAX_VALUE));
        assert (offset.unsignedRemainder(AbiUtils.singleton().trampolineSize()).equal(0));
        return ptr.subtract(offset);
    }

    private static BitSet initializedPatchedStubs(int nbits) {
        BitSet patchedStubs = null;
        assert ((patchedStubs = new BitSet(nbits)).isEmpty());
        return patchedStubs;
    }

    private boolean getAndSetPatchedStub(int id) {
        assert (this.patchedStubs != null);
        boolean res = this.patchedStubs.get(id);
        this.patchedStubs.set(id);
        return res;
    }

    private PinnedObject pin(Object object) {
        PinnedObject pinned = PinnedObject.create((Object)object);
        this.pins.add(pinned);
        return pinned;
    }

    TrampolineSet(AbiUtils.TrampolineTemplate template) {
        assert (TrampolineSet.allocationSize().rawValue() % (long)AbiUtils.singleton().trampolineSize() == 0L);
        assert (this.trampolineCount <= TrampolineSet.maxTrampolineCount());
        this.trampolines = this.prepareTrampolines(this.pin(this.methodHandles), this.pin(this.stubs), template);
        this.patchedStubs = TrampolineSet.initializedPatchedStubs(this.stubs.length);
    }

    Pointer base() {
        return this.trampolines;
    }

    boolean hasFreeTrampolines() {
        assert (0 <= this.assigned && this.assigned <= this.trampolineCount || this.assigned == -1);
        return this.assigned != -1 && this.assigned != this.trampolineCount;
    }

    Pointer assignTrampoline(MethodHandle methodHandle, CFunctionPointer upcallStubPointer) {
        PinnedObject pinned = this.pin(methodHandle);
        int id = this.assigned++;
        this.methodHandles[id] = pinned.addressOfObject();
        this.stubs[id] = upcallStubPointer;
        assert (!this.patchedStubs.get(id));
        return this.trampolines.add(id * AbiUtils.singleton().trampolineSize());
    }

    void patchTrampolineForDirectUpcall(Pointer trampolinePointer, CFunctionPointer directUpcallStubPointer) {
        VMError.guarantee((boolean)trampolinePointer.aboveOrEqual((UnsignedWord)this.trampolines), (String)"invalid trampoline pointer");
        int id = UnsignedUtils.safeToInt((UnsignedWord)trampolinePointer.subtract((UnsignedWord)this.trampolines).unsignedDivide(AbiUtils.singleton().trampolineSize()));
        VMError.guarantee((id >= 0 && id < this.stubs.length ? 1 : 0) != 0, (String)"invalid trampoline id");
        assert (!this.getAndSetPatchedStub(id)) : "attempt to patch trampoline twice";
        this.stubs[id] = directUpcallStubPointer;
    }

    private Pointer prepareTrampolines(PinnedObject mhsArray, PinnedObject stubsArray, AbiUtils.TrampolineTemplate template) {
        UnsignedWord pageSize = TrampolineSet.allocationSize();
        Pointer page = CommittedMemoryProvider.get().allocateExecutableMemory(pageSize, Word.unsigned((int)SubstrateOptions.codeAlignment()));
        if (page.isNull()) {
            throw new OutOfMemoryError("Could not allocate memory for trampolines.");
        }
        VMError.guarantee((boolean)page.unsignedRemainder(pageSize).equal(0), (String)"Trampoline allocation must be aligned to allocationSize().");
        Pointer it = page;
        Pointer end = page.add(pageSize);
        for (int i = 0; i < this.trampolineCount; ++i) {
            VMError.guarantee((boolean)TrampolineSet.getAllocationBase(it).equal((UnsignedWord)page));
            it = template.write(it, CurrentIsolate.getIsolate(), (Word)mhsArray.addressOfArrayElement(i), (Word)stubsArray.addressOfArrayElement(i));
            VMError.guarantee((boolean)it.belowOrEqual((UnsignedWord)end), (String)"Not enough memory was allocated to hold trampolines");
        }
        VMError.guarantee((VirtualMemoryProvider.get().protect((PointerBase)page, pageSize, 4) == 0 ? 1 : 0) != 0, (String)"Error when making the trampoline allocation executable");
        if (AbstractRuntimeCodeInstaller.RuntimeCodeInstallerPlatformHelper.singleton().needsInstructionCacheSynchronization()) {
            new InstructionCacheOperation(page.rawValue(), pageSize.rawValue()).enqueue();
        }
        return page;
    }

    boolean tryFree() {
        ++this.freed;
        assert (this.freed <= this.trampolineCount);
        if (this.freed < this.trampolineCount) {
            return false;
        }
        for (PinnedObject pinned : this.pins) {
            pinned.close();
        }
        CommittedMemoryProvider.get().freeExecutableMemory((PointerBase)this.trampolines, TrampolineSet.allocationSize(), TrampolineSet.alignment());
        this.assigned = -1;
        if (this.patchedStubs != null) {
            this.patchedStubs.clear();
        }
        return true;
    }

    private static class InstructionCacheOperation
    extends JavaVMOperation {
        private final long codeStart;
        private final long codeSize;

        InstructionCacheOperation(long codeStart, long codeSize) {
            super(VMOperationInfos.get(InstructionCacheOperation.class, (String)"Prepare FFM API trampoline set", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
            this.codeStart = codeStart;
            this.codeSize = codeSize;
        }

        protected void operate() {
            AbstractRuntimeCodeInstaller.RuntimeCodeInstallerPlatformHelper.singleton().performCodeSynchronization(this.codeStart, this.codeSize);
        }
    }
}

