/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.svm.core.util.BasedOnJDKClass;
import java.lang.foreign.MemoryLayout;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@BasedOnJDKClass(value=MemoryLayout.class)
@Platforms(value={Platform.HOSTED_ONLY.class})
final class MemoryLayoutParser {
    private static final String ALIGN = "align";
    private static final String STRUCT = "struct";
    private static final String UNION = "union";
    private static final String SEQUENCE = "sequence";
    private static final String PADDING = "padding";
    private final String input;
    private final Map<String, MemoryLayout> canonicalLayouts;
    private int at;

    private MemoryLayoutParser(String input, Map<String, MemoryLayout> canonicalLayouts) {
        this.input = input;
        this.canonicalLayouts = canonicalLayouts;
        this.at = 0;
    }

    private char peek() {
        if (this.at == this.input.length()) {
            return '\u0000';
        }
        return this.input.charAt(this.at);
    }

    private char consume() {
        if (this.at == this.input.length()) {
            return '\u0000';
        }
        return this.input.charAt(this.at++);
    }

    private String consumeName() {
        int start = this.at;
        char c = this.peek();
        while (Character.getType(c) == 2 || c == '_' || c == '*' || c == ' ') {
            this.consume();
            c = this.peek();
        }
        return this.input.substring(start, this.at).trim().replaceAll("\\h+", " ");
    }

    private String peekName() {
        int start = this.at;
        String word = this.consumeName();
        this.at = start;
        return word;
    }

    private void discardSpaces() {
        while (Character.isSpaceChar(this.peek())) {
            this.consume();
        }
    }

    private void consumeChecked(char expected) throws MemoryLayoutParserException {
        char v = this.consume();
        if (v != expected) {
            throw new MemoryLayoutParserException("Expected " + expected + " but got " + v + " in " + this.input);
        }
    }

    private long parseLong() throws MemoryLayoutParserException {
        int start = this.at;
        if (!Character.isDigit(this.peek())) {
            throw new MemoryLayoutParserException("Expected a number at position " + this.at + " in \"" + this.input + "\"");
        }
        char c = this.peek();
        while (Character.isLetterOrDigit(c) || c == '_') {
            this.consume();
            c = this.peek();
        }
        String substring = this.input.substring(start, this.at);
        try {
            return Long.parseLong(substring);
        }
        catch (NumberFormatException e) {
            throw new MemoryLayoutParserException("Expected a long at position " + start + " in \"" + this.input + "\"");
        }
    }

    private void consumeNameChecked(String name) {
        String actualName = this.consumeName();
        assert (name.equals(actualName));
    }

    private void checkDone() throws MemoryLayoutParserException {
        if (this.at < this.input.length()) {
            throw new MemoryLayoutParserException("Parsing ended (at " + this.at + ") before its end: " + this.input);
        }
    }

    private MemoryLayout[] parseLayoutList() throws MemoryLayoutParserException {
        this.discardSpaces();
        this.consumeChecked('(');
        this.discardSpaces();
        ArrayList<MemoryLayout> elements = new ArrayList<MemoryLayout>();
        if (this.peek() != ')') {
            elements.add(this.parseLayout());
            this.discardSpaces();
        }
        while (this.peek() != ')') {
            this.consumeChecked(',');
            this.discardSpaces();
            elements.add(this.parseLayout());
            this.discardSpaces();
        }
        this.consumeChecked(')');
        return (MemoryLayout[])elements.toArray(MemoryLayout[]::new);
    }

    private MemoryLayout parseLayout() throws MemoryLayoutParserException {
        return switch (this.peekName()) {
            case ALIGN -> this.parseAlignment();
            case STRUCT -> this.parseGroupLayout(STRUCT, MemoryLayout::structLayout);
            case UNION -> this.parseGroupLayout(UNION, MemoryLayout::unionLayout);
            case SEQUENCE -> this.parseSequenceLayout();
            case PADDING -> this.parsePaddingLayout();
            default -> this.parseValueLayout();
        };
    }

    private MemoryLayout parseGroupLayout(String name, Function<MemoryLayout[], MemoryLayout> factory) throws MemoryLayoutParserException {
        this.consumeNameChecked(name);
        return factory.apply(this.parseLayoutList());
    }

    private MemoryLayout parseAlignment() throws MemoryLayoutParserException {
        this.consumeNameChecked(ALIGN);
        this.consumeChecked('(');
        long alignment = this.parseLong();
        this.consumeChecked(',');
        MemoryLayout element = this.parseLayout();
        this.consumeChecked(')');
        return element.withByteAlignment(alignment);
    }

    private MemoryLayout parsePaddingLayout() throws MemoryLayoutParserException {
        this.consumeNameChecked(PADDING);
        this.consumeChecked('(');
        long padding = this.parseLong();
        this.consumeChecked(')');
        return MemoryLayout.paddingLayout(padding);
    }

    private MemoryLayout parseSequenceLayout() throws MemoryLayoutParserException {
        this.consumeNameChecked(SEQUENCE);
        this.consumeChecked('(');
        long size = this.parseLong();
        this.consumeChecked(',');
        MemoryLayout element = this.parseLayout();
        this.consumeChecked(')');
        return MemoryLayout.sequenceLayout(size, element);
    }

    private MemoryLayout parseValueLayout() throws MemoryLayoutParserException {
        String name = this.consumeName();
        if (!this.canonicalLayouts.containsKey(name)) {
            throw new MemoryLayoutParserException("Unknown value layout: " + name + " at " + this.at + " in " + this.input);
        }
        return this.canonicalLayouts.get(name);
    }

    public static MemoryLayout parse(String input, Map<String, MemoryLayout> canonicalLayouts) throws MemoryLayoutParserException {
        MemoryLayoutParser parser = new MemoryLayoutParser(input, canonicalLayouts);
        MemoryLayout res = parser.parseLayout();
        parser.checkDone();
        return res;
    }

    public static Optional<MemoryLayout> parseAllowVoid(String input, Map<String, MemoryLayout> canonicalLayouts) throws MemoryLayoutParserException {
        if ("void".equals(input.trim())) {
            return Optional.empty();
        }
        return Optional.of(MemoryLayoutParser.parse(input, canonicalLayouts));
    }

    protected static final class MemoryLayoutParserException
    extends Exception {
        public MemoryLayoutParserException(String msg) {
            super(msg);
        }
    }
}

