// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: GraalOptions.java
package jdk.graal.compiler.core.common;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class GraalOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(GraalOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "AlwaysInlineVTableStubs": {
            return OptionDescriptor.create(
                /*name*/ "AlwaysInlineVTableStubs",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.AlwaysInlineVTableStubs,
                /*fieldName*/ "AlwaysInlineVTableStubs",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ArrayRegionEqualsConstantLimit": {
            return OptionDescriptor.create(
                /*name*/ "ArrayRegionEqualsConstantLimit",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Evaluates array region equality checks at compile time if the receiver is a constant and the length of the array is less than this value.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.ArrayRegionEqualsConstantLimit,
                /*fieldName*/ "ArrayRegionEqualsConstantLimit",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AssemblyGCBarriers": {
            return OptionDescriptor.create(
                /*name*/ "AssemblyGCBarriers",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use generated assembly for GC barriers if supported by the platform",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.AssemblyGCBarriers,
                /*fieldName*/ "AssemblyGCBarriers",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AssemblyGCBarriersSlowPathOnly": {
            return OptionDescriptor.create(
                /*name*/ "AssemblyGCBarriersSlowPathOnly",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Force use of slow path for assembly GC barriers. Intended for debugging only.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.AssemblyGCBarriersSlowPathOnly,
                /*fieldName*/ "AssemblyGCBarriersSlowPathOnly",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConditionalElimination": {
            return OptionDescriptor.create(
                /*name*/ "ConditionalElimination",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Eliminates redundant conditional expressions and statements where possible. This can improve performance because fewer logic instructions have to be executed.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.ConditionalElimination,
                /*fieldName*/ "ConditionalElimination",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConditionalEliminationMaxIterations": {
            return OptionDescriptor.create(
                /*name*/ "ConditionalEliminationMaxIterations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.ConditionalEliminationMaxIterations,
                /*fieldName*/ "ConditionalEliminationMaxIterations",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeoptALot": {
            return OptionDescriptor.create(
                /*name*/ "DeoptALot",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.DeoptALot,
                /*fieldName*/ "DeoptALot",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeoptsToDisableOptimisticOptimization": {
            return OptionDescriptor.create(
                /*name*/ "DeoptsToDisableOptimisticOptimization",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the number of deoptimizations allowed per compilation unit until optimistic optimizations are disabled.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.DeoptsToDisableOptimisticOptimization,
                /*fieldName*/ "DeoptsToDisableOptimisticOptimization",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EagerSnippets": {
            return OptionDescriptor.create(
                /*name*/ "EagerSnippets",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Eagerly construct extra snippet info.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.EagerSnippets,
                /*fieldName*/ "EagerSnippets",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EarlyGVN": {
            return OptionDescriptor.create(
                /*name*/ "EarlyGVN",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs early global value numbering on statements and expressions directly after parsing. This can clean up the intermediate representation and simplify later optimizations. ",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.EarlyGVN,
                /*fieldName*/ "EarlyGVN",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EarlyLICM": {
            return OptionDescriptor.create(
                /*name*/ "EarlyLICM",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs early loop-invariant code motion.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.EarlyLICM,
                /*fieldName*/ "EarlyLICM",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EmitStringSubstitutions": {
            return OptionDescriptor.create(
                /*name*/ "EmitStringSubstitutions",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Emits substitutions for String methods. This can improve performance because the compiler can use optimized intrinsics for certain string operations.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.EmitStringSubstitutions,
                /*fieldName*/ "EmitStringSubstitutions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableFixReadsConditionalElimination": {
            return OptionDescriptor.create(
                /*name*/ "EnableFixReadsConditionalElimination",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.EnableFixReadsConditionalElimination,
                /*fieldName*/ "EnableFixReadsConditionalElimination",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EscapeAnalysisIterations": {
            return OptionDescriptor.create(
                /*name*/ "EscapeAnalysisIterations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.EscapeAnalysisIterations,
                /*fieldName*/ "EscapeAnalysisIterations",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EscapeAnalysisLoopCutoff": {
            return OptionDescriptor.create(
                /*name*/ "EscapeAnalysisLoopCutoff",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.EscapeAnalysisLoopCutoff,
                /*fieldName*/ "EscapeAnalysisLoopCutoff",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EscapeAnalyzeOnly": {
            return OptionDescriptor.create(
                /*name*/ "EscapeAnalyzeOnly",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.EscapeAnalyzeOnly,
                /*fieldName*/ "EscapeAnalyzeOnly",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FloatingDivNodes": {
            return OptionDescriptor.create(
                /*name*/ "FloatingDivNodes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Try to float non-constant division operations to expose global value numbering of divisions.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.FloatingDivNodes,
                /*fieldName*/ "FloatingDivNodes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FullUnroll": {
            return OptionDescriptor.create(
                /*name*/ "FullUnroll",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs loop unrolling optimization. ",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.FullUnroll,
                /*fieldName*/ "FullUnroll",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GCDebugStartCycle": {
            return OptionDescriptor.create(
                /*name*/ "GCDebugStartCycle",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Start tracing compiled GC barriers after N garbage collections (disabled if N <= 0).",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.GCDebugStartCycle,
                /*fieldName*/ "GCDebugStartCycle",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GenLoopSafepoints": {
            return OptionDescriptor.create(
                /*name*/ "GenLoopSafepoints",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.GenLoopSafepoints,
                /*fieldName*/ "GenLoopSafepoints",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GuardPriorities": {
            return OptionDescriptor.create(
                /*name*/ "GuardPriorities",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.GuardPriorities,
                /*fieldName*/ "GuardPriorities",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HotSpotPrintInlining": {
            return OptionDescriptor.create(
                /*name*/ "HotSpotPrintInlining",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print inlining optimizations",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.HotSpotPrintInlining,
                /*fieldName*/ "HotSpotPrintInlining",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineEverything": {
            return OptionDescriptor.create(
                /*name*/ "InlineEverything",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.InlineEverything,
                /*fieldName*/ "InlineEverything",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineGraalStubs": {
            return OptionDescriptor.create(
                /*name*/ "InlineGraalStubs",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Embeds all the emitted code for Graal-generated stubs.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.InlineGraalStubs,
                /*fieldName*/ "InlineGraalStubs",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineMegamorphicCalls": {
            return OptionDescriptor.create(
                /*name*/ "InlineMegamorphicCalls",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inline calls with megamorphic type profile (i.e., not all types could be recorded).",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.InlineMegamorphicCalls,
                /*fieldName*/ "InlineMegamorphicCalls",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineMonomorphicCalls": {
            return OptionDescriptor.create(
                /*name*/ "InlineMonomorphicCalls",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inline calls with monomorphic type profile.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.InlineMonomorphicCalls,
                /*fieldName*/ "InlineMonomorphicCalls",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlinePolymorphicCalls": {
            return OptionDescriptor.create(
                /*name*/ "InlinePolymorphicCalls",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inline calls with polymorphic type profile.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.InlinePolymorphicCalls,
                /*fieldName*/ "InlinePolymorphicCalls",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineVTableStubs": {
            return OptionDescriptor.create(
                /*name*/ "InlineVTableStubs",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Inlines the vtable stub for method dispatch during inlining.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.InlineVTableStubs,
                /*fieldName*/ "InlineVTableStubs",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Intrinsify": {
            return OptionDescriptor.create(
                /*name*/ "Intrinsify",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Uses compiler intrinsifications.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.Intrinsify,
                /*fieldName*/ "Intrinsify",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IsolatedLoopHeaderAlignment": {
            return OptionDescriptor.create(
                /*name*/ "IsolatedLoopHeaderAlignment",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Alignment in bytes for loop header blocks that have no fall through paths.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.IsolatedLoopHeaderAlignment,
                /*fieldName*/ "IsolatedLoopHeaderAlignment",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LimitInlinedInvokes": {
            return OptionDescriptor.create(
                /*name*/ "LimitInlinedInvokes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Double.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.LimitInlinedInvokes,
                /*fieldName*/ "LimitInlinedInvokes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopHeaderAlignment": {
            return OptionDescriptor.create(
                /*name*/ "LoopHeaderAlignment",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the alignment in bytes for loop header blocks.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.LoopHeaderAlignment,
                /*fieldName*/ "LoopHeaderAlignment",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopMaxUnswitch": {
            return OptionDescriptor.create(
                /*name*/ "LoopMaxUnswitch",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.LoopMaxUnswitch,
                /*fieldName*/ "LoopMaxUnswitch",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopPeeling": {
            return OptionDescriptor.create(
                /*name*/ "LoopPeeling",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs loop peeling optimization.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.LoopPeeling,
                /*fieldName*/ "LoopPeeling",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopPredication": {
            return OptionDescriptor.create(
                /*name*/ "LoopPredication",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Hoists array bounds checks out of simple loops. This is ignored if SpeculativeGuardMovement is enabled.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.LoopPredication,
                /*fieldName*/ "LoopPredication",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopPredicationMainPath": {
            return OptionDescriptor.create(
                /*name*/ "LoopPredicationMainPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Restricts LoopPredication to only focus on array bounds checks that dominate the back edge of a loop.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.LoopPredicationMainPath,
                /*fieldName*/ "LoopPredicationMainPath",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoopUnswitch": {
            return OptionDescriptor.create(
                /*name*/ "LoopUnswitch",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs loop unswitching optimization.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.LoopUnswitch,
                /*fieldName*/ "LoopUnswitch",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MatchExpressions": {
            return OptionDescriptor.create(
                /*name*/ "MatchExpressions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allow backend to match complex expressions.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.MatchExpressions,
                /*fieldName*/ "MatchExpressions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumDesiredSize": {
            return OptionDescriptor.create(
                /*name*/ "MaximumDesiredSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum desired size of the compiler graph in nodes.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.MaximumDesiredSize,
                /*fieldName*/ "MaximumDesiredSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumEscapeAnalysisArrayLength": {
            return OptionDescriptor.create(
                /*name*/ "MaximumEscapeAnalysisArrayLength",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the maximum length of an array that will be escape analyzed.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.MaximumEscapeAnalysisArrayLength,
                /*fieldName*/ "MaximumEscapeAnalysisArrayLength",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumInliningSize": {
            return OptionDescriptor.create(
                /*name*/ "MaximumInliningSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the maximum graph size (measured in nodes) for which inlining is explored for each call site.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.MaximumInliningSize,
                /*fieldName*/ "MaximumInliningSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumRecursiveInlining": {
            return OptionDescriptor.create(
                /*name*/ "MaximumRecursiveInlining",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the maximum level of recursive inlining.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.MaximumRecursiveInlining,
                /*fieldName*/ "MaximumRecursiveInlining",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MegamorphicInliningMinMethodProbability": {
            return OptionDescriptor.create(
                /*name*/ "MegamorphicInliningMinMethodProbability",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Double.class,
                /*help*/ "Minimum probability for methods to be inlined for megamorphic type profiles.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.MegamorphicInliningMinMethodProbability,
                /*fieldName*/ "MegamorphicInliningMinMethodProbability",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MinimalBulkZeroingSize": {
            return OptionDescriptor.create(
                /*name*/ "MinimalBulkZeroingSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "If applicable, uses bulk zeroing instructions when the zeroing size in bytes exceeds this threshold.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.MinimalBulkZeroingSize,
                /*fieldName*/ "MinimalBulkZeroingSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MinimumPeelFrequency": {
            return OptionDescriptor.create(
                /*name*/ "MinimumPeelFrequency",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Float.class,
                /*help*/ "Minimum frequency a loop must have to be considered for loop peeling.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.MinimumPeelFrequency,
                /*fieldName*/ "MinimumPeelFrequency",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OmitHotExceptionStacktrace": {
            return OptionDescriptor.create(
                /*name*/ "OmitHotExceptionStacktrace",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OmitHotExceptionStacktrace,
                /*fieldName*/ "OmitHotExceptionStacktrace",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptAssumptions": {
            return OptionDescriptor.create(
                /*name*/ "OptAssumptions",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Uses assumptions during compilation that may later be invalidated and cause code to be deoptimized.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptAssumptions,
                /*fieldName*/ "OptAssumptions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptConvertDeoptsToGuards": {
            return OptionDescriptor.create(
                /*name*/ "OptConvertDeoptsToGuards",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Replaces deoptimization points with movable guards where possible. This can help the optimizer to apply better code movement optimizations.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptConvertDeoptsToGuards,
                /*fieldName*/ "OptConvertDeoptsToGuards",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptDeoptimizationGrouping": {
            return OptionDescriptor.create(
                /*name*/ "OptDeoptimizationGrouping",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptDeoptimizationGrouping,
                /*fieldName*/ "OptDeoptimizationGrouping",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptDevirtualizeInvokesOptimistically": {
            return OptionDescriptor.create(
                /*name*/ "OptDevirtualizeInvokesOptimistically",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptDevirtualizeInvokesOptimistically,
                /*fieldName*/ "OptDevirtualizeInvokesOptimistically",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptEliminateGuards": {
            return OptionDescriptor.create(
                /*name*/ "OptEliminateGuards",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptEliminateGuards,
                /*fieldName*/ "OptEliminateGuards",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptFloatingReads": {
            return OptionDescriptor.create(
                /*name*/ "OptFloatingReads",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs floating-read optimization. This enables memory read operations to freely move in control-flow while respecting memory (anti)-dependencies. This helps to reduce memory accesses and can improve performance. ",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptFloatingReads,
                /*fieldName*/ "OptFloatingReads",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptImplicitNullChecks": {
            return OptionDescriptor.create(
                /*name*/ "OptImplicitNullChecks",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Uses trapping null checks where possible to reduce explicit control flow for null checks. This can improve performance because explicit null checks do not have to be performed.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptImplicitNullChecks,
                /*fieldName*/ "OptImplicitNullChecks",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptReadElimination": {
            return OptionDescriptor.create(
                /*name*/ "OptReadElimination",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Tries to remove redundant memory accesses (for example, successive reads of a non-volatile Java field).",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptReadElimination,
                /*fieldName*/ "OptReadElimination",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptScheduleOutOfLoops": {
            return OptionDescriptor.create(
                /*name*/ "OptScheduleOutOfLoops",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptScheduleOutOfLoops,
                /*fieldName*/ "OptScheduleOutOfLoops",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptimizeDiv": {
            return OptionDescriptor.create(
                /*name*/ "OptimizeDiv",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Optimize integer division operation by using various mathematical foundations to  express it in faster, equivalent, arithmetic.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptimizeDiv,
                /*fieldName*/ "OptimizeDiv",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OptimizeLongJumps": {
            return OptionDescriptor.create(
                /*name*/ "OptimizeLongJumps",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "AMD64 only: Replace forward jumps (jmp, jcc) with equivalent but smaller instructions if the actual jump displacement fits in one byte.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.OptimizeLongJumps,
                /*fieldName*/ "OptimizeLongJumps",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PartialEscapeAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "PartialEscapeAnalysis",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs partial escape analysis and scalar replacement optimization.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.PartialEscapeAnalysis,
                /*fieldName*/ "PartialEscapeAnalysis",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PartialUnroll": {
            return OptionDescriptor.create(
                /*name*/ "PartialUnroll",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Performs partial loop unrolling optimizations. This is a special form of loop unrolling that splits a loop into a main and a post loop. The main loop can then be unrolled by a fixed amount of iterations. The post-loop performs any necessary fixup iterations. This can improve performance because the loop control overhead is reduced in the unrolled version.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.PartialUnroll,
                /*fieldName*/ "PartialUnroll",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PreferUnsignedComparison": {
            return OptionDescriptor.create(
                /*name*/ "PreferUnsignedComparison",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Rewrite signed comparisons to unsigned ones if the result is equal.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.PreferUnsignedComparison,
                /*fieldName*/ "PreferUnsignedComparison",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintProfilingInformation": {
            return OptionDescriptor.create(
                /*name*/ "PrintProfilingInformation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print profiling information when parsing a method's bytecode",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.PrintProfilingInformation,
                /*fieldName*/ "PrintProfilingInformation",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RawConditionalElimination": {
            return OptionDescriptor.create(
                /*name*/ "RawConditionalElimination",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.RawConditionalElimination,
                /*fieldName*/ "RawConditionalElimination",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReadEliminationMaxLoopVisits": {
            return OptionDescriptor.create(
                /*name*/ "ReadEliminationMaxLoopVisits",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.ReadEliminationMaxLoopVisits,
                /*fieldName*/ "ReadEliminationMaxLoopVisits",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReassociateExpressions": {
            return OptionDescriptor.create(
                /*name*/ "ReassociateExpressions",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Reassociates loop invariants and constants.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.ReassociateExpressions,
                /*fieldName*/ "ReassociateExpressions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReduceCodeSize": {
            return OptionDescriptor.create(
                /*name*/ "ReduceCodeSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.ReduceCodeSize,
                /*fieldName*/ "ReduceCodeSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RegisterPressure": {
            return OptionDescriptor.create(
                /*name*/ "RegisterPressure",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Comma separated list of registers that register allocation is limited to.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.RegisterPressure,
                /*fieldName*/ "RegisterPressure",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RemoveNeverExecutedCode": {
            return OptionDescriptor.create(
                /*name*/ "RemoveNeverExecutedCode",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Uses deoptimization to prune branches of code in the generated code that have never been executed by the interpreter.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.RemoveNeverExecutedCode,
                /*fieldName*/ "RemoveNeverExecutedCode",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReplaceInputsWithConstantsBasedOnStamps": {
            return OptionDescriptor.create(
                /*name*/ "ReplaceInputsWithConstantsBasedOnStamps",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.ReplaceInputsWithConstantsBasedOnStamps,
                /*fieldName*/ "ReplaceInputsWithConstantsBasedOnStamps",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SmallCompiledLowLevelGraphSize": {
            return OptionDescriptor.create(
                /*name*/ "SmallCompiledLowLevelGraphSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "If the previous low-level graph size of the method exceeds the threshold, it is not inlined.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.SmallCompiledLowLevelGraphSize,
                /*fieldName*/ "SmallCompiledLowLevelGraphSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SnippetCounters": {
            return OptionDescriptor.create(
                /*name*/ "SnippetCounters",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable counters for various paths in snippets.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.SnippetCounters,
                /*fieldName*/ "SnippetCounters",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpeculateVirtualLocks": {
            return OptionDescriptor.create(
                /*name*/ "SpeculateVirtualLocks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Speculate that locks can be virtualized on HotSpot.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.SpeculateVirtualLocks,
                /*fieldName*/ "SpeculateVirtualLocks",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpeculativeGuardMovement": {
            return OptionDescriptor.create(
                /*name*/ "SpeculativeGuardMovement",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Moves loop invariant guards (for example, array bounds checks) out of loops.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.SpeculativeGuardMovement,
                /*fieldName*/ "SpeculativeGuardMovement",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StressExplicitExceptionCode": {
            return OptionDescriptor.create(
                /*name*/ "StressExplicitExceptionCode",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stress the code emitting explicit exception throwing code.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.StressExplicitExceptionCode,
                /*fieldName*/ "StressExplicitExceptionCode",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StressInvokeWithExceptionNode": {
            return OptionDescriptor.create(
                /*name*/ "StressInvokeWithExceptionNode",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stress the code emitting invokes with explicit exception edges.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.StressInvokeWithExceptionNode,
                /*fieldName*/ "StressInvokeWithExceptionNode",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StressTestEarlyReads": {
            return OptionDescriptor.create(
                /*name*/ "StressTestEarlyReads",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stress the code by emitting reads at earliest instead of latest point.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.StressTestEarlyReads,
                /*fieldName*/ "StressTestEarlyReads",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StrictDeoptInsertionChecks": {
            return OptionDescriptor.create(
                /*name*/ "StrictDeoptInsertionChecks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform checks that guards and deopts aren't introduced in graphs that should handle exceptions explicitly",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.StrictDeoptInsertionChecks,
                /*fieldName*/ "StrictDeoptInsertionChecks",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StringIndexOfConstantLimit": {
            return OptionDescriptor.create(
                /*name*/ "StringIndexOfConstantLimit",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Invocations of String.indexOf are evaluated at compile time if the receiver is a constant and its length is less than this value.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.StringIndexOfConstantLimit,
                /*fieldName*/ "StringIndexOfConstantLimit",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SupportJsrBytecodes": {
            return OptionDescriptor.create(
                /*name*/ "SupportJsrBytecodes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.SupportJsrBytecodes,
                /*fieldName*/ "SupportJsrBytecodes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TargetVectorLowering": {
            return OptionDescriptor.create(
                /*name*/ "TargetVectorLowering",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables target-specific lowering and legalization of SIMD operations. Required for SIMD code generation.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.TargetVectorLowering,
                /*fieldName*/ "TargetVectorLowering",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceEscapeAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "TraceEscapeAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.TraceEscapeAnalysis,
                /*fieldName*/ "TraceEscapeAnalysis",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceInlining": {
            return OptionDescriptor.create(
                /*name*/ "TraceInlining",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ """
Enable tracing of inlining decisions.
Output format:
  compilation of 'Signature of the compilation root method':
    at 'Signature of the root method' ['Bytecode index']: <'Phase'> 'Child method signature': 'Decision made about this callsite'
      at 'Signature of the child method' ['Bytecode index']:
         |--<'Phase 1'> 'Grandchild method signature': 'First decision made about this callsite'
         \\--<'Phase 2'> 'Grandchild method signature': 'Second decision made about this callsite'
      at 'Signature of the child method' ['Bytecode index']: <'Phase'> 'Another grandchild method signature': 'The only decision made about this callsite.'""",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.TraceInlining,
                /*fieldName*/ "TraceInlining",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceInliningForStubsAndSnippets": {
            return OptionDescriptor.create(
                /*name*/ "TraceInliningForStubsAndSnippets",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable inlining decision tracing in stubs and snippets.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.TraceInliningForStubsAndSnippets,
                /*fieldName*/ "TraceInliningForStubsAndSnippets",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackNodeInsertion": {
            return OptionDescriptor.create(
                /*name*/ "TrackNodeInsertion",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track source stack trace where a node was inserted into the graph.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.TrackNodeInsertion,
                /*fieldName*/ "TrackNodeInsertion",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackNodeSourcePosition": {
            return OptionDescriptor.create(
                /*name*/ "TrackNodeSourcePosition",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the NodeSourcePosition.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.TrackNodeSourcePosition,
                /*fieldName*/ "TrackNodeSourcePosition",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrivialInliningSize": {
            return OptionDescriptor.create(
                /*name*/ "TrivialInliningSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the size of a graph (counted in nodes) that is considered trivial. Graphs with fewer than this number of nodes are therefore always inlined.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.TrivialInliningSize,
                /*fieldName*/ "TrivialInliningSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TypeCheckMaxHints": {
            return OptionDescriptor.create(
                /*name*/ "TypeCheckMaxHints",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of profiled types that will be used when compiling a profiled type check. Note that TypeCheckMinProfileHitProbability also influences whether profiling info is used in compiled type checks.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.TypeCheckMaxHints,
                /*fieldName*/ "TypeCheckMaxHints",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TypeCheckMinProfileHitProbability": {
            return OptionDescriptor.create(
                /*name*/ "TypeCheckMinProfileHitProbability",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Double.class,
                /*help*/ "If the probability that a type check will hit one of the profiled types (up to TypeCheckMaxHints) is below this value, the type check will be compiled without profiling info.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.TypeCheckMinProfileHitProbability,
                /*fieldName*/ "TypeCheckMinProfileHitProbability",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseExceptionProbability": {
            return OptionDescriptor.create(
                /*name*/ "UseExceptionProbability",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.UseExceptionProbability,
                /*fieldName*/ "UseExceptionProbability",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseLoopLimitChecks": {
            return OptionDescriptor.create(
                /*name*/ "UseLoopLimitChecks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.UseLoopLimitChecks,
                /*fieldName*/ "UseLoopLimitChecks",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseSnippetGraphCache": {
            return OptionDescriptor.create(
                /*name*/ "UseSnippetGraphCache",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a cache for snippet graphs.",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.UseSnippetGraphCache,
                /*fieldName*/ "UseSnippetGraphCache",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseTypeCheckHints": {
            return OptionDescriptor.create(
                /*name*/ "UseTypeCheckHints",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.UseTypeCheckHints,
                /*fieldName*/ "UseTypeCheckHints",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyAssemblyGCBarriers": {
            return OptionDescriptor.create(
                /*name*/ "VerifyAssemblyGCBarriers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify oops processed by GC barriers",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.VerifyAssemblyGCBarriers,
                /*fieldName*/ "VerifyAssemblyGCBarriers",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyHeapAtReturn": {
            return OptionDescriptor.create(
                /*name*/ "VerifyHeapAtReturn",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform platform dependent validation of the Java heap at returns",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.VerifyHeapAtReturn,
                /*fieldName*/ "VerifyHeapAtReturn",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyPhases": {
            return OptionDescriptor.create(
                /*name*/ "VerifyPhases",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.VerifyPhases,
                /*fieldName*/ "VerifyPhases",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapStackOnMethodEntry": {
            return OptionDescriptor.create(
                /*name*/ "ZapStackOnMethodEntry",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "",
                /*container*/ getContainer(),
                /*option*/ GraalOptions.ZapStackOnMethodEntry,
                /*fieldName*/ "ZapStackOnMethodEntry",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 95;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AlwaysInlineVTableStubs");
                    case 1: return get("ArrayRegionEqualsConstantLimit");
                    case 2: return get("AssemblyGCBarriers");
                    case 3: return get("AssemblyGCBarriersSlowPathOnly");
                    case 4: return get("ConditionalElimination");
                    case 5: return get("ConditionalEliminationMaxIterations");
                    case 6: return get("DeoptALot");
                    case 7: return get("DeoptsToDisableOptimisticOptimization");
                    case 8: return get("EagerSnippets");
                    case 9: return get("EarlyGVN");
                    case 10: return get("EarlyLICM");
                    case 11: return get("EmitStringSubstitutions");
                    case 12: return get("EnableFixReadsConditionalElimination");
                    case 13: return get("EscapeAnalysisIterations");
                    case 14: return get("EscapeAnalysisLoopCutoff");
                    case 15: return get("EscapeAnalyzeOnly");
                    case 16: return get("FloatingDivNodes");
                    case 17: return get("FullUnroll");
                    case 18: return get("GCDebugStartCycle");
                    case 19: return get("GenLoopSafepoints");
                    case 20: return get("GuardPriorities");
                    case 21: return get("HotSpotPrintInlining");
                    case 22: return get("InlineEverything");
                    case 23: return get("InlineGraalStubs");
                    case 24: return get("InlineMegamorphicCalls");
                    case 25: return get("InlineMonomorphicCalls");
                    case 26: return get("InlinePolymorphicCalls");
                    case 27: return get("InlineVTableStubs");
                    case 28: return get("Intrinsify");
                    case 29: return get("IsolatedLoopHeaderAlignment");
                    case 30: return get("LimitInlinedInvokes");
                    case 31: return get("LoopHeaderAlignment");
                    case 32: return get("LoopMaxUnswitch");
                    case 33: return get("LoopPeeling");
                    case 34: return get("LoopPredication");
                    case 35: return get("LoopPredicationMainPath");
                    case 36: return get("LoopUnswitch");
                    case 37: return get("MatchExpressions");
                    case 38: return get("MaximumDesiredSize");
                    case 39: return get("MaximumEscapeAnalysisArrayLength");
                    case 40: return get("MaximumInliningSize");
                    case 41: return get("MaximumRecursiveInlining");
                    case 42: return get("MegamorphicInliningMinMethodProbability");
                    case 43: return get("MinimalBulkZeroingSize");
                    case 44: return get("MinimumPeelFrequency");
                    case 45: return get("OmitHotExceptionStacktrace");
                    case 46: return get("OptAssumptions");
                    case 47: return get("OptConvertDeoptsToGuards");
                    case 48: return get("OptDeoptimizationGrouping");
                    case 49: return get("OptDevirtualizeInvokesOptimistically");
                    case 50: return get("OptEliminateGuards");
                    case 51: return get("OptFloatingReads");
                    case 52: return get("OptImplicitNullChecks");
                    case 53: return get("OptReadElimination");
                    case 54: return get("OptScheduleOutOfLoops");
                    case 55: return get("OptimizeDiv");
                    case 56: return get("OptimizeLongJumps");
                    case 57: return get("PartialEscapeAnalysis");
                    case 58: return get("PartialUnroll");
                    case 59: return get("PreferUnsignedComparison");
                    case 60: return get("PrintProfilingInformation");
                    case 61: return get("RawConditionalElimination");
                    case 62: return get("ReadEliminationMaxLoopVisits");
                    case 63: return get("ReassociateExpressions");
                    case 64: return get("ReduceCodeSize");
                    case 65: return get("RegisterPressure");
                    case 66: return get("RemoveNeverExecutedCode");
                    case 67: return get("ReplaceInputsWithConstantsBasedOnStamps");
                    case 68: return get("SmallCompiledLowLevelGraphSize");
                    case 69: return get("SnippetCounters");
                    case 70: return get("SpeculateVirtualLocks");
                    case 71: return get("SpeculativeGuardMovement");
                    case 72: return get("StressExplicitExceptionCode");
                    case 73: return get("StressInvokeWithExceptionNode");
                    case 74: return get("StressTestEarlyReads");
                    case 75: return get("StrictDeoptInsertionChecks");
                    case 76: return get("StringIndexOfConstantLimit");
                    case 77: return get("SupportJsrBytecodes");
                    case 78: return get("TargetVectorLowering");
                    case 79: return get("TraceEscapeAnalysis");
                    case 80: return get("TraceInlining");
                    case 81: return get("TraceInliningForStubsAndSnippets");
                    case 82: return get("TrackNodeInsertion");
                    case 83: return get("TrackNodeSourcePosition");
                    case 84: return get("TrivialInliningSize");
                    case 85: return get("TypeCheckMaxHints");
                    case 86: return get("TypeCheckMinProfileHitProbability");
                    case 87: return get("UseExceptionProbability");
                    case 88: return get("UseLoopLimitChecks");
                    case 89: return get("UseSnippetGraphCache");
                    case 90: return get("UseTypeCheckHints");
                    case 91: return get("VerifyAssemblyGCBarriers");
                    case 92: return get("VerifyHeapAtReturn");
                    case 93: return get("VerifyPhases");
                    case 94: return get("ZapStackOnMethodEntry");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
