// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: HostInliningPhase.Options.java
package jdk.graal.compiler.truffle.host;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class HostInliningPhase_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(HostInliningPhase.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "TruffleHostInlining": {
            return OptionDescriptor.create(
                /*name*/ "TruffleHostInlining",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Whether Truffle host inlining is enabled.",
                /*container*/ getContainer(),
                /*option*/ HostInliningPhase.Options.TruffleHostInlining,
                /*fieldName*/ "TruffleHostInlining",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TruffleHostInliningBaseBudget": {
            return OptionDescriptor.create(
                /*name*/ "TruffleHostInliningBaseBudget",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum budget for Truffle host inlining for runtime compiled methods.",
                /*container*/ getContainer(),
                /*option*/ HostInliningPhase.Options.TruffleHostInliningBaseBudget,
                /*fieldName*/ "TruffleHostInliningBaseBudget",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TruffleHostInliningByteCodeInterpreterBudget": {
            return OptionDescriptor.create(
                /*name*/ "TruffleHostInliningByteCodeInterpreterBudget",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum budget for Truffle host inlining for runtime compiled methods with a BytecodeInterpreterSwitch annotation.",
                /*container*/ getContainer(),
                /*option*/ HostInliningPhase.Options.TruffleHostInliningByteCodeInterpreterBudget,
                /*fieldName*/ "TruffleHostInliningByteCodeInterpreterBudget",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TruffleHostInliningMaxExplorationDepth": {
            return OptionDescriptor.create(
                /*name*/ "TruffleHostInliningMaxExplorationDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Determines the maximum call depth for exploration during host inlining.",
                /*container*/ getContainer(),
                /*option*/ HostInliningPhase.Options.TruffleHostInliningMaxExplorationDepth,
                /*fieldName*/ "TruffleHostInliningMaxExplorationDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TruffleHostInliningMaxSubtreeInvokes": {
            return OptionDescriptor.create(
                /*name*/ "TruffleHostInliningMaxSubtreeInvokes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of subtree invokes for a subtree to get inlined until it is considered too complex.",
                /*container*/ getContainer(),
                /*option*/ HostInliningPhase.Options.TruffleHostInliningMaxSubtreeInvokes,
                /*fieldName*/ "TruffleHostInliningMaxSubtreeInvokes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TruffleHostInliningMinFrequency": {
            return OptionDescriptor.create(
                /*name*/ "TruffleHostInliningMinFrequency",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Double.class,
                /*help*/ "Minimum relative frequency for calls to get inlined. Default 0.001 on HotSpot and no minimum frequency on SVM.",
                /*container*/ getContainer(),
                /*option*/ HostInliningPhase.Options.TruffleHostInliningMinFrequency,
                /*fieldName*/ "TruffleHostInliningMinFrequency",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TruffleHostInliningPrintExplored": {
            return OptionDescriptor.create(
                /*name*/ "TruffleHostInliningPrintExplored",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "When logging is activated for this phase enables printing of only explored, but ultimately not inlined call trees.",
                /*container*/ getContainer(),
                /*option*/ HostInliningPhase.Options.TruffleHostInliningPrintExplored,
                /*fieldName*/ "TruffleHostInliningPrintExplored",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 7;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("TruffleHostInlining");
                    case 1: return get("TruffleHostInliningBaseBudget");
                    case 2: return get("TruffleHostInliningByteCodeInterpreterBudget");
                    case 3: return get("TruffleHostInliningMaxExplorationDepth");
                    case 4: return get("TruffleHostInliningMaxSubtreeInvokes");
                    case 5: return get("TruffleHostInliningMinFrequency");
                    case 6: return get("TruffleHostInliningPrintExplored");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
